Unit GRFLIB;

{$F+}
{$G+}

(*     Fichero de inclusin para compatibilizar la libreria GRAPH       *)
(*con Turbo Pascal (no sera difcil adaptarla para otros compiladores) *)
(*                          Por   N A V I   D.j.                        *)

INTERFACE

TYPE
  dword     =   LongInt;

CONST
  DPonPixel               =      0;
  DBorraPantalla          =      1;
  DDestVirtual            =      2;
  DCreaVirtual            =      3;
  DLinea                  =      4;
  DCopiaPantalla          =      5;
  DCogePixel              =      6;
  DSegmentoPV             =      7;
  DTrataError             =      8;
  DCargaSprite            =      9;
  DDibujaSprite           =      10;
  DDestSprite             =      11;
  DVaciaMEM               =      12;
  DfPonPixel              =      13;
  DfBorraPantalla         =      14;
  DfLinea                 =      15;
  DfCogePixel             =      16;
  DfDibujaSprite          =      17;
  DCogeColor              =      18;
  DPonColor               =      19;
  DCogePaleta             =      20;
  DPonPaleta              =      21;
  DFadeDown               =      22;
  DCargaPaleta            =      23;
  DFadeUp                 =      24;
  DFadeTo                 =      25;
  DBlackOut               =      26;
  DInsertaDirPal          =      27;
  DSegmentoPal            =      28;
  DCargaCEL               =      29;
  DCargaAnima             =      30;
  DPonFrameAnima          =      31;
  DfPonFrameAnima         =      32;
  DDestAnima              =      33;
  DInsertaDirSprite       =      34;
  DInsertaDirAnima        =      35;
  DInsertaDirPV           =      36;
  DSegmentoSprite         =      37;
  DSegmentoAnima          =      38;
  DDescompPuntos          =      39;
  DDescompWorm            =      40;
  DfCaja                  =      41;
  DCaja                   =      42;
  DRectangulo             =      43;
  DfRectangulo            =      44;
  DPoligono               =      45;
  DfPoligono              =      46;
  DCreaSprite             =      47;
  DCambiaSprites          =      48;
  DGetImagen              =      49;
  DfGetImagen             =      50;
  DCirculo                =      51;
  DfCirculo               =      52;
  DDestPaleta             =      53;
  DLeePCX                 =      54;
  DLeeBMP                 =      55;
  DInicGRAPH              =      56;
  DEndGRAPH               =      57;
  DCargaFuente            =      58;
  DCambiaTipo             =      59;
  DQueTipo                =      60;
  DEscLetra               =      61;
  DCogeFuenteDOS          =      62;
  DSetCursor              =      63;
  DGetCursor              =      64;
  DEscribe                =      65;
  DLeeLetra               =      66;
  DLeeLetraEcho           =      67;
  DLeeByte                =      68;
  DLeeCadena              =      69;
  DLeeWord                =      70;
  DEscByte                =      71;
  DEscWord                =      72;
  DWrite                  =      73;
  DNuevoArchivo           =      74;
  DLeeEntrada             =      75;
  DLeeTrozo               =      76;
  DLongitudFile           =      77;
  DFlipCopy               =      78;
  DFlip                   =      79;
  DSegmentoFuente         =      80;
  DDoblaLineas            =      81;
  DSetStart               =      82;
  DSetVSPixels            =      83;
  DPideXMS                =      84;
  DLiberaXMS              =      85;
  DGetAddress             =      86;
  DMaximaXMS              =      87;
  DGuardaFlat             =      88;
  DCargaFlat              =      89;
  DCargaBloque            =      90;
  DCargaMapa              =      91;
  DDestBloque             =      92;
  DDestMapa               =      93;
  DDibujaMapa             =      94;
  DPosMapa                =      95;
  DModoGrafico            =      96;
  DModoTexto              =      97;
  DInsertaDirBloque       =      98;
  DInsertaDirMapa         =      99;
  DSegmentoBloque         =      100;
  DSegmentoMapa           =      101;
  DResetGRAPH             =      102;
  DPlayFli                =      103;
  DCreaMapa               =      104;
  DCreaBloque             =      105;
  DDestFuente             =      106;
  DInsertaDirFuente       =      107;


VAR
  Ssegmento :   word;
  Soffset   :   word;
  wvuelta   :   word;
  bvuelta   :   byte;

  LERROR    :   Word;
  Registro  :   Word;

  i        : Integer;
  Bolsa    : Array [0..100] of Pointer;
  Tamanyos : Array [0..100] of Word;

PROCEDURE CallPas;
PROCEDURE InicPas;
PROCEDURE LiberaMEM(puntero:word);
PROCEDURE WaitVR;
PROCEDURE PonFrameAnima(hdl, pv:byte; x, y, frame:word);
PROCEDURE fPonFrameAnima(hdl, pv:byte; x, y, frame:word);
PROCEDURE DestAnima(hdl:byte);
{PROCEDURE CogeColor(registro:byte; VAR crojo, cverde, cazul:byte);}
PROCEDURE PonColor(NReg, R, G, B:byte);
PROCEDURE PonPaleta(Hdl, FCol, LCol:byte);
PROCEDURE FadeDown(Retar:word; FCol, LCol:byte);
PROCEDURE FadeUp(Retar:word; FCol, LCol:byte);
PROCEDURE FadeTo(Hdl:byte; Retar:word; FCol, LCol:byte);
PROCEDURE BlackOut(FCol, LCol:byte);
PROCEDURE DestPaleta(hdl:byte);
PROCEDURE PonPixel(x, y:word; color, pv:byte);
PROCEDURE fPonPixel(x, y:word; color, pv:byte);
PROCEDURE BorraPantalla(color, pv:byte);
PROCEDURE fBorraPantalla(color, pv:byte);
PROCEDURE Rectangulo(x1, y1, x2, y2:word; col, hdl:byte);
PROCEDURE fRectangulo(x1, y1, x2, y2:word; col, hdl:byte);
PROCEDURE Circulo(Xcen, Ycen, radio:word; hdl, col:byte); 
PROCEDURE fCirculo(Xcen, Ycen, radio:word; hdl, col:byte); 
PROCEDURE ModoGrafico;
PROCEDURE ModoTexto;
PROCEDURE Linea(Xi, Yi, Xf, Yf:word; color, pv:byte); 
PROCEDURE fLinea(Xi, Yi, Xf, Yf:word; color, pv:byte); 
PROCEDURE Caja(x1, y1, x2, y2:word; col, hdl:byte); 
PROCEDURE fCaja(x1, y1, x2, y2:word; col, hdl:byte); 
PROCEDURE Poligono(PTRVertices:Pointer; NVertices, col, hdl:byte); 
PROCEDURE fPoligono(PTRVertices:Pointer; NVertices, col, hdl:byte); 
PROCEDURE CopiaPantalla(Opv, Dpv:byte); 
PROCEDURE DestVirtual(pv:byte); 
PROCEDURE VaciaMEM;
PROCEDURE TrataError;
PROCEDURE DestSprite(hdl:byte);
PROCEDURE CambiaSprites(hdl1, hdl2:byte); 
PROCEDURE DibujaSprite(hdl, pv:byte; x, y:word); 
PROCEDURE fDibujaSprite(hdl, pv:byte; x, y:word); 
PROCEDURE CargaCEL(nombre:string;pv:byte); 
PROCEDURE DescompPuntos(color:byte; semilla:word); 
PROCEDURE DescompWorm(color:byte; semilla:word); 
PROCEDURE InicGRAPH(modo:word; flags:dword); 
PROCEDURE EndGRAPH;
PROCEDURE CambiaTipo(new:byte); 
PROCEDURE SetCursor(posx, posy:word); 
{PROCEDURE GetCursor(VAR posx, posy:word); }
PROCEDURE EscLetra(hdl, letra, pv, color:byte); 
PROCEDURE Escribe(hdl:byte; cadena:string; pv, color, distx, disty:byte);
PROCEDURE LeeCadena(hdl:byte; buffer:string; pv, color, distx:byte; longi:word);
PROCEDURE Write(hdl:byte; cadena:string; pv, color, distx, disty:byte);
PROCEDURE NuevoArchivo(nombre:string);
PROCEDURE LeeEntrada(buffer:pointer; campo:word);
PROCEDURE LeeTrozo(buffer:pointer; campo:word; longi, inicio:dword);
PROCEDURE FlipCopy(Opv, Dpv:byte); 
PROCEDURE Flip(Opv:byte); 
PROCEDURE DoblaLineas;
PROCEDURE SetStart(direc:word);
PROCEDURE SetVSPixels(lineas:byte);
PROCEDURE LiberaXMS(memo:word);
PROCEDURE CargaFlat(hdl, tipo:byte; hdlxms:word); 
PROCEDURE DestBloque(hdl:byte); 
PROCEDURE DestMapa(hdl:byte); 
PROCEDURE DibujaMapa(pv, hmapa, hblk:byte; posx, posy:dword); 
PROCEDURE InsertaDirBloque(segm:word; longx, longy:byte; numero:word); 
PROCEDURE InsertaDirMapa(segm, longx, longy:word); 
PROCEDURE ResetGRAPH(modo:word; flags:dword); 
PROCEDURE PlayFLI(nombre:string; pausa:word); 
PROCEDURE DestFuente(hdl:byte); 
PROCEDURE InsertaDirFuente(segm:word; longx, longy, prim, ult:byte);
FUNCTION PideMEM(cantidad:word):word;
FUNCTION CargaAnima(nombre:string; longX, longY, NSprites:word):byte;
FUNCTION CogePaleta:byte;
FUNCTION CargaPaleta(nombre:string):byte;
FUNCTION CogePixel(x, y:word; pv:byte):byte;
FUNCTION fCogePixel(x, y:word; pv:byte):byte;
FUNCTION CreaVirtual:byte;
FUNCTION SegmentoPV(pv:byte):word;
FUNCTION SegmentoPal(Hdl:byte):word;
FUNCTION SegmentoSprite(Hdl:byte):word;
FUNCTION SegmentoAnima(Hdl:byte):word;
FUNCTION InsertaDirPV(segm:word):byte;
FUNCTION InsertaDirPal(segm:word):byte;
FUNCTION InsertaDirSprite(segm, lx, ly:word):byte;
FUNCTION InsertaDirAnima(segm, lx, ly, num:word):byte;
FUNCTION CargaSprite(nombre:string; lonx, lony:word):byte;
FUNCTION CreaSprite(lx, ly:word):byte; 
FUNCTION GetImagen(x1, y1, x2, y2:word; hdl:byte):byte; 
FUNCTION fGetImagen(x1, y1, x2, y2:word; hdl:byte):byte; 
FUNCTION LeePCX(nombre:string; hdl:byte):byte;
FUNCTION LeeBMP(nombre:string; hdl:byte):byte; 
FUNCTION QueTipo:byte;
FUNCTION CargaFuente(nombre:string; lonx, lony, prime, ulti:byte):byte;
FUNCTION CogeFuenteDOS:byte;
FUNCTION LeeLetra:byte;
FUNCTION LeeLetraEcho(hdl, pv, color:byte):byte;
FUNCTION LongitudFile(campo:word):dword;
FUNCTION SegmentoFuente(Hdl:byte):word;
FUNCTION PideXMS(memo:word):word;
FUNCTION GetAddress(hdl:word):dword;
FUNCTION MaximaXMS:word;
FUNCTION GuardaFlat(hdl, tipo:byte):word; 
FUNCTION CargaBloque(nombre:string):byte; 
FUNCTION CargaMapa(nombre:string):byte; 
FUNCTION PosMapa(hdl:byte; posx, posy:word):word; 
FUNCTION SegmentoBloque(Hdl:byte):word; 
FUNCTION SegmentoMapa(Hdl:byte):word; 
FUNCTION CreaMapa(longx, longy:word):byte; 
FUNCTION CreaBloque(longx, longy:byte; numero:word):byte; 

{$L c:\bp\units\GRAPHP.OBJ}

IMPLEMENTATION

PROCEDURE CallPas; external;
PROCEDURE InicPas; external;

FUNCTION Segmento(punt:pointer):word; Assembler;
ASM
  db 66h
  mov ax, word ptr punt
  mov cl, 16
  db 66h
  shr ax, cl
END;

PROCEDURE CargaDS(modo:byte); Assembler;
ASM
  nop; nop; nop; nop; nop; nop; nop; nop; nop; nop; nop; 
  cmp  modo, 1
  je  @@get
  mov  ax, ds
  mov  cs:[offset @@memvar], ax
  jmp @@fin
 @@memvar:
  dw 0
 @@get:
  mov  ax,cs:[offset @@memvar]
  mov  ds,ax
 @@fin:
END;

FUNCTION PideMEM(cantidad:word):word;
VAR
  p,
  pos:Pointer;
  i:Integer;
BEGIN
  asm pusha; push si; push di; end;
  Cantidad:=Cantidad*16;
  asm push ds end;
  CargaDS(1);
  GetMem(p, cantidad);
  asm pop ds end;
  i:=0; pos:=pointer(1);
  While pos<>NIL Do
   BEGIN
     pos:=Bolsa[i];
     If pos=NIL Then
      BEGIN
        Bolsa[i]:=p;
        Tamanyos[i]:=cantidad;
      END;
     i:=i+1;
   END;
  PideMEM:=Segmento(p);
  asm pop di; pop si; popa; end;
END;

PROCEDURE LiberaMEM(puntero:word);
VAR
  p:Pointer;
  i:Integer;
BEGIN
  asm pusha; push si; push di; end;
  For i:=0 To 100 DO
   BEGIN
     p:=Bolsa[i];
     If Seg(p)=puntero Then
      BEGIN
        FreeMem(p, Tamanyos[i]);
        Bolsa[i]:=NIL;
      END;
   END;
  asm pop di; pop si; popa; end;
END;

PROCEDURE WaitVR; Assembler;
ASM
  mov dx,03DAh
 @@St1:
  in al,dx
  test al,08h
  jz @@St1
 @@St2:
  in al,dx
  test al,08h
  jnz @@St2
END;

FUNCTION CargaAnima(nombre:string; longX, longY, NSprites:word):byte;
BEGIN
        Ssegmento:=Seg(nombre);
        Soffset:=Ofs(nombre);
        asm  push ds end;
        asm  push bp end;
        asm  mov dx,Soffset; inc dx end;
        asm  mov ax,Ssegmento end;
        asm  mov ds,ax end;
        asm  mov ax, NSprites end;
        asm  mov bx, longX end;
        asm  mov cx, longY end;
        asm  push DCARGAANIMA end;
        asm CALL CallPas; pop bx end;
        asm  pop bp end;
        asm  pop ds end;
        asm  mov bvuelta,al end;
        CargaAnima:=bvuelta;
END;

PROCEDURE PonFrameAnima(hdl, pv:byte; x, y, frame:word);
BEGIN
        asm  push ds end;
        asm  push bp end;
        asm  mov al,pv end;
        asm  mov ah,hdl end;
        asm  mov bx,y end;
        asm  mov cx,frame end;
        asm  mov bp,x end;
        asm  push DPONFRAMEANIMA end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
        asm  pop ds end;
END;

PROCEDURE fPonFrameAnima(hdl, pv:byte; x, y, frame:word);
BEGIN
        asm  push ds end;
        asm  push bp end;
        asm  mov al,pv end;
        asm  mov ah,hdl end;
        asm  mov bx,y end;
        asm  mov cx,frame end;
        asm  mov bp,x end;
        asm  push DFPONFRAMEANIMA end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
        asm  pop ds end;
END;

PROCEDURE DestAnima(hdl:byte);
BEGIN
        asm  push bp end;
        asm  mov al,hdl end;
        asm  push DDESTANIMA end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
END;

(*
PROCEDURE CogeColor(registro:byte; VAR crojo, cverde, cazul:byte);
BEGIN
        asm  mov al, registro end;
        asm  push DCOGECOLOR end;
        asm CALL CallPas; pop ax end;
        asm  mov crojo, cl  end;
        asm  mov cverde, bl  end;
        asm  mov cazul, al  end;
END;*)

PROCEDURE PonColor(NReg, R, G, B:byte);
BEGIN
        asm  mov cl,R end;
        asm  mov bl,G end;
        asm  mov al,B end;
        asm  mov ah,NReg end;
        asm  push DPONCOLOR end;
        asm CALL CallPas; pop ax end;
END;

FUNCTION CogePaleta:byte;
BEGIN
        asm  push bp end;
        asm  push DCOGEPALETA end;
        asm CALL CallPas; pop bx end;
        asm  pop bp end;
        asm  mov bvuelta,al end;
        CogePaleta:=bvuelta;
END;

PROCEDURE PonPaleta(Hdl, FCol, LCol:byte);
BEGIN        
        asm  push bp end;
        asm  mov bl,LCol end;
        asm  mov al,FCol end;
        asm  mov ah,Hdl end;
        asm  push DPONPALETA end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
END;

FUNCTION CargaPaleta(nombre:string):byte;
BEGIN
        Ssegmento:=SEG(nombre);
        Soffset:=OFS(nombre);
        asm  push ds end;
        asm  mov dx,Soffset; inc dx end;
        asm  mov ax,Ssegmento end;
        asm  mov ds,ax end;
        asm  push DCARGAPALETA end;
        asm CALL CallPas; pop bx end;
        asm  pop ds end;
	asm  mov bvuelta,al end;
        CargaPaleta:=bvuelta;
END;

PROCEDURE FadeDown(Retar:word; FCol, LCol:byte);
BEGIN
        asm  push bp end;
        asm  mov dh,LCol end;
        asm  mov dl,FCol end;
        asm  mov cx,Retar end;
        asm  push DFADEDOWN end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
END;

PROCEDURE FadeUp(Retar:word; FCol, LCol:byte);
BEGIN
        asm  push bp end;
        asm  mov dh,LCol end;
        asm  mov dl,FCol end;
        asm  mov cx,Retar end;
        asm  push DFADEUP end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
END;

PROCEDURE FadeTo(Hdl:byte; Retar:word; FCol, LCol:byte);
BEGIN
        asm  push bp end;
        asm  mov dh,LCol end;
        asm  mov dl,FCol end;
        asm  mov cx,Retar end;
        asm  mov al,Hdl end;
        asm  push DFADETO end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
END;

PROCEDURE BlackOut(FCol, LCol:byte);
BEGIN
        asm  mov bl,LCol end;
        asm  mov al,FCol end;
        asm  push DBLACKOUT end;
        asm CALL CallPas; pop ax end;
END;

PROCEDURE DestPaleta(hdl:byte);
BEGIN
        asm  mov al,hdl end;
        asm  push DDESTPALETA end;
        asm CALL CallPas; pop ax end;
END;

PROCEDURE PonPixel(x, y:word; color, pv:byte);
BEGIN
        asm  push bp end;
        asm  mov bx,x end;
        asm  mov dx,y end;
        asm  mov cl,color end;
        asm  mov al,pv end;
        asm  push DPONPIXEL end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
END;

PROCEDURE fPonPixel(x, y:word; color, pv:byte);
BEGIN
        asm  push bp end;
        asm  mov bx,x end;
        asm  mov dx,y end;
        asm  mov cl,color end;
        asm  mov al,pv end;
        asm  push DFPONPIXEL end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
END;

PROCEDURE BorraPantalla(color, pv:byte);
BEGIN
        asm  push bp end;
        asm  mov cl,color end;
        asm  mov al,pv end;
        asm  push DBORRAPANTALLA end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
END;

PROCEDURE fBorraPantalla(color, pv:byte);
BEGIN
        asm  push bp end;
        asm  mov cl,color end;
        asm  mov al,pv end;
        asm  push DFBORRAPANTALLA end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
END;

FUNCTION CogePixel(x, y:word; pv:byte):byte;
BEGIN
        asm  push bp end;
        asm  mov al,pv end;
        asm  mov bx,x end;
        asm  mov dx,y end;
        asm  push DCOGEPIXEL end;
        asm CALL CallPas; pop ax end;
        asm  mov bvuelta,cl end;
        asm  pop bp end;
        CogePixel:=bvuelta;
END;

FUNCTION fCogePixel(x, y:word; pv:byte):byte;
BEGIN
        asm  push bp end;
        asm  mov al,pv end;
        asm  mov bx,x end;
        asm  mov dx,y end;
        asm  push DFCOGEPIXEL end;
        asm CALL CallPas; pop ax end;
        asm  mov bvuelta,cl end;
        asm  pop bp end;
        fCogePixel:=bvuelta;
END;

PROCEDURE Rectangulo(x1, y1, x2, y2:word; col, hdl:byte);
BEGIN
        asm  push bp end;
        asm  mov al,hdl end;
        asm  mov cl,col end;
        asm  mov bx,x1 end;
        asm  mov si,y1 end;
        asm  mov dx,x2 end;
        asm  mov di,y2 end;
        asm  push DRECTANGULO end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
END;

PROCEDURE fRectangulo(x1, y1, x2, y2:word; col, hdl:byte);
BEGIN
        asm  push bp end;
        asm  mov al, hdl end;
        asm  mov cl, col end;
        asm  mov bx,x1 end;
        asm  mov si,y1 end;
        asm  mov dx,x2 end;
        asm  mov di,y2 end;
        asm  push DFRECTANGULO end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
END;

PROCEDURE Circulo(Xcen, Ycen, radio:word; hdl, col:byte); BEGIN
        asm  push bp end;
        asm  mov ch,hdl end;
        asm  mov bx,Xcen end;
        asm  mov dx,Ycen end;
        asm  mov ax,radio end;
        asm  mov cl,col end;
        asm  push DCIRCULO end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;END;

PROCEDURE fCirculo(Xcen, Ycen, radio:word; hdl, col:byte); BEGIN
        asm  push bp end;
        asm  mov ch,hdl end;
        asm  mov bx,Xcen end;
        asm  mov dx,Ycen end;
        asm  mov ax,radio end;
        asm  mov cl,col end;
        asm  push DFCIRCULO end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;END;

PROCEDURE ModoGrafico;
BEGIN
        asm  push ds end;
        asm  push bp end;
        asm  push DMODOGRAFICO end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
        asm  pop ds end;
END;

PROCEDURE ModoTexto;
BEGIN
        asm  push ds end;
        asm  push bp end;
        asm  push DMODOTEXTO end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
        asm  pop ds end;
END;

PROCEDURE Linea(Xi, Yi, Xf, Yf:word; color, pv:byte); BEGIN
        asm  push bp end;
        asm  mov bx,Xi end;
        asm  mov dx,Xf end;
        asm  mov si,Yi end;
        asm  mov di,Yf end;
        asm  mov ch,color end;
        asm  mov al,pv end;
        asm  push DLINEA end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;END;

PROCEDURE fLinea(Xi, Yi, Xf, Yf:word; color, pv:byte); BEGIN
        asm  push bp end;
        asm  mov bx,Xi end;
        asm  mov dx,Xf end;
        asm  mov si,Yi end;
        asm  mov di,Yf end;
        asm  mov ch,color end;
        asm  mov al,pv end;
        asm  push DFLINEA end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;END;

PROCEDURE Caja(x1, y1, x2, y2:word; col, hdl:byte); BEGIN
        asm  push bp end;
        asm  mov al,hdl end;
        asm  mov cl,col end;
        asm  mov bx,x1 end;
        asm  mov si,y1 end;
        asm  mov dx,x2 end;
        asm  mov di,y2 end;
        asm  push DCAJA end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;END;

PROCEDURE fCaja(x1, y1, x2, y2:word; col, hdl:byte); BEGIN
        asm  push bp end;
        asm  mov al,hdl end;
        asm  mov cl,col end;
        asm  mov bx,x1 end;
        asm  mov si,y1 end;
        asm  mov dx,x2 end;
        asm  mov di,y2 end;
        asm  push DFCAJA end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;END;

PROCEDURE Poligono(PTRVertices:Pointer; NVertices, col, hdl:byte); BEGIN
        Ssegmento:=SEG(PTRVertices);
        Soffset:=OFS(PTRVertices);
        asm  push ds end;
        asm  push bp end;
        asm  mov dx,Soffset end;
        asm  mov ax,Ssegmento end;
        asm  mov ds,ax end;
        asm  mov cl,col end;
        asm  mov al,hdl end;
        asm  mov ch,NVertices end;
        asm  push DPOLIGONO end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
        asm  pop ds end;END;

PROCEDURE fPoligono(PTRVertices:Pointer; NVertices, col, hdl:byte); BEGIN
        Ssegmento:=SEG(PTRVertices);
        Soffset:=OFS(PTRVertices);
        asm  push ds end;
        asm  push bp end;
        asm  mov dx,Soffset end;
        asm  mov ax,Ssegmento end;
        asm  mov ds,ax end;
        asm  mov cl,col end;
        asm  mov al,hdl end;
        asm  mov ch,NVertices end;
        asm  push DFPOLIGONO end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
        asm  pop ds end;END;

FUNCTION CreaVirtual:byte;
BEGIN
        asm  push DCREAVIRTUAL end;
        asm CALL CallPas; pop bx end;
        asm  mov bvuelta,al end;
        CreaVirtual:=bvuelta;
END;

PROCEDURE CopiaPantalla(Opv, Dpv:byte); BEGIN
        asm  push ds end;
        asm  push bp end;
        asm  mov al,Opv end;
        asm  mov ah,Dpv end;
        asm  push DCOPIAPANTALLA end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
        asm  pop ds end;
END;

PROCEDURE DestVirtual(pv:byte); BEGIN
        asm  push bp end;
        asm  mov al,pv end;
        asm  push DDESTVIRTUAL end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
END;

FUNCTION SegmentoPV(pv:byte):word;
BEGIN
        asm  mov al,pv end;
        asm  push DSEGMENTOPV end;
        asm CALL CallPas; pop ax end;
        asm  mov wvuelta,es end;
        SegmentoPV:=wvuelta;
END;

FUNCTION SegmentoPal(Hdl:byte):word;
BEGIN
        asm  mov al,Hdl end;
        asm  push DSEGMENTOPAL end;
        asm CALL CallPas; pop ax end;
        asm  mov wvuelta,es end;
        SegmentoPal:=wvuelta;
END;

FUNCTION SegmentoSprite(Hdl:byte):word;
BEGIN
        asm  mov al,Hdl end;
        asm  push DSEGMENTOSPRITE end;
        asm CALL CallPas; pop ax end;
        asm  mov wvuelta,es end;
        SegmentoSprite:=wvuelta;
END;

FUNCTION SegmentoAnima(Hdl:byte):word;
BEGIN
        asm  mov al,Hdl end;
        asm  push DSEGMENTOANIMA end;
        asm CALL CallPas; pop ax end;
        asm  mov wvuelta,es end;
        SegmentoAnima:=wvuelta;
END;

PROCEDURE VaciaMEM;
BEGIN
  asm  push DVACIAMEM end;
  asm CALL CallPas; pop ax end;
END;

PROCEDURE TrataError;
BEGIN
  asm  push DTRATAERROR end;
  asm CALL CallPas; pop ax end;
END;

FUNCTION InsertaDirPV(segm:word):byte;
BEGIN
        asm  mov ax,segm end;
        asm  mov es,ax end;
        asm  push DINSERTADIRPV end;
        asm CALL CallPas; pop bx end;
        asm  mov bvuelta,al end;
        InsertaDirPV:=bvuelta;
END;

FUNCTION InsertaDirPal(segm:word):byte;
BEGIN
        asm  mov ax,segm end;
        asm  mov es,ax end;
        asm  push DINSERTADIRPAL end;
        asm CALL CallPas; pop bx end;
        asm  mov bvuelta,al end;
        InsertaDirPal:=bvuelta;
END;

FUNCTION InsertaDirSprite(segm, lx, ly:word):byte;
BEGIN
        asm  mov ax,segm end;
        asm  mov es,ax end;
        asm  mov ax,lx end;
        asm  mov cx,ly end;
        asm  push DINSERTADIRSPRITE end;
        asm CALL CallPas; pop bx end;
        asm  mov bvuelta,al end;
        InsertaDirSprite:=bvuelta;
END;

FUNCTION InsertaDirAnima(segm, lx, ly, num:word):byte;
BEGIN
        asm  mov ax,segm end;
        asm  mov es,ax end;
        asm  mov ax,lx end;
        asm  mov cx,ly end;
        asm  mov si,num end;
        asm  push DINSERTADIRANIMA end;
        asm CALL CallPas; pop bx end;
        asm  mov bvuelta,al end;
        InsertaDirAnima:=bvuelta;
END;

FUNCTION CargaSprite(nombre:string; lonx, lony:word):byte;
BEGIN
        Ssegmento:=Seg(nombre);
        Soffset:=Ofs(nombre);
        asm  push ds end;
        asm  push bp end;
        asm  mov dx,Soffset; inc dx end;
        asm  mov ax,Ssegmento end;
        asm  mov ds,ax end;
        asm  mov bx,lonx end;
        asm  mov cx,lony end;
        asm  push DCARGASPRITE end;
        asm CALL CallPas; pop bx end;
        asm  pop bp end;
        asm  pop ds end;
        asm  mov bvuelta,al end;
        CargaSprite:=bvuelta;
END;

PROCEDURE DestSprite(hdl:byte);
BEGIN
        asm  push bp end;
        asm  mov al,hdl end;
        asm  push DDESTSPRITE end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
END;

PROCEDURE CambiaSprites(hdl1, hdl2:byte); BEGIN
        asm  push bp end;
        asm  mov al,hdl1 end;
        asm  mov dl,hdl2 end;
        asm  push DCAMBIASPRITES end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;END;

FUNCTION CreaSprite(lx, ly:word):byte; BEGIN
        asm  mov bx,lx end;
        asm  mov cx,ly end;
        asm  push DCREASPRITE end;
        asm CALL CallPas; pop bx end;
	asm  mov bvuelta, al end;
        CreaSprite:=bvuelta;END;

PROCEDURE DibujaSprite(hdl, pv:byte; x, y:word); BEGIN
        asm  push bp end;
        asm  push ds end;
        asm  mov al,pv end;
        asm  mov ah,hdl end;
        asm  mov bx,y end;
        asm  mov bp,x end;
        asm  push DDIBUJASPRITE end;
        asm CALL CallPas; pop ax end;
        asm  pop ds end;
        asm  pop bp end;END;

PROCEDURE fDibujaSprite(hdl, pv:byte; x, y:word); BEGIN
        asm  push bp end;
        asm  push ds end;
        asm  mov al,pv end;
        asm  mov ah,hdl end;
        asm  mov bx,y end;
        asm  mov bp,x end;
        asm  push DFDIBUJASPRITE end;
        asm CALL CallPas; pop ax end;
        asm  pop ds end;
        asm  pop bp end;END;

PROCEDURE CargaCEL(nombre:string;pv:byte); BEGIN
        Ssegmento:=Seg(nombre);
        Soffset:=Ofs(nombre);
        asm  push ds end;
        asm  push bp end;
        asm  mov dx,Soffset; inc dx end;
        asm  mov ax,Ssegmento end;
        asm  mov ds,ax end;
        asm  mov al, pv end;
        asm  push DCARGACEL end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
        asm  pop ds end;END;

FUNCTION GetImagen(x1, y1, x2, y2:word; hdl:byte):byte; BEGIN
        asm  push bp end;
        asm  push ds end;
        asm  mov al,hdl end;
        asm  mov bx,x1 end;
        asm  mov si,y1 end;
        asm  mov dx,x2 end;
        asm  mov di,y2 end;
        asm  push DGETIMAGEN end;
        asm CALL CallPas; pop bx end;
        asm  pop ds end;
        asm  pop bp end;
        asm  mov bvuelta,al end;
        GetImagen:=bvuelta;END;

FUNCTION fGetImagen(x1, y1, x2, y2:word; hdl:byte):byte; BEGIN
        asm  push bp end;
        asm  push ds end;
        asm  mov al,hdl end;
        asm  mov bx,x1 end;
        asm  mov si,y1 end;
        asm  mov dx,x2 end;
        asm  mov di,y2 end;
        asm  push DFGETIMAGEN end;
        asm CALL CallPas; pop bx end;
        asm  pop ds end;
        asm  pop bp end;
        asm  mov bvuelta,al end;
        fGetImagen:=bvuelta;END;

PROCEDURE DescompPuntos(color:byte; semilla:word); BEGIN
        asm  push bp end;
        asm  mov ax,semilla end;
        asm  mov cl,color end;
        asm  push DDESCOMPPUNTOS end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;END;

PROCEDURE DescompWorm(color:byte; semilla:word); BEGIN
        asm  push bp end;
        asm  mov ax,semilla end;
        asm  mov cl,color end;
        asm  push DDESCOMPWORM end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
END;

FUNCTION LeePCX(nombre:string; hdl:byte):byte;
BEGIN
        Ssegmento:=SEG(nombre);
        Soffset:=OFS(nombre);
        asm  push ds end;
        asm  mov dx,Soffset; inc dx end;
        asm  mov ax,Ssegmento end;
        asm  mov ds,ax end;
        asm  mov al,hdl end;
        asm  push DLEEPCX end;
        asm CALL CallPas; pop bx end;
        asm  pop ds end;
	asm  mov bvuelta,ah end;
        LeePCX:=bvuelta;
END;

{  Nuevas en GRAPH 2.0 }

FUNCTION LeeBMP(nombre:string; hdl:byte):byte; BEGIN
        Ssegmento:=SEG(nombre);
        Soffset:=OFS(nombre);
        asm  push ds end;
        asm  mov dx,Soffset; inc dx end;
        asm  mov ax,Ssegmento end;
        asm  mov ds,ax end;
        asm  mov al,hdl end;
        asm  push DLEEBMP end;
        asm CALL CallPas; pop bx end;
        asm  pop ds end;
	asm  mov bvuelta,al end;
        LeeBMP:=bvuelta;END;

PROCEDURE InicGRAPH(modo:word; flags:dword); BEGIN
        asm  push ds end;
        asm  push bp end;
        asm  mov bx,modo end;
        asm  db 66h
             mov ax, word ptr flags end;
        asm  push DINICGRAPH end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
        asm  pop ds end;END;

PROCEDURE EndGRAPH;
BEGIN
        asm  push ds end;
        asm  push bp end;
        asm  push DENDGRAPH end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
        asm  pop ds end;END;

PROCEDURE CambiaTipo(new:byte); BEGIN
        asm  mov al,new end;
        asm  push DCAMBIATIPO end;
        asm CALL CallPas; pop ax end;END;

FUNCTION QueTipo:byte;
BEGIN
        asm  push DCAMBIATIPO end;
        asm CALL CallPas; pop bx end;
        asm  mov bvuelta,al end;
        QueTipo:=bvuelta;
END;

PROCEDURE SetCursor(posx, posy:word); BEGIN
        asm  mov bx,posx end;
        asm  mov dx,posy end;
        asm  push DSETCURSOR end;
        asm CALL CallPas; pop ax end;
        END;
(*
PROCEDURE GetCursor(VAR posx, posy:word); BEGIN
        asm  push DGETCURSOR end;
        asm CALL CallPas; pop ax end;
        asm  mov posx,bx end;
        asm  mov posy,dx end;END;
*)
FUNCTION CargaFuente(nombre:string; lonx, lony, prime, ulti:byte):byte;
BEGIN
        Ssegmento:=SEG(nombre);
        Soffset:=OFS(nombre);
        asm  push ds end;
        asm  push bp end;
        asm  mov dx,Soffset; inc dx end;
        asm  mov ax,Ssegmento end;
        asm  mov ds,ax end;
        asm  mov bl,lonx end;
        asm  mov bh,lony end;
        asm  mov ah,prime end;
        asm  mov al,ulti end;
        asm  push DCARGAFUENTE end;
        asm CALL CallPas; pop bx end;
        asm  pop bp end;
        asm  pop ds end;
        asm  mov bvuelta,al end;
        CargaFuente:=bvuelta;
END;

FUNCTION CogeFuenteDOS:byte;
BEGIN
        asm  push bp end;
        asm  push ds end;
        asm  push DCOGEFUENTEDOS end;
        asm CALL CallPas; pop bx end;
        asm  pop ds end;
        asm  pop bp end;
        asm  mov bvuelta,al end;
        CogeFuenteDOS:=bvuelta;
END;

PROCEDURE EscLetra(hdl, letra, pv, color:byte); BEGIN
        asm  push bp end;
        asm  push ds end;
	asm  mov al,hdl end;
	asm  mov ah,letra end;
	asm  mov bl,pv end;
	asm  mov bh,color end;
        asm  push DESCLETRA end;
        asm CALL CallPas; pop ax end;
        asm  pop ds end;
        asm  pop bp end;END;

PROCEDURE Escribe(hdl:byte; cadena:string; pv, color, distx, disty:byte);
BEGIN
        Ssegmento:=SEG(cadena);
        Soffset:=OFS(cadena);
        asm  push bp end;
        asm  push ds end;
        asm  mov si,Soffset; inc si end;
	asm  mov ax,Ssegmento end;
	asm  mov ds,ax end;
	asm  mov al,hdl end;
	asm  mov bl,pv  end;
	asm  mov bh,color end;
	asm  mov cl,distx end;
	asm  mov dl,disty end;
        asm  push DESCRIBE end;
        asm CALL CallPas; pop ax end;
        asm  pop ds end;
        asm  pop bp end;
END;

FUNCTION LeeLetra:byte;
BEGIN
        asm  push DLEELETRA end;
        asm CALL CallPas; pop bx end;
        asm  mov bvuelta,al end;
        LeeLetra:=bvuelta;
END;

FUNCTION LeeLetraEcho(hdl, pv, color:byte):byte;
BEGIN
	asm  mov al,hdl end;
	asm  mov bl,pv  end;
	asm  mov bh,color end;
        asm  push DLEELETRAECHO end;
        asm CALL CallPas; pop bx end;
        asm  mov bvuelta,al end;
        LeeLetraEcho:=bvuelta;
END;

PROCEDURE LeeCadena(hdl:byte; buffer:string; pv, color, distx:byte; longi:word);
BEGIN
        Ssegmento:=SEG(buffer);
        Soffset:=OFS(buffer);
        asm  push ds end;
        asm  mov dx,Soffset; inc dx end;
	asm  mov ax,Ssegmento end;
	asm  mov ds,ax end;
	asm  mov al,hdl end;
	asm  mov bl,pv  end;
	asm  mov bh,color end;
	asm  mov ah,distx end;
	asm  mov cx,longi end;
        asm  push DLEECADENA end;
        asm CALL CallPas; pop ax end;
        asm  pop ds end;
END;

PROCEDURE Write(hdl:byte; cadena:string; pv, color, distx, disty:byte);
BEGIN
        Ssegmento:=SEG(cadena);
        Soffset:=OFS(cadena);
        asm  push bp end;
        asm  push ds end;
        asm  mov si,Soffset; inc si end;
	asm  mov ax,Ssegmento end;
	asm  mov ds,ax end;
	asm  mov al,hdl end;
	asm  mov bl,pv  end;
	asm  mov bh,color end;
	asm  mov cl,distx end;
	asm  mov dl,disty end;
        asm  push DWRITE end;
        asm CALL CallPas; pop ax end;
        asm  pop ds end;
        asm  pop bp end;
END;

PROCEDURE NuevoArchivo(nombre:string);
BEGIN
        Ssegmento:=SEG(nombre);
        Soffset:=OFS(nombre);
        asm  push ds end;
        asm  push bp end;
        asm  mov si,Soffset end;
        asm  mov ax,Ssegmento end;
        asm  mov ds,ax end;
        asm  push DNUEVOARCHIVO end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
        asm  pop ds end;
END;

PROCEDURE LeeEntrada(buffer:pointer; campo:word);
BEGIN
        Ssegmento:=SEG(buffer);
        Soffset:=OFS(buffer);
        asm  push ds end;
        asm  push bp end;
        asm  mov di,Soffset end;
        asm  mov ax,Ssegmento end;
        asm  mov es,ax end;
        asm  mov ax,campo end;
        asm  push DLEEENTRADA end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
        asm  pop ds end;
END;

PROCEDURE LeeTrozo(buffer:pointer; campo:word; longi, inicio:dword);
BEGIN
        Ssegmento:=SEG(buffer);
        Soffset:=OFS(buffer);
        asm  push ds end;
        asm  push bp end;
        asm  mov di,Soffset end;
        asm  mov ax,Ssegmento end;
        asm  mov es,ax end;
        asm  mov ax,campo end;
        asm  db 66h
             mov si, word ptr inicio end;
        asm  db 66h
             mov bp, word ptr longi end;
        asm  push DLEETROZO end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
        asm  pop ds end;
END;

FUNCTION LongitudFile(campo:word):dword;
BEGIN
        asm  push ds end;
        asm  push bp end;
        asm  mov ax,campo end;
        asm  push DLONGITUDFILE end;
        asm CALL CallPas; pop ax end;
        asm  mov ax,bp end;
        asm  db 66h
             shr bp,16 end;
        asm  mov dx,bp end;
        asm  pop bp end;
        asm  pop ds end;
END;

PROCEDURE FlipCopy(Opv, Dpv:byte); BEGIN
        asm  push ds end;
        asm  push bp end;
        asm  mov al,Opv end;
        asm  mov ah,Dpv end;
        asm  push DFLIPCOPY end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
        asm  pop ds end;
END;

PROCEDURE Flip(Opv:byte); BEGIN
        asm  push ds end;
        asm  push bp end;
        asm  mov al,Opv end;
        asm  push DFLIP end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
        asm  pop ds end;
END;

FUNCTION SegmentoFuente(Hdl:byte):word;
BEGIN
        asm  mov al,Hdl end;
        asm  push DSEGMENTOFUENTE end;
        asm CALL CallPas; pop ax end;
        asm  mov wvuelta,es end;
        SegmentoFuente:=wvuelta;
END;

PROCEDURE DoblaLineas;
BEGIN
        asm  push DDOBLALINEAS end;
        asm CALL CallPas; pop ax end;
END;

PROCEDURE SetStart(direc:word);
BEGIN
        asm  mov bx,direc end;
        asm  push DSETSTART end;
        asm CALL CallPas; pop ax end;
END;

PROCEDURE SetVSPixels(lineas:byte);
BEGIN
        asm  mov ah,lineas end;
        asm  push DSETVSPIXELS end;
        asm CALL CallPas; pop ax end;
END;

FUNCTION PideXMS(memo:word):word;
BEGIN
        asm  push bp end;
        asm  mov dx,memo end;
        asm  push DPIDEXMS end;
        asm CALL CallPas; pop ax end;
	asm  mov wvuelta,dx end;
        asm  pop bp end;
        PideXMS:=wvuelta;
END;

PROCEDURE LiberaXMS(memo:word);
BEGIN
        asm  push bp end;
        asm  mov dx,memo end;
        asm  push DLIBERAXMS end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
END;

FUNCTION GetAddress(hdl:word):dword;
BEGIN
        asm  mov dx,hdl end;
        asm  push DGETADDRESS end;
        asm CALL CallPas; pop ax end;
        asm  mov ax,dx end;
        asm  db 66h
             shr dx,16 end;
END;

FUNCTION MaximaXMS:word;
BEGIN
        asm  push DMAXIMAXMS end;
        asm CALL CallPas; pop ax end;
        asm  mov wvuelta,dx end;
        MaximaXMS:=wvuelta;
END;

FUNCTION GuardaFlat(hdl, tipo:byte):word; BEGIN
        asm  push ds end;
        asm  db 0Fh
             db 0A8h end;
        asm  push bp end;
        asm  mov al,hdl end;
        asm  mov ah,tipo end;
        asm  push DGUARDAFLAT end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
        asm  db 0Fh
             db 0A9h end;
        asm  pop ds end;
        asm  mov wvuelta,dx end;
        GuardaFlat:=wvuelta;END;

PROCEDURE CargaFlat(hdl, tipo:byte; hdlxms:word); BEGIN
        asm  push ds end;
        asm  db 0Fh
             db 0A8h end;
        asm  push bp end;
        asm  mov al,hdl end;
        asm  mov ah,tipo end;
        asm  mov dx,hdlxms end;
        asm  push DCARGAFLAT end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
        asm  db 0Fh
             db 0A9h end;
        asm  pop ds end;END;

FUNCTION CargaBloque(nombre:string):byte; BEGIN
        Ssegmento:=SEG(nombre);
        Soffset:=OFS(nombre);
        asm  push ds end;
        asm  push bp end;
        asm  mov dx,Soffset; inc dx end;
        asm  mov ax,Ssegmento end;
        asm  mov ds,ax end;
        asm  push DCARGABLOQUE end;
        asm CALL CallPas; pop bx end;
        asm  pop bp end;
        asm  pop ds end;
        asm  mov bvuelta,al end;
        CargaBloque:=bvuelta;END;

FUNCTION CargaMapa(nombre:string):byte; BEGIN
        Ssegmento:=SEG(nombre);
        Soffset:=OFS(nombre);
        asm  push ds end;
        asm  push bp end;
        asm  mov dx,Soffset; inc dx end;
        asm  mov ax,Ssegmento end;
        asm  mov ds,ax end;
        asm  push DCARGAMAPA end;
        asm CALL CallPas; pop bx end;
        asm  pop bp end;
        asm  pop ds end;
        asm  mov bvuelta,al end;
        CargaMapa:=bvuelta;END;

PROCEDURE DestBloque(hdl:byte); BEGIN
        asm  push bp end;
        asm  mov al,hdl end;
        asm  push DDESTBLOQUE end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
END;

PROCEDURE DestMapa(hdl:byte); BEGIN
        asm  push bp end;
        asm  mov al,hdl end;
        asm  push DDESTMAPA end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
END;

PROCEDURE DibujaMapa(pv, hmapa, hblk:byte; posx, posy:dword); BEGIN
        asm  push ds end;
        asm  db 0Fh
             db 0A8h end;
        asm  db 0Fh
             db 0A0h end;
        asm  push bp end;
        asm  mov al,pv end;
        asm  mov bl,hmapa end;
        asm  mov bh,hblk end;
        asm  db 66h
             mov cx, word ptr posx end;
        asm  db 66h
             mov dx, word ptr posy end;
        asm  push DDIBUJAMAPA end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
        asm  db 0Fh
             db 0A1h end;
        asm  db 0Fh
             db 0A9h end;
        asm  pop ds end;
END;

FUNCTION PosMapa(hdl:byte; posx, posy:word):word; BEGIN
        asm  push ds end;
        asm  push bp end;
        asm  mov al,hdl end;
        asm  mov cx,posx end;
        asm  mov dx,posy end;
        asm  push DPOSMAPA end;
        asm CALL CallPas; pop bx end;
        asm  pop bp end;
        asm  pop ds end;
        asm  mov wvuelta,ax end;
        PosMapa:=wvuelta;END;

PROCEDURE InsertaDirBloque(segm:word; longx, longy:byte; numero:word); BEGIN
        asm  mov ax,segm end;
        asm  mov es,ax end;
        asm  mov cl,longy end;
        asm  mov dh,longx end;
        asm  mov dx,numero end;
        asm  push DINSERTADIRBLOQUE end;
        asm CALL CallPas; pop ax end;
END;

PROCEDURE InsertaDirMapa(segm, longx, longy:word); BEGIN
        asm  mov ax,segm end;
        asm  mov es,ax end;
        asm  mov cx,longy end;
        asm  mov dx,longx end;
        asm  push DINSERTADIRMAPA end;
        asm CALL CallPas; pop ax end;
END;

PROCEDURE ResetGRAPH(modo:word; flags:dword); BEGIN
        asm  push ds end;
        asm  push bp end;
        asm  mov bx,modo end;
        asm  db 66h
             mov ax, word ptr flags end;
        asm  push DRESETGRAPH end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
        asm  pop ds end;
END;

FUNCTION SegmentoBloque(Hdl:byte):word; BEGIN
        asm  mov al,Hdl end;
        asm  push DSEGMENTOBLOQUE end;
        asm CALL CallPas; pop ax end;
        asm  mov wvuelta,es end;
        SegmentoBloque:=wvuelta;END;

FUNCTION SegmentoMapa(Hdl:byte):word; BEGIN
        asm  mov al,Hdl end;
        asm  push DSEGMENTOMAPA end;
        asm CALL CallPas; pop ax end;
        asm  mov wvuelta,es end;
        SegmentoMapa:=wvuelta;END;

PROCEDURE PlayFLI(nombre:string; pausa:word); BEGIN
        Ssegmento:=SEG(nombre);
        Soffset:=OFS(nombre);
        asm  push ds end;
        asm  push bp end;
        asm  mov dx,Soffset; inc dx end;
        asm  mov ax,Ssegmento end;
        asm  mov ds,ax end;
        asm  mov ax,pausa end;
        asm  push DPLAYFLI end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
        asm  pop ds end;
END;

FUNCTION CreaMapa(longx, longy:word):byte; BEGIN
        asm  push bp end;
        asm  mov ax,longx end;
        asm  mov cx,longy end;
        asm  push DCREAMAPA end;
        asm CALL CallPas; pop bx end;
        asm  mov bvuelta,al end;
        asm  pop bp end;
        CreaMapa:=bvuelta;END;

FUNCTION CreaBloque(longx, longy:byte; numero:word):byte; BEGIN
        asm  push bp end;
        asm  mov al,longx end;
        asm  mov ah,longy end;
        asm  mov cx,numero end;
        asm  push DCREABLOQUE end;
        asm CALL CallPas; pop bx end;
        asm  mov bvuelta,al end;
        asm  pop bp end;
        CreaBloque:=bvuelta;END;

PROCEDURE DestFuente(hdl:byte); BEGIN
        asm  push bp end;
        asm  mov al,hdl end;
        asm  push DDESTFUENTE end;
        asm CALL CallPas; pop ax end;
        asm  pop bp end;
END;

PROCEDURE InsertaDirFuente(segm:word; longx, longy, prim, ult:byte);
BEGIN
        asm  mov ax,segm end;
        asm  mov es,ax end;
        asm  mov cl,longy end;
        asm  mov ch,longx end;
        asm  mov al,prim end;
        asm  mov ah,ult end;
        asm  push DINSERTADIRFUENTE end;
        asm CALL CallPas; pop ax end;
END;

BEGIN
  CargaDS(32);
  For i:=1 To 100 Do
    Bolsa[i]:=NIL;
  InicPas;
END.
