;;;;  Super nevada...   By Navi Dj.     Vilamarxant 1996
;;;;;;;;;;;;;   Copyright (C) 1996
        ;;;;;   Free software -- Assembler forever.
        ;;;;;
;;;;;;;;;;;;;           S U P E R - N I E V E
;;;;                    ^^^^^^^^^^^^^^^^^^^^^

.MODEL TINY
.CODE
.386
 LOCALS @@
 ORG 100h

        NumCopos        EQU     1700    ;  Nmero de copos de nieve.
        ColNieve        EQU     15      ;  El color de la nieve.
        Tiempo          EQU     1       ;  Nmero de VR de espera.
        Espera          EQU     25      ;  Espera hasta declarar un copo
                                        ;  quieto inactivo.

Inicio:         JMP     Main

;;;;  Pseudo rea de datos.

aPosX           DW      NumCopos+2 DUP (0)   ;  Arrays con las posiciones X
aPosY           DW      NumCopos+2 DUP (0)   ; e Y de los copos de nieve.
aActivo         DB      NumCopos+1 DUP (0)   ;  Indica si el copo est activo.

Fichero         DB      'COSA.RAW',0    ;  Fichero con los grficos.
Handle          DW      0               ;  Handle de fichero.

Rand1           DW      04316h          ;  Variables para los nmeros alea-
Rand2           DW      0A443h          ; torios.
Rand3           DW      055ABh

;;;;  Cdigo del efecto.

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;  UTILIDAD: Espera un retrazado completo de pantalla.
;  ENTRADAS: Ninguna.
;   SALIDAS: Ninguna.
;  MODIFICA: Nada.
;     NOTAS: Ninguna.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
WaitVR          PROC    NEAR
                PUSH    DX              ;  Preserva los registros.
                PUSH    AX
                MOV     DX, 03DAh
        @@St1:  IN      AL, DX          ;  Espera a que termine el retrazo.
                TEST    AL, 08h
                JZ    @@St1
        @@St2:  IN      AL, DX          ;  Espera a que empieze el nuevo.
                TEST    AL, 08h
                JNZ   @@St2
                POP     AX 
                POP     DX
                RET
WaitVR          ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;  UTILIDAD: Hace una pequea pausa.
;  ENTRADAS: Ninguna.
;   SALIDAS: Ninguna.
;  MODIFICA: Registro CX.
;     NOTAS: Ninguna.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Pausa           PROC    NEAR
                MOV     CX, Tiempo
        @@BuclePausa:
                CALL    WaitVR
                LOOP  @@BuclePausa
                RET
Pausa           ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;  UTILIDAD: Funcin para "colorear" un determinado pixel.
;  ENTRADAS: En (BX,DX) las coordenadas del pixel y en CL el color (en ES
;            debe estar el segmento reservado).
;   SALIDAS: Ninguna.
;  MODIFICA: Registros BX, DX, CX
;     NOTAS: Ninguna.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PutPixel        PROC    NEAR
                CMP     BX, 320
                JA    @@NoPixel         ;  Comprobacin de rango.
                MOV     CH, DL          ;  Preservamos la coordenada Y.
                SHL     DX, 6           ;  Multiplicamos Y por 64.
                ADD     DH, CH          ;  Sumamos Y multiplicado por 256.
                ADD     BX, DX          ;  BX = Y*320+X
                MOV     ES:[BX], CL     ;  Escribimos el punto.
     @@NoPixel: RET
PutPixel        ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;  UTILIDAD: Funcin para obtener el color de un determinado pixel.
;  ENTRADAS: En (BX,DX) las coordenadas del pixel (en ES debe estar el
;            segmento reservado).
;   SALIDAS: En CL el color.
;  MODIFICA: Registros BX, DX, CX
;     NOTAS: Ninguna.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
GetPixel        PROC    NEAR
                CMP     BX, 320
                JA    @@NoPixel         ;  Comprobacin de rango.
                MOV     CH, DL          ;  Preservamos la coordenada Y.
                SHL     DX, 6           ;  Multiplicamos Y por 64.
                ADD     DH, CH          ;  Sumamos Y multiplicado por 256.
                ADD     BX, DX          ;  BX = Y*320+X
                MOV     CL, ES:[BX]     ;  Leemos el punto.
     @@NoPixel: RET
GetPixel        ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;  UTILIDAD: Genera nmeros pseudo-aleatorios.
;  ENTRADAS: Ninguna.
;   SALIDAS: En AX un numero.
;  MODIFICA: Registro AX. 
;     NOTAS: Sn nmeros pseudo-aleatorios. Inicializar las variables Rand?
;            si es preciso.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Random          PROC    NEAR            ;  Hacemos unas cuantas tonterias
                MOV     AX, CS:[Rand1]  ; con los nmeros para barajarlos lo
                ROL     AX, 2           ; mejor posible.
                ADD     AX, CS:[Rand2]
                SUB     CS:[Rand1], AX
                ROR     AX, 3
                XOR     AX, CS:[Rand3]
                ADD     CS:[Rand2], AX
                ROR     AX, 1
                XOR     CS:[Rand3], AX
                RET
Random          ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;  UTILIDAD: Entra en el modo grfico indicado.
;  ENTRADAS: En AL el nuevo modo.
;   SALIDAS: Ninguna.
;  MODIFICA: Registro AX.
;     NOTAS: Ninguna.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
NuevoModo       PROC    NEAR
                XOR     AH, AH          ;  Funcin 0 de la BIOS de video.
                INT     10h
                RET
NuevoModo       ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;  UTILIDAD: Carga una imagen RAW en pantalla.
;  ENTRADAS: En DS:DX la direccin donde se guarda el nombre.
;   SALIDAS: Ninguna.
;  MODIFICA: Registros AX, BX, CX, DX, DS.
;     NOTAS: El fichero debe medir 64000 bytes exactamente.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
LoadRAW         PROC    NEAR
                MOV     AX, 3D00h
                INT     21h             ;  Abrimos el fichero.
                JC    @@NoEsta          ;  Si no est.
                MOV     CS:[Handle], AX ;  Guardamos el handle.
                MOV     BX, AX          ;  Metemos en BX el handle.
                MOV     DX, 0A000h
                MOV     AH, 3Fh
                MOV     DS, DX          ;  Cogemos en DS el segmento de video.
                XOR     DX, DX          ;  Hacemos DX = 0.
                MOV     CX, 64000       ;  Bytes a leer.
                INT     21h             ;  Leemos directamente a video.
        @@NoEsta:               ;  Si no hay fichero... pues sin l.
                RET
LoadRAW         ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;  UTILIDAD: Es el efecto en s.
;  ENTRADAS: Ninguna.
;   SALIDAS: Ninguna.
;  MODIFICA: Todo.
;     NOTAS: Ninguna.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Nevada          PROC    NEAR
      @@BucleTecla:
                MOV     EBP, NumCopos   ;  Iteramos `NumCopos veces.
      @@BucleCopos:
                CMP     CS:[aActivo.BP], 1
                JNE   @@Inactivo        ;  Mira si est activo el copo.
            ;; Borrado del pixel anterior.
                MOV     DX, CS:[aPosY+EBP*2]
                MOV     BX, CS:[aPosX+EBP*2]
                CMP     DX, 198         ;  Detenemos el copo si ha caido
                JAE   @@DetenCopo       ; hasta bajo del todo.
                XOR     CL, CL
                CALL    PutPixel        ;  Borramos el pixel anterior.
            ;; Eleccin de la direccin.
                CALL    Random          ;  Pillamos un aleatorio.
                SHR     AX, 1
                JC    @@HaciaAbajo      ;  Hacia abajo.
                SHR     AX, 1
                JC    @@Izquierda       ;  Hacia la izquierda.
                JMP   @@Derecha         ;  Hacia la derecha.
        @@HaciaAbajo:
                MOV     BX, CS:[aPosX+EBP*2]
                MOV     DX, CS:[aPosY+EBP*2]
                INC     DX              ;  Una posicin ms abajo.
                CALL    GetPixel        ;  Leemos el pixel.
                CMP     CL, ColNieve    ;  Es eso nieve?
                JE    @@Nieve           ;  S, es nieve.
                OR      CL, CL          ;  Es el espacio?
                JE    @@SigueA          ;  S, seguir cayendo por abajo.
                JMP   @@DetenCopo       ;  Sino, detenemos el copo.
        @@Izquierda:
                MOV     BX, CS:[aPosX+EBP*2]
                MOV     DX, CS:[aPosY+EBP*2]
                INC     DX              ;  Una posicin ms abajo.
                DEC     BX              ;  Hacia la izquierda.
                CALL    GetPixel        ;  Leemos el pixel.
                CMP     CL, ColNieve    ;  Es eso nieve?
                JE    @@Nieve           ;  S, es nieve.
                OR      CL, CL          ;  Es el espacio?
                JE    @@SigueI          ;  S, seguir cayendo por la izquierda.
                JMP   @@DetenCopo       ;  Sino, detenemos el copo.
        @@Derecha:
                MOV     BX, CS:[aPosX+EBP*2]
                MOV     DX, CS:[aPosY+EBP*2]
                INC     DX              ;  Una posicin ms abajo.
                INC     BX              ;  Hacia la derecha.
                CALL    GetPixel        ;  Leemos el pixel.
                CMP     CL, ColNieve    ;  Es eso nieve?
                JE    @@Nieve           ;  S, es nieve.
                OR      CL, CL          ;  Es el espacio?
                JE    @@SigueD          ;  S, seguir cayendo por la derecha.
                                        ;  Sino, detenemos el copo.
            ;;  Actuamos segn el prximo movimiento.
        @@DetenCopo:
                MOV     CS:[aActivo.BP], 0      ;  Paramos el copito.
                MOV     BX, CS:[aPosX+EBP*2]    ;  Actualizamos el copo.
                MOV     DX, CS:[aPosY+EBP*2]
                MOV     CL, ColNieve
                CALL    PutPixel        ;  Dibujamos el copo.
                JMP   @@Inactivo        ;  Dejamos la posibilidad de otro copo.
        @@Nieve:                ;  Si es nieve, esperamos un segundo sin
                INC     CS:[aActivo.BP]         ; hacer nada.
                MOV     BX, CS:[aPosX+EBP*2]    ;  Actualizamos el copo.
                MOV     DX, CS:[aPosY+EBP*2]
                MOV     CL, ColNieve
                CALL    PutPixel        ;  Dibujamos el copo.
                JMP   @@OtroCopo
        @@SigueI:
                CALL    Random
                SHR     AX, 2           ;  Rotamos dos posiciones.
                JNC   @@NoHacer         ;  Relentizamos el copo.
                INC     CS:[aPosY+EBP*2]   ;  Bajamos una posicin.
                DEC     CS:[aPosX+EBP*2]   ;  A la izquierda una posicin.
        @@NoHacer:
                MOV     DX, CS:[aPosY+EBP*2]
                MOV     BX, CS:[aPosX+EBP*2]
                MOV     CL, ColNieve
                CALL    PutPixel        ;  Dibujamos el copo.
                JMP   @@OtroCopo
        @@SigueD:
                CALL    Random
                SHR     AX, 2           ;  Rotamos dos posiciones.
                JNC   @@NoHacer         ;  Relentizamos el copo.
                INC     CS:[aPosY+EBP*2]   ;  Bajamos una posicin.
                INC     CS:[aPosX+EBP*2]   ;  A la derecha una posicin.
                MOV     DX, CS:[aPosY+EBP*2]
                MOV     BX, CS:[aPosX+EBP*2]
                MOV     CL, ColNieve
                CALL    PutPixel        ;  Dibujamos el copo.
                JMP   @@OtroCopo
        @@SigueA:
                CALL    Random
                SHR     AX, 2           ;  Rotamos dos posiciones.
                JNC   @@NoHacer         ;  Relentizamos el copo.
                INC     CS:[aPosY+EBP*2]   ;  Bajamos una posicin.
                MOV     DX, CS:[aPosY+EBP*2]
                MOV     BX, CS:[aPosX+EBP*2]
                MOV     CL, ColNieve
                CALL    PutPixel        ;  Dibujamos el copo.
                JMP   @@OtroCopo
        @@IntentaSeguir:
                MOV     DX, CS:[aPosY+EBP*2]
                MOV     BX, CS:[aPosX+EBP*2]
                INC     DX              ;  Miramos ah abajo.
                ;DEC     BX
                CALL    GetPixel        ;  Dibujamos el copo.
                INC     CS:[aActivo.BP] ;  Vamos cansandonos de esperar.
                CMP     CL, ColNieve
                JE    @@OtroCopo        ;  Si es nieve, siguiente copo.
                MOV     CS:[aActivo.BP], 1   ;  Marcamos como buena.
                JMP   @@OtroCopo
        @@Inactivo:
                MOV     AL, CS:[aActivo.BP]
                OR      AL, AL          ;  Habia un copo o estabamos en
                JZ    @@NuevoCopo       ; espera.
                CMP     AL, Espera      ;  Nos hemos cansado de esperar?
                JB    @@IntentaSeguir   ;  No, intentamos seguir.
           @@NuevoCopo:
            ;; Creacin de nuevos copos.
                CALL    Random          ;  Aleatorio para ver si creamos un
                SHR     AX, 1           ; nuevo copo.
                JC    @@OtroCopo        ;  Si impar no hacemos copo.
                CMP     AX, 320         ;  Hay unas coordenadas creibles?
                JA    @@NuevoCopo       ;  Hacemos que sea ms dificil que
                MOV     CS:[aPosY+EBP*2], 0 ; aparezcan los pixels.
                MOV     CS:[aPosX+EBP*2], AX;  Insertamos las posiciones X e Y.
                MOV     CS:[aActivo.BP], 1  ;  Colocamos el flag de actividad.
           @@OtroCopo:
                DEC     BP              ;  Mientras queden copos seguimos.
                JNZ   @@BucleCopos
                CALL    Pausa           ;  Hacemos una pausita.
                IN      AL, 60h         ;  Leemos el buffer de teclado.
                DEC     AL              ;  Pulsado ESC?
                JNZ   @@BucleTecla      ;  Seguimos...
                RET
Nevada          ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;  UTILIDAD: Programa principal, se encarga de distribuir las tareas.
;  ENTRADAS: Ninguna.
;   SALIDAS: Ninguna.
;  MODIFICA: Todo.
;     NOTAS: Ninguna.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Main            PROC    NEAR
                PUSH    CS
                MOV     AL, 13h
                CALL    NuevoModo       ;  Modo de 320x200 con 256 colores.
                POP     DS
                MOV     DX, Offset Fichero
                CALL    LoadRAW         ;  Cargamos el fichero RAW.
                MOV     AX, 0A000h
                MOV     ES, AX          ;  Cargamos el segmento de video.

                MOV     BP, 200
        @@BucleLin1:                    ;  Bucle que dibuja una lnea vertical.
                MOV     BX, 319
                MOV     DX, BP
                MOV     CL, ColNieve
                CALL    PutPixel
                DEC     BP
                JNZ   @@BucleLin1

                MOV     BP, 200
        @@BucleLin2:                    ;  Bucle que dibuja otra lnea
                XOR     BX, BX          ; vertical.
                MOV     DX, BP
                MOV     CL, ColNieve
                CALL    PutPixel
                DEC     BP
                JNZ   @@BucleLin2

                CALL    Nevada          ;  Llama a la funcin principal.

                MOV     AL, 03h
                CALL    NuevoModo       ;  Modo texto normal.
                MOV     AX, 4C00h
                INT     21h             ;  Salimos al DOS.
Main            ENDP
                END     Inicio
