;  Funcin "preparada" para la incorporacin en una DEMO que proyecta
; en pantalla el fractal de Mandel.
;               Por NAVI Dj.

.MODEL TINY
.287
.CODE

                                ORG     100h
Inicio:         JMP     Main

;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;-=-=-=        AREA DE DATOS DEL PROGRAMA
;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

 X1             DQ      -0.25E1         ;  Variables que definen la ventana
 X2             DQ      0.15E1          ; de visin fractal.
 Y1             DQ      0.15E1
 Y2             DQ      -0.15E1

 VariacionX     DQ      160E0           ;  Representan la variacin de coordenadas
 VariacionY     DQ      100E0           ; en el plano fractal por cada pixel.

 Estado         DW      ?               ;  Estado del copro.
 aux            DQ      ?               ;  Para llevar una variable temporal.
 aux2           DD      2E0             ;  Utilizada para multiplicacin.
 aux3           DD      4E0             ;  Utilizada para comparacin.
 
;-=-=-=  Variables de la ecuacin imaginaria: Z=Z+C
 a              DQ      ?
 b              DQ      ?
 x              DQ      ?
 y              DQ      ?

;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;-=-=-=        AREA DE CDIGO DEL PROGRAMA 
;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

Main            PROC                    ;  Funcin principal.
                FLD     X2
                FSUB    X1
                FDIV    VariacionX      ;  En st(0) tenemos (X2-X1)/320.
                FSTP    VariacionX      ;  Lo guardamos en memria.

                FLD     Y2
                FSUB    Y1
                FDIV    VariacionY      ;  En st(0) tenemos (Y2-Y1)/320.
                FSTP    VariacionY      ;  Lo guardamos en memria.

                FLD     X1              ;  a = X1 (no es el mtodo ms
                FSTP    a               ; rpido, pero...)

                MOV     AX, 0013h
                INT     10h             ;  Establecemos modo video 13h.

                MOV     AX, 0A000h
                MOV     ES, AX          ;  ES contendr "siempre" el segmento
                                        ; de video.
                MOV     DX, 318d        ;  Contador de la variable NPH
                XOR     CL, CL          ;  Para acelerar el proceso.

        @BucleK:                        ;  Bucle donde se establecen las coor. horizontales.
                OR      DX, DX
                JNZ    @@BK
                JMP    @Fin
               
              @@BK:
                FLD     a
                FADD    VariacionX
                FSTP    a               ;  Se incrementa "a" en VariacionX.

                FLD     Y2
                FSTP    b               ;  b = Y2

                MOV     CH, 200d        ;  Contador de la variable NPV
        
        @BucleJ:                        ;  Bucle donde se establecen las coor. verticales.
                OR      CH, CH
                JNZ    @@BJ
                JMP    @SiguienteLinea
              
              @@BJ:
                FLD     b
                FSUB    VariacionY
                FSTP    b               ;  Se decrementa "b" en VariacionY.

                FLDZ
                FST     x
                FSTP    y
                XOR     BX, BX          ;  x = y = BX = 0 (BX son las iteraciones).

        @BucleIteraciones:              ;  Bucle principal.
                CMP     BX, 50          ;  100 es el nmero mx. de iteraciones.
                JNB    @SiguientePunto  ;  Si mximas iteraciones permitidas.
                
                FLD     y
                FMUL    y
                FLD     x
                FMUL    x
                FADD    st(0), st(1)
                FSUB    aux3            ;  Le resta 4
                FTST                    ;  Comprueba si x^2+y^2 excede de 4.
                FSTSW   Estado
                MOV     AX, Estado      ;  Ponemos en los flags la palabra de
                SAHF                    ; estado del copro.
                FFREE   st(0)           ;  Vaciamos la pila del copro.
                FFREE   st(1)
                JZ     @SiguientePunto  ;  Si el mdulo es mayor que 2
                
                FLD     y
                FMUL    y
                FLD     x
                FMUL    x
                FSUB    st(0), st(1)
                FADD    a               ;  Hemos hecho: x^2-y^2+a
                FSTP    aux             ;  Lo guardamos en la auxiliar.
                FFREE   st(0)           ;  Vaciamos la pila del copro.

                FLD     x
                FMUL    y
                FMUL    aux2
                FADD    b
                FSTP    y               ;  Hacemos que "y" valga 2*x*y+b

                FLD     aux
                FSTP    x               ;  x = aux

                INC     BX
                JMP    @BucleIteraciones

        @SiguientePunto:

                MOV     AX, DX
                MOV     SI, CX
                ADD     DX, CX
                SHR     CX, 1
                SHR     CX, 1
                ADD     CX, DX
                MOV     DI, CX
                MOV     BH, BL
                MOV     WORD PTR ES:[DI], BX     ;  Ponemos un punto en el stio donde
                MOV     WORD PTR ES:[DI+320], BX ; acabamos de calcular y circundantes.
                MOV     CX, SI
                MOV     DX, AX

                DEC     CH
                DEC     CH
                JMP    @BucleJ
        
        @SiguienteLinea:
                DEC     DX
                DEC     DX
                JMP    @BucleK
        
        @Fin:   MOV     AX, 0003h
;                INT     10h             ;  Volvemos al modo texto.
                MOV     AX, 4C00h
                INT     21h

Main            ENDP
                END     Inicio
