;;;; PING-PONG es el tpico juego de la pelotita y los 2 bates.
;;;;;;; Por   N A V I   D. j.
;;
;;;       Vilamarxant * Enero * 1996

.MODEL TINY
LOCALS @@
.STACK
.386

;;;;;;;;;;;;;;;;;;
;;;;  EQUIVALENTES
;;;;;;;;;;;;;;;;;;

LastKey         EQU     mapa_teclado
ESC             EQU     mapa_teclado+1
NUMERO1         EQU     mapa_teclado+2
NUMERO2         EQU     mapa_teclado+3
FlechaIzq       EQU     mapa_teclado+18h
FlechaDer       EQU     mapa_teclado+19h

LONGxBATE       EQU     30
LONGyBATE       EQU     10
LONGxBOLA       EQU     10
LONGyBOLA       EQU     10

INTRO           EQU     0Dh,0Ah         ;  Cdigo de retorno de carro.
BEL             EQU     07h             ;  Cdigo del maldit... pitidito.
EndOfText       EQU     '$'             ;  Cdigo fin de cadena.

;;;;;;;;;;;;;;;;;;;
;;;;  AREA DE DATOS
;;;;;;;;;;;;;;;;;;;

.DATA
Presentacion    DB      INTRO
  DB  '    NAVI  Dj.  presenta...',BEL,BEL,BEL,BEL,BEL,BEL,INTRO
  DB  '                        P I N G - P O N G', INTRO
  DB  '                 La reedicin de un clsico :->.',INTRO,INTRO
  DB  '       Creado en ASSEMBLER un "magnfico" dia de verano',INTRO
  DB  '                          del ao 1996.',INTRO,INTRO
  DB  '     Para crear este juego he  utilizado la librera grfica',INTRO
  DB  '                            GRAPH 2.0b',INTRO
  DB  '       Creada por m mismo en  ASSEMBLER puro y disponible',INTRO
  DB  '             para todo el mundo en la forma CARD-WARE',INTRO
  DB  '     Puedes jugar con las teclas O y P para moverte hacia los',INTRO
  DB  '           lados. Opcin de 2 jugadores no disponible.',INTRO,INTRO
  DB  ' Para ms informacin:',INTRO
  DB  INTRO,INTRO,INTRO,INTRO
  DB  '     Ivan Gadea Saez',INTRO
  DB  '   Crt\de Lliria  N57',INTRO
  DB  '       Vilamarxant',INTRO
  DB  '         Valencia',INTRO,EndOfText


PaletaJuego     DB      'PAL01.PIN',0           ;  Paleta del propio juego.
HdlPalJuego     DB      0                       ;  Handle de la paleta.

SpriteBate      DB      'SPR01.PIN',0           ;  Sprite del bate.
HdlSprBate      DB      0                       ;  Handle del sprite del bate.

SpriteBola      DB      'SPR02.PIN',0           ;  Sprite de la bola.
HdlSprBola      DB      0                       ;  Handle del sprite de la bola.

FondoPgPg       DB      'GRF01.PIN',0           ;  Fondo en el juego.
HdlFondJuego    DB      0                       ;  Handle del fondo del juego.

MenuOpciones    DB      'GRF02.PIN',0           ;  Men inicial.
HdlMenu         DB      0                       ;  Handle del men.

HdlJuego        DB      0       ;  La pantalla virtual del juego.
XINCbola        DB      0
YINCbola        DB      0       ;  Incremento X e Y de la bola.
Ybola           DW      0
Xbola           DW      0       ;  Coordenadas X e Y de la bola.
N               DB      0       ;  Variable auxiliar.
Xbate1          DW      0       ;  Bate player 1.
Xbate2          DW      0       ;  Bate ordenador o player 2.

;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;  FUNCIONES Secundarias
;;;;;;;;;;;;;;;;;;;;;;;;;;;

.CODE
INCLUDE GRFLIB2.INC             ;  Funciones graficas GRAPH 2.0
INCLUDE TECLADO.INC             ;  Funciones del teclado.

CargaGraficos   PROC
                MOV     DX, Offset PaletaJuego
                CALL    CargaPaleta     ;  Carga la paleta.
                CALL    TrataError
                MOV     [HdlPalJuego], AL
                MOV     AH, AL
                XOR     AL, AL
                XOR     BL, BL
                CALL    PonPaleta       ;  Y la pone.

                MOV     DX, Offset SpriteBate
                MOV     BX, LONGxBATE
                MOV     CX, LONGyBATE
                CALL    CargaSprite     ;  Carga el sprite del bate.
                CALL    TrataError
                MOV     [HdlSprBate], AL

                MOV     DX, Offset SpriteBola
                MOV     BX, LONGxBOLA
                MOV     CX, LONGyBOLA
                CALL    CargaSprite     ;  Carga el sprite de la bola.
                CALL    TrataError
                MOV     [HdlSprBola], AL

                CALL    CreaVirtual
                CALL    TrataError
                MOV     [HdlFondJuego], AL
                MOV     DX, Offset FondoPgPg
                CALL    LeePCX
                CALL    TrataError      ;  No me preocupo por la paleta por
                RET                     ; ser la misma durante todo el juego.
CargaGraficos   ENDP

PonPresentacion PROC
                MOV     AX, 0003h
                INT     10h             ;  Borrar la pantalla en modo mono.

                MOV     DX, Offset Presentacion
                MOV     AH, 9
                INT     21h             ;  Funcin del DOS para presentar
                                        ; textos en pantalla.
  @@Tecla:      IN      AL, 60h
                CMP     AL, 127d
                JNB   @@Tecla           ;  Espera a la pulsacin de una tecla.
                RET
PonPresentacion ENDP

MenuInicial     PROC
                CALL    CreaVirtual
                CALL    TrataError
                MOV     [HdlMenu], AL
                MOV     DX, Offset MenuOpciones
                CALL    LeePCX          ;  Carga el grfico.
                PUSH    AX
                MOV     AH, AL
                XOR     AL, AL
                XOR     BL, BL          ;  Ponemos los colores de la paleta.
                CALL    PonPaleta
                CALL    TrataError
                POP     AX
                CALL    DestPaleta      ;  Liberamos la memoria usada.
                CALL    TrataError

                MOV     AL, [HdlMenu]
                XOR     AH, AH
                CALL    CopiaPantalla   ;  Visualiza el menu.
                CALL    TrataError

                MOV     AL, [HdlMenu]
                CALL    DestVirtual     ;  Libera la zona de memoria.
                CALL    TrataError
                CALL    FlushKbd        ;  Borramos el mapa de teclas.

  @@CMPulsacion:CMP     [mapa_teclado+1], 1
                JNE   @@NoESC
                XOR     AX, AX
                RET
  @@NoESC:      CMP     [mapa_teclado+2], 1
                JNE   @@No1
                MOV     AX, 1
                RET
  @@No1:        CMP     [mapa_teclado+3], 1
                JNE   @@CMPulsacion
                MOV     AX, 2
                RET
MenuInicial     ENDP

;;;;;;;;;;;;;;;;;;;;;;
;;;;  KERNEL del juego
;;;;;;;;;;;;;;;;;;;;;;

PartidaOne      PROC
                CALL    CreaVirtual     ;  Pido una pantalla virtual.
                CALL    TrataError
                MOV     [HdlJuego], AL

   @@NoMeVale:
                CALL    Aleatorio       ;  Inicializacin.
                AND     AL, 00000011b
                JZ    @@NoMeVale        ;  Reiniciar.
                AND     AH, 00000011b
                JZ    @@NoMeVale        ;  Reiniciar.
                MOV     [XINCbola], AL
                MOV     [YINCbola], AH
                MOV     [XBate1], 150
                MOV     [XBate2], 150   ;  Posiciones iniciales de los bates.
                MOV     [N], 0
                MOV     [Ybola], 100

 @@Entre60y250: CALL    Aleatorio
                XOR     AH, AH
                CMP     AX, 60
                JB    @@Entre60y250
                CMP     AX, 250
                JA    @@Entre60y250     ;  Sencillo procedimiento de repeticin
                MOV     [Xbola], AX     ; para encontrar un valor adecuado.

 @@BuclePrincipal:
                CMP     [FlechaIzq], 1
                JNE   @@NoIzq
                SUB     [Xbate1], 3
                JNS   @@NoIzq
                MOV     [Xbate1], 0
 @@NoIzq:       CMP     [FlechaDer], 1
                JNE   @@NoDer
                ADD     [Xbate1], 3
                CMP     [Xbate1], 320-LONGxBATE
                JB    @@NoDer
                MOV     [Xbate1], 320-LONGxBATE
 @@NoDer:       CALL    MueveComputer   ;  Le toca al ordenador.
                MOVSX   DX, [XINCbola]
                MOVSX   CX, [YINCbola]
                ADD     [Xbola], DX
                ADD     [Ybola], CX     ;  Movimiento de la bola.

                CMP     [Xbola], 320-LONGxBOLA
                JNA   @@NoMuyDer        ;  Se sale por la derecha?
                NEG     [XINCbola]
                JMP   @@Representacion
 @@NoMuyDer:    CMP     [Xbola], LONGxBOLA
                JNB   @@NoMuyIzq        ;  Se sale por la izquierda?
                NEG     [XINCbola]
                JMP   @@Representacion
 @@NoMuyIzq:    CMP     [Ybola], 170
                JA    @@CMPChoke        ;  Vamos a ver si rebota...
                CMP     [Ybola], 30
                JNB   @@Representacion
 @@CMPChoke:    CMP     [YINCbola], 4
                JB    @@Abajo
                MOV     DX, [Xbate2]    ;  Choke palo arriba?
                CMP     [Xbola], DX
                JB    @@NoLaPilla
                ADD     DX, 30
                CMP     [Xbola], DX
                JA    @@NoLaPilla
                NEG     [YINCbola]
                MOV     [N], 0
                JMP   @@Representacion
 @@Abajo:       MOV     DX, [Xbate1]    ;  Choke palo abajo?
                CMP     [Xbola], DX
                JB    @@NoLaPilla
                ADD     DX, 30
                CMP     [Xbola], DX
                JA    @@NoLaPilla
                NEG     [YINCbola]
                MOV     [N], 0
                JMP   @@Representacion
 @@NoLaPilla:   INC     [N]
                CMP     [N], 5
                JBE   @@Representacion
                        ;;  FIN del juego  -->  GAME OVER
                XOR     DX, DX
                MOV     CX, 0FFFFh
                CALL    FadeDown        ;  Borra la pantalla.
                CALL    TrataError
                MOV     AL, [HdlJuego]
                CALL    DestVirtual
                CALL    TrataError
                RET

  @@Representacion:
                PUSH    BP
                MOV     AH, [HdlJuego]
                MOV     AL, [HdlFondJuego]
                CALL    CopiaPantalla
                CALL    TrataError      ;  Dibuja el fondo.
                MOV     AL, [HdlJuego]
                MOV     AH, [HdlSprBola]
                MOV     BP, [Xbola]
                MOV     BX, [Ybola]
                CALL    DibujaSprite
                CALL    TrataError      ;  Dibuja el sprite de la bola.
                MOV     AL, [HdlJuego]
                MOV     AH, [HdlSprBate]
                MOV     BX, 20
                MOV     BP, [Xbate2]
                CALL    DibujaSprite    ;  Dibuja el sprite del bate 2.
                CALL    TrataError
                MOV     AL, [HdlJuego]
                MOV     AH, [HdlSprBate]
                MOV     BX, 170
                MOV     BP, [Xbate1]
                CALL    DibujaSprite    ;  Dibuja el sprite del bate 1.
                CALL    TrataError
                WaitVR                  ;  Esperamos el retrazado.
                MOV     AL, [HdlJuego]
                XOR     AH, AH          ;  Cpia a la VGA.
                CALL    CopiaPantalla
                CALL    TrataError
                POP     BP
                JMP   @@BuclePrincipal
PartidaOne      ENDP

MueveComputer   PROC                    ;  El ordenador hace movimientos muy
                MOV     AX, [Xbate2]    ; simples, se limita a seguir la bola
                ADD     AX, LONGxBATE   ; (que no es poco 8-).
                CMP     [Xbola], AX
                JA    @@Derecha
                SUB     [Xbate2], 3
                RET
  @@Derecha:    ADD     [Xbate2], 3
                RET
MueveComputer   ENDP

PartidaTwo      PROC                    ;  No funciona.
                RET
PartidaTwo      ENDP

;;;;;;;;;;;;;;;;;;;;;;;
;;;;  FUNCIN PRINCIPAL
;;;;;;;;;;;;;;;;;;;;;;;

Main            PROC
                CALL    LiberaMEM
                MOV     AX, @DATA
                MOV     DS, AX

                CALL    PonPresentacion
                        ;  En modo texto una pequea presentacin del juego.
                MOV     BX, 1
                MOV     EAX, 0          ;  No ponemos nada especial.
                CALL    InicGraph       ;  Entramos en el apasionante mundo
                CALL    TrataError      ; de GRAPH.
                CALL    CargaGraficos   ;  Carga los sprites.
                CALL    INIT_TECLADO
                        ;  Captura la IRQ del teclado e inserta un 
                        ; controlador ms adecuado.
                CALL    FlushKbd
                CALL    TrataError
                        ;  Pone la pantalla en modo grfico.

@@BucleInicial: CALL    MenuInicial
                        ;  Dibuja el grfico del men inicial y espera la
                        ; pulsacin de una tecla: ESC=Salir, 1=un player,
                        ; 2=dos players. Devuelve en AX el resultado.
                OR      AX, AX
                JNZ   @@Jugar
                CALL    EndGraph        ;  Regresa al modo anterior.
                CALL    TrataError
                CALL    VaciaMEM        ;  Libera TODA la memoria.
                CALL    FIN_TECLADO     ;  Devuelve control al DOS.
                MOV     AX, 4C00h
                INT     21h             ;  Salir al DOS.

@@Jugar:        CMP     AX, 2
                JZ    @@TwoPlayers
                CALL    PartidaOne      ;  Un jugador.
                JMP   @@BucleInicial
                        ;  Vuelve a la pantalla de presentacin.
@@TwoPlayers:   CALL    PartidaTwo      ;  Si 2 jugadores.
                JMP   @@BucleInicial
Main            ENDP
                END     Main
