/*
  
  
                                                                         
  TEST DE VELOCIDAD DE DIFERENTES FORMAS DE PONER UN PIXEL EN 13H        
  
                                                                         
  Gargon's / Code by eXcalibur                                           
                                                                         
  1997, Gargon Soft.                                                     
  
*/
#include <stdio.h>
#include <conio.h>
#include <time.h>                      


/*-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-... Constantes ...-.-.-.-.-.-.-.-.-.-.-.-.-*/
#define TIME        4

#define GRAFICO         19  
#define TEXTO           3                                                      


/*-.-.-.-.-.-.-.-.-.-.-.-... Declaracin funciones ...-.-.-.-.-.-.-.-.-.-.-.*/
void IniMode(char);
void PutPixelC(int, int, char);
void PutPixelCShr(int, int, char);
void PutPixelVRAM(int, int, char);
void PutPixelCTbl(int, int, char);
void PutPixelASM(int x, int y, char col);


/*-.-.-.-.-.-.-.-.-.-.-.-.-... Variables globales ...-.-.-.-.-.-.-.-.-.-.-.-*/

unsigned char *Pantalla=(unsigned char) 0xA0000000L;

int Linea[199];

long int puntos1i=0, puntos2i=0, puntos3i=0, puntos4i=0, puntos5i=0;
long int puntos1, puntos2, puntos3, puntos4, puntos5;

clock_t INICIO,                                 /* Para control tiempo   */
	FIN;


/* FUNCION PRINCIPAL */
void main(void)
{
 int i;

 for(i=0;i<199;i++)
	Linea[i]=i*320;

 IniMode(TEXTO);                                /* Iniciamos modo texto(cls)*/

 gotoxy(1,3);

 printf("Test de velocidad de las diferentes rutinas:\n\n\r");

 printf("PutPixelC();      > Usando pokeb con multiplicaciones\n\r");
 printf("PutPixelCShl();   > Usando pokeb mediante desplazamientros\n\r");
 printf("PutPixelVRAM();   > Usando la acceso directo a VRAM mediante\n\r");
 printf("                        la tabla precalculada (Line)\n\r");
 printf("PutPixelCTbl();   > Usando pokeb con tabla precalculada\n\r");
 printf("PutPixelASM();   > Usando asm puro y duro XDD\n\n\r");
                                                           

 printf(" La prueba consistir en que cada rutina se ir ejecutando durante\n\r");
 printf("4 segundos poniendo pixels en el medio de la pantalla. Cuando haya acabado\n\r");
 printf("se mostrar el resultado en nmero de pixels por segundo de cada una..\n\n\n\r");

 printf("Pulsa una tecla para continuar..."); 
 getch();

 IniMode(GRAFICO);                      /* Inicializamos modo grfico 13H    
				   (320x200 con 256 colores).
				*/

 /*-------------------------Test 1. PutPixelC();-----------------------------*/
   INICIO=clock();
   while((FIN=(clock()-INICIO)/CLK_TCK) < TIME)
    {
      PutPixelC(160,100,15);
      puntos1i++;
    }
   
   puntos1= puntos1i/TIME;


 IniMode(GRAFICO);

/*-------------------------Test 2. PutPixelCShr();---------------------------*/
   INICIO=clock();
   while((FIN=(clock()-INICIO)/CLK_TCK) < TIME)
    {
      PutPixelCShr(160,100,15);
      puntos2i++;
    }
   
   puntos2= puntos2i/TIME;


 IniMode(GRAFICO);

/*-------------------------Test 3. PutPixelVRAM();---------------------------*/
   INICIO=clock();
   while((FIN=(clock()-INICIO)/CLK_TCK) < TIME)
    {
      PutPixelVRAM(160,100,15);
      puntos3i++;
    }
   
   puntos3= puntos3i/TIME;


 IniMode(GRAFICO);

/*-------------------------Test 4. PutPixelCTbl();---------------------------*/
   INICIO=clock();
   while((FIN=(clock()-INICIO)/CLK_TCK) < TIME)
    {
      PutPixelCTbl(160,100,15);
      puntos4i++;
    }

   puntos4=puntos4i/TIME;

   INICIO=clock();
   while((FIN=(clock()-INICIO)/CLK_TCK) < TIME)
    {
      PutPixelASM(160, 100, 15);
      puntos5i++;
    }
   puntos5=puntos5i/TIME;


 IniMode(TEXTO);

 gotoxy(1,3);
 printf("RESULTADO COMPARACION VELOCIDAD (4 segundos cada rutina)\n\r");
 printf("\n\r\n");

 printf("Usando pokeb con multiplicaciones.................%u pixels segundo.\r\n",puntos1);
 printf("Usando pokeb mediante desplazamientos.............%u pixels segundo.\r\n",puntos2);
 printf("Usando el acceso directo a la Video Ram  mediante\r\n");

 printf("una tabla precalculada (Line).....................%u pixels segundo.\r\n",puntos3);
 printf("Usando pokeb con tabla precalculada...............%u pixels segundo.\r\n",puntos4);
 printf("Usando rutina con ASM.............................%u pixels segundo.\r\n",puntos5);
 printf("\n\n\n");

 asm mov ax, 4c00h                              /* Volvemos al dos        */
 asm int 10h
}

void IniMode(char mode)                         /* Para iniciar un modo   */
 {                                              /* grfico.           */        
  asm xor ax, ax
  asm mov al, mode
  asm int 10h
 }                            


void PutPixelC(int x, int y, char color)        /* Mediante multiplicaciones*/
 {
  pokeb(0xA000,y*320+x,color);
 }

void PutPixelCShr(int x, int y, char color)       /* Usando desplazamientos  */
 {
  pokeb(0xA000,(y<<8)+(y<<6)+x,color);
 }

void PutPixelVRAM(int x, int y, char color)       /* Usando acceso directo a */
 {                                      /* memoria (0xA000) + Tabla*/
  Pantalla[Linea[y]+x]=color;
 }

void PutPixelCTbl(int x, int y, char color)       /* Usando Tabla pero con   */
 {
  pokeb(0xA000,Linea[y]+x,color);               /* pokeb();                */
 }

void PutPixelASM(int x, int y, char col)
 {
  asm mov ax, 0xa000
  asm mov es, ax

  asm mov ax, y
  asm mov di, ax
  asm shl ax, 6
  asm shl di, 8
  asm add di, ax
  asm add di, x

  asm mov al, col

  asm mov es:[di], al
 }