comment ~ 
*****************************************************************************
         Example program for DOS32 dos-extender.


           Using the VESA BIOS Extention.




*****************************************************************************
~
.386
.MODEL FLAT , PASCAL
.STACK

;
;  Macro to print some text on the screem
;
Print MACRO string
local @text,@skip
    mov edx,offset @text
    mov ah,9
    int 21h
    jmp @skip
@text db string,13,10,36
@skip:
ENDM


.DATA
DOS_Ptr             DD ?
VideoPtr            DD ?
ProgramBaseAddress  DD ?

DOS_segs LABEL DWORD
Real_ES     DW  ?
Real_DS     DW  ?

CurrentBank         DB  ?
.CODE


Palette  Label Byte
Include VESA.INC

;---------------------------------------
; SET Video bank number to AL
;---------------------------------------
SetBank PROC USES EDX EBX
        movzx  edx,al
        mov    bh,0
        mov    bl,0
        mov    ax,04F05h
        push   10h
        call   DOSinterrupt
        Ret
SetBank ENDP


VBEstart PROC
         mov    ax,0EE02h       ; GET REAL MODE SEGMENT OF FILE I/O BUFFER
         int    31h
         mov    ProgramBaseAddress,ebx
         mov    Real_ES,ax
         And    Eax,0FFFFh
         shl    Eax,4
         sub    eax,ebx
         Mov    DOS_Ptr,eax


         mov    ax,4F00h        ; GET VESA INFORMATION
         mov    di,0             ; ES:DI -> 256 byte buffer
         push   10h
         call   DOSinterrupt
         Cmp    AX,004Fh
         jne   NoVESA



     ;
     ; Search video mode list for 640x480x256 ( VESA mode 101h )
     ;
         mov   eax,DOS_Ptr
         Movzx edx,Word Ptr [Eax+10h]       ; get DOS segment of mode list
         shl   edx,4
         sub   edx,ProgramBaseAddress
         movzx ebx,Word Ptr [Eax+0Eh]       ; get offset of mode list
         add   edx,ebx
                                            ; EDX points to video mode list.

Loop01:  Mov   ax,[Edx]                     ; Read video mode list
         Cmp   Ax,0FFFFh
         je  @@ModeNotFound
         add   Edx,2
         cmp   Ax,101h
         jne   Loop01

     ;
     ; Calulate CPU video address
     ;
         mov    eax,0A0000h
         sub    eax,ProgramBaseAddress
         mov    VideoPtr,eax

     ;
     ; Set VIDEO mode  640x480x256 ..........
     ;
         mov    ax,4F02h
         mov    BX,101h
         Int    10h
         Cmp    AX,004Fh
         jne    @@ModeNotFound

    ;
    ; Set palette
    ;
         mov    al,0
         mov    dx,3C8h
         out    dx,al
         mov    esi,Offset Palette
         mov    dx,3C9h
         mov    ecx,768
         cld
         rep    outsb


    ;
    ; Fill in screen with some patterns
    ;
         mov     CurrentBank,0
         mov     bl,0
loop02:  mov     edi,VideoPtr
         mov     al,CurrentBank
         call    SetBank
         mov     bh,102
Loop03:  mov     ecx,640/4
         mov     al,bl
         mov     ah,bl
         push    ax
         push    ax
         pop     eax
         rep     stosd
         inc     bl
         dec     bh
         jnz Loop03

         inc     CurrentBank
         cmp     CurrentBank,5
         jb loop02


        mov     ah,0        ; Wait for a key ( using BIOS service )
        int     16h

        mov    ax,3          ; Return to TEXT mode
        int    10h

Exit:
         Mov    Ax,4C00h
         Int    21h

@@ModeNotFound:
         Print 'Video mode 640x480x256 not supported  ( VESA mode 101h )'
         jmp Exit

NoVESA:
         Print 'VESA BIOS not installed'
         jmp Exit

VBEstart ENDP


;------------------------------------------------------------
; Procudure to call a DOS interrupt.
;------------------------------------------------------------
DOSinterrupt PROC
        push    dword ptr 0             ; ignore  SS, SP
        lea     esp,[esp - 8]           ; ignore  CS, IP ,FS, GS
        push    [DOS_segs]
        pushfw
        pushad
        mov     edi,esp
        mov     ax,0300h
        xor     cx,cx
        movzx   Ebx,Byte Ptr [esp+36h]  ; Get int number from stack param
        int     31h                     ; Emulate Real Mode Interrupt
        popad
        popfw
        lea     esp,[esp+16]            ; Ignore SS,SP,CS,IP,FS,GS,ES & DS
        ret     4
DOSinterrupt ENDP

End VBEstart
