;**************************************************************************
;*	Ce module contient les routines servant  rechercher les
;*	informations sur la musique dans le module ST3010
;* Programm par Sbastien Granjoux
;* Commenc le 26/12/93
;* Dernire modif 26/12/93


IDEAL
P386N
MODEL SMALL

PUBLIC	getname
PUBLIC	getinst
PUBLIC	getdevice
PUBLIC	getmaxseq
PUBLIC	dectostr
PUBLIC	gettempo
PUBLIC	getpattern
PUBLIC	getvoice
PUBLIC	gonextpos


STRUC VOIX
	endsamp DW 33
	volume	DB 0
	extra	DB 0
	adrvoc	DP 0
	lenrep	DW 32		; evite un bug
	play    DW 0		; note jou
	newnote	DW 0		; note d'arriv (vibrato et portamento)
	oldnote DW 0		; note prcdente (portamento)
	effet   DW 0
	note1   DW 0
	note2   DW 0
	oldport DW 0
	amplit	DW 0
	vitesse DB 0
	temp	DB 0
	tremolo DB 0
	tremvit DB 0
	oldvol	DB 0
	compte	DB 0
	inst	DB 0	;bit 7 changer vol,6 changer adr,5 changer inst
        gusinf	DB 0	;bit 3 new vol,2 nul vol,1 change adr,0 new inst
        	DB 0
	effnb	DB 0
	looppos DW 0
ENDS

EXTRN	TAB_ARPEGE:far
EXTRN	Nb_voice:far
EXTRN	Voix1:far
EXTRN	Music:far
EXTRN	INSTRUMENT
EXTRN	Instruments:far
EXTRN	Sequence:far
EXTRN	Tempo:far
EXTRN	Speed:far
EXTRN	Ligne:far
EXTRN	Partition:far
EXTRN	Position:far

DATASEG

INST_LEN	EQU	32

inst		DW	0

		ASSUME ds:SEG Voix1

cur_voice	DW	OFFSET Voix1
		ASSUME ds:_DATA


Lastvol		DB	8 DUP (0)

DEVICE_LEN	EQU	5

Devices         DW	OFFSET nuldev
		DW	OFFSET spkdev
		DW	OFFSET dacdev
		DW	OFFSET sbdev
                DW	OFFSET gusdev

Nuldev		DB	'Rien',0
Spkdev		DB	'le haut parleur interne',0
Dacdev		DB	'un DAC sur un port parallle',0
Sbdev		DB	'une carte sound blaster',0
Gusdev		DB	'une Gravis Ultra Sound',0

CODESEG

;************************************************************************
;*	Renvoit le nom de la musique
;*
;* Entre:
;*	ES:DI	buffer o copier le nom musique

PROC	getname

	push	ds
	mov	ax,SEG Music
	mov	ds,ax
	ASSUME	ds:SEG Music
	mov     si,OFFSET Music

	mov	cx,10
	rep	movsw

	pop	ds
	ASSUME	ds:_DATA

	ret

ENDP

;************************************************************************
;*	Renvoit les instruments de la musique
;*
;* Entre:
;*	ES:DI	buffer o copier le nom de l'instrument

PROC	getinst

	push	ds
	mov	si,[word ptr ds:OFFSET inst]

	mov	ax,SEG Instruments
	mov	ds,ax
	ASSUME	ds:SEG Instruments

	add	si,OFFSET Instruments

	mov	cx,11
	rep	movsw

	sub	si,OFFSET Instruments+22
	add	si,INST_LEN
	cmp	si,(INST_LEN)*32
	jb	@@no_loop
	xor	si,si
@@no_loop:
	pop	ds
	ASSUME	ds:_DATA

	mov	[word ptr ds:OFFSET inst],si

	ret

ENDP

;************************************************************************
;*	Renvoit le nom de l'appareil de sortie du son
;*
;* Entre:
;*	ES:DI	buffer o copier le nom de l'appareil
;*	DL	numero de l'appareil

PROC	getdevice

	and	dx,00ffh
	mov	si,dx
	shl	si,1
	mov	si,[ds:OFFSET Devices+si]

	mov	cx,16
	rep	movsw

	ret

ENDP

;***************************************************************************
;*	Renvoit le nombre de position totale de la musique
;* Sortie:
;*	AL	nombre de position totale

PROC	getmaxseq


	push	ds
	mov	ax,SEG Sequence
	mov	ds,ax

	ASSUME	ds:SEG Sequence

	mov	al,[ds:OFFSET Sequence]
	dec	al

	pop	ds
	ASSUME	ds:_DATA

	ret

ENDP

;***************************************************************************
;*	Convertie un nombre en DL en une chaine de caractre reprsentant
;*	ce nombre en dcimal
;*
;* Entre:
;*	DS:DI	adresse de la zone o mettre la chaine sur 3 octet
;*	AL	nombre  convertir

PROC	dectostr

	xor	ah,ah
	mov	bl,100
	div	bl
	or	al,al
	jne	@@number
	sub	al,'0'-' '
@@number:
	add	al,'0'
	mov	[byte ptr ds:di],al
	inc	di
	mov	al,ah
	xor	ah,ah
	mov	bl,10
	div	bl
	or	al,al
	add	al,'0'
	mov	[byte ptr ds:di],al
        inc	di
	add	ah,'0'
	mov	[byte ptr ds:di],ah

	ret

ENDP

;***************************************************************************
;*	Renvoit le tempo dans al et ah
;*
;* Sortie:
;*	AL	tempo normale
;*	AH	tempo tendue

PROC	gettempo

	push	ds
	mov	ax,SEG Sequence
	mov	ds,ax

	ASSUME	ds:SEG Sequence

	mov	ax,[ds:OFFSET Speed]
	mov	bx,100
	mul	bx
	mov	al,[ds:OFFSET Tempo]

	pop	ds
	ASSUME	ds:_DATA

	ret

ENDP

;***************************************************************************
;*	Renvoit la position dans la squence ainsi que le pattern et la
;*	ligne
;*
;* Sortie:
;*	AL	position dans la squence
;*	AH	pattern
;*	DL	ligne

PROC	getpattern

	push	ds
	mov	ax,SEG Ligne
	mov	ds,ax

	ASSUME	ds:SEG Ligne
	mov	eax,[dword ptr ds:OFFSET Ligne]
	shr	ax,2
	mov	cl,[ds:OFFSET Nb_voice]
	div	cl
	mov	dl,al
	shr	eax,16

	ASSUME	ds:SEG Partition
	sub	ax,[ds:OFFSET Partition]
        neg	cl
        add	cl,6
	shl	ax,cl

	ASSUME	ds:SEG Sequence
	mov	al,[ds:OFFSET Position]

	pop	ds
	ASSUME	ds:_DATA

	ret

ENDP

;*************************************************************************
;*	Donne des informations sur les voix  chaque tour
;*
;* Sortie:
;*	AL	instrument
;*	AH	volume
;*	BL	note*2
;*	BH	effet*2
;*	CH	octet jou

PROC	getvoice

	push	ds

	ASSUME	ds:_DATA
	mov	si,[ds:OFFSET cur_voice]
	mov	ax,SEG Voix1
	mov	ds,ax

	ASSUME	ds:SEG Voix1
	mov	cx,[(VOIX PTR ds:si).newnote]

	ASSUME	ds:SEG TAB_ARPEGE
	mov     bx,OFFSET TAB_ARPEGE-2
@@not_find:
	add     bx,2
	cmp     cx,[ds:bx]
	jb      @@not_find

	sub	bx,OFFSET TAB_ARPEGE

	ASSUME	ds:SEG Voix1
	mov	bh,[(VOIX PTR ds:si).effnb]
	mov	ch,[(VOIX PTR ds:si).inst]
	and	ch,1fh
	mov	dl,[(VOIX PTR ds:si).volume]
	mov	cl,[ds:OFFSET Nb_voice]

	lds	edi,[(VOIX PTR ds:si).adrvoc]

	mov	al,[ds:di]
	mul	dl
	mov	al,ch
	mov	ch,ah
	mov     ah,dl

	pop	ds
	ASSUME	ds:_DATA


	mov	di,[cs:cur_vol]

;        pushad
;        xor	edx,edx
;        mov	dx,di
;        call	writelong
;        popad

	mov	dl,[ds:di]
	shr	ch,2
	add	dl,ch
	mov	ch,dl
	shr	ch,4
	sub	dl,ch
	mov	[ds:di],dl
	inc	di

	ASSUME	ds:SEG Voix1

	add	si,SIZE VOIX
	push	ax
	mov	al,SIZE VOIX
	mul	cl
	mov	dx,ax
	pop	ax
	add	dx,OFFSET Voix1
	cmp	si,dx
	jb	@@ok
	mov	si,OFFSET Voix1
	ASSUME	ds:_DATA
	mov	di,OFFSET Lastvol
@@ok:
	ASSUME	ds:_DATA

	mov	[ds:OFFSET cur_voice],si
	mov	[cs:cur_vol],di
	ret
ENDP

cur_vol		DW	OFFSET Lastvol
SCREEN_POS	DW 640

;***************************************************************************
;*	Ecrit un nombre en EAX sur 32 bits en chaine de caractre
;*	correspondant  se reprsentation hexadcimal
;*
;* Entre:
;*	EDX	nombre  convertir

PROC	writelong

	push	es
	mov	ax,0b800h
	mov	es,ax
	mov	di,[cs:SCREEN_POS]
	add	di,16

	mov	ax,'h'
	std
	stosb

	mov	cl,4
@@next_digit:
	movzx	ax,dl
	shr	edx,8
	shl	ax,4
	shr	al,4
	xchg	al,ah
	and	ax,0f0fh
	add	ax,3030h
	cmp	al,3Ah
	jb	@@al_ok
	add	al,7
@@al_ok:
	cmp	ah,3Ah
	jb	@@ah_ok
	add	ah,7
@@ah_ok:
	xchg	al,ah
	dec	di
	stosb
	dec	di
	mov	al,ah
	stosb
	dec	cl
	jne	@@next_digit

	cld

	add	di,19
	mov	al,' '
	stosb
	inc	di

	pop	es

	cmp	di,4000
	jb	@@ok
	mov	di,0
@@ok:
	mov	[cs:SCREEN_POS],di


	ret

ENDP


;*************************************************************************
;*	Passe au  la position suivante

PROC	gonextpos

	push	ds

	mov	ax,SEG Position
	mov	ds,ax
	ASSUME	ds:SEG Position
	mov	bx,[ds:OFFSET Position]

	mov     bl,[ds:OFFSET Position]
	inc     bl
	cmp     bl,[byte ptr ds:OFFSET Sequence]
	jb     @@not_end_seq

	xor	bl,bl
@@not_end_seq:
	 mov    [ds:OFFSET Position],bl
	 mov	al,[byte ptr ds:OFFSET Sequence+2+bx]
	 mov	cl,[ds:OFFSET Nb_voice]
	 mul	cl
	 shl	ax,4
	 add	ax,[ds:OFFSET Partition]
	 mov	[word ptr ds:OFFSET Ligne+2],ax
	 mov	[word ptr ds:OFFSET Ligne],0

	pop	ds
	ASSUME	ds:_DATA

	ret
ENDP

ENDS

END