/**************************************************************************/
/*   Voici un petit programme d'exemple d'intgration de mes routines     */
/*   dans un programme C.                                                 */
/*              							  */
/*   Attention comme la routine de chargement du MOD se charge d'allouer  */
/*   elle mme la mmoire dont elle a besoin,il ne faut pas que le tas    */
/*   occupe toutes la mmoire disponible. (compiler en SMALL). Deplus     */
/*   l'orde d'appel des fonction est importants.	                  */
/*   Evidament il faut lier ce programme avec CRYS24.OBJ.		  */
/*									  */
/* Programm par Sbastien Granjoux                                       */
/* Commenc le 30/12/93                                                   */
/* Modification le 25/10/94						  */

#include <dos.h>

/* Les dfinitions des fonctions de CRYS24.OBJ				  */

extern "C"
{
int far pascal SETMOD(unsigned int frequence,char device,int port,char irq);
int far pascal FLOADMOD(char far *filename);
int far pascal MLOADMOD(char far *adress);
void far pascal DETECTSND(unsigned char far *device,unsigned int far *port,unsigned char far *irq,unsigned char far *dma);
void far pascal UNLOADMOD();
void far pascal STARTMOD();
void far pascal MAKEMOD();
void far pascal STOPMOD();
};

void main()
{
 char *Fichier="c:patega.mod";    /* Nom du fichier  jouer */
 unsigned int port=0;
 unsigned char irq=0;
 unsigned char dma=0;
 unsigned char dev=5;

 DETECTSND(&dev,&port,&irq,&dma); /* Cherche la meilleur cartes sonore
				    dans les variables d'environnements   */

 FLOADMOD(Fichier);               /* Charge le fichier MOD                */

 SETMOD(180,dev,port,irq);	  /* Prpare le MOD  18kHz avec la carte
				    son trouv                            */

 STARTMOD();			  /* Commence la musique                  */

 /* A partir de ce moment il ne peut y avoir que les interruptions clavier
  ou horloge, vous devez donc dmasquer les interruptions qui pourraient
  vous tre utile comme celle du disque dur ou de la souris. Toutefois si
  vous tenez  avoir une musique de la meilleur qualit possible vitez
  de le faire et n'utilisez que des routines simples.		          */

 do
 {
  MAKEMOD();                     /* Calcul 1/50s de musique	          */

 }while(inportb(0x60)>=0x80);    /* Beaucoup plus rapide qu'une fonction
				   du genre de kbhit() et donc meilleur
				   pour la qualit de la musique	  */

 STOPMOD();                      /* Arrte la musique et remet le PC dans
				   son tat initial			  */

 UNLOADMOD();                    /* Rend la mmoire utilis pour charger
				   le MOD au DOS		          */

}
