#ifndef MPLAYER_H
#define MPLAYER_H

#include "mtypes.h"


typedef struct ENVPR{
	UBYTE flg;          // envelope flag
	UBYTE pts;			// number of envelope points
	UBYTE sus;			// envelope sustain index
	UBYTE beg;			// envelope loop begin
	UBYTE end;			// envelope loop end
	WORD  p;			// current envelope counter
	UWORD a;			// envelope index a
	UWORD b;			// envelope index b
	ENVPT *env;			// envelope points
} ENVPR;


typedef struct AUDTMP{
	INSTRUMENT 	*i;
	SAMPLE      *s;

	WORD  fadevol;		// fading volume

	ENVPR venv;
	ENVPR penv;

	UBYTE keyon;		// if true=key is pressed.
	UBYTE kick;			// if true=sample has to be restarted
	UBYTE sample;		// which sample number (0-31)
	WORD  handle;		// which sample-handle

	ULONG start;		// The start byte index in the sample

	UBYTE panning;		// panning position
	UBYTE pansspd;		// panslide speed

	BYTE  volume;		// amiga volume (0 t/m 64) to play the sample at
	UWORD period;		// period to play the sample at

	/* You should not have to use the values
	   below in the player routine */

	BYTE  transpose;

	UBYTE note;			//

	WORD  ownper;
	WORD  ownvol;

	UBYTE *row;			// row currently playing on this channel

	BYTE  retrig;		// retrig value (0 means don't retrig)
	UWORD c2spd;		// what finetune to use

	BYTE  tmpvolume;	// tmp volume

	UWORD tmpperiod;	// tmp period
	UWORD wantedperiod;	// period to slide to (with effect 3 or 5)

	UWORD slidespeed;	//
	UWORD portspeed;	// noteslide speed (toneportamento)

	UBYTE s3mtremor;	// s3m tremor (effect I) counter

	UBYTE s3mvolslide;	// last used volslide

	UBYTE s3mrtgspeed;	// last used retrig speed
	UBYTE s3mrtgslide;	// last used retrig slide

	UBYTE glissando;	// glissando (0 means off)
	UBYTE wavecontrol;	//

	BYTE  vibpos;		// current vibrato position
	UBYTE vibspd;		// "" speed
	UBYTE vibdepth;		// "" depth

	BYTE  trmpos;		// current tremolo position
	UBYTE trmspd;		// "" speed
	UBYTE trmdepth;		// "" depth

	UWORD soffset;		// last used sample-offset (effect 9)
} AUDTMP;


extern AUDTMP mp_audio[32];		// max eight channels
extern UBYTE  mp_bpm;			// beats-per-minute speed
extern UWORD  mp_patpos;		// current row number (0-63)
extern WORD   mp_sngpos;		// current song position
extern UWORD  mp_sngspd;		// current songspeed
extern UBYTE  mp_numchn;		// number of channels

extern BOOL   mp_loop;
extern BOOL   mp_panning;
extern BOOL   mp_extspd;
extern UBYTE  mp_volume;

// Function prototypes:

#ifdef __cplusplus
extern "C" {
#endif

int	 MP_Ready(void);
void MP_NextPosition(void);
void MP_PrevPosition(void);
void MP_HandleTick(void);
void MP_Init(UNIMOD *m);

#ifdef __cplusplus
}
#endif


#endif

