;
; Example .EXE which demonstrates the use of the MikMod routines
; from assembler.
;
; Created Sun 2nd July 1995 by MikMak / Jean-Paul Mikkers
;
        P286                    ; select the processor
        DOSSEG                  ; indicate DOS segment conventions
        MODEL SMALL,PASCAL      ; select the model - can be any model
        JUMPS                   ; enable automatic jump sizing

        STACK 1000h             ; reserve stack space as needed for application

        INCLUDELIB mikmod.lib   ; tell tlink to add mikmod.lib
        INCLUDE mikmod.inc      ; include mikmod declarations

DATASEG

;<<Any initialized data is defined here>>

str1    db 'testmod.uni',0
str2    db 7,'MikMod error: ',0
banner  db 'MikMod 2.03 Assembler version - (c)1995 MikMak / J.P. Mikkers <mikmak@via.nl>',0dh,0ah,0
loading db 'Loading testmod.uni..',0dh,0ah,0
busy    db 'Playing module - press any key to quit',0dh,0ah,0


UDATASEG

   ;<<Any uninitialized data is defined here>>

playertimer     dw ?            ; player timer handle
unimod          dd ?            ; far pointer to loaded module


CODESEG
        ; This marks the start of executable code
        STARTUPCODE
        ; EXE program has all available memory allocated to it
        ; Release all memory except the amount currently being used
        ; End of stack is end of non-heap portion of program
        MOV BX,SP
        ADD BX,15       ;convert SP into paragraphs
        SHR BX,4
        MOV AX,SS       ;calculate size of program using ES PSP address
        ADD BX,AX
        MOV AX,ES
        SUB BX,AX
        MOV AH,4AH      ;resize memory block with PSP
        INT 21H         ;address in ES
        CALL MainPrg    ; call main program, returns with errorlevel in AL
        ;Exit to DOS when complete
        MOV AH,4CH
        INT 21H
        RET

ReportError PROC NEAR
        cmp  word ptr [myerr],0
        jnz  @@wel
        cmp  word ptr [myerr+2],0
        jz   @@niet
@@wel:  call _mm_outstring C,DS OFFSET str2
        call _mm_outstring C,myerr
@@niet: ret
        ENDP

Player  PROC FAR
        ; This is the player interrupt.. it is called as a FAR procedure
        ; so it should do a far return (NOT IRET!!)
        pusha
        call MP_HandleTick C                    ; play a tick
        xor  ax,ax
        mov  al,mp_bpm                          ; fetch current bpm
        call VT_SetBPM C,playertimer,ax         ; set current bpm speed
        call MD_Update C                        ; update hardware channels
        popa
        ret
        ENDP

;Arguments to this procedure:
;ES=PSP address (for command-line arguments)
;Must return an exit value in AL

MainPrg PROC NEAR
        ; Display Banner
        call _mm_outstring C,DS OFFSET banner

        ; uncomment next line if you want nosound support
;;;;;;; call MD_RegisterDriver C,SEG nosnddriver OFFSET nosnddriver
        
        ; Register gus driver & uni loader
        call MD_RegisterDriver C,SEG gusdriver OFFSET gusdriver
        call ML_RegisterLoader C,SEG uniload OFFSET uniload

        ; init vtimer routines & player interrupt:
        call VT_Init C
        call VT_Alloc C
        mov  playertimer,ax
        call VT_SetHandler C,playertimer,SEG Player OFFSET Player

        ; set device preferences & init device:
        mov  md_device,0                        ; autodetect
        mov  md_mixfreq,44100                   ; 44100 Khz
        mov  md_mode,DMODE_STEREO+DMODE_16BITS  ; stereo, 16 bit
        mov  md_dmabufsize,8192                 ; 8192 bytes dma buffer
        call MD_Init C                          ; initialize driver
        or   ax,ax                              ; check return value
        jz   @@devinitfailed                    ; failed? -> exit
        
        ; Load music module:
        call _mm_outstring C,DS OFFSET loading  ; print loading message
        call ML_LoadFN C,DS OFFSET str1         ; load .uni module -> (dx:ax)
        mov  bx,ax                              ; 
        or   bx,dx                              ;
        jz   @@modloadfailed                    ; dx:ax == 0 ? -> exit

        mov  word ptr [unimod],AX               ; store far ptr to module
        mov  word ptr [unimod+2],DX             ;

        ; Init modplayer to play this module:
        call MP_Init C,unimod   
        mov  mp_loop,1          ; restart when it's done playing

        ; set number of channels to be used on device & start mixing:
        mov  al,mp_numchn       ; get number of channels from player vars
        mov  md_numchn,al       ; set number of hardware channels
        call MD_PlayStart C     ; start device mixing

        ; Set BPM speed of player timer interrupt to 125 BPM & start it:
        call VT_SetBPM C,playertimer,125
        call VT_Start C,playertimer

; <<<<<<<< Wait for user to press a key >>>>>>>>

        call _mm_outstring C,DS OFFSET busy
        mov  ah,08h
        int  21h

        ; stop player interrupt & mixing
        call VT_Stop C,playertimer      ; stop interrupt
        call MD_PlayStop C              ; stop mixing
        call ML_Free C,unimod           ; free module
@@modloadfailed:
        call MD_Exit C                  ; de-init device
@@devinitfailed:
        call VT_Exit C                  ; de-init vtimer
        call ReportError                ; report error (if any)
        xor  al,al                      ; clear error code
        RET
        ENDP
        
        
        END
