.286
.model small
.stack 100h

global  morf:proc

.data

plane   db 80 dup (1,2,4,8)
xpage   db 0

square  label word
        c = -100
        rept 4
        b = -100
        rept 4
        a = -100
        rept 4
        dw   a,b,c
        a = a + 50
        endm
        b = b + 50
        endm
        c = c + 50
        endm

cylndr  dw 64*3 dup (0)

cone    dw 64*3 dup (0)

morfis  dw 64*3 dup (0)

sintbl  dw         0 ,   1 ,   2 ,   3 ,   4 ,   6 ,   7 ,   8 ,   9 , 10
        dw        11 ,  12 ,  13 ,  15 ,  16 ,  17 ,  18 ,  19 ,  20 , 21
        dw        22 ,  23 ,  24 ,  26 ,  27 ,  28 ,  29 ,  30 ,  31 , 32
        dw        33 ,  34 ,  35 ,  36 ,  37 ,  39 ,  40 ,  41 ,  42 , 43
        dw        44 ,  45 ,  46 ,  47 ,  48 ,  49 ,  50 ,  51 ,  52 , 53
        dw        54 ,  55 ,  56 ,  57 ,  58 ,  59 ,  60 ,  61 ,  62 , 63
        dw        64 ,  65 ,  66 ,  67 ,  68 ,  69 ,  70 ,  71 ,  72 , 73
        dw        74 ,  74 ,  75 ,  76 ,  77 ,  78 ,  79 ,  80 ,  81 , 82
        dw        82 ,  83 ,  84 ,  85 ,  86 ,  87 ,  87 ,  88 ,  89 , 90
        dw        91 ,  91 ,  92 ,  93 ,  94 ,  95 ,  95 ,  96 ,  97 , 97
        dw        98 ,  99 , 100 , 100 , 101 , 102 , 102 , 103 , 104 ,104
        dw       105 , 106 , 106 , 107 , 108 , 108 , 109 , 109 , 110 ,110
        dw       111 , 112 , 112 , 113 , 113 , 114 , 114 , 115 , 115 ,116
        dw       116 , 117 , 117 , 118 , 118 , 118 , 119 , 119 , 120 ,120
        dw       120 , 121 , 121 , 122 , 122 , 122 , 123 , 123 , 123 ,124
        dw       124 , 124 , 124 , 125 , 125 , 125 , 125 , 126 , 126 ,126
        dw       126 , 126 , 127 , 127 , 127 , 127 , 127 , 127 , 127 ,128
        dw       128 , 128 , 128 , 128 , 128 , 128 , 128 , 128 , 128 ,128
costbl  dw       128 , 128 , 128 , 128 , 128 , 128 , 128 , 128 , 128 ,128
        dw       128 , 128 , 127 , 127 , 127 , 127 , 127 , 127 , 127 ,126
        dw       126 , 126 , 126 , 126 , 125 , 125 , 125 , 125 , 124 ,124
        dw       124 , 124 , 123 , 123 , 123 , 122 , 122 , 122 , 121 ,121
        dw       120 , 120 , 120 , 119 , 119 , 118 , 118 , 118 , 117 ,117
        dw       116 , 116 , 115 , 115 , 114 , 114 , 113 , 113 , 112 ,112
        dw       111 , 110 , 110 , 109 , 109 , 108 , 108 , 107 , 106 ,106
        dw       105 , 104 , 104 , 103 , 102 , 102 , 101 , 100 , 100 , 99
        dw        98 ,  97 ,  97 ,  96 ,  95 ,  95 ,  94 ,  93 ,  92 , 91
        dw        91 ,  90 ,  89 ,  88 ,  87 ,  87 ,  86 ,  85 ,  84 , 83
        dw        82 ,  82 ,  81 ,  80 ,  79 ,  78 ,  77 ,  76 ,  75 , 74
        dw        74 ,  73 ,  72 ,  71 ,  70 ,  69 ,  68 ,  67 ,  66 , 65
        dw        64 ,  63 ,  62 ,  61 ,  60 ,  59 ,  58 ,  57 ,  56 , 55
        dw        54 ,  53 ,  52 ,  51 ,  50 ,  49 ,  48 ,  47 ,  46 , 45
        dw        44 ,  43 ,  42 ,  41 ,  40 ,  39 ,  37 ,  36 ,  35 , 34
        dw        33 ,  32 ,  31 ,  30 ,  29 ,  28 ,  27 ,  26 ,  24 , 23
        dw        22 ,  21 ,  20 ,  19 ,  18 ,  17 ,  16 ,  15 ,  13 , 12
        dw        11 ,  10 ,   9 ,   8 ,   7 ,   6 ,   4 ,   3 ,   2 ,  1
        dw         0 ,  -1 ,  -2 ,  -3 ,  -4 ,  -6 ,  -7 ,  -8 ,  -9 ,-10
        dw       -11 , -12 , -13 , -15 , -16 , -17 , -18 , -19 , -20 ,-21
        dw       -22 , -23 , -24 , -26 , -27 , -28 , -29 , -30 , -31 ,-32
        dw       -33 , -34 , -35 , -36 , -37 , -39 , -40 , -41 , -42 ,-43
        dw       -44 , -45 , -46 , -47 , -48 , -49 , -50 , -51 , -52 ,-53
        dw       -54 , -55 , -56 , -57 , -58 , -59 , -60 , -61 , -62 ,-63
        dw       -64 , -65 , -66 , -67 , -68 , -69 , -70 , -71 , -72 ,-73
        dw       -74 , -74 , -75 , -76 , -77 , -78 , -79 , -80 , -81 ,-82
        dw       -82 , -83 , -84 , -85 , -86 , -87 , -87 , -88 , -89 ,-90
        dw       -91 , -91 , -92 , -93 , -94 , -95 , -95 , -96 , -97 ,-97
        dw       -98 , -99 ,-100 ,-100 ,-101 ,-102 ,-102 ,-103 ,-104 ,-104
        dw      -105 ,-106 ,-106 ,-107 ,-108 ,-108 ,-109 ,-109 ,-110 ,-110
        dw      -111 ,-112 ,-112 ,-113 ,-113 ,-114 ,-114 ,-115 ,-115 ,-116
        dw      -116 ,-117 ,-117 ,-118 ,-118 ,-118 ,-119 ,-119 ,-120 ,-120
        dw      -120 ,-121 ,-121 ,-122 ,-122 ,-122 ,-123 ,-123 ,-123 ,-124
        dw      -124 ,-124 ,-124 ,-125 ,-125 ,-125 ,-125 ,-126 ,-126 ,-126
        dw      -126 ,-126 ,-127 ,-127 ,-127 ,-127 ,-127 ,-127 ,-127 ,-128
        dw      -128 ,-128 ,-128 ,-128 ,-128 ,-128 ,-128 ,-128 ,-128 ,-128
        dw      -128 ,-128 ,-128 ,-128 ,-128 ,-128 ,-128 ,-128 ,-128 ,-128
        dw      -128 ,-128 ,-127 ,-127 ,-127 ,-127 ,-127 ,-127 ,-127 ,-126
        dw      -126 ,-126 ,-126 ,-126 ,-125 ,-125 ,-125 ,-125 ,-124 ,-124
        dw      -124 ,-124 ,-123 ,-123 ,-123 ,-122 ,-122 ,-122 ,-121 ,-121
        dw      -120 ,-120 ,-120 ,-119 ,-119 ,-118 ,-118 ,-118 ,-117 ,-117
        dw      -116 ,-116 ,-115 ,-115 ,-114 ,-114 ,-113 ,-113 ,-112 ,-112
        dw      -111 ,-110 ,-110 ,-109 ,-109 ,-108 ,-108 ,-107 ,-106 ,-106
        dw      -105 ,-104 ,-104 ,-103 ,-102 ,-102 ,-101 ,-100 ,-100 ,-99
        dw       -98 , -97 , -97 , -96 , -95 , -95 , -94 , -93 , -92 ,-91
        dw       -91 , -90 , -89 , -88 , -87 , -87 , -86 , -85 , -84 ,-83
        dw       -82 , -82 , -81 , -80 , -79 , -78 , -77 , -76 , -75 ,-74
        dw       -74 , -73 , -72 , -71 , -70 , -69 , -68 , -67 , -66 ,-65
        dw       -64 , -63 , -62 , -61 , -60 , -59 , -58 , -57 , -56 ,-55
        dw       -54 , -53 , -52 , -51 , -50 , -49 , -48 , -47 , -46 ,-45
        dw       -44 , -43 , -42 , -41 , -40 , -39 , -37 , -36 , -35 ,-34
        dw       -33 , -32 , -31 , -30 , -29 , -28 , -27 , -26 , -24 ,-23
        dw       -22 , -21 , -20 , -19 , -18 , -17 , -16 , -15 , -13 ,-12
        dw       -11 , -10 ,  -9 ,  -8 ,  -7 ,  -6 ,  -4 ,  -3 ,  -2 , -1
        dw        0 ,   1 ,   2 ,   3 ,   4 ,   6 ,   7 ,   8 ,   9 , 10
        dw        11 ,  12 ,  13 ,  15 ,  16 ,  17 ,  18 ,  19 ,  20 , 21
        dw        22 ,  23 ,  24 ,  26 ,  27 ,  28 ,  29 ,  30 ,  31 , 32
        dw        33 ,  34 ,  35 ,  36 ,  37 ,  39 ,  40 ,  41 ,  42 , 43
        dw        44 ,  45 ,  46 ,  47 ,  48 ,  49 ,  50 ,  51 ,  52 , 53
        dw        54 ,  55 ,  56 ,  57 ,  58 ,  59 ,  60 ,  61 ,  62 , 63
        dw        64 ,  65 ,  66 ,  67 ,  68 ,  69 ,  70 ,  71 ,  72 , 73
        dw        74 ,  74 ,  75 ,  76 ,  77 ,  78 ,  79 ,  80 ,  81 , 82
        dw        82 ,  83 ,  84 ,  85 ,  86 ,  87 ,  87 ,  88 ,  89 , 90
        dw        91 ,  91 ,  92 ,  93 ,  94 ,  95 ,  95 ,  96 ,  97 , 97
        dw        98 ,  99 , 100 , 100 , 101 , 102 , 102 , 103 , 104 ,104
        dw       105 , 106 , 106 , 107 , 108 , 108 , 109 , 109 , 110 ,110
        dw       111 , 112 , 112 , 113 , 113 , 114 , 114 , 115 , 115 ,116
        dw       116 , 117 , 117 , 118 , 118 , 118 , 119 , 119 , 120 ,120
        dw       120 , 121 , 121 , 122 , 122 , 122 , 123 , 123 , 123 ,124
        dw       124 , 124 , 124 , 125 , 125 , 125 , 125 , 126 , 126 ,126
        dw       126 , 126 , 127 , 127 , 127 , 127 , 127 , 127 , 127 ,128
        dw       128 , 128 , 128 , 128 , 128 , 128 , 128 , 128 , 128 ,128

alpha   dw 0
beta    dw 0
gamma   dw 0

scanl   label word
    i = 0
    REPT 200
        dw i
    i = i+80
    ENDM

x       dw ?
y       dw ?
z       dw ?
x1      dw ?
y1      dw ?
z1      dw ?
x2      dw ?
y2      dw ?
z2      dw ?

real_x  dw ?
real_y  dw ?

palette db 0,0,0
        db 33,5,5
        db 38,15,15
        db 43,25,25
        db 48,35,35

color   db ?        
disp    dw 20000

current dw 1

.code

        call    morf
        mov     ax,0003h
        int     10h
        mov     ax,4c00h
        int     21h

proc    morf
        mov     ax,@data
        mov     ds,ax
        mov     ax,0012h
        int     10h
        mov     ax,0013h
        int     10h
        push    0a000h
        pop     es
        mov     dx,3c4h
        mov     ax,0604h
        out     dx,ax
        mov     dx,3d4h
        mov     ax,0014h
        out     dx,ax
        mov     ax,0e317h
        out     dx,ax
        mov     ax,109h
        out     dx,ax

        mov     dx,3c8h
        xor     al,al
        out     dx,al
        inc     dx
        mov     cx,15
load_colors:
        xor     ax,ax
        out     dx,al
        loop    load_colors

        call    create_cylndr
        call    create_cone

        mov     cx,80
        mov     current,1
drive_in_loop:
        push    cx
        mov     color,1
        lea     si,square
        call    draw_object
        call    update_angle
        mov     color,2
        lea     si,square
        call    draw_object
        call    update_angle
        mov     color,3
        lea     si,square
        call    draw_object
        call    update_angle
        mov     color,4
        lea     si,square
        call    draw_object
        call    fade
        inc     current
        call    un_update_angle
        sub     disp,250
        call    flip_page
        pop     cx
        loop    drive_in_loop

        mov     disp,0

        mov     cx,300
square_loop:
        push    cx
        mov     color,1
        lea     si,square
        call    draw_object
        call    update_angle
        mov     color,2
        lea     si,square
        call    draw_object
        call    update_angle
        mov     color,3
        lea     si,square
        call    draw_object
        call    update_angle
        mov     color,4
        lea     si,square
        call    draw_object
        call    un_update_angle
        call    flip_page
        pop     cx
        loop    square_loop

        mov     cx,100
        mov     current,1
sq_2_cl_loop:
        push    cx
        lea     di,square
        lea     si,cylndr
        call    transform
        mov     color,1
        lea     si,morfis
        call    draw_object
        call    update_angle
        mov     color,2
        lea     si,morfis
        call    draw_object
        call    update_angle
        mov     color,3
        lea     si,morfis
        call    draw_object
        call    update_angle
        mov     color,4
        lea     si,morfis
        call    draw_object
        call    un_update_angle
        inc     current
        call    flip_page
        pop     cx
        loop    sq_2_cl_loop


        mov     cx,300
cylndr_loop:
        push    cx
        mov     color,1
        lea     si,cylndr
        call    draw_object
        call    update_angle
        mov     color,2
        lea     si,cylndr
        call    draw_object
        call    update_angle
        mov     color,3
        lea     si,cylndr
        call    draw_object
        call    update_angle
        mov     color,4
        lea     si,cylndr
        call    draw_object
        call    un_update_angle
        call    flip_page
        pop     cx
        loop    cylndr_loop

        mov     cx,100
        mov     current,1
cl_2_co_loop:
        push    cx
        lea     di,cylndr
        lea     si,cone
        call    transform
        mov     color,1
        lea     si,morfis
        call    draw_object
        call    update_angle
        mov     color,2
        lea     si,morfis
        call    draw_object
        call    update_angle
        mov     color,3
        lea     si,morfis
        call    draw_object
        call    update_angle
        mov     color,4
        lea     si,morfis
        call    draw_object
        call    un_update_angle
        inc     current
        call    flip_page
        pop     cx
        loop    cl_2_co_loop


        mov     cx,300
cone_loop:
        push    cx
        mov     color,1
        lea     si,cone
        call    draw_object
        call    update_angle
        mov     color,2
        lea     si,cone
        call    draw_object
        call    update_angle
        mov     color,3
        lea     si,cone
        call    draw_object
        call    update_angle
        mov     color,4
        lea     si,cone
        call    draw_object
        call    un_update_angle
        call    flip_page
        pop     cx
        loop    cone_loop


        mov     cx,80
        mov     current,63
drive_out_loop:
        push    cx
        mov     color,1
        lea     si,cone
        call    draw_object
        call    update_angle
        mov     color,2
        lea     si,cone
        call    draw_object
        call    update_angle
        mov     color,3
        lea     si,cone
        call    draw_object
        call    update_angle
        mov     color,4
        lea     si,cone
        call    draw_object
        add     disp,250
        call    fade
        dec     current
        jnz     curok
        mov     current,1
curok:
        call    un_update_angle
        call    flip_page
        pop     cx
        loop    drive_out_loop
        ret
endp    morf

proc    fade
        pusha
        mov     cx,15
        mov     dx,3c8h
        xor     al,al
        out     dx,al
        inc     dx
        lea     si,palette
        mov     bx,current

fade_all_5:
        push    cx
        lodsb
        cmp     bl,al
        jae     no_fade
        mov     al,bl
no_fade:
        out     dx,al
        pop     cx
        loop    fade_all_5
        popa
        ret
endp    fade

proc    create_cone
        pusha
        xor     di,di
        mov     cx,4
        mov     dx,-100
        mov     current,0
height:
        push    cx
        mov     cx,16
        xor     bx,bx
radius:
        push    cx dx
        mov     ax,sintbl[bx]
        mov     cx,current
        sar     ax,cl
        mov     cone[di],ax
        add     di,2
        mov     ax,costbl[bx]
        mov     cx,current
        sar     ax,cl
        mov     cone[di],ax
        add     di,2       
        pop     dx
        mov     ax,dx
        mov     cone[di],ax
        add     di,2
        add     bx,4*24
        pop     cx
        loop    radius
        add     current,1
        add     dx,50
        pop     cx
        loop    height
        popa
        ret
endp    create_cone


proc    transform
        pusha
        mov     cx,64*3
        xor     bx,bx
transform_loop:
        push    cx
        push    bx
        mov     ax,[si]
        add     si,2
        mov     cx,[di]
        add     di,2

        sub     ax,cx
        push    cx
        xor     dx,dx
        mov     bx,current
        imul    bx
        mov     bx,100
        idiv    bx
        pop     cx
        add     ax,cx

        pop     bx
        mov     morfis[bx],ax
        add     bx,2
        pop     cx
        loop    transform_loop
        popa
        ret
endp    transform

proc    create_cylndr
        pusha
        xor     di,di
        mov     cx,4
        mov     dx,-100
depth:
        push    cx
        mov     cx,16
        xor     bx,bx
diameter:
        push    cx
        mov     ax,sintbl[bx]
        mov     cylndr[di],ax
        add     di,2
        mov     ax,costbl[bx]
        mov     cylndr[di],ax
        add     di,2       
        mov     ax,dx
        mov     cylndr[di],ax
        add     di,2
        add     bx,4*24
        pop     cx
        loop    diameter
        add     dx,50
        pop     cx
        loop    depth
        popa
        ret
endp    create_cylndr

proc    draw_object
        pusha
        mov     cx,64
draw_points:
        push    cx
        lodsw
        mov     x,ax
        lodsw
        mov     y,ax
        lodsw
        mov     z,ax

        push    si
        call    rotate
        pop     si
        push    z2 y2 x2
        pop     x y z
        
        mov     ax,disp
        add     z,ax
        add     z,400
        call    draw_xyz

        pop     cx
        loop    draw_points
        popa
        ret
draw_xyz:
        mov     ax,x
        mov     bx,200
        imul    bx
        mov     bx,z
        idiv    bx
        add     ax,160
        mov     real_x,ax

        mov     ax,y
        mov     bx,200
        imul    bx
        mov     bx,z
        idiv    bx        
        add     ax,100
        mov     real_y,ax

        cmp     real_y,5
        jb      off_page
        cmp     real_y,195
        ja      off_page
        cmp     real_x,5
        jb      off_page
        cmp     real_x,315
        ja      off_page

        push    ax        
        call    get_page        
        pop     bx
        shl     bx,1
        add     di,scanl[bx]

        mov     ax,real_x
        mov     bx,ax
        shr     ax,2
        add     di,ax

        mov     dx,3c4h
        mov     al,2
        mov     ah,plane[bx]
        out     dx,ax
        mov     al,color
        stosb
off_page:
        ret
endp    draw_object

proc    get_page
        cmp     xpage,1
        jz      page_one
        mov     di,16000
        ret
page_one:
        xor     di,di
        ret
endp    get_page

proc    flip_page
        cmp     xpage,0
        jz      page_two
        mov     xpage,0
        xor     bx,bx
        call    set_offset
        mov     di,16000
        call    clear_other_page
        jmp     pages_flipped
page_two:
        mov     xpage,1
        mov     bx,16000
        call    set_offset
        xor     di,di
        call    clear_other_page
pages_flipped:
        ret
clear_other_page:
        mov     dx,3c4h
        mov     ax,0f02h
        out     dx,ax
        mov     cx,8000
        xor     ax,ax
        rep     stosw
        ret
endp    flip_page

proc    set_offset
        pusha
        mov     dx,3d4h
        mov     al,0ch
        mov     ah,bh
        out     dx,ax
        inc     al
        mov     ah,bl
        out     dx,ax
        mov     dx,3dah
        in      al,dx
        test    al,8
        jnz     $-3
        in      al,dx
        test    al,8
        jz      $-3
        popa
        ret
endp    set_offset

proc    update_angle
        pusha
        add     alpha,4
        cmp     alpha,2*720
        jb      aok
        sub     alpha,2*720
aok:
        add     beta,4
        cmp     beta,2*720
        jb      bok
        sub     beta,2*720
bok:
        add     gamma,4
        cmp     gamma,2*720
        jb      gok
        sub     gamma,2*720
gok:
        popa
        ret
endp    update_angle

proc    un_update_angle
        pusha
        sub     alpha,4
        sub     beta,4
        sub     gamma,4
        popa
        ret
endp    un_update_angle

proc    rotate
        pusha
        push    si
        mov     si,alpha

        mov     ax,y                    ;x1:=sin(alpha)*y+cos(alpha)*x
        imul    word ptr sintbl[si]
        sar     ax,7
        push    ax
        mov     ax,x
        imul    word ptr costbl[si]
        sar     ax,7
        pop     bx
        add     bx,ax
        mov     x1,bx

        mov     ax,y                    ;y1:=cos(alpha)*y-sin(alpha)*x
        imul    word ptr costbl[si]
        sar     ax,7
        push    ax
        mov     ax,x
        imul    word ptr sintbl[si]
        sar     ax,7
        pop     bx
        sub     bx,ax
        mov     y1,bx

        mov     si,beta

        mov     ax,x1                   ;x2:=cos(beta)*x1-sin(beta)*z
        imul    word ptr costbl[si]
        sar     ax,7
        push    ax
        mov     ax,z
        imul    word ptr sintbl[si]
        sar     ax,7
        pop     bx
        sub     bx,ax
        mov     x2,bx

        mov     ax,z                    ;z1:=cos(beta)*z+sin(beta)*x1
        imul    word ptr costbl[si]
        sar     ax,7
        push    ax
        mov     ax,x1
        imul    word ptr sintbl[si]
        sar     ax,7
        pop     bx
        add     bx,ax
        mov     z1,bx

        mov     si,gamma

        mov     ax,z1                   ;y2:=sin(gamma)*z1+cos(gamma)*y1
        imul    word ptr sintbl[si]
        sar     ax,7
        push    ax
        mov     ax,y1
        imul    word ptr costbl[si]
        sar     ax,7
        pop     bx
        add     bx,ax
        mov     y2,bx

        mov     ax,z1                   ;z2:=cos(gamma)*z1-sin(gamma)*y1
        imul    word ptr costbl[si]
        sar     ax,7
        push    ax
        mov     ax,y1
        imul    word ptr sintbl[si]
        sar     ax,7
        pop     bx
        sub     bx,ax
        mov     z2,bx
        pop     si
        popa
        ret
endp    rotate
end
