.286
.model small
.stack 100h

GLOBAL  GREETINGS:PROC

.data

x_out   dw 0
y_out   dw 768
st1     db 'QQQQQQQQQQ',255
st2     db '    OXYGEN',255
st3     db '  MAJIC IZ',255
st4     db '      MYST',255
st5     db '    FUTURE',254
        db '      CREW',255
st6     db '       ICE',255
st7     db '   ANARCHY',255
st8     db '       DPS',255
st9     db '    IGUANA',255
st10    db '   SUPRISE',255
st11    db '       KLF',255
st12    db '   SILICON',254
        db '     LOGIC',255
st13    db '   CASCADA',255
st14    db '       TSC',255
st15    db '  SONIC PC',255
st16    db '      DUST',255
st17    db '   EXTREME',255
st18    db '       EMF',255
st19    db '  REALTECH',255
st20    db 'QQQQQQQQQQ',255

text    dw offset st20
        dw 1
        dw offset st19
        dw 1
        dw offset st18
        dw 1
        dw offset st17
        dw 1
        dw offset st16
        dw 1
        dw offset st15
        dw 1
        dw offset st14
        dw 1
        dw offset st13
        dw 1
        dw offset st12
        dw 2
        dw offset st11
        dw 1
        dw offset st10
        dw 1
        dw offset st9
        dw 1
        dw offset st8
        dw 1
        dw offset st7
        dw 1
        dw offset st6
        dw 1
        dw offset st5
        dw 2
        dw offset st4
        dw 1
        dw offset st3
        dw 1
        dw offset st2
        dw 1
        dw offset st1
        dw 1
texto   dw 0

bouncer dw ?
plane   db 1,2,4,8
at_end  dw ?

b_ofs   dw 0
bounce1 label byte
include bounce1.inc
bounce2 label byte
include bounce2.inc

palette label byte
include greet.pal

palf    db 'BULLET.DAT',0
handle  dw ?

font    dw ?

.code
        mov     ax,@data
        mov     ds,ax
        mov     ax,4a00h
        mov     bx,1000h
        int     21h
        mov     ax,3d00h
        lea     dx,palf
        int     21h
        mov     bx,ax
        mov     ax,4200h
        mov     cx,9
        mov     dx,04f9eh
        int     21h
        call    greetings
        mov     ax,3e00h
        int     21h
        mov     ax,0003h
        int     10h
        mov     ax,4c00h
        int     21h

proc    greetings
        push    bx
        mov     handle,bx
        mov     ax,0012h
        int     10h
        mov     ax,0013h
        int     10h
        push    0a000h
        pop     es
        mov     dx,3c4h
        mov     ax,0604h
        out     dx,ax
        mov     dx,3d4h
        mov     ax,0014h
        out     dx,ax
        mov     ax,0e317h
        out     dx,ax
        mov     ax,109h
        out     dx,ax

        mov     dx,3c8h
        xor     al,al
        out     dx,al
        inc     dx
        lea     si,palette
        mov     cx,768
load_colors:
        lodsb
        out     dx,al
        loop    load_colors

        mov     ax,4800h
        mov     bx,1000h
        int     21h
        mov     font,ax

        mov     bx,handle
        push    ds
        mov     ax,font
        mov     ds,ax
        mov     ax,3f00h
        mov     cx,320*96
        xor     dx,dx
        int     21h
        pop     ds

        mov     bx,63920
        call    pixel_pan

        mov     cx,30
wait_for_init:
        call    vertical
        loop    wait_for_init

        mov     cx,20
greetings_loop:
        push    cx
        push    bx
        mov     bx,texto
        add     texto,4
        mov     ax,word ptr text[bx+2]
        mov     bouncer,ax
        cmp     bouncer,1
        jz      onlyone
        sub     y_out,32
onlyone:
        mov     si,word ptr text[bx]
        call    write_string
        pop     bx
        mov     b_ofs,0
        mov     cx,250
scroll:
        push    cx
        call    bounce
        call    vertical
        pop     cx
        loop    scroll
        mov     cx,15
wait_a_while:
        call    vertical
        loop    wait_a_while
        pop     cx
        sub     y_out,32
        loop    greetings_loop

        mov     cx,40
wait_after_finished:
        call    vertical
        loop    wait_after_finished

        mov     cx,63
fade_out:
        push    cx
        mov     bx,at_end
        call    pixel_pan
        sub     at_end,80
        call    fade_to_black
        call    vertical
        pop     cx
        loop    fade_out

        push    es
        mov     ax,font
        mov     es,ax
        mov     ax,4900h
        int     21h
        pop     es

        pop     bx
        ret
endp    greetings

proc    fade_to_black
        xor     bl,bl
        mov     cx,256
fade_to_white_stuff:
        push    cx
        mov     dx,3c7h
        mov     al,bl
        out     dx,al
        mov     dx,3c9h
        in      al,dx
        mov     cl,al
        in      al,dx
        mov     ch,al
        in      al,dx
        mov     bh,al
        mov     dx,3c8h
        mov     al,bl
        out     dx,al
        inc     dx
        cmp     cl,0 
        jz      rok
        dec     cl
rok:
        cmp     ch,0
        jz      gok
        dec     ch
gok:
        cmp     bh,0
        jz      bok
        dec     bh
bok:
        mov     al,cl
        out     dx,al
        mov     al,ch
        out     dx,al
        mov     al,bh
        out     dx,al
        inc     bl
        pop     cx
        loop    fade_to_white_stuff
        ret
endp    fade_to_black


proc    bounce
        pusha
        mov     bx,b_ofs
        add     b_ofs,2
        cmp     bouncer,1
        jnz     double
        mov     bx,word ptr bounce1[bx]
        jmp     doneit
double:
        mov     bx,word ptr bounce2[bx]
doneit:
        sub     bx,32
        mov     ax,80
        mov     dx,y_out
        add     dx,bx
        imul    dx
        mov     bx,ax
        mov     at_end,bx
        call    pixel_pan
        popa
        ret
endp    bounce

proc    pixel_pan
        pusha
        mov     dx,3d4h
        mov     al,0ch
        mov     ah,bh
        out     dx,ax
        inc     al
        mov     ah,bl
        out     dx,ax
        popa
        ret
endp    pixel_pan

proc    write_string
        pusha
        push    y_out x_out
get_character:
        lodsb
        cmp     al,255
        jnz     no_quit
        pop     x_out y_out
        popa
        ret
no_quit:
        cmp     al,254
        jnz     no_new_line
        pop     x_out
        push    x_out
        add     y_out,32
        jmp     get_character
no_new_line:
        cmp     al,32
        jnz     no_space
        add     x_out,16
        jmp     get_character
no_space:
        sub     al,65
;        lea     bp,font
        xor     bp,bp   ;!!!!!!!!
check_bp:
        cmp     al,10
        jb      add_offset
        sub     al,10
        add     bp,320*32
        jmp     check_bp
add_offset:
        xor     ah,ah
        mov     cx,32
        imul    cx
        add     bp,ax

        mov     cx,y_out
        mov     ax,80
        imul    cx
        mov     di,ax
        xor     dx,dx
        mov     ax,x_out
        mov     cx,4
        idiv    cx
        mov     bx,dx
        add     di,ax

        inc     bp
        mov     cx,32
draw_character:
        push    di bx cx
        mov     cx,32
draw_line:
        mov     dx,3c4h
        mov     al,2
        mov     ah,plane[bx]
        out     dx,ax
        push    ds
        mov     ax,font
        mov     ds,ax
        mov     al,ds:[bp]
        pop     ds
        mov     es:[di],al
        inc     bp
        inc     bx
        cmp     bx,4
        jz      change_plane
        loop    draw_line
        jmp     finished_line
change_plane:
        xor     bx,bx
        inc     di
        loop    draw_line
finished_line:
        pop     cx bx di
        add     bp,320-32
        add     di,80
        loop    draw_character
finished_character:
        add     x_out,32
        jmp     get_character
endp    write_string

proc    vertical
        pusha
        mov     dx,3dah
        in      al,dx
        test    al,8
        jnz     $-3
        in      al,dx
        test    al,8
        jz      $-3
        popa
        ret
endp    vertical
end
