unit xms;

INTERFACE

const
	XMSError:byte=0;

type
	Txms=record
		bytes:longint;
		HandleOrigen:word;
		DirOrigen:pointer;
		HandleDestino:word;
		DirDestino:pointer;
	end;

var
	MoverXMS:Txms;

function init:boolean;
{TRUE si hay XMS}

function version:word;
{Devuelve la versin de XMS}

procedure AsignarHMA;
{Reserva todo el HMA}

procedure LiberaHMA;
{Libera todo el HMA}

procedure HabilitaA20;
{Habilita globalmente la lnea A20}

procedure InhabilitaA20;
{Inhabilita globalmente la lnea A20}

procedure HabilitaLocalA20;
{Habilita localmente la lnea A20}

procedure InhabilitaLocalA20;
{Inhabilita localmente la lnea A20}

function EstadoA20:boolean;
{Devuelve el estado de la lnea A20, TRUE habilitado}

function XMSMemAvail:word;
{Devuelve la memoria libre en K's}

function XMSMalloc(k:word):word;
{Devuelve el handle para el nmero de K's}

function bloquear(handle:word):LongInt;
{bloquea el handle para poder escribir directamente y devuelve la direccin
en 32 bits}

procedure desbloquear(handle:word);
{desbloquea el handle para poder bloquear otro o liberarlo}

procedure XMSmove;
{mueve bloques de memoria XMS con el tipo Txms}

procedure XMSDalloc(handle:word);
{Libera el handle}

					{TODAS ESTAS FUNCIONES XMS DEVUELVEN ERROR EN XMSError}

IMPLEMENTATION

var
	DirXMS,dir:pointer;

function init:boolean;ASSEMBLER;
ASM
	MOV			AX,$4300
	INT			$2F

	CMP			AL,$80
	JNZ			@ERROR

	MOV			AX,$4310
	INT			$2F

	MOV			WORD(DirXMS),BX
	MOV			WORD(DirXMS+2),ES

	MOV			AL,TRUE
	JMP			@FIN

@ERROR:
	XOR			AL,AL

@FIN:
END;

function version:word;ASSEMBLER;
ASM
	XOR			AH,AH
	CALL		DirXMS

	TEST		AX,AX
	JZ			@ERROR

	MOV			AL,1
	JMP			@FIN

@ERROR:
	MOV			XMSError,BL

@FIN:
END;

procedure AsignarHMA;ASSEMBLER;
ASM
	MOV			AH,1
	MOV			DX,$FFFF
	CALL		DirXMS

	TEST		AX,AX
	JNZ			@BIEN

	MOV			XMSError,BL

@BIEN:
END;

procedure LiberaHMA;ASSEMBLER;
ASM
	MOV			AH,$2
	CALL		DirXMS

	TEST		AX,AX
	JNZ			@BIEN

	MOV			XMSError,BL

@BIEN:
END;

procedure HabilitaA20;ASSEMBLER;
ASM
END;

procedure InhabilitaA20;ASSEMBLER;
ASM
END;

procedure HabilitaLocalA20;ASSEMBLER;
ASM
	MOV 			AH,5
	CALL     	DirXMS
END;

procedure InhabilitaLocalA20;ASSEMBLER;
ASM
	MOV			AH,6
	CALL			DirXMS
END;

function EstadoA20:boolean;ASSEMBLER;
ASM
END;

function XMSMemAvail:word;ASSEMBLER;
ASM
	MOV			AH,8
	CALL		DirXMS

	TEST		AX,AX
	JNZ			@BIEN
	MOV			XMSError,BL

@BIEN:
END;

function XMSMalloc(k:word):word;ASSEMBLER;
ASM
	MOV			AH,9
	MOV			DX,k
	CALL		DirXMS

	TEST		AX,AX
	JZ			@ERROR

	MOV			AX,DX
	JMP			@FIN

@ERROR:
	MOV			XMSError,BL

@FIN:
END;

function bloquear(handle:word):LongInt;ASSEMBLER;
ASM
	MOV			AH,$C
	MOV			DX,handle
	CALL		DirXMS

	TEST		AX,AX
	JZ			@ERROR
	MOV			AX,BX
	JMP			@FIN

@ERROR:
	MOV			XMSError,BL

@FIN:
END;

procedure desbloquear(handle:word);ASSEMBLER;
ASM
	MOV			AH,$D
	MOV			DX,handle
	CALL		DirXMS

	TEST		AX,AX
	JZ			@ERROR
	MOV			AX,BX
	JMP			@FIN

@ERROR:
	MOV			XMSError,BL

@FIN:
END;

procedure XMSmove;ASSEMBLER;
ASM
	MOV			AH,$B
	LDS			SI,dir
	CALL		DirXMS

	TEST		AX,AX
	JNZ			@FIN
	MOV			XMSError,BL

@FIN:
END;

procedure XMSDalloc(handle:word);ASSEMBLER;
ASM
	MOV			AH,$A
	MOV			DX,handle
	CALL		DirXMS

	TEST		AX,AX
	JNZ			@FIN
	MOV			XMSError,BL

@FIN:
END;

begin
	dir:=@MoverXMS;
	FillChar(MoverXMS,SizeOf(MoverXMS),0);
end.