unit syncro;

INTERFACE

uses global;

const
	NO_COMMAND=0;
	BEGIN_MODULE=1;
	END_MODULE=2;
	WHITE_SCREEN=3;
	NEXT_EFFECT=4;
	PAUSE_MODULE=5;
	CONTINUE_MODULE=6;

	CambiaPaginaVisible:boolean=TRUE;

type
	Tsync=(X50,X60,X100,X120,X200,X240,X256,X400,X480,X512);

var
	sync:array[Tsync] of word;

procedure init;
{Pregunta por la tarjeta de sonido y la inicializa}

procedure PlayModule(n:string);
{Toca el MOD n y se sincroniza con el barrido}

procedure StopModule;
{Para la msica}

procedure SetScreenSyncro(temp:word);
{Cambia la frecuencia de barrida a la indicada}

function GetScreenSyncro:word;
{Devuelve la frecuencia actual}

procedure SetColors(p,u:integer;var c:Tpaleta);
{Pone los colores indefinidamente c desde p hasta u}

procedure StopColors;
{Deja de poner los colores indefinidamente}

function GetSemaphore(c:integer):byte;
{Devuelve el semaforo del pattern C}

procedure done;
{Acaba la librera}

IMPLEMENTATION

uses
	ModeX,colors,speed,
	midas,Mplayer,ModP,Mconfig,timer,
	strings;

const
	on:boolean=FALSE;

	PrimerColor:integer=0;
	UltimoColor:integer=0;
	CambiaColorSyncro:boolean=FALSE;

var
	module:PmpModule;
	info:PmpInformation;
	MP:PModulePlayer;
	colores:Tpaleta;

{$F+}
procedure SetAddress;
begin
	if CambiaPaginaVisible then SetDisplayPage(PaginaVisible);
	inc(frames);
end;

procedure InkColors;
begin
	if CambiaColorSyncro then	InkAllRGB(PrimerColor,UltimoColor,colores);
end;
{$F-}

procedure init;
begin
	if on then exit;

	MidasSetDefaults;                   { set MIDAS defaults }
	MidasConfig;       									{ set configuration }

	on:=TRUE;
end;

procedure PlayModule(n:string);
var
	str:array[0..256] of char;

begin
	if not on then exit;

	music:=TRUE;

	MidasInit;                          { initialize MIDAS Sound System }
	StrPCopy(str,n);
	module:=MidasLoadModule(str,@mpMOD,NIL);
	MidasPlayModule(module,0);         	{ start playing }
	MP:=MidasMP;

	SetScreenSyncro(GetScreenSyncro);
end;

procedure StopModule;
begin
	if not music then exit;
	music:=FALSE;

	MidasStopModule(module);            { stop playing }
	MidasFreeModule(module);            { deallocate module }
end;

procedure SetScreenSyncro(temp:word);
begin
	TmrSyncScr(temp,@SetAddress,NIL,@InkColors);
end;

function GetScreenSyncro:word;
var
	temp:word;

begin
	TmrGetScrSync(@temp);
	GetScreenSyncro:=temp;
end;

function GetSemaphore(c:integer):byte;
begin
	MP^.GetInformation(@info);

	with info^ do with chans^[c] do if ord(command)=8 then
		GetSemaphore:=InfoByte else GetSemaphore:=0;
end;

procedure SetColors(p,u:integer;var c:Tpaleta);
begin
	PrimerColor:=p;
	UltimoColor:=u;
	CambiaColorSyncro:=TRUE;

	SpeedMove(c,colores,SizeOf(colores));
end;

procedure StopColors;
begin
	CambiaColorSyncro:=FALSE;
end;

procedure done;
begin
	if not on then exit;

	TmrStopScrSync;
	TmrClose;

	MidasClose;                         { uninitialize MIDAS }

	on:=FALSE;
end;

end.