unit Modo101;

INTERFACE

uses global;

function Init:boolean;

procedure LoadPCX(n:string;var p:Tpaleta);

procedure done;

IMPLEMENTATION

uses
 XMS,
{$IFDEF _megafich_ }
	Megafich
{$ELSE}
	files
{$ENDIF}
 ;

var

	Granularity : Word;
	 gRA2 : LongInt;
	 Mem : ^byte;
	vRAM : word;

function Init;
var
	error : integer;
begin
	GetMem(Mem,256);
   vRAM:=$a000;
asm
	PUSHA
	LES DI,Mem
   MOV AX,$4F00
   INT $10
   CMP AL,$4F
	 JNE @no_hay
	 MOV AX,ES:[DI+$12]
	CMP AX,8
   JL @no_hay
	MOV AX,$4F02
   MOV BX,$0101
   INT $10
	MOV AX,$4F01
	 MOV CX,$0101
   INT $10
   MOV AX,ES:[DI+$04]
   MOV Granularity,AX
	MOV error,0
   jmp @salir
@no_hay:
	MOV error,1
@salir:
	POPA
end;
	gra2:=LongInt(granularity)*1024;
	Init:=(error=0);
end;

procedure done;
begin
	FreeMem(Mem,256);
  ASM
     MOV AX,$13
     INT $10
  END;
end;

procedure LoadPCX(n : string; var p:Tpaleta);
type
	PCXHeader=record
		manufacturer,version,encoding,BitsPerPixel:byte;
		XMin,YMin,XMax,YMax,HRes,VRes:word;
		palette:array[0..47] of byte;
		reserved:byte;
		ColorPlanes:byte;
		BytesPerLine:word;
		PalleteType:word;
		filler:array[0..57] of byte;
	end;


var
	PCX : Tfile;
	l : word;
	 header : PCXHeader;
	 handle : integer;
	 PCXmem : ^byte;
	 offs : LongInt;
	 contador : Word;
	 segm : Word;
    ofm,lim: Word;
begin
	open(PCX,n,RO);
	 seek(PCX,0);
	 read(PCX,header,SizeOf(header),l);
	if not ( header.manufacturer = 10) and (header.version = 5) and
			(header.BitsPerPixel = 8) and (header.ColorPlanes = 1) and
			(header.XMax = 639) and (header.YMax = 479) then
	 begin
		close(PCX);
			exit;
	 end;
	 GetMem(PCXmem,64000);
	 segm:=seg(PCXmem^);
    ofm:=ofs(PCXmem^);
    lim:=ofm+31999;
	XMS.init;
	 offs:=0;
	handle:=XMSMalloc(480);
	 seek(PCX,128);
	 FileSize(PCX);
	 MoverXMS.HandleOrigen:=0;
	 MoverXMS.HandleDestino:=handle;
	 MoverXMS.DirOrigen:=PCXmem;
	 MoverXMS.bytes:=64000;
	 l:=64000;
	 while l = 64000  do
	 begin
		 MoverXMS.DirDestino:=pointer(offs);
		read(PCX,PCXmem^,64000,l);
			XMSMove;
			inc(offs,l);
	 end;
	close(PCX);
asm
	PUSH DS
	 LES DI,p
	 MOV AX,l
	 SUB AX,768
	 LDS SI,PCXmem
	 ADD SI,AX
	 MOV CX,768
	 CLD
@bucle:
{	MOV AL,DS:[SI]
	 INC SI}
	 LODSB
	 SHR AL,2
{   MOV ES:[DI],AL
	 INC DI}
	 STOSB
	 LOOP @bucle
	 POP DS
end;

	contador:=0;
	offs:=0;
asm
	PUSHA
	 MOV AX,$4F05
	 MOV BX,0
	 MOV DX,0
	 INT $10
	 POPA
	 LES SI,PCXMem
	 MOV AX,ES
	 MOV segm,AX
	MOV ES,vRAM
	DB $66; XOR DI,DI
	DB $66; XOR DX,DX
	PUSHA
end;
	while offs < 640*480 -1 do
	 begin
		 MoverXMS.HandleOrigen:=handle;
		MoverXMS.HandleDestino:=0;
		 MoverXMS.DirOrigen:=pointer(offs);
		MoverXMS.DirDestino:=PCXmem;
		 MoverXMS.bytes:=32000;
		XMSMove;
asm
		POPA
		MOV AX,segm
			DB $8E,$E0     {MOV FS,AX}
			MOV SI,ofm
@BUCLE:
			MOV CX,1
			DB $64; MOV AL,[SI]
			INC SI
			CMP AL,$C0
			JB @SIGUE
			MOV CL,AL
			AND CL,63
		DB $64; MOV AL,[SI]
			INC SI
@SIGUE:
{		REP STOSB}
		MOV ES:[DI],AL
		DB $66;INC DI
			db $66;CMP DI,word(Gra2)
			JL @BUCLE2
			INC DX
			PUSHA
			MOV AX,$4F05
			MOV BX,0
			INT $10
			POPA
			PUSH AX
			DB $66;SUB DI,word(Gra2)
			MOV AX,contador
			ADD AX,granularity
			MOV contador,AX
			POP AX
@BUCLE2:
		LOOP @SIGUE
@BUCLE1:
		CMP SI,lim
			JL @BUCLE
			MOV l,SI
@FIN:
			PUSHA
end;
		inc(offs,l-ofm);
	end;
asm
	POPA
end;
	FreeMem(PCXmem,64000);
	XMSDalloc(handle);
end;
end.