{$DEFINE precision}

unit mode13;

INTERFACE

uses global;

const
	XMAX=319;YMAX=199;
	CENTERX=160;CENTERY=100;

	RELACION=1.2;
	CIRCLE_ADJUST=0.707106781;

	vRAM:word=$a000;
	vRAM2:word=$a000;

type
	ClipRegion=record
		xul,yul,xlr,ylr:word
	end;

	MaxX=0..XMAX;MaxY=0..YMAX*2;

const
	clipping:boolean=FALSE;
	region:ClipRegion=(xul:0;yul:0;xlr:XMAX;ylr:YMAX);

	VGA:^byte=ptr($a000,0);

var
	MultBy320:array[0..YMAX] of word;
	ModoActual:Tmodo;
	PvRAM1,PvRAM2:^byte;

function init(m:Tmodo):boolean;
{Cambia el modo de video}

procedure done;
{Devuelve el anterior modo de video}

procedure OutTextXY(var x:MaxX;y:MaxY;color,fondo:byte;cadena:string);
{Escribe la cadena CADENA en las coordenadas XY con color y fondo}

procedure OutNumXY(x:MaxX;y:MaxY;color,fondo:byte;num:LongInt);
{Escribe el nmero num en las coordenadas XY con el color y fondo}

procedure print(x:MaxX;y:MaxY;color,fondo:byte;cadena:string;num:LongInt);

function test(x:MaxX;y:MaxY):byte;
{devuelve el color de las coordenadas XY}

procedure plot(x:MaxX;y:MaxY;col:byte);
{Pone el color COL en las coordenadas XY}

procedure PlotFondo(x:MaxX;y:MaxY;col:byte);
{Pone el color COL en las coordenadas XY}

procedure PlotXor(x:MaxX;y:MaxY;col:byte);
{Poneel color COL en las coordenadas XY, pero primero
hace un XOR con el fondo}

procedure draw(x1:MaxX;y1:MaxY;x2:MaxX;y2:MaxY;color:byte);
{dibuja una lnea desde X1Y1 hasta X2Y2 con el color COLOR}

procedure DrawH(x1:MaxX;y:MaxY;x2:MaxX;color:byte);
{dibuja una lnea horizontal desde X1Y1 hasta X2 con el color COLOR}

procedure DrawV(x:MaxX;y1:MaxY;y2:MaxY;color:byte);
{dibuja una lnea vertical desde X1Y1 hasta Y2 con el color COLOR}

procedure circle(x:MaxX;y:MaxY;radio:real;color:byte);
{Dibuja un crculo en las coordenadas X e Y con el
radio RADIO y color COLOR}

procedure ellipse(xx:MaxX;yy:MaxY;a0:MaxX;b0:MaxY;color:byte);
{Dibuja un elipse en las coordenadas XX e YY con el radio A0 y B0 y color COLOR}

procedure rectangle(x1:MaxX;y1:MaxY;x2:MaxX;y2:MaxY;color:byte);
{Borra el rectngulo dado con el color COLOR en x1y1x2y2}

procedure box(x1:MaxX;y1:MaxY;x2:MaxX;y2:MaxY;color:byte);
{Pone un caja en X1Y1, X2Y2 con COLOR}

function clip(var x1,y1,x2,y2:integer):boolean;
{Hace un clipping de x1 y1 , x2 y2}

procedure poligono(vertices:integer;var poligono:Tpoligono;color:byte);
{Rellena un polgono de n VERTICES, con COLOR, con las coordenadas de
polgono}

procedure PoligonoGouraud(vertices:integer;var poligono:Tpoligono;color1,color2:word);

procedure ClsPage(var s);
{Borra con 0 el puntero S de 64k}

procedure CopyPage(var p1,p2);
{Copia el puntero p1 al puntero 2, 64K}

procedure CopyPageAndClsPage(var p1,p2);
{Copia el puntero p1 al puntero p1 y lo borra}

procedure CopyBackGroundAndCopy2vRAM(var p1,p2,p3);
{Copia el puntero p1 al puntero p2 y el puntero p2 al p3}

procedure anima;
{Copia el segmento vRAM a la memoria de video y lo borra}

function LoadPCX(n:string;s:word;var p:Tpaleta):boolean;
{Carga un PCX en el segmento s y devuelve la paleta p}

procedure FillEllipse(x,y,rx,ry,color:integer);
{hace una elipse en x MAX 128 y MAX 50 con radios rx,xy y color}

IMPLEMENTATION

uses memory,
{$IFDEF _megafich_}
	megafich;
{$ELSE}
	files;
{$ENDIF}

const
	SC_INDEX=$3C4;

	TOPE=YMAX*2;

	inicializado:boolean=FALSE;
	numero:LongInt=$8000;

var
	senos:array[0..360+90] of word;

	my,mxy,m1,m2:integer;
	xi,xd:array[-TOPE..TOPE] of word;

	d,dInc1,dInc2,NumPixels,
	cx1,cy1,cx2,cy2:integer;

function init(m:Tmodo):boolean;
begin
	if not VGAexist then exit;

	ModoActual:=m;

	init:=FALSE;

{	VgaOff;}
	ASM
		MOV		AX,$13
		INT		$10
	END;
{	frame;
	VgaOn;}

	CENTER_X:=CENTERX;
	CENTER_Y:=CENTERY;

	init:=TRUE;

	case m of
		BORRA:
			begin
				PvRAM1:=MemAllocSeg(64000);
				FillChar(PvRAM1^,64000,0);
				vRAM:=seg(PvRAM1^);
			end;

		COPIA:
			begin
				PvRAM1:=MemAllocSeg(64000);
				FillChar(PvRAM1^,64000,0);
				vRAM2:=seg(PvRAM1^);

				PvRAM2:=MemAllocSeg(64000);
				FillChar(PvRAM2^,64000,0);
				vRAM:=seg(PvRAM2^);
			end;
	end;

	mv:=MO13;
end;

procedure done;
begin
	ASM
		MOV		AX,3
		INT		$10
	END;

	case ModoActual of
		COPIA:
			begin
				FreeMem(PvRAM1,64000);
				FreeMem(PvRAM2,64000);
			end;
		BORRA:FreeMem(PvRAM1,64000);
	end;
end;

procedure OutTextXY(var x:MaxX;y:MaxY;color,fondo:byte;cadena:string);

	procedure text(xx,yy:integer;caracter:char;c,f:byte);ASSEMBLER;
ASM
	PUSH			DS

	MOV				BX,yy
	ADD				BX,BX
	MOV				DI,xx
	ADD				DI,WORD(MultBy320[BX])

	MOV				AX,$40
	MOV				DS,AX
	MOV				CX,DS:[$85]

	XOR				AX,AX
	MOV				DS,AX
	MOV				AL,caracter
	MOV				BX,$43*4
	LDS				SI,DS:[BX]
	MUL				CL
	ADD				SI,AX
	MOV				BL,c
	MOV       BH,f

@BUCLE:
	PUSH			CX
	MOV				CX,8
	LODSB
	MOV				AH,AL

@CONT1:
	MOV				AL,BL
	ADD				AH,AH
	JC				@CONT2
	MOV				AL,BH

@CONT2:
	STOSB
	DEC				CX
	JNZ				@CONT1

@SIGUE:
	ADD				DI,320-8
	POP				CX
	DEC				CX
	JNZ				@BUCLE

	POP				DS
END;

var
	m:byte;
	cx:integer;

begin
	cx:=x;
	ASM MOV ES,vRAM	END;
	for m:=1 to length(cadena) do
		begin
			text(cx,y,cadena[m],color,fondo);
			inc(cx,8);
		end;
	x:=cx;
end;

procedure OutNumXY(x:MaxX;y:MaxY;color,fondo:byte;num:LongInt);
var
	s:string;

begin
	str(num,s);
	OutTextXY(x,y,color,fondo,s);
end;

procedure print(x:MaxX;y:MaxY;color,fondo:byte;cadena:string;num:LongInt);
var
	s:string;

begin
	OutTextXY(x,y,color,fondo,cadena);
	inc(x,8);

	str(num,s);
	OutTextXY(x,y,color,fondo,s);
end;

function test(x:MaxX;y:MaxY):byte;ASSEMBLER;
ASM
	MOV				ES,vRAM

	MOV				BX,y
	MOV				DI,x

	CMP				BX,YMAX
	JA				@SIGUE
	CMP				DI,XMAX
	JA				@SIGUE

	ADD				BX,BX
	ADD				DI,WORD(MultBy320[BX])
	MOV				AL,ES:[DI]

@SIGUE:
END;

procedure plot(x:MaxX;y:MaxY;col:byte);ASSEMBLER;
ASM
	MOV				ES,vRAM

	MOV				BX,y
	MOV				DI,x

	CMP				BX,YMAX
	JA				@SIGUE
	CMP				DI,XMAX
	JA				@SIGUE

	ADD				BX,BX
	ADD				DI,WORD(MultBy320[BX])
	MOV				AL,col
	MOV				ES:[DI],AL

@SIGUE:
END;


procedure PlotFondo(x:MaxX;y:MaxY;col:byte);ASSEMBLER;
ASM
	MOV				ES,vRAM2

	MOV				BX,y
	MOV				DI,x

	CMP				BX,YMAX
	JA				@SIGUE
	CMP				DI,XMAX
	JA				@SIGUE

	ADD				BX,BX
	ADD				DI,WORD(MultBy320[BX])
	MOV				AL,col
	MOV				ES:[DI],AL

@SIGUE:
END;

procedure PlotXor(x:MaxX;y:MaxY;col:byte);ASSEMBLER;
ASM
	MOV				ES,vRAM

	MOV				BX,y
	MOV				DI,x

	CMP				BX,YMAX
	JA				@SIGUE
	CMP				DI,XMAX
	JA				@SIGUE

	ADD				BX,BX
	ADD				DI,WORD(MultBy320[BX])
	MOV				AL,col
	XOR				ES:[DI],AL

@SIGUE:
END;

procedure draw(x1:MaxX;y1:MaxY;x2:MaxX;y2:MaxY;color:byte);ASSEMBLER;
ASM
	PUSH	BP
	MOV		ES,vRAM

	MOV		AL,color
	MOV		BYTE(@PRINCIPAL+3),AL

	MOV		BX,x1
	MOV		CX,y1
	MOV		DX,x2
	MOV		AX,y2

	CMP		BX,DX         {if x1>x2 then swap(x1,x2);}
	JLE		@YM						{@XM}
	XCHG	BX,DX

@XM:
(*	CMP		CX,AX         {if y1>y2 then swap(y1,y2);}
	JLE		@YM*)
	XCHG	CX,AX

@YM:
	MOV		cx1,BX
	MOV		cy1,CX
	MOV		cx2,DX
	MOV		cy2,AX

	SUB		DX,BX
	JZ		@LINE_V       {if DeltaX=0 then DrawV(x1,y1,y2,color);}
	JGE		@XS
	NEG		DX       			{DeltaX:=abs(DeltaX);}

@XS:
	SUB		AX,CX
	JZ		@LINE_H       {if DeltaY=0 then DrawH(x1,y1,x2,color);}
	JGE		@YS
	NEG		AX       			{DeltaY:=abs(DeltaY);}

@YS:
	CMP		DX,AX
	JL		@DELTA_MENOR	{if DeltaX >= DeltaY then...}

	MOV		CX,AX
	ADD		CX,CX
	MOV		dInc1,CX      {dInc1 := DeltaY Shl 1;}

	SUB		AX,DX
	ADD		AX,AX
	MOV		dInc2,AX			{dinc2 := (DeltaY - DeltaX) shl 1;}

	SUB		CX,DX
	MOV		d,CX          {d := (2 * DeltaY) - DeltaX;}

	MOV		CX,DX
	INC		CX
	MOV		NumPixels,CX	{NumPixels := DeltaX + 1;}

	MOV		AX,1       		{xInc1=1}
	XOR		SI,SI       	{yInc1=0}

	MOV		DX,AX       	{xInc2=1}
	MOV		BP,320       	{yInc2=1}

	JMP		@CONTINUE

@DELTA_MENOR:
	MOV		CX,DX
	ADD		CX,CX
	MOV		dInc1,CX      {dInc1 := DeltaX Shl 1;}

	SUB		DX,AX
	ADD		DX,DX
	MOV		dInc2,DX			{dinc2 := (DeltaX - DeltaY) shl 1;}

	SUB		CX,AX
	MOV		d,CX          {d := (2 * DeltaX) - DeltaY;}

	MOV		CX,AX
	INC		CX
	MOV		NumPixels,CX	{NumPixels := DeltaY + 1;}

	XOR		AX,AX      		{xInc1=0}
	MOV		SI,320       	{yInc1=1}

	MOV		DX,1       		{xInc2=1}
	MOV		BP,SI       	{yInc2=1}

@CONTINUE:
	MOV		DI,cy1
	CMP		DI,cy2
	JLE		@Y_MENOR
	NEG		SI						{yInc1 := - yInc1;}
	NEG		BP						{yInc2 := - yInc2;}

@Y_MENOR:
	MOV		CX,cx1
	CMP		CX,cx2
	JLE		@X_MENOR
	NEG		AX            {xInc1 := - xInc1;}
	NEG		DX            {xInc2 := - xInc2;}

@X_MENOR:
	ADD   SI,AX					{ScreenInc1 := yInc1 * 320 + xInc1;}
	ADD		BP,DX					{ScreenInc2 := yInc2 * 320 + xInc2;}

	ADD		DI,DI
	MOV		DI,WORD(MultBy320[DI])
	ADD		DI,CX

	MOV		CX,NumPixels
	MOV		DX,d

	MOV		BX,dInc1
	MOV		AX,dInc2

@PRINCIPAL:
	MOV		BYTE(ES:[DI]),$FF
	TEST	DX,DX
	JGE		@MAYOR
											{d<0}
	ADD		DX,BX         {inc(d,dInc1);}
	ADD		DI,SI
	JMP		@SIGUE

@MAYOR:  							{d>=0}
	ADD		DX,AX         {inc(d,dInc2);}
	ADD		DI,BP

@SIGUE:
	DEC		CX
	JNZ		@PRINCIPAL

	JMP		@FIN

{---------------------------------------------------------------------------}
@LINE_H:
	MOV		DI,CX		{CX=y1}
	ADD		DI,DI
	MOV		DI,WORD(MultBy320[DI])
	ADD		DI,BX   {BX=x1}

	MOV		CX,cx2  {DX=x2}
	INC		CX
	SUB		CX,BX   
	JZ		@FIN    {if x2-x1=0 then goto fin}

	MOV		AL,color
	MOV		AH,AL
	MOV		BX,AX
	DB		_386;SHL AX,16
	MOV		AX,BX

	MOV		DX,CX
	AND		DX,3
	SHR		CX,2
	REP;	DB _386;STOSW     {REP STOSD}
	MOV		CX,DX
	SHR		CX,1
	REP		STOSW
	ADC		CX,CX
	REP		STOSB

	JMP		@FIN

{---------------------------------------------------------------------------}
@LINE_V:
	CMP		AX,CX
	JBE		@MENOR
	XCHG	AX,CX

@MENOR:
	MOV		DI,AX		{AX=y2,CX=y1}
	ADD		DI,DI
	MOV		DI,WORD(MultBy320[DI])
	ADD		DI,BX		{BX=x1}

	SUB		CX,AX
	INC		CX

	MOV		AL,color

	PUSH	DS
	MOV		DX,ES
	MOV		DS,DX

	MOV		BX,320

@BUCLE_V:
	MOV		[DI],AL
	ADD		DI,BX
	DEC		CX
	JNZ		@BUCLE_V

@FIN_V:
	POP		DS

@FIN:
	POP		BP
END;

procedure DrawH(x1:MaxX;y:MaxY;x2:MaxX;color:byte);ASSEMBLER;
ASM
	MOV			ES,vRAM

	MOV			BX,region.xul
	MOV			DX,region.xlr

	MOV			AX,x1
	MOV			CX,x2

	CMP			AX,CX
	JLE			@SIGUE
	XCHG		AX,CX     {if x1>x2 then swap(x1,x2);}

@SIGUE:
	CMP			AX,DX
	JG			@SALIR		{if x1>region.xlr then goto fin}

	CMP			AX,BX
	JGE			@SIGUE1
	MOV			AX,BX     {if x1<region.xul then x1:=region.xul}

@SIGUE1:
	CMP			CX,BX
	JL			@SALIR    {if x2<region.xul then goto salir}

	CMP			CX,DX
	JLE			@SIGUE2
	MOV			CX,DX     {if x2>region.xlr then x2:=region.xlr}

@SIGUE2:
	MOV			BX,y

	CMP			BX,region.ylr
	JG			@SALIR        {if y>region.ylr then goto fin}

	CMP			BX,region.yul
	JL			@SALIR        {if y<region.yul then goto fin}

	ADD			BX,BX
	MOV			DI,AX
	ADD			DI,WORD(MultBy320[BX])

	SUB			CX,AX
	INC			CX

	MOV			AL,color
	MOV			AH,AL
	MOV			BX,AX
	DB			_386;SHL			AX,16
	MOV			AX,BX

	MOV			DX,CX
	AND			DX,3
	SHR			CX,2
	REP;		DB _386;	STOSW     {REP STOSD}
	MOV			CX,DX
	SHR			CX,1
	REP			STOSW
	ADC			CX,CX
	REP			STOSB

@SALIR:
END;

procedure DrawV(x:MaxX;y1:MaxY;y2:MaxY;color:byte);ASSEMBLER;
ASM
	PUSH		DS

	MOV			AX,y1
	MOV			CX,y2

	CMP			AX,CX
	JLE			@SIGUE
	XCHG		AX,CX

@SIGUE:
	MOV			BX,region.yul
	MOV			DX,region.ylr

	CMP			AX,DX
	JG			@SALIR		{if y1>region.ylr then goto fin}

	CMP			AX,BX
	JGE			@SIGUE1
	MOV			AX,BX     {if y1<region.yul then y1:=region.yul}

@SIGUE1:
	MOV			CX,y2
	CMP			CX,BX
	JL			@SALIR    {if y2<region.yul then goto salir}

	CMP			CX,DX			{if y2>region.ylr then y2:=region.ylr}
	JLE			@SIGUE2
	MOV			CX,DX

@SIGUE2:
	MOV			DI,AX
	ADD			DI,DI
	MOV			DI,WORD(MultBy320[DI])

	MOV			BX,x
	CMP			BX,region.xlr
	JG			@SALIR        {if x>region.xlr then goto fin}

	CMP			BX,region.xul
	JL			@SALIR        {if y<region.xul then goto fin}

	ADD			DI,BX

	SUB			CX,AX
	INC			CX

	MOV			AL,color
	MOV			DX,320
	MOV			DS,vRAM

@BUCLE:
	MOV			[DI],AL
	ADD			DI,DX
	DEC			CX
	JNZ			@BUCLE

@SALIR:
	POP			DS
END;

procedure circle(x:MaxX;y:MaxY;radio:real;color:byte);
var
	 radqu,xx,yy,u1,u2,u3,u4,v1,v2,v3,v4,counter:word;

begin
	 counter:=0;
	 radqu:=trunc(sqr(radio));
	 yy:=trunc(sqrt(radqu-sqr(x)));
	 for xx:=0 to trunc(radio/1.41421356240) do
		begin
			u1:=x-xx;v1:=y-yy;
			u2:=x+xx;v2:=y+yy;
			u3:=x-yy;v3:=y-xx;
			u4:=x+yy;v4:=y+xx;

			plot(u1,v1,color);
			plot(u1,v2,color);
			plot(u2,v1,color);
			plot(u2,v2,color);
			plot(u3,v3,color);
			plot(u3,v4,color);
			plot(u4,v3,color);
			plot(u4,v4,color);
		end;
end;

procedure ellipse(xx:MaxX;yy:MaxY;a0:MaxX;b0:MaxY;color:byte);

	procedure Set4Pixels(xx,yy,x,y:integer;col:byte);ASSEMBLER;
ASM
	MOV				DX,xx
	MOV				CX,yy
	MOV				AL,col
	MOV				SI,y

{	plot(cx+xx,cy+yy,color);}
	MOV				BX,SI
	ADD				BX,CX
	ADD				BX,BX
	MOV				DI,x
	ADD				DI,DX
	ADD				DI,WORD(MultBy320[BX])
	MOV				ES:[DI],AL

{	plot(cx-xx,cy+yy,color);}
	SUB				DI,DX
	SUB				DI,DX
	MOV				ES:[DI],AL

{	plot(cx+xx,cy-yy,color);}
	MOV				BX,SI
	SUB				BX,CX
	ADD				BX,BX
	MOV				DI,x
	ADD				DI,DX
	ADD				DI,WORD(MultBy320[BX])
	MOV				ES:[DI],AL

{	plot(cx-xx,cy-yy,color);}
	ADD				DX,DX
	SUB				DI,DX
	MOV				ES:[DI],AL
end;

var
	x,y:integer;
	a,b,asquared,TwoAsquared,BSquared,TwoBSquared,d,dx,dy:LongInt;

begin
	x:=0;y:=b0;
	a:=a0;b:=b0;
	asquared:=sqr(a);
	TwoAsquared:=2*asquared;
	BSquared:=sqr(b);
	TwoBSquared:=2*BSquared;
	d:=BSquared-asquared*b+asquared div 4;
	dx:=0;
	dy:=TwoAsquared*b;

	ASM MOV	ES,vRAM END;

	while dx<dy do
		begin
			Set4Pixels(x,y,xx,yy,color);
			if d>0 then
				begin
					dec(y);
					dec(dy,TwoAsquared);
					dec(d,dy);
				end;
			inc(x);
			inc(dx,TwoBSquared);
			inc(d,BSquared+dx);
		end;
	inc(d,(3*(asquared-BSquared) div 2-(dx+dy)) div 2);
	while y>=0 do
		begin
			Set4Pixels(x,y,xx,yy,color);
			if d<0 then
				begin
					inc(x);
					inc(dx,TwoBSquared);
					inc(d,dx);
				end;
			dec(y);
			dec(dy,TwoAsquared);
			inc(d,asquared-dy);
		end;
end;

procedure rectangle(x1:MaxX;y1:MaxY;x2:MaxX;y2:MaxY;color:byte);ASSEMBLER;
ASM
	MOV			ES,vRAM

	MOV			AX,x1
	MOV			CX,y1

	MOV			BX,CX
	ADD			BX,BX
	MOV			DI,AX
	ADD			DI,WORD(MultBy320[BX])

	MOV			BP,x2
	SUB			BP,AX
	INC			BP

	MOV			BX,y2
	SUB			BX,CX
	INC			BP

	MOV			SI,320
	SUB			SI,BP

	MOV			AL,color
	MOV			AH,AL
	MOV   	DX,AX
	DB			_386;SHL AX,16
	MOV			AX,DX

@BUCLE:
	MOV			DX,CX
	AND			DX,3
	SHR			CX,2
	REP;		DB _386;	STOSW     {REP STOSD}
	MOV			CX,DX
	SHR			CX,1
	REP			STOSW
	ADC			CX,CX
	REP			STOSB

	ADD			DI,SI
	DEC			BX
	JNZ			@BUCLE

@SALIR:
END;

procedure box(x1:MaxX;y1:MaxY;x2:MaxX;y2:MaxY;color:byte);
begin
	draw(x1,y1,x2,y1,color);
	draw(x1,y1,x1,y2,color);
	draw(x1,y2,x2,y2,color);
	draw(x2,y1,x2,y2,color);
end;

{function clip(var x1,y1,x2,y2:integer):boolean;
type
	OcsRec=record
		code0,code1,code2,code3:boolean;
	end;

	OutCodeRec=record
		case boolean of
			0:(OutCodes:LongInt);
			1:(ocs:OcsRec);
		end;

procedure SetOutCodes(var u:OutCodeRec;x,y:integer);
begin
	u.OutCodes:=0;
	u.ocs.code0:=(x<region.xul);
	u.ocs.code1:=(y<region.yul);
	u.ocs.code2:=(x>region.xlr);
	u.ocs.code3:=(y>region.ylr);
end;

procedure Swap(var pa,pb:integer);
var
	t:integer;

begin
	t:=pa;
	pa:=pb;
	pb:=t
end;

var
	ocu1,ocu2,ocu3:OutCodeRec;
	Inside,Outside:boolean;

begin
	SetOutCodes(ocu1,x1,y1);
	SetOutCodes(ocu2,x2,y2);

	Inside:=(ocu1.OutCodes or ocu2.OutCodes)=0;
	Outside:=(ocu1.OutCodes and ocu2.OutCodes)<>0;

	while (not OutSide) and (not InSide) do
		begin
			if ocu1.OutCodes=0 then
				begin
					swap(x1,x2);
					swap(y1,y2);

					ocu3:=ocu1;
					ocu1:=ocu2;
					ocu2:=ocu3
				end;

			if ocu1.ocs.code0 then
				begin
					y1:=y1+(y2-y1)*(region.xul-x1) div (x2-x1);
					x1:=region.xul;
				end else if ocu1.ocs.code1 then
					begin
						x1:=x1+(x2-x1)*(region.yul-y1) div (y2-y1);
						y1:=region.yul;
					end else if ocu1.ocs.code2 then
						begin
							y1:=y1+(y2-y1)*(region.xlr-x1) div (x2-x1);
							x1:=region.xlr;
						end else if ocu1.ocs.code3 then
							begin
								x1:=x1+(x2-x1)*(region.ylr-y1) div (y2-y1);
								y1:=region.ylr;
							end;

			SetOutCodes(ocu1,x1,y1);
			Inside:=(ocu1.OutCodes or ocu2.OutCodes)=0;
			Outside:=(ocu1.OutCodes and ocu2.OutCodes)<>0;
		end;

	clip:=inside
end;}

function clip(var x1,y1,x2,y2:integer):boolean;ASSEMBLER;
ASM
	push	bp

	les		di,x1
	mov		bx,es:[di]

	les		di,y1
	mov		cx,es:[di]

	les		di,x2
	mov		si,es:[di]

	les		di,y2
	mov		di,es:[di]

@@doclip:
	cmp	bx,si			{is the line vertical?}
	je	@@vert

	cmp	cx,di
	je	@@horz		{or horizontal?}

{------------------------------}
	xor	al,al

	test	cx,cx
	jns	@no1
	or	al,0001b
	jmp	@dox

@no1:
	cmp	cx,200
	jl	@dox
	or	al,0010b

@dox:
	test	bx,bx
	jns	@no2
	or	al,0100b
	jmp	@no3

@no2:
	cmp	bx,320
	jl	@no3
	or	al,1000b

@no3:

{----------------------------}

	xor	ah,ah

	test di,di
	jns	@no1_
	or	ah,0001b
	jmp	@dox_

@no1_:
	cmp	di,199
	jl	@dox_
	or	ah,0010b

@dox_:
	test	si,si
	jns	@no2_
	or	ah,0100b
	jmp	@no3_

@no2_:
	cmp	si,320
	jl	@no3_
	or	ah,1000b

@no3_:
{----------------------------}

	mov	dl,al			{don't draw if the line is fully}
	and	dl,ah			{outside the screen (outcodes}
	jnz	@@outside		{have at least 1 same bit set}

	mov	dl,al
	or	dl,ah			{if both outcodes are zero, the line}
	jz	@@done			 {is completely on screen}

	test	al,al
	jnz	@@cp1
	mov	al,ah			{ swap points if point 1 doesn't need}
	xchg	bx,si		{	 clipping}
	xchg	cx,di

@@cp1:
	mov	bp,ax			{ bp = outcode for point 1}

	test	al,0001b
	jz	@@no11

	mov	ax,si			{ outcode AND 1 != 0 --> point is}
	sub	ax,bx			{ above the window}
	neg	cx
	imul	cx
	add	cx,di			{ x1 = x1 + (x2-x1) * (0-y1) / (y2-y1)}
	idiv	cx
	add	bx,ax

	xor	cx,cx			{ y1 = 0}

	jmp	@@no12


@@no11:
	test	bp,0010b
	jz	@@no12

	mov	ax,si			{ outcode AND 2 != 0 --> point is}
	sub	ax,bx			{below the window}
	mov	dx,199
	sub	dx,cx
	imul	dx
	neg	cx
	add	cx,di			{ x1 = x1 + (x2-x1) * (yMax-y1)}
	idiv	cx			{	/ (y2-y1)}
	add	bx,ax

	mov	cx,199		{ y1 = yMax}


@@no12:
	cmp	bx,si
	je	@@horz

	test	bp,0100b
	jz	@@no13

	mov	ax,di			{ outcode AND 4 != 0 --> point is}
	sub	ax,cx			{ to left of the window}
	neg	bx
	imul	bx
	add	bx,si
	idiv	bx			{y1 = y1 + (y2-y1) * (0-x1) / (x2-x1)}
	add	cx,ax

	xor	bx,bx			{x1 = 0}

	jmp	@@doclip


@@no13:
	test	bp,1000b
	jz	@@doclip

	mov	ax,di			{ outcode AND 8 != 0 --> point is}
	sub	ax,cx			{ to right of the window}
	mov	dx,319
	sub	dx,bx
	imul	dx
	neg	bx
	add	bx,si
	idiv	bx			{ y1 = y1 + (y2-y1) * (xMax-x1)}
	add	cx,ax			{	/ (x2-x1)}

	mov	bx,319		{x1 = xMax}

	jmp	@@doclip

@@outside:
	mov	ax,FALSE
	pop bp
	jmp	@@exit

@@vert:
	{ vertical line}
	cmp	cx,di
	jle	@@v1			{swap endpoints if y2<y1}
	xchg	cx,di
	xchg	bx,si

@@v1:
	test	di,di
	js	@@outside		{is the line completely outside the}
	cmp	cx,200		{ screen?}
	jge	@@outside
	cmp	bx,320		{ in X direction?}
	jae	@@outside

	cmp	di,200
	jl	@@v2
	mov	di,199

@@v2:
	test	cx,cx
	jns	@@done
	xor	cx,cx
	jmp	@@done


@@horz:
	{ horizontal line}
	cmp	bx,si
	jle	@@h1			{swap endpoints if x2<x1}

	xchg	bx,si
	xchg	cx,di

@@h1:
	test	si,si
	js	@@outside		{is the line completely outside the}
	cmp	bx,320			{ screen?}
	jge	@@outside
	cmp	cx,200		{in Y direction?}
	jae	@@outside

	cmp	si,320
	jl	@@h2
	mov	si,319

@@h2:
	test	bx,bx
	jns	@@done
	xor	bx,bx


@@done:
	pop		bp

	mov		ax,di

	les		di,x1
	mov		es:[di],bx

	les		di,y1
	mov		es:[di],cx

	les		di,x2
	mov		es:[di],si

	les		di,y2
	mov		es:[di],ax

	mov al,TRUE

@@exit:
END;

procedure poligono(vertices:integer;var poligono:Tpoligono;color:byte);ASSEMBLER;
ASM
	CLD
	PUSH		BP

	MOV			AL,color
	MOV			AH,AL
	MOV			BX,AX
	DB			_386;SHL		AX,16
	MOV			AX,BX
	DB			_386;MOV		WORD(@COLORIN+2),AX

	MOV			SI,WORD(poligono)
	MOV			AX,WORD(poligono+2)       {GS:SI=@poligono[0]}
	DW			MOV_GS_AX

	DB			GS;MOV			DX,[SI+4]  		{DX=poligono[1].x}
	DB			GS;MOV			DI,[SI+6]  		{DI=poligono[1].y}
	ADD			SI,8                      {GS:SI=@poligono[2]}

	MOV			AX,DI                     {AX=my}
	MOV			BX,DI                     {BX=mxy=my}

	MOV			CX,vertices
	MOV			WORD(@VERT+1),CX
	DEC			CX                        {for i:=2 to vertices do}

@BUCLE00:
	DB			GS;MOV			BP,Tpoligono[SI].Txy.y

	CMP			BP,AX		{if poligono[i].y<my my:=poligono[i].y}
	JGE			@SIGUE_Y
	MOV			AX,BP

@SIGUE_Y:
	CMP			BP,BX 	{if poligono[i].y>mxy mxy:=poligono[i].y}
	JLE			@SIGUE_X
	MOV			BX,BP

@SIGUE_X:
	ADD			SI,4
	DEC			CX
	JNZ			@BUCLE00

	DB			GS;MOV			Tpoligono[SI].Txy.x,DX	{poligono[vertices+1].x:=poligono[1].x;}
	DB			GS;MOV			Tpoligono[SI].Txy.y,DI	{poligono[vertices+1].y:=poligono[1].y;}

	MOV			CX,region.yul
	MOV			DX,region.ylr

	CMP			AX,CX        	{if my<region.yul then my:=region.yul;}
	JGE			@MAYOR_0
	MOV			AX,CX

@MAYOR_0:
	CMP			BX,DX					{if mxy>region.ylr then mxy:=region.ylr;}
	JLE			@MENOR_YMAX
	MOV			BX,DX

@MENOR_YMAX:
	CMP			AX,DX
	JG			@FINAL				{if my>region.ylr then goto final}

	CMP			BX,CX
	JL			@FINAL				{if mxy<region.yul then goto final}

	CMP			AX,BX
	JE			@FINAL        {if mx=mxy then goto final}

	MOV     my,AX
	MOV			mxy,BX

{---------------------------------------------------------------------------}

@VERT:
	MOV			CX,0     				{for i:=vertices DownTo 1 do}
	SUB			SI,4						{GS:SI=@poligono[i];}

	MOV			AX,DS
	MOV			ES,AX

@COM:
		PUSH		CX

		DB			GS;MOV			DI,Tpoligono[SI].Txy.y		{y2=poligono[i].y}
		CMP			DI,TOPE
		JG			@MAYOR11

		CMP			DI,-TOPE    {Cutre cdigo...}
		JG			@SIGUE11
		MOV			DI,-TOPE+1
		JMP			@SIGUE11

@MAYOR11:
		MOV			DI,TOPE-1

@SIGUE11:
		MOV			DX,DI       {Guardo y1}

		DB			GS;MOV			BX,Tpoligono[SI+4].Txy.y	{y1=poligono[i+1].y}
		CMP			BX,TOPE
		JG			@MAYOR22

		CMP			BX,-TOPE
		JG			@SIGUE22
		MOV			BX,-TOPE+1
		JMP			@SIGUE22

@MAYOR22:
		MOV			BX,TOPE-1   {BX=m2}

@SIGUE22:
		DB			GS;MOV			AX,Tpoligono[SI].Txy.x		{x1:=poligono[i].x;}
		DB			GS;MOV			BP,Tpoligono[SI+4].Txy.x 	{x2:=poligono[i+1].x;}

		SUB			DI,BX							{a:=y2-y1;}
		DD			MOVSX_ECX_DI

		JZ			@FIN_BUCLE				{if a=0 then continue}
		JL			@A_MENOR          {if a<0 then goto a_menor}

		LEA			DI,Xi+(TOPE*2) 		{ES:DI=@xi[0]}
		ADD			BX,BX
		ADD			DI,BX
		JMP			@A_SIGUE

@A_MENOR:
		SUB			BX,DX             {a:=y1-y2}
		DD			MOVSX_ECX_BX

		LEA			DI,Xd+(TOPE*2)  	{ES:DI=@xd[0]}
		ADD			DX,DX             {Recupero y1}
		ADD			DI,DX

		XCHG		AX,BP             {swap(x1,x2)}

@A_SIGUE:
			INC			CX

			DB			$66,$81,$C5,$0,0,0,$80{ADD EBP,$80000000}
			SUB			AX,BP
{      INC			AX{}
			DB			_386;SHL		AX,16    	{incr:=(c2-c1)+1 shl 16;}
			DW			CDQ
			DB			_386;IDIV		CX      	{incr:=incr div p;}

			DB			_386;ROL		AX,16     {Intercambia EAX}
			DB			_386;XCHG		AX,BP

			{$IFNDEF precision}
			CLC
			{$ENDIF}

@BUCLEG:            								{for n:=1 to p+1 do}
			STOSW
			{$IFNDEF precision}
			DB			_386;ADC		AX,BP   	{inc(acum,incr);}
			{$ELSE}
			DB			_386;ADD		AX,BP
			ADC			AX,0
			{$ENDIF}
			DEC			CX
			JNZ			@BUCLEG

@FIN_BUCLE:
		POP			CX

		SUB			SI,4
		DEC			CX
		JNZ			@COM

{---------------------------------------------------------------------------}
	MOV			AX,region.xul
	MOV			WORD(@R1+1),AX

	MOV			AX,region.xlr
	MOV			WORD(@R2+1),AX

	MOV			BX,my

	MOV			ES,vRAM
	XOR			DI,DI

	MOV			BP,BX
	ADD			BP,BP
	ADD			DI,WORD(DS:MultBy320[BP])   {DirPant:=my*320}

	LEA			SI,Xi+(TOPE*2)
	ADD			SI,BP                   {GS:SI=@Xid[my]}

	MOV			BP,mxy
	SUB			BP,BX
	INC			BP                      {for n:=(mxy-my)+1 DownTo 0 do}

@BUCLE_P:
	LODSW                           {AX=xi[n]}
	MOV			CX,[SI+(TOPE*4)]    		{CX=xd[n]}

	CMP			AX,CX
	JLE			@SIGUE
	XCHG		AX,CX                   {if x1>x2 swap(x1,x2)}

@SIGUE:
	PUSH		BX   {Guardo y1}
	PUSH		DI   {Guardo DirPant}

{----------------------------------------------------------------------------}
@R1:
	MOV			DX,0

@R2:
	MOV			BX,0

	CMP			AX,BX     {if x1>region.xlr then goto salir}
	JG			@SALIR

	CMP			CX,DX     {if x2<region.xul then goto salir}
	JL			@SALIR

	CMP			AX,DX     {if x1<region.xul then x1:=region.xul}
	JGE			@SIGUE10
	MOV			AX,DX

@SIGUE10:
	CMP			CX,BX   	{if x2>region.xlr then x2:=region.xlr}
	JLE			@SIGUE20
	MOV			CX,BX

@SIGUE20:
	ADD			DI,AX			{inc(DirPant,x1);}
	SUB			CX,AX			{dec(x2,x1)}
	INC			CX

@COLORIN:
	DB			$66,$B8,0,0,0,0		{MOV EAX,0}
	MOV			DX,CX
	AND			DX,3
	SHR			CX,2
	REP;		DB _386;	STOSW   {REP STOSD}
	MOV			CX,DX
	SHR			CX,1
	REP			STOSW
	ADC			CX,CX
	REP			STOSB

@SALIR:
{----------------------------------------------------------------------------}
	POP			DI          	{Recupero DirPant}
	ADD			DI,320      	{Y salto a la siguiente lnea}

	POP			BX
	INC			BX
	DEC			BP
	JNZ			@BUCLE_P

@FINAL:
	POP			BP
END;

procedure PoligonoGouraud(vertices:integer;var poligono:Tpoligono;color1,color2:word);ASSEMBLER;
ASM
	CLD
	PUSH		BP

	MOV			AX,color1
	MOV			WORD(@COLORIN1+1),AX

	MOV			AX,color2
	MOV			WORD(@COLORIN2+1),AX

	MOV			SI,WORD(poligono)
	MOV			AX,WORD(poligono+2)       {GS:SI=@poligono[0]}
	DW			MOV_GS_AX

	DB			GS;MOV			DX,[SI+4]  		{DX=poligono[1].x}
	DB			GS;MOV			DI,[SI+6]  		{DI=poligono[1].y}
	ADD			SI,8                      {GS:SI=@poligono[2]}

	MOV			AX,DI                     {AX=my}
	MOV			BX,DI                     {BX=mxy=my}

	MOV			CX,vertices
	MOV			WORD(@VERT+1),CX
	DEC			CX                        {for i:=2 to vertices do}

@BUCLE00:
	DB			GS;MOV			BP,Tpoligono[SI].Txy.y

	CMP			BP,AX		{if poligono[i].y<my my:=poligono[i].y}
	JGE			@SIGUE_Y
	MOV			AX,BP

@SIGUE_Y:
	CMP			BP,BX 	{if poligono[i].y>mxy mxy:=poligono[i].y}
	JLE			@SIGUE_X
	MOV			BX,BP

@SIGUE_X:
	ADD			SI,4
	DEC			CX
	JNZ			@BUCLE00

	DB			GS;MOV			Tpoligono[SI].Txy.x,DX	{poligono[vertices+1].x:=poligono[1].x;}
	DB			GS;MOV			Tpoligono[SI].Txy.y,DI	{poligono[vertices+1].y:=poligono[1].y;}

	MOV			CX,region.yul
	MOV			DX,region.ylr

	CMP			AX,CX        	{if my<region.yul then my:=region.yul;}
	JGE			@MAYOR_0
	MOV			AX,CX

@MAYOR_0:
	CMP			BX,DX					{if mxy>region.ylr then mxy:=region.ylr;}
	JLE			@MENOR_YMAX
	MOV			BX,DX

@MENOR_YMAX:
	CMP			AX,DX
	JG			@FINAL				{if my>region.ylr then goto final}

	CMP			BX,CX
	JL			@FINAL				{if mxy<region.yul then goto final}

	CMP			AX,BX
	JE			@FINAL        {if mx=mxy then goto final}

	MOV     my,AX
	MOV			mxy,BX

{---------------------------------------------------------------------------}
@VERT:
	MOV			CX,0     				{for i:=vertices DownTo 1 do}
	SUB			SI,4						{GS:SI=@poligono[i];}

	MOV			AX,DS
	MOV			ES,AX

@COM:
		PUSH		CX

		DB			GS;MOV			DI,Tpoligono[SI].Txy.y		{y2=poligono[i].y}
		CMP			DI,TOPE
		JG			@MAYOR11

		CMP			DI,-TOPE    {Cutre cdigo...}
		JG			@SIGUE11
		MOV			DI,-TOPE+1
		JMP			@SIGUE11

@MAYOR11:
		MOV			DI,TOPE-1

@SIGUE11:
		MOV			DX,DI       {Guardo y1}

		DB			GS;MOV			BX,Tpoligono[SI+4].Txy.y	{y1=poligono[i+1].y}
		CMP			BX,TOPE
		JG			@MAYOR22

		CMP			BX,-TOPE
		JG			@SIGUE22
		MOV			BX,-TOPE+1
		JMP			@SIGUE22

@MAYOR22:
		MOV			BX,TOPE-1   {BX=m2}

@SIGUE22:
		DB			GS;MOV			AX,Tpoligono[SI].Txy.x		{x1:=poligono[i].x;}
		DB			GS;MOV			BP,Tpoligono[SI+4].Txy.x 	{x2:=poligono[i+1].x;}

		SUB			DI,BX							{a:=y2-y1;}
		DD			MOVSX_ECX_DI

		JZ			@FIN_BUCLE				{if a=0 then continue}
		JL			@A_MENOR          {if a<0 then goto a_menor}

		LEA			DI,Xi+(TOPE*2) 		{ES:DI=@xi[0]}
		ADD			BX,BX
		ADD			DI,BX
		JMP			@A_SIGUE

@A_MENOR:
		SUB			BX,DX             {a:=y1-y2}
		DD			MOVSX_ECX_BX

		LEA			DI,Xd+(TOPE*2)  	{ES:DI=@xd[0]}
		ADD			DX,DX             {Recupero y1}
		ADD			DI,DX

		XCHG		AX,BP             {swap(x1,x2)}

@A_SIGUE:
			INC			CX

(*			DB			$66,$81,$C5,$0,0,0,$80{ADD EBP,$80000000}
			SUB			AX,BP
{			INC			AX}
			DB			_386;SHL		AX,16    	{incr:=(c2-c1)+1 shl 16;}
			DW			CDQ
			DB			_386;IDIV		CX      	{incr:=incr div p;}

			DB			_386;ROL		AX,16     {Intercambia EAX}
			DB			_386;XCHG		AX,BP

			{$IFNDEF precision}
			CLC
			{$ENDIF}

@BUCLEG:            								{for n:=1 to p+1 do}
			STOSW
			{$IFNDEF precision}
			DB			_386;ADC		AX,BP   	{inc(acum,incr);}
			{$ELSE}
			DB			_386;ADD		AX,BP   	{inc(acum,incr);}
			ADC			AX,0
			{$ENDIF}
			DEC			CX
			JNZ			@BUCLEG*)

			SUB			AX,BP
			INC			AX
			DB			_386;SHL			AX,16
			DW			CDQ
			DB			_386;IDIV		CX
			DB			$66,$F,$A4,$C2,$10		{SHLD EDX,EAX,16}

			MOV			BX,$8000
			XCHG		AX,BP

@BUCLE:
			STOSW
			ADD			BX,BP
			ADC			AX,DX
			DEC			CX
			JNZ			@BUCLE

@FIN_BUCLE:
		POP			CX

		SUB			SI,4
		DEC			CX
		JNZ			@COM

{---------------------------------------------------------------------------}
	MOV			AX,region.xul
	MOV			WORD(@R1+1),AX

	MOV			AX,region.xlr
	MOV			WORD(@R2+1),AX

	MOV			BX,my

	MOV			ES,vRAM
	XOR			DI,DI

	MOV			BP,BX
	ADD			BP,BP
	ADD			DI,WORD(DS:MultBy320[BP])   {DirPant:=my*320}

	LEA			SI,Xi+(TOPE*2)
	ADD			SI,BP                   {GS:SI=@Xid[my]}

	MOV			BP,mxy
	SUB			BP,BX
	INC			BP                      {for n:=(mxy-my)+1 DownTo 0 do}

	DB			_386;XOR			CX,CX			{Nos cargamos la parte alta de ECX}

@BUCLE_P:
	LODSW                           {AX=xi[n]}
	MOV			CX,[SI+(TOPE*4)]    		{CX=xd[n]}

	CMP			AX,CX
	JLE			@SIGUE
	XCHG		AX,CX                   {if x1>x2 swap(x1,x2)}

@SIGUE:
	PUSH		BX   {Guardo y1}
	PUSH		DI   {Guardo DirPant}

{----------------------------------------------------------------------------}
@R1:
	MOV			DX,0

@R2:
	MOV			BX,0

	CMP			AX,BX     {if x1>region.xlr then goto salir}
	JG			@SALIR

	CMP			CX,DX     {if x2<region.xul then goto salir}
	JL			@SALIR

	CMP			AX,DX     {if x1<region.xul then x1:=region.xul}
	JGE			@SIGUE10
	MOV			AX,DX

@SIGUE10:
	CMP			CX,BX   	{if x2>region.xlr then x2:=region.xlr}
	JLE			@SIGUE20
	MOV			CX,BX

@SIGUE20:
	ADD			DI,AX			{inc(DirPant,x1);}
	SUB			CX,AX			{dec(x2,x1)}
	JZ			@SALIR
	INC			CX

	DB			$66,$BB,$0,0,0,$80		{MOV EBX,$80000000}
@COLORIN1:
	MOV			BX,0

@COLORIN2:
	MOV			AX,0
	SUB			AX,BX
{	INC			AX}
	DB			_386;SHL		AX,16    	{incr:=(c2+1-c1) shl 16;}
	DW			CDQ
	DB			_386;IDIV		CX      	{incr:=incr div p;}

	DB			_386;ROL		AX,16     {Intercambia EAX}
	DB			_386;XCHG		AX,BX

	{$IFNDEF precision}
	CLC
	{$ENDIF}

@PINTA:            							{for n:=1 to p+1 do}
	STOSB
	{$IFNDEF precision}
	DB			_386;ADC		AX,BX   	{inc(acum,incr);}
	{$ELSE}
	DB			_386;ADD		AX,BX
	ADC			AL,0
	{$ENDIF}
	DEC			CX
	JNZ			@PINTA

@SALIR:
{----------------------------------------------------------------------------}
	POP			DI          	{Recupero DirPant}
	ADD			DI,320      	{Y salto a la siguiente lnea}

	POP			BX
	INC			BX
	DEC			BP
	JNZ			@BUCLE_P

@FINAL:
	POP			BP
END;

procedure ClsPage(var s);ASSEMBLER;
ASM
	CLD
	LES			DI,s

	MOV			CX,64000/4
	DB			_386;XOR			AX,AX  {XOR EAX,EAX}
	REP;		DB	_386;STOSW      	{REP STOSD}
END;

procedure CopyPage(var p1,p2);ASSEMBLER;
ASM
	CLD

	PUSH		DS
	LES			DI,p2
	LDS			SI,p1

	MOV			CX,64000/4
	REP;		DB	_386;MOVSW			{REP MOVSD}

	POP			DS
END;

procedure CopyPageAndClsPage(var p1,p2);ASSEMBLER;
ASM
	CLD

	PUSH		DS
	LES			DI,p2
	LDS			SI,p1

	DB			_386;XOR			BX,BX
	MOV			CX,64000/4

@BUCLE:
	DB			_386;MOV			AX,[SI]
	DW			STOSD
	DB			_386;MOV			[SI],BX
	ADD			SI,4
	DEC			CX
	JNZ			@BUCLE

	POP			DS
END;

procedure CopyBackGroundAndCopy2vRAM(var p1,p2,p3);ASSEMBLER;
ASM
	PUSH		DS
	LES			DI,p3
	LDS			SI,p2
	MOV			AX,WORD(p1+2)
	DW			MOV_GS_AX
	MOV			BX,WORD(p1)
	MOV			CX,64000/4

@BUCLE:
	DB			_386;MOV			AX,[SI]
	DW			STOSD
	DW			GS_386;MOV		AX,[BX]
	DB			_386;MOV			[SI],AX
	ADD			SI,4
	ADD			BX,4
	DEC			CX
	JNZ			@BUCLE

	POP			DS
END;

procedure anima;
var
	temp:LongInt;

begin
	if not music then frame else
		begin
			temp:=frames;
			while frames=temp do;
		end;

	case ModoActual of
		BORRA:CopyPageAndClsPage(PvRAM1^,VGA^);
		COPIA:CopyBackGroundAndCopy2vRAM(PvRAM1^,PvRAM2^,VGA^);
	end;
end;

function LoadPCX(n:string;s:word;var p:Tpaleta):boolean;
type
	PCXHeader=record
		manufacturer,version,encoding,BitsPerPixel:byte;
		XMin,YMin,XMax,YMax,HRes,VRes:word;
		palette:array[0..47] of byte;
		reserved:byte;
		ColorPlanes:byte;
		BytesPerLine:word;
		PalleteType:word;
		filler:array[0..57] of byte;
	end;

var
	PCXFile:Tfile;
	header:PCXHeader;
	VirScr:^byte;

procedure SetPal;
var
	n:integer;
	l:word;

begin
	seek(PCXFile,FileSize(PCXFile)-SizeOf(p));
	read(PCXFile,p,SizeOf(p),l);

	for n:=0 to 255 do with p[n] do
		begin
			rojo:=rojo div 4;
			verde:=verde div 4;
			azul:=azul div 4;
		end;
end;

procedure DescomprimePCX(var p;s:word);ASSEMBLER;
ASM
	PUSH		DS

	MOV			ES,s
	XOR			DI,DI
	LDS			SI,p

@BUCLE:
	MOV			CL,1
	LODSB
	CMP			AL,192
	JB			@SIGUE
	MOV			CL,AL
	AND			CL,63
	LODSB

@SIGUE:
	MOV			AH,AL
	MOV			BX,AX
	DB			_386;SHL		AX,16
	MOV			AX,BX

	MOV			DX,CX
	AND			DX,3
	SHR			CX,2
	REP;		DB _386;STOSW     {REP STOSD}
	MOV			CX,DX
	SHR			CX,1
	REP			STOSW
	ADC			CX,CX
	REP			STOSB

	CMP			DI,320*200
	JB			@BUCLE

	POP			DS
END;

procedure ReadPCX;
var
	l:word;

begin
	seek(PCXFile,128);
	read(PCXFile,VirScr^,FileSize(PCXFile)-768-128,l);
	close(PCXFile);
end;

function ValidPCX:boolean;
var
	l:word;

begin
	seek(PCXFile,0);
	read(PCXFile,header,SizeOf(header),l);
	with header do
		ValidPCX:=(manufacturer=10) and (version=5) and
							(BitsPerPixel=8) and (ColorPlanes=1);
end;

function ValidPal:boolean;
var
	v:byte;
	l:word;

begin
	seek(PCXFile,FileSize(PCXFile)-769);
	read(PCXFile,v,1,l);
	validPal:=v=$c;
end;

begin
	LoadPCX:=FALSE;

	if (open(PCXFILE,n,RO)>0) or (not ValidPCX) or (not ValidPal) then
		begin
			close(PCXFile);
			exit;
		end;

	GetMem(VirScr,64000);
	SetPal;
	ReadPCX;
	DescomprimePCX(VirScr^,s);
	FreeMem(VirScr,64000);

	if ModoActual=COPIA then CopyPage(PvRAM1^,PvRAM2^);

	LoadPCX:=TRUE;
end;

procedure FillEllipse(x,y,rx,ry,color:integer);ASSEMBLER;
ASM
	PUSH		BP

	MOV			DI,ry
	CMP			DI,50
	JA			@FIN
	MOV			SI,rx

	MOV			AX,x
	MOV			WORD(@CAMBIA_X1+1),AX
	MOV			WORD(@CAMBIA_X2+1),AX

	MOV			AX,y
	MOV			WORD(@CAMBIA_Y1+1),AX
	MOV			WORD(@CAMBIA_Y2+1),AX

	MOV			AX,color
	MOV			WORD(@CAMBIA_COLOR1+1),AX
	MOV			WORD(@CAMBIA_COLOR2+1),AX

	MOV			CX,360		{for n:=180 to 360 do}

@BUCLE:
	MOV			BX,CX
	ADD			BX,BX
	MOV			AX,WORD(senos[BX])
	IMUL		SI
	SAR			AX,8      {x:=(rx*seno[n]) div ESCALA;}
	MOV			BP,AX

	MOV			BX,CX
	ADD			BX,BX
	MOV			AX,WORD(senos[BX+180])
	IMUL		DI
	SAR			AX,8			{y:=(ry*seno[n+90]) div ESCALA;}

@CAMBIA_Y1:
	MOV			BX,0
	SUB			BX,AX
	MOV			WORD(@CAMBIA_Y3+1),BX

@CAMBIA_Y2:
	ADD			AX,0			{y:=CENTERY+cy;}

@CAMBIA_X1:
	MOV			DX,0
	ADD			DX,BP			{DX=i=x+cx}

@CAMBIA_X2:
	MOV			BX,0
	SUB			BX,BP     {BX=d=d-cx}

	CMP			BX,DX
	JE			@SIGUE

	PUSH		CX
	PUSH		DI

	PUSH		DX
	PUSH		BX

@CAMBIA_COLOR1:
	MOV			CX,0

	PUSH		DX
	PUSH		AX
	PUSH		BX
	PUSH		CX
	CALL		DrawH

@CAMBIA_COLOR2:
	MOV			CX,0

	POP			BX
	POP			DX

@CAMBIA_Y3:
	MOV 		AX,0

	PUSH		DX
	PUSH		AX
	PUSH		BX
	PUSH		CX
	CALL		DrawH

	POP			DI
	POP			CX

@SIGUE:
	DEC			CX
	CMP			CX,90*3
	JNE			@BUCLE

@FIN:
	POP			BP
END;

var
	n:integer;

begin
	for n:=0 to YMAX do MultBy320[n]:=n*320;
	for n:=0 to high(senos) do senos[n]:=round(256*sin(n/180*pi));

	FillChar(Xi,SizeOf(Xi),0);
	FillChar(Xd,SizeOf(Xd),0);
end.