;----------------------------------------------------------------------------
; Poly Versin 2.45
;----------------------------------------------------------------------------
; Code: Chc/Reset-Tvc
; 20-27 de Mayo y 1-2 de Junio de 1994
;----------------------------------------------------------------------------
; NOTA: esta vez ya he utilizado el nuevo mtodo de trazado de polgonos
;       sin tener que utilizar ningn buffer intermedio ni nada por el
;       estilo...adems ya no uso el algoritmo de bresenham y gano algo
;       ms de velocidad... ;-)
;----------------------------------------------------------------------------
; NOTA 2 : por qu registros de 32 bits? Pues la verdad es que era necesario
;          ya que al no usar el algoritmo de Bresenham tena que tener en un
;          slo registro la parte fraccionaria y la entera de un determinado
;          dx/dy...y debido a que X e Y pueden exceder de 8 bits...
;----------------------------------------------------------------------------
; MODIFICACIONES :
;
;       1 de Junio: ya hay fijados algunos bugs desde la versin 2.15
;       2 de Junio: ahora ya acepta multiples vertices y el rellenado es ms
;                  exacto...
;       3 de Junio: ya soporta tweaked...
;       7 de Junio: acaba definitivamente la versin de 16 colores
;
;----------------------------------------------------------------------------

; hace una suma especial con lmite y posicin de restauracin en caso
; de desbordamiento....

add2            MACRO reg,cantidad
                LOCAL @@nada

                mov dx,[num_vertices]
                shl dx,2
                mov cx,[pos_vertices]
                add cx,dx
                add reg,cantidad      ; haz la suma
                cmp reg,cx            ; ha superado el lmite?
                jne @@nada            ; no

                mov reg,[pos_vertices]
@@nada:
                ENDM

sub2            MACRO reg,cantidad
                LOCAL @@nada

                sub reg,cantidad
                mov dx,[pos_vertices]
                sub dx,4
                cmp reg,dx
                jne @@nada


                mov dx,[num_vertices]
                dec dx
                shl dx,2
                add dx,[pos_vertices]
                mov reg,dx
@@nada:
                ENDM

; Convierte una palabra cualquiera a una doble palabra

cword           MACRO reg,extreg

                push eax              ; guarda EAX
                xor eax,eax
                mov ax,reg            ; transfiere el registro a AX
                cwde                  ; ahora conviertelo a dword
                mov extreg,eax        ; ponlo en el destino
                pop eax               ; recupera EAX

                ENDM

; Mira si es mnimo o no el registro dado

Minimo          MACRO registro
                LOCAL @@nada

                cmp [min_r],registro  ; compara con el valor actual
                jle @@nada            ; no es menor?

                mov [min],si          ; es menor...pues guarda los valores
                mov [min_r],registro
                mov bx,registro       ; el inicio debe contenerlo BX, para el
@@nada:                               ; clipping...
                ENDM

; Mira si es mximo o no el registro dado

Maximo          MACRO registro
                LOCAL @@nada

                cmp [max_r],registro  ; es mayor?
                jge @@nada            ; no

                mov [max],si          ; si, pues almacena los valores
                mov [max_r],registro
@@nada:
                ENDM

; Inicializa el clipping y las variables del polgono
; An falta por implementar el clipping total del polgono

Init_Clip       MACRO
                LOCAL @@sigue

                mov [max_r],-32000    ; la primera comparacin siempre mayor
                mov [min_r],32000     ; la primera comparacin siempre menor
                mov [izq_length],1    ; para que se haga el setup al principio
                mov [der_length],1    ;   "   "  "    "  "    "    "    "
                mov si,[pos_vertices]

                mov dx,[num_vertices]
                @@sigue:
                        mov cx,[si+2] ; ahora busca el mnimo y el mximo de
                        minimo cx     ; las coordenadas Y para saber cual es
                        maximo cx     ; el principio y el final...
                        add si,4      ; siguiente vertice
                dec dx
                jnz @@sigue

                mov [finish_poly],0
                mov ax,[min]
                mov [izq_pos],ax      ; la posicin inicial izquierda y derecha
                mov [der_pos],ax      ; es siempre la mnima...

                mov di,[logical]      ; inicio en el buffer de video

                test [min_r],0ffffh   ; si es negativo ya est bien DI
                js @@ignora

                mov ax,[min_r]        ; sino, el inicio en el buffer de video
                mov cx,buffer_width   ; es la coordenada Y mnima...
                mul cx
                mov di,ax
                add di,[logical]

@@ignora:
                ENDM

; Hace el setup de una nueva lnea en direccin a la izquierda

Setup_Izq       MACRO
                LOCAL @@sigue,@@init,@@no_izq

                push esi              ; guarda X derecha e incremento derecho
@@init:
                mov si,[izq_pos]      ; posicin actual en los vrtices
                cmp si,[max]          ; se ha llegado al final?
                jne @@sigue           ; no

                or [finish_poly],1    ; si, pues est parte finalizada
                jmp @@no_izq

@@sigue:        mov ax,[si]           ; coge X
                mov bp,[si+2]         ; coge Y
                sub2 si,4             ; siguiente coordenada
                mov [izq_pos],si      ; nueva posicin
                mov cx,ax
                sub ax,[si]           ; AX = diferencial x
                sub bp,[si+2]         ; BP = diferencial y
                jz @@init             ; si es una linea recta coge el siguiente

                mov [izq_length],bp   ; guarda la altura de la linea en Y's
                neg [izq_length]

                cwde               ; convierte a Dword diferencial de X e Y
                cword bp,ebp

                sal eax,16         ; por 65536 para simular la coma flotante
                cdq                ; eax -> edx:eax...para la divisin...
                idiv ebp           ; dx/dy -> escalado de la linea
                mov [left_incr],eax
                                   ; escalado
                                   ; 16 bits de mas peso : incremento entero
                                   ; 16 bits de menos peso :   "    fraccionario
                sal ecx,16         ; X inicial

                ; hace una aproximacin al centro del pixel

                add ecx,08000h     ; + 1/2
                mov ebp,ecx
                                   ; esta aproximacin la he hecho para que
                                   ; el rellenado del polgono parezca ms
                                   ; verosmil en los vrtices, y as se
                                   ; parezca mucho ms a lo que debe de ser...
                                   ; as la precisin es mayor...
@@no_izq:
                pop esi            ; recupera la posicin

                ENDM


; Hace el setup de una nueva lnea en direccin a la derecha

Setup_Der       MACRO
                LOCAL @@sigue,@@init,@@no_der

                push ebp

@@init:
                mov si,[der_pos]   ; mira si se ha llegado al final...
                cmp si,[max]
                jne @@sigue        ; no?, pues sigue

                or [finish_poly],010b ; se acab la rutina
                jmp @@no_der

@@sigue:        mov ax,[si]        ; X inicial
                mov bp,[si+2]      ; Y inicial
                add2 si,4          ; siguiente coordenada
                mov [der_pos],si
                mov cx,ax
                sub ax,[si]        ; diferencial de X
                sub bp,[si+2]      ; diferencial de Y
                jz @@init          ; si es una linea horizontal ve a buscar
                                   ; la siguiente coordenada

                mov [der_length],bp   ; guarda la longitud de la linea
                neg [der_length]

                cwde                  ; convierte a Dword los diferenciales
                cword bp,ebp

                sal eax,16            ; para simular la coma flotante
                cdq                   ; para hacer la divisin eax -> edx:eax
                idiv ebp              ; divide
                mov [right_incr],eax  ; incremento
                sal ecx,16            ; X inicial...

                ; hace una aproximacin al centro del pixel

                add ecx,08000h     ; + 1/2
                                   ; esta aproximacin la he hecho para que
                                   ; el rellenado del polgono parezca ms
                                   ; verosmil en los vrtices, y as se
                                   ; parezca mucho ms a lo que debe de ser...
                                   ; as la precisin es mayor...

                mov esi,ecx           ; posicin derecha
@@no_der:
                pop ebp               ; recupera los incrementos y la posicin

                ENDM

; Esta rutina hace un clipping de una de las coordenadas

Clipping        MACRO registro,value
                LOCAL @@noXclip1,@@noXclip2

                cmp registro,XMinClip   ; menor que el mnimo?
                jnl @@noXclip1          ; no

                or cl,value
                mov registro,XMinClip   ; si...pues pon el mnimo
@@noXclip1:
                cmp registro,XMaxClip   ; mayor que el mximo?
                jng @@noXclip2          ; no

                or ch,value
                mov registro,XMaxClip   ; si...pues pon el mximo
@@noXclip2:
                ENDM


; Dibuja una linea en 320x200x16
; Esta funcin debe realizar el clipping horizontal

PutLine         MACRO
                LOCAL @@noXclip1,@@noXclip2,@@no_draw,@@nada,@@normal_dir

                push di
                push bx

                mov eax,ebp     ; haz la copia
                mov edx,esi

                shr edx,16      ; ahora elimina la parte fraccionaria de cada
                shr eax,16      ; una de las coordenadas X

                ; ahora realiza el clipping horizontal...

IFDEF           CLIPX

                xor cx,cx
                Clipping ax,1   ; clipping de la x menor
                Clipping dx,2   : clipping de la x mayor
                cmp ch,3
                jz @@no_draw    ; si los dos a la derecha no dibuja
                cmp cl,3
                jz @@no_draw    ; si los dos a la izquierda no dibuja

ENDIF

IFDEF           TRANSPARENT

                test [toggle],0ffh
                jnz @@normal_dir

                xchg dx,ax
@@normal_dir:

ENDIF
                sub dx,ax
                js @@no_draw
                shl dx,2        ; por 4
                mov bx,ax
                and bx,0111b
                shl bx,11       ; por 2048
                add bx,dx
                shr ax,3
                add di,ax       ; posicin de inicio en la linea
                mov al,tabla[bx]
                mov dl,es:[di]  ; slo sirve para actualiza los latches
                mov es:[di],al
                inc di
                xor ch,ch
                mov cl,tabla+1[bx]
                test cl,0ffh
                jz @@nada
                mov al,011111111b
                rep stosb
@@nada:         mov al,tabla+2[bx]
                mov dl,es:[di]  ; slo sirve para actualizar los latches
                mov es:[di],al
@@no_draw:
                pop bx
                pop di

                ENDM


;  Unidad de polgonos  

        ALIGN 4

; Dibuja un polgono

DPoly   PROC NEAR

        cld

        mov dx,SC_INDEX
        mov al,2
        mov ah,[map_mask]
        out dx,ax               ; mscara de mapa

        mov bl,01111b
        mov bh,[color]
        call SetReset           ; el color y la mscara de activacin de color

        mov ax,[si]
        mov [num_vertices],ax
        add si,8
        mov [pos_vertices],si

        Init_Clip               ; inicializa el clipping del polgono
next_line:
        dec [izq_length]        ; decrementa la longitud de la linea izquierda
        jnz no_izq_setup        ; no se acab la linea?

        Setup_Izq               ; otra nueva linea

no_izq_setup:
        dec [der_length]        ; decrementa la longitud de la linea derecha
        jnz no_der_setup        ; no se acab la linea?

        Setup_Der               ; otra nueva linea

no_der_setup:
        cmp [finish_poly],3
        je none                 ; si ya es la ltima linea no se dibuja

IFDEF   CLIPY

        cmp bx,YMaxClip         ; Clipping inferior (ste implica que ya no se
        jg none                 ; debe seguir haciendo nada)

        cmp bx,YMinClip         ; Clipping superior
        jl skip

ENDIF
        PutLine                 ; si no hay clipping pon la linea

        add di,Buffer_Width     ; posicin en el buffer de video
skip:   inc bx                  ; contador de la Y
        add ebp,[left_incr]     ; siguiente pixel en la linea, izquierda
        add esi,[right_incr]    ; siguiente pixel en la linea, derecha
        jmp next_line           ; si hay ms que hacer...sigue...

none:
;
; Por la propia construccin de la rutina se necesita dibujar una linea ms
;

IFDEF   CLIPY

        cmp bx,YMaxClip         ; Clipping inferior (ste implica que ya no se
        jg none2                ; debe seguir haciendo nada)

        cmp bx,YMinClip         ; Clipping superior
        jl none2

ENDIF
        PutLine                 ; si no hay clipping pon la linea

none2:

        ret
        ENDP

