;
;
; Objectos en 3D slidos!!!
; Versin 2.00
;
; Copyright Chc/Reset-Tvc
;
; Version 1.00 : 24,25,26 de Diciembre de 1993 y 1 de Enero de 1994
; Version 2.00 : 2,3,4,5 y 6 de Junio de 1994
;
;
;
;ESTRUCTURA OBJECTO:
;
;  NAME   OFFSET              LONG     DESCRIPCION
;
; verts     0                  2     Nmero de vrtices que tiene el objecto
; plans     2                  2     Nmero de planos que tiene el objecto
; -----     4               12*verts Coordenada x,y,z para cada vrtice (32 bits)
; pverts 4+12*verts            2     Nmero de vrtices en este plano                        
; pcol   6+12*verts            2     Color del plano                                           Para cada
; -----  8+12*verts         2*pverts Indices a cada uno de los vrtices del plano *            uno de los
; pvis   8+12+verts+2*pverts   2     COMANDO                                                   planos...
;   .             .            .                         .                                   
;   .             .            .                         .
;   .             .            .                         .
;                                   
;
; * ) el primero de los indices apunta al vector normal usado en caso de
;     sombreado...
;
;
;
; MODIFICACIONES RESPECTO A LA VERSION 1.00 :
;
;       - El cdigo ya no es para utilizar desde Turbo Pascal y esto me permite
;         meterlo TODO en el segmento de datos, por lo cual ya no tengo que usar
;         prefijos de segmento en NINGUNA instruccin (ms velocidad)
;
;       - He hecho algunas optimizaciones de instrucciones, como en el caso
;         del paso final (dibujar poligonos) en el cual la rutina ahora va
;         un 300% ms rpida que la anterior...como mnimo... ;-)
;
;       - Ahora la rutina slo soporta 32 bits para hacer los clculos, y a la
;         hora de dibujar las coordenadas X e Y de los polgonos deben de ser
;         de 16 bits... (eso no parece un problema...supongo que ser difcil
;         que salga una X  Y REAL en la pantalla mayor de 32768...)
;
;       - La rutina de rotaciones es todava de 12 multiplicaciones, pero la
;         he optimizado bastante (le he quitado ms de 12 instrucciones)
;
;

                CENTROX equ 85
                CENTROY equ 90

; posicin de cada vrtice

X1 EQU 0
Y1 EQU 4
Z1 EQU 8

; para la visibilidad de los objetos

XX1 EQU 0
YY1 EQU 2
XX2 EQU 4
YY2 EQU 6
XX3 EQU 8
YY3 EQU 10

; Mueve una variable memoria-memoria

Move            MACRO var1,var2

                mov bx,var1
                mov var2,bx

                ENDM

; Mira si es mnimo o no el registro dado

Minimo2         MACRO registro,variable
                LOCAL @@nada

                cmp variable,registro  ; compara con el valor actual
                jle @@nada            ; no es menor?

                mov variable,registro
@@nada:                               ; clipping...
                ENDM

; Mira si es mximo o no el registro dado

Maximo2         MACRO registro,variable
                LOCAL @@nada

                cmp variable,registro  ; es mayor?
                jge @@nada            ; no

                mov variable,registro
@@nada:
                ENDM

; Cambia dos variables

Change          MACRO var1,var2

                mov bx,var1
                xchg bx,var2
                mov var1,bx

                ENDM

; Rellena un rectngulo

Rectangle       MACRO
                LOCAL @@next

                ;ahora disponte a borrar propiamente el anterior frame

                mov di,[logical]

                mov dx,SC_INDEX
                mov ax,0f02h
                out dx,ax               ;escribe en todos los planos

                mov bx,01111b
                mov bh,[Rcol]
                call SetReset           ;color 0

                mov ax,[oomin_y]
                mov bx,Buffer_Width
                mul bx
                mov di,ax
                add di,[logical]        ;posicin Y de inicio

                mov bx,[oomax_y]
                sub bx,[oomin_y]
                inc bx
@@next:
                mov [aux],di
                mov ax,[oomin_x]
                shr ax,3
                add di,ax
                mov cx,[oomax_x]
                shr cx,3
                sub cx,ax
                mov al,011111111b
                inc cx
                rep stosb

                mov di,[aux]
                add di,Buffer_Width
                dec bx
                jnz @@next

                ENDM

; Coge el rectngulo de borrado para el siguiente plano

GetClear        MACRO
                LOCAL @@next_vertex,@@sigue1,@@sigue2,@@sigue3,@@sigue4,@@no_clear,@@next_plane,@@sj1,@@sj2,@@sj3,@@sj4


                ;coge las coordenadas mnima y mxima de X e Y

                mov [max_x],-32000
                mov [max_y],-32000
                mov [min_x],32000
                mov [min_y],32000

                mov bx,[planos]
@@next_plane:
                mov cx,[si]
                add si,8                ;salta vrtices,color y Z

@@next_vertex:  mov ax,[si]
                maximo2 ax,[max_x]
                minimo2 ax,[min_x]
                mov ax,[si+2]
                maximo2 ax,[max_y]
                minimo2 ax,[min_y]
                add si,4
                dec cx
                jnz @@next_vertex

                dec bx
                jnz @@next_plane


                ;ahora el recorte de X e Y...ha de comprobar todos los casos
                ;posibles para el recorte completo...


IFDEF           CLIPX

                cmp [min_y],YMinClip
                jnl @@sigue1
                mov [min_y],YMinClip
@@sigue1:       cmp [max_y],YMaxClip
                jng @@sigue2
                mov [max_y],YMaxClip
@@sigue2:       cmp [min_y],YMaxClip
                jng @@sj1
                mov [min_y],YMaxClip
@@sj1:          cmp [max_y],YMinClip
                jnl @@sj2
                mov [max_y],YMinClip
@@sj2:


ENDIF

IFDEF           CLIPY

                cmp [min_x],XMinClip
                jnl @@sigue3
                mov [min_x],XMinClip
@@sigue3:       cmp [max_x],XMaxClip
                jng @@sigue4
                mov [max_x],XMaxClip
@@sigue4:       cmp [min_x],XMaxClip
                jng @@sj3
                mov [min_x],XMaxClip
@@sj3:          cmp [max_x],XMinClip
                jnl @@sj4
                mov [max_x],XMinClip
@@sj4:

ENDIF

                Rectangle

                ;cambio de frames

                move [omax_x],[oomax_x]
                move [omax_y],[oomax_y]
                move [omin_x],[oomin_x]
                move [omin_y],[oomin_y]

                move [max_x],[omax_x]
                move [max_y],[omax_y]
                move [min_x],[omin_x]
                move [min_y],[omin_y]

                ENDM

;##########
;Calcula el color de acuerdo a las sombras que existen
;##########

SHADES      MACRO
            LOCAL @@salta

            push di

            ;calcula la posicin del vector normal

            mov bx,OFFSET coordsnew
            mov ax,[si+4]
            mov cx,12
            mul cx
            add bx,ax

            mov eax,[Lx]
            imul dword ptr [bx+X1]
            mov ebp,eax
            mov ecx,edx
            mov eax,[Ly]
            imul dword ptr [bx+Y1]
            add ebp,eax
            adc ecx,edx
            mov eax,[Lz]
            imul dword ptr [bx+Z1]
            add ebp,eax
            adc ecx,edx
            shld ecx,ebp,5      ;base shade (-32 to 32)

            mov dx,[actual_col]
            mov [di+2],dx

            add cx,32           ;de 0 a 64
            mov ax,cx
            mov cx,3
            mul cx              ;multiplica por 3

            mov bx,OFFSET paleta
            add bx,32*3         ;en esta posicin comienza el degradado
            add bx,ax
            mov di,[actual_ptr]
            mov al,[bx]
            mov [di],al
            mov al,[bx+1]
            mov [di+1],al
            mov al,[bx+2]
            mov [di+2],al

            add si,6

            pop di

            ENDM

;##########
;Macro que testea la visibilidad de un plano,mediante el mtodo
;del vector normal al plano (slo se calcula la componente Z)
;si la componente es negativa (o positiva, depende del sistema de referencia)
;el plano no se ve...
;##########

VISIBILITY  MACRO

            push di
            push bx
            add di,8                 ;salta nmero de vrtices,color y Z

            ;calcula V1 y V2 (slo componentes X e Y)

            mov ax,[di+XX1]
            sub ax,[di+XX2]
            mov [v1x],ax            ;V1(x,y) = P0(x,y) - P1(x,y)
            mov ax,[di+YY1]
            sub ax,[di+YY2]
            mov [v1y],ax
            mov ax,[di+XX3]
            sub ax,[di+XX2]
            mov [v2x],ax            ;V2(x,y) = P2(x,y) - P1(x,y)
            mov ax,[di+YY3]
            sub ax,[di+YY2]
            mov [v2y],ax

            ;calcula ahora la componente Z del vector normal

            mov ax,[v1x]
            imul word ptr [v2y]
            mov bx,ax
            mov cx,dx
            mov ax,[v1y]
            neg ax             ;z = (V1x*V2y - V1y*V2x)
            imul word ptr [v2x]
            add bx,ax
            adc cx,dx
            pop bx
            pop di

            ENDM

;##########
;Realiza algunos clculos para optimizar las rotaciones
;##########

POLLCOS     MACRO

            mov si,[xan]
            shl si,2
            mov eax,dword ptr coseno[si]
            mov [cosdatax],eax
            mov eax,dword ptr seno[si]
            mov [sindatax],eax

            mov si,[yan]
            shl si,2
            mov eax,dword ptr coseno[si]
            mov [cosdatay],eax
            mov eax,dword ptr seno[si]
            mov [sindatay],eax

            mov si,[zan]
            shl si,2
            mov eax,dword ptr coseno[si]
            mov [cosdataz],eax
            mov eax,dword ptr seno[si]
            mov [sindataz],eax

            ENDM

;##########
;Macro que realiza la rotacin de cada uno de los vrtices del objeto
;##########


ROTAXYZ     MACRO

                                       ;z := sin(xan)*y + cos(xan)*z
                                       ;y := cos(xan)*y - sin(xan)*z
            mov eax,[cosdatax]
            imul dword ptr [si+Y1]
            mov ebx,eax
            mov eax,[sindatax]
            imul dword ptr [si+Z1]
            sub ebx,eax
            sar ebx,9                   ;quita el factor de 512
            mov eax,[sindatax]
            imul dword ptr [si+Y1]
            mov ecx,eax
            mov eax,[cosdatax]
            imul dword ptr [si+Z1]
            add ecx,eax
            sar ecx,9
            mov dword ptr [di+Z1],ecx
            mov dword ptr [di+Y1],ebx

                                      ;x := cos(yan)*x + sin(yan)*z
                                      ;z := -sin(yan)*x + cos(yan)*z
            mov eax,[cosdatay]
            imul dword ptr [si+X1]
            mov ebx,eax
            mov eax,[sindatay]
            imul dword ptr [di+Z1]
            add ebx,eax
            sar ebx,9                  ;quita el factor de 512
            mov eax,[sindatay]
            imul dword ptr [si+X1]
            mov ecx,eax
            neg ecx
            mov eax,[cosdatay]
            imul dword ptr [di+Z1]
            add ecx,eax
            sar ecx,9
            mov dword ptr [di+Z1],ecx
            mov dword ptr [di+X1],ebx

                                      ;x := cos(zan)*x - sin(zan)*y
                                      ;y := sin(zan)*x + cos(zan)*y
            mov eax,[cosdataz]
            imul dword ptr [di+X1]
            mov ebx,eax
            mov eax,[sindataz]
            imul dword ptr [di+Y1]
            sub ebx,eax
            sar ebx,9                   ;quita el factor de 512
            mov eax,[sindataz]
            imul dword ptr [di+X1]
            mov ecx,eax
            mov eax,[cosdataz]
            imul dword ptr [di+Y1]
            add ecx,eax
            sar ecx,9
            mov dword ptr [di+Y1],ecx
            mov dword ptr [di+X1],ebx

            ENDM

            include poly.asm

; rutina de dibujar el objeto en la pantalla

            ALIGN 4

DrawObject  PROC NEAR

            POLLCOS
            mov [planos],0         ;numero de caras a dibujar
            mov [actual_col],5     ;empieza en el tres
            mov [actual_ptr],OFFSET RGB

            ;rotacin de los vrtices del objecto


            mov di,OFFSET coordsnew     ;aqu guardo las coordenadas rotadas
            mov si,OFFSET object        ;si al objeto
            mov cx,[si]                 ;nmero de vrtices a rotar
            add si,4
@@rota_all: push cx
            mov [aux],si
            ROTAXYZ                     ;transforma el vrtice
            mov si,[aux]
            add si,12
            add di,12                   ;siguiente vrtice
            pop cx
            dec cx
            jnz @@rota_all

            ;ahora testea visibilidad, haz la ordenacin y prepara el
            ;borrado del siguiente frame

            mov si,OFFSET object
            mov cx,[si+2]               ;nmero de planos
            mov ax,[si]                 ;nmero de vrtices
            mov bx,12
            mul bx                      ;12 bytes por vrtice
            add ax,4                    ;salta los dos datos WORD iniciales
            add si,ax                   ;si apunta a la estructura de los
                                        ;planos...
            mov [sort_place],OFFSET sort_list
            mov di,OFFSET vertices      ;adonde guardas los vertices de los planos

@@next_plane:
            push cx
            push di

            mov bx,[sort_place]         ;ve ya actualizando la tabla de
            mov [bx],di                 ;posiciones
            mov [sort_dist],-10000000   ;la mnima distancia posible

            mov cx,[si]                 ;nmero de vrtices en cada plano
            dec cx                      ;(no contamos el vector normal)
            mov [di],cx                 ;gurdalo

            SHADES                      ;calcula las sombras del polgono

            add di,8                    ;apunta al inicio de la tabla

@@next_vertex:
            push cx
            mov bx,OFFSET coordsnew     ;coordenadas recin calculadas
            mov ax,[si]                 ;carga ndice del vrtice actual
            mov dx,12
            mul dx                      ;12 bytes por vrtice
            add bx,ax                   ;posicin del vrtice

            mov eax,[bx]                ;X
            add eax,[desplx]            ;X+desplazamiento
            cdq                         ;convierte DWORD a cuadruple word
            shld edx,eax,8
            shl eax,8                   ;multiplica por 256 (distancia)
            mov ecx,[bx+8]              ;coge la Z
            add ecx,[dist]              ;smale la distancia
            idiv ecx                    ;divide por la Z
            add eax,CENTROX             ;cntralo en la pantalla
            mov [di],ax                 ;X real en la pantalla

            mov eax,[bx+4]              ;Y
            add eax,[desply]            ;X+desplazamiento
            cdq                         ;convierte DWORD a cuadruple word
            shld edx,eax,8
            shl eax,8                   ;multiplica por 256 (distancia)
            idiv ecx                    ;divide por la Z
            add eax,CENTROY             ;cntralo en la pantalla
            mov [di+2],ax               ;Y real en la pantalla

            cmp [sort_dist],ecx
            jg @@salta

            mov [sort_dist],ecx         ;distancia ms lejana en el polgono
@@salta:
            add di,4                    ;siguiente coordenada a guardar
            inc si                      ;siguiente ndice a un vrtice
            inc si
            pop cx
            dec cx
            jnz @@next_vertex

            mov bx,[sort_place]         ;ahora guarda la distancia del
            mov ecx,[sort_dist]         ;plano...
            mov bx,[bx]                 ;puntero a punteros
            mov [bx+4],ecx

            mov dx,[si]                 ;flag de visibilidad
            inc si                      ;incrementa
            inc si                      ;incrementa
            mov [aux],di                ;guarda DI por si plano no visible
            pop di                      ;recupera DI
            test dx,0ffffh
            jnz @@visible               ;no hace falta testear la visibilidad

            VISIBILITY                  ;testea la visibilidad del plano
            or cx,cx
            jns @@no_visible            ;no es visible, DI sigue apuntando
                                        ;donde antes, por tanto los datos
                                        ;se reescribirn...ya que no nos sirven

@@visible:  inc word ptr [planos]       ;un plano ms a dibujar
            mov di,[aux]                ;entonces almacena el siguiente plano

            inc [actual_col]            ;el siguiente color de las sombras
            add [actual_ptr],3
            add [sort_place],2          ;siguiente plano

@@no_visible:
            pop cx
            dec cx
            jnz @@next_plane

            ;borra los planos anteriores

            mov si,OFFSET vertices
            GetClear                    ;rectangulo a borrar en el siguiente
                                        ;frame...

            ;dibuja los planos que se deban dibujar

            mov cx,[planos]             ;nmero de planos a dibujar
            test cx,0ffffh
            jz @@ninguno                ;no hay planos que dibujar...

            mov [toggle],1              ;sentido a la derecha
            mov [map_mask],01111b       ;de momento todos los planos

            mov ax,SCREEN_SEG
            mov es,ax                   ;segmento de video

@@planes:   push cx                     ;guarda contador

            ;va dibujando los polgonos en estricto orden de
            ;lejana...

            mov edx,-10000000           ;distancia mnima

            mov di,OFFSET sort_list
            mov cx,[planos]
@@more:
            mov bx,[di]
            cmp word ptr [bx+2],0
            je @@salta2                 ;si ya ha sido dibujado, salta
            cmp [bx+4],edx
            jl @@salta2                 ;es menor

            mov edx,[bx+4]
            mov si,bx

@@salta2:   inc di
            inc di
            dec cx
            jnz @@more

            mov ax,[si+2]               ;guarda color
            mov [color],al
            mov word ptr [si+2],0       ;color zero para no volverlo a escribir
            call DPoly                  ;dibuja el polgono

            pop cx

            dec cx
            jnz @@planes
@@ninguno:
            ret

            ENDP

DoShades  PROC NEAR

        ;se encarga de cambiar la paleta de las sombras
        mov di,OFFSET RGB
        mov dx,3c8h
        mov al,5
        out dx,al
        jmp $+2
        inc dx
        mov cx,[actual_col]
@@sigue:
        mov al,[di]
        out dx,al
        jmp $+2
        mov al,[di+1]
        out dx,al
        jmp $+2
        mov al,[di+2]
        out dx,al
        jmp $+2
        add di,3
        dec cx
        jnz @@sigue
        ret

        ENDP

