
//Ŀ
// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// TERMIN.EXE -> Terminator II Scroll By    I s p a n i a (ERT) '94.       
// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// * Objetivo  : Intento de hacer algunos scrollers y otros efectos...     
// * Programa  : TERMIN.C                                                  
// * Librerias : N/A.                                                      
// * Cdigo    : C y ASM.                                                  
// * Compilador: Borland C++ 3.1 & TASM.                                   
// * Hardware  : 386 DX (33) & VGA Tseng 4000.                             
// ------------------------------------------------------------------------
// 01-01-94  Creacin.                                                     
// 17-04-94  Revisin y actualizacin.                                     
// 17-05-94  Actualizacin  y distribuicin del cdigo.                    
// -----------------------------------------                               
// Code by: NOP/franker (ERT) - Ispania '94.                               
// -----------------------------------------                               
//

#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <alloc.h>
#include <string.h>
#include <fcntl.h>
#include <io.h>
#include <dos.h>

#define  SEQU_ADDR      0x3C4    /* Puerto de Miscelanea (varias funciones)*/
#define	 CRTC_ADDR	0x3D4    /* Puerto del CRTC 0x3C4 para el retrazo..*/
#define  INPUT_STATUS	0x3DA    /* Informacin de comienzo de retrazo..   */
#define  DAC_DATA       0x3C9
#define  DAC_WRITE      0x3C8
#define  DAC_READ	0x3C7
#define	 MAXX		319      /* Algunas coordenadas...... */
#define	 MAXY		199
#define	 STARTX		000
#define	 STARTY		000
#define	 ANCHURA	320
#define	 ALTURA		200
#define  MODE_MCGA      0x13     /* Modo de Video MCGA 256 colores..      */

typedef unsigned char byte;
typedef unsigned int  word;

byte pag_visible=0;
byte pag_actual=0;
byte *VIDEO_MCGA=(byte *) MK_FP(0xA000,0);       /* direccin de la MCGA */
byte *buf;
char *nombre="parte1.dat",caracter;/* Nombre del fichero de dibujo por defecto*/
int buc,cont,pase=0;

// ----------------------
// ERT/Ispania funciones.
// I s p a n i a .
// ----------------------

void set_pal(byte *memo);                 //Carga la paleta de colores..
void put_pixel(word x,word y,byte color); //Coloca un pixel en pantalla.
void page_visible(byte page);             //Asigna la pgina visible.
void display(byte *buf,int x,int y);  //Muestra el contenido del puntero(buf) en X e Y....
void scr_offset(word offset);
byte scroll_up(byte pag,byte speed);   //Scroll por hardware hacia arriba.
byte scroll_dw(byte pag,byte speed);   //Idem abajo.
void wait_vbi(void);                   //Espera retrazo .
void wait_vbi2(void);           //Espera un retrazo menor.
void set_mcga(void);                   //Pone la VGA en modo X (320x200)
void fade_out(byte start, int count);             //Fades de paleta
void fade_in(byte start, int count,byte *memo);   //Idem
void blanco_a_fade(byte start, int count,byte *memo);    //Flash a blanco.
void fade_a_blanco(byte start, int count);         //Blanco a grfico.
void clr_pal(byte start, int number,byte color);   //Borra paleta actual.
void quit(char *txt);        //Fin de programa.
void clr_scr(byte color);    //Borra la pantalla, vuelca color en VGA.
void clr_all(byte color);    //Borra todos los planos.
void rest_modo_video(void);  //vuelve al modo de texto.
byte *l_cel(char *name);     //Carga un fichero .CEL

void put_img(word x, word y, byte *bufer);    //Vuelca imagen en pantalla.

// -------------------
// Programa principal.
// -------------------

void main(void)
{
    set_mcga();

    clr_all(0);
    buf=l_cel("ispania.dat");
    set_pal(buf);

    clr_all(0);
    buf=l_cel(nombre);
    set_pal(buf);
    page_visible(1);
    display(buf,0,0);
    page_visible(0);
    fade_in(0,256,buf);

    pag_actual=1;
    buf=l_cel("parte2.dat");
    display(buf,0,0);
    pag_actual=2;
    buf=l_cel("parte3.dat");
    display(buf,0,0);
    pag_actual=3;
    buf=l_cel("parte4.dat");
    display(buf,0,0);
    caracter=getch();

    do
    {
       pag_actual=0;
       buc=1;
       scroll_up(3,buc);
       pag_actual=3;
       scroll_dw(3,buc);

       buc=6;
       pag_actual=0;
       scroll_up(3,buc);
       pag_actual=3;
       scroll_dw(3,buc);
       caracter=getch();
       if(caracter==27) break;
    } while(buc!=100);


    pag_actual=0;

    fade_a_blanco(0,256);
    clr_all(0);
    buf=l_cel("cara.dat");

    blanco_a_fade(0,256,buf);

    pag_actual=1;
    display(buf,0,0);
    pag_actual=0;
    scroll_up(1,7);
    getch();
    fade_out(0,256);

    pag_actual=1;
    page_visible(0);

    clr_all(0);
    buf=l_cel("ispania.dat");
    set_pal(buf);

    display(buf,0,0);
    pag_actual=0;
    scroll_up(1,1);

    getch();

    fade_out(0,256);

    quit(" \n");
}


// -----------------------------------
// Coloca un pixel en pantalla modo X.
// -----------------------------------

void put_pixel(word x,word y,byte color)
{
     word pag,despy,npi;
     byte despx;

     asm   {
	     mov   cx,x
	     mov   ax,3
	     and   cx,ax

	     mov   ax,1
	     shl   ax,cl
	     mov   pag,ax

	     mov   ax,x
	     mov   bx,4
	     div   bl
	     mov   despx,al

	     xor   ax,ax
	     mov   al,y
	     mov   bx,80
	     mul   bl
	     mov   despy,ax

	     mov   bl,pag_actual
	     mov   ax,15744
	     mul   bx

	     mov   npi,bx;

	     add   ax,despx
	     add   ax,despy


	     mov   di,ax
	     mov   ax,0A000h
	     mov   es,ax

	     mov   dx,SEQU_ADDR
	     mov   al,2
	     mov   ah,pag
	     out   dx,ax

	     mov   al,color

	     stosb
	   }
}


// -------------------------------------------
// Volcado de pantalla , optimizado por NOP.
// -------------------------------------------

void put_img(word x, word y, byte *bufer)
{
   word dif,anchow,ancho,alto;

   asm {
	  cli
	  push ds

	  les di,VIDEO_MCGA
	  lds si,bufer

	  cld

	  inc si
	  inc si

	  lodsw
	  mov ancho,ax
	  lodsw
	  mov alto,ax
	  add si,794

          mov ax,320
	  sub ax,ancho
	  mov dif,ax

	  mov ax,ancho
	  shr ax,1
	  mov anchow,ax

	  mov ax,320
	  mov bx,y
	  mul bx
	  add ax,x
	  mov di,ax


	  mov cx,alto

       }
   altura:

   asm {
	  push cx
	  mov cx,anchow
	  rep movsw

	  add di,dif

	  pop cx
	  loop altura

	  pop ds
	  sti
       }
}

// -------------------------------------
// Coloca la paleta del grfico cargado.
// -------------------------------------

void set_pal(byte *memo)
{
    byte rgb[256][3];
    register int loop;

    memo+=32;

    for(loop=0;loop<256;loop++)
    {
	rgb[loop][0]=*memo;
	memo++;
	rgb[loop][1]=*memo;
	memo++;
	rgb[loop][2]=*memo;
	memo++;
    }

    for (loop=0;loop<256;loop++)
    {
       asm cli;
       outportb(DAC_WRITE,loop);
       outportb(DAC_DATA,rgb[loop][0]);
       outportb(DAC_DATA,rgb[loop][1]);
       outportb(DAC_DATA,rgb[loop][2]);
       asm sti;
    }
}

// ----------------
// Fundido a negro.
// ----------------

void fade_out(byte start, int count)
{
   int i, j, cycle;

   byte rgb[256][3];


    for (i=0;i<256;i++)
    {
       asm cli;
       outportb(DAC_READ,i);
       rgb[i][0]=inport(DAC_DATA);
       rgb[i][1]=inport(DAC_DATA);
       rgb[i][2]=inport(DAC_DATA);
       asm sti;
    }

        for (cycle=64;cycle>0;cycle--)
		{
		i=start;
		wait_vbi();
		outportb(DAC_WRITE,i);
		wait_vbi();
		asm cli;
		for (i=start;i<(start+count);i++)
			{
			for (j=0;j<3;j++)
				{
				if (rgb[i][j]!=0)
					rgb[i][j]--;
				outportb(DAC_DATA,rgb[i][j]);
				}
			}
		asm sti;
		}
}

// ---------------------------
// Fundido de negro al dibujo.
// ---------------------------

void fade_in(byte start, int count,byte *memo)
{
    int i, j, cycle;
    byte rgb[256][3],palette[256][3];

    memset(rgb,0,768);

    memo+=32;

    for(i=0;i<256;i++)
    {
	palette[i][0]=*memo;
	memo++;
	palette[i][1]=*memo;
	memo++;
	palette[i][2]=*memo;
	memo++;
    }

        for (cycle=0;cycle<64;cycle++)
		{
		outportb(DAC_WRITE,i);
                wait_vbi();
		asm cli;
		for (i=start;i<(start+count);i++)
			{
			for (j=0;j<3;j++)
				{
				if ((64-cycle)<=palette[i][j])
					rgb[i][j]++;
				outportb(DAC_DATA,rgb[i][j]);
				}
			}
		asm sti;
		}
}

// ------------------------------
// Blanco, luego a dibujo.
// ------------------------------

void blanco_a_fade(byte start, int count,byte *memo)
{
    int i, j, cycle;
    byte rgb[256][3],palette[256][3];


    memset(rgb,255,768);


    memo+=32;

    for(i=0;i<256;i++)
    {
	palette[i][0]=*memo;
	memo++;
	palette[i][1]=*memo;
	memo++;
	palette[i][2]=*memo;
	memo++;
    }



	for (cycle=63;cycle>0;cycle--)
		{
		outportb(DAC_WRITE,i);
		wait_vbi2();
		asm cli;
		for (i=start;i<(start+count);i++)
			{
			for (j=0;j<3;j++)
				{
				if ((cycle)>=palette[i][j])
					rgb[i][j]--;
				outportb(DAC_DATA,rgb[i][j]);
				}
			}
		asm sti;
		}
}


// ---------------------------
// De dibujo a Blanco (flash).
// ---------------------------

void fade_a_blanco(byte start, int count)
{
   int i, j, cycle;

   byte rgb[256][3];

    for (i=0;i<256;i++)
    {
       asm cli;
       outportb(DAC_READ,i);
       rgb[i][0]=inport(DAC_DATA);
       rgb[i][1]=inport(DAC_DATA);
       rgb[i][2]=inport(DAC_DATA);
       asm sti;
    }

        for (cycle=0;cycle<64;cycle++)
		{
		outportb(DAC_WRITE,i);
		wait_vbi2();
		asm cli;
		for (i=start;i<(start+count);i++)
			{
			for (j=0;j<3;j++)
				{
				if (rgb[i][j]<63)
					rgb[i][j]++;
				outportb(DAC_DATA,rgb[i][j]);
				}
			}
		asm sti;
		}
}

// -------------
// Borra Paleta.
// -------------

void clr_pal(byte start, int number,byte color)
{
	register word i;


	for (i=start;i<(start+number);i++)
		{
		asm cli;
		outportb(DAC_WRITE,i);
		outportb(DAC_DATA,color);
		outportb(DAC_DATA,color);
		outportb(DAC_DATA,color);
		asm sti;
		}
}

// ---------------------------------------
// Selecciona la pgina a ser visualizada.
// ---------------------------------------

void page_visible(byte page)
{
       wait_vbi();
       scr_offset(16000*page);
       pag_visible=page;
}


// ----------------------------------------------
// Coloca la imagen cargada en pantalla (modo X).
// ----------------------------------------------

void display(byte *pt,int x,int y)
{
   register word vert,horz;
   byte lo,hi;
   word ancho,alto;


   pt++;
   pt++;
   lo=(byte) *pt;
   pt++;
   hi=(byte) *pt;
   ancho=(hi*256)+lo;

   pt++;
   lo=(byte) *pt;
   pt++;
   hi=(byte) *pt;
   alto=(hi*256)+lo;
   pt+=795;


   for(vert=y;vert<alto;vert++)
   {
      for(horz=x;horz<ancho;horz++)
      {

      put_pixel(horz,vert,*pt);
      pt++;

      }
   }
}



// -----------------------------------------
// Hace un Scroll hacia arriba por Hardware.
// -----------------------------------------

byte scroll_up(byte pag,byte speed)
{
    word loop,comp,add;
    word desplaz=16000*pag_actual;

    if(pag_actual+pag>3)
       return(1);

    comp=(200*pag)/speed;
    add=speed*80;

    for(loop=0;loop<=comp;loop++)
    {
       wait_vbi();
       scr_offset(desplaz);
       desplaz+=add;
    }
    pag_visible+=pag;
    return(0);
}

// ----------------------------------------
// Hace un Scroll hacia abajo por Hardware.
// ----------------------------------------

byte scroll_dw(byte pag,byte speed)
{
    word loop,comp,add;
    word desplaz=16000*pag_actual;

    if(pag<pag_actual)
       return(1);

    comp=(200*pag)/speed;
    add=speed*80;

    for(loop=0;loop<=comp;loop++)
    {
       wait_vbi();
       scr_offset(desplaz);
       desplaz-=add;
    }
    pag_visible-=pag;
    return(0);
}


// ---------------------------
// Espera Retrazo de pantalla.
// ---------------------------

void wait_vbi()
{
	asm mov dx, INPUT_STATUS;
	test_1:
	asm	{
		in al, dx
		test al,0x8
		jnz test_1
		}

	test_2:
	asm	{
		in al, dx
		test al,0x8
		jz test_2
		}

}

// Idem.

void wait_vbi2(void)
{
	asm mov dx, INPUT_STATUS;
	test_2:
	asm	{
		in al, dx
		test al,0x8
		jz test_2
		}

}

// --------------------
// Salida del programa.
// --------------------

void quit(char *txt)
{
    rest_modo_video();
    clrscr();
    cprintf("%s \r\n",txt);

    textcolor(LIGHTGREEN);
    cprintf("Coded by NOP/franker  I S P A N I A \r\n\n");
    textcolor(LIGHTBLUE);
    cprintf("Imagen TERMINATOR II - Amiga 4000 \r\n");
    cprintf("Realizado en BC++ 3.1 y Assembler \r\n\n");
    cprintf("TERMIN v 2.0 (Source codes) \r\n ");
    textcolor(YELLOW+BLINK);
    cprintf("    I s p a n i a \r\n\n\n");
    textcolor(LIGHTCYAN);
    textcolor(LIGHTRED);
    cprintf(" NO LAMMERS! ;-P \r\n\n");
    textcolor(WHITE);
    cprintf(" By Ispania 1994.\r\n");
    exit(1);

}

// --------------------------------
// Pasa a modo grfico MCGA normal.
// --------------------------------

void mcga(void)
{
	union REGS r;

	r.x.ax =0x13;
	int86(16, &r, &r);
}

// --------------------------
// Inicializa y pone MODO X.
// --------------------------

void set_mcga(void)
{
    asm {
	   mov  ax,13h
	   int  10h

	   mov  dx,3C0h
	   mov  al,30h
	   out  dx,al
	   mov  al,61h
	   out  dx,al
	   mov  dx,3C4h
	   mov  ax,0604h
	   out  dx,ax

	   mov  dx,3D4h
	   mov  ax,14h
	   out  dx,ax
	   mov  ax,0f317h
	   out  dx,ax

	}
}

// ------------------------------------------------------------------------
// Desplazamiento de la direccion de pantalla (usado para hacer el scroll.
// ------------------------------------------------------------------------

void scr_offset(word offset)
{
	outport(CRTC_ADDR, 0xC);
	outport(CRTC_ADDR+1, offset >> 8);
	outport(CRTC_ADDR, 0xD);
	outport(CRTC_ADDR+1, offset & 0xff);
}

// ------------------------------------
// Borra Pantalla (slo una pantalla).
// ------------------------------------

void clr_scr(byte color)
{

    asm   {

	     mov   ax,0f02h
	     mov   dx,3C4h
	     out   dx,ax

	     xor   bh,bh
	     mov   bl,pag_actual
	     mov   ax,16000
	     mul   bx

	     les   di,VIDEO_MCGA
	     mov   di,ax

	     mov   ah,color
	     mov   al,ah

	     mov   cx,8000

	     rep   stosw
	  }
}

// -----------------------------------
// Borra todas las pantallas volcadas.
// -----------------------------------

void clr_all(byte color)
{
    asm   {
	     mov   ax,0F02h
	     mov   dx,3C4h
	     out   dx,ax

	     les   di,VIDEO_MCGA

	     mov   ah,color
	     mov   al,ah

	     mov   cx,32000

	     rep   stosw
	  }
}

// --------------------------
// Restaura el modo de video.
// --------------------------

void rest_modo_video(void)
{
	union REGS r;


	r.h.al = 3;
	r.h.ah = 0;
	int86(16, &r, &r);
}


// ----------------------------------
// Rutina de carga de un fichero .CEL
// ----------------------------------

byte *l_cel(char *name)
{
   byte *memo;
   int control;
   size_t tamano;
   FILE *in;


   control=open(name,O_BINARY);
   if((in=fdopen(control,"rb")) == NULL)
   {
      rest_modo_video();
      printf("ERROR: fichero no encontrado.\n");
      printf("Deben de estar en el mismo directorio.\n");
      printf(".- Ispania '94");
      exit(1);
   }

   tamano=(size_t) filelength(control);
   if((memo=malloc(tamano))==NULL)
   {
	quit("Error: Memoria");
   }

   fread(memo,tamano,1,in);
   fclose(in);
   close(control);
   return(memo);
}

// Fin de Programa.
// ---------------------------------------------------------------------
// Si quieres ms comentarios, escrbelos t ;-)
// ---------------------------------------------------------------------
// Todas estas rutinas han sido creadas integramente por Ispania! ------
// --------- No olvides mencionarnos si utilizas estos cdigos ---------
// ---------------------------------------------------------------------
// (C) Ispania / ERT '94

