; -------------------------------- LANDMAIN.C -----------------------------
; (C) Copyright 1993 bye Jare and JCAB (Javier & Juan Carlos Arevalo Baeza)
; of Iguana/VangeliSTeam


        INCLUDE LLKEY.INC
        INCLUDE VBL.INC

; Keyobard handler for the landscape. Called by interrupts to allow a
; reliable control of the ship without caring for the update frame rate.
; This keyboard handler is like this for historical reasons.
; Now it could (should) be coded entirely in C.

_keyup DB 0
_keydn DB 0
_keylt DB 0
_keyrt DB 0
_keyff DB 0
_keybk DB 0


EXTRN LAND_Fader: NEAR

_16kbhandler:
        PUSH    DS
        PUSH    EAX EDX
        MOV     AX,_seldata
        MOV     DS,AX
        XOR     EAX,EAX
        CMP     AL,[LLK_Keys+kPGUP]
        ADC     [_keyup],AL
        CMP     AL,[LLK_Keys+kPGDN]
        ADC     [_keydn],AL
        CMP     AL,[LLK_Keys+kLARROW]
        ADC     [_keylt],AL
        CMP     AL,[LLK_Keys+kRARROW]
        ADC     [_keyrt],AL
        CMP     AL,[LLK_Keys+kUARROW]
        ADC     [_keyff],AL
        CMP     AL,[LLK_Keys+kDARROW]
        ADC     [_keybk],AL
;        CALL    LAND_Fader
        POP     EDX EAX
        POP     DS
        RET

GLOBAL L3D_keyup: DWORD
GLOBAL L3D_keydn: DWORD
GLOBAL L3D_keylt: DWORD
GLOBAL L3D_keyrt: DWORD
GLOBAL L3D_keyff: DWORD
GLOBAL L3D_keybk: DWORD

L3D_keyup DD 0
L3D_keydn DD 0
L3D_keylt DD 0
L3D_keyrt DD 0
L3D_keyff DD 0
L3D_keybk DD 0

        ; Link our keyboard handler to the retrace interrupt

PUBLIC L3D_Init
L3D_Init:
        PUSH    ESI EDI EBX EBP
        CLI
        LEA     EBX,[_keyup]
        MOV     [L3D_keyup],EBX
        LEA     EBX,[_keydn]
        MOV     [L3D_keydn],EBX
        LEA     EBX,[_keylt]
        MOV     [L3D_keylt],EBX
        LEA     EBX,[_keyrt]
        MOV     [L3D_keyrt],EBX
        LEA     EBX,[_keyff]
        MOV     [L3D_keyff],EBX
        LEA     EBX,[_keybk]
        MOV     [L3D_keybk],EBX
        MOV     [VBL_FullHandler],OFFSET _16kbhandler
        STI
        POP     EBP EBX EDI ESI
        RET

; Here use LANDSIZE = 2^LANDBITS
LANDBITS = 10
LANDSIZE = 1 SHL LANDBITS

EXTRN YZTable:    DWORD
EXTRN LandHeight: DWORD

EXTRN MyHeight: DWORD

        ALIGN 4

PUBLIC XPos, YPos, XInc, YInc
XPos DD 0
YPos DD 0
XInc DD 0
YInc DD 0

PUBLIC LineStart, LineLimit
LineStart DB 0
LineLimit DB 0

        ALIGN 4

PUBLIC YZLimit, YAddr
YZLimit DD 0
YAddr   DD 0

bufOffsMap DD 2*256 DUP (0)
counter1 DD 0


; This calculates the map coordinates of the ray as it advances.

PrecalcRay MACRO n
LOCAL @@l
        MOV     [counter1],n/16
    @@l:
        REPT 16
           ADD     EBP,EDX          ; Advance coordinates.
           ADD     EBX,ESI
           XOR     EAX,EAX
           SHLD    EAX,EBX,LANDBITS ; Find offset in the map memory.
           SHLD    EAX,EBP,LANDBITS
           ADD     EAX,ECX          ; Add the start of the map memory.
           STOSD
        ENDM
        DEC     [counter1]
        JNZ     @@l
ENDM

PUBLIC _ShowVLine
_ShowVLine:
        PUSH    EBX EBP ESI EDI

        MOV     EBP,[XPos]
        MOV     EDX,[XInc]
        MOV     EBX,[YPos]
        MOV     ESI,[YInc]
        MOV     ECX,[LandHeight]
        MOV     EDI,OFFSET bufOffsMap

        ; Precalculate the map coordinates of the full ray, to have some free
        ; registers in the drawing loop.
        ; Not that this is divided in five steps, just the same as the
        ; creation of the YZTable (see landmain.c).

        PrecalcRay 32
        ADD     EDX,EDX                 ; Now advance by 2.
        ADD     ESI,ESI
        PrecalcRay 32
        ADD     EDX,[XInc]              ; Now advance by 3.
        ADD     ESI,[YInc]
        PrecalcRay 32
        ADD     EDX,[XInc]              ; Now advance by 4.
        ADD     ESI,[YInc]
        PrecalcRay 32
        ADD     EDX,[XInc]              ; Now advance by 6.
        ADD     ESI,[YInc]
        ADD     EDX,[XInc]
        ADD     ESI,[YInc]
        PrecalcRay 32

        MOV     EDI,[YAddr]
        ;MOV     EBX,[LandHeight]
        MOV     ESI,OFFSET bufOffsMap
        MOV     EBP,[YZTable]
        MOV     DH,[LineStart]
   @@drawl1:
        LODSD
        MOVZX   ECX,BYTE PTR [EAX]          ; Height.
        ADD     ECX,[MyHeight]
   @@draw:
        MOV     DL,BYTE PTR [LANDSIZE*LANDSIZE+EAX]     ; Colour.
        MOV     AL,[EBP+ECX]    ; Project.
        SUB     AL,DH           ; Subtract from highest pixel drawn till now.
        JBE     LARGE @@nodraw
        ADD     DH,AL
        JC      SHORT @@last
        CMP     DH,[LineLimit]
        JNC     SHORT @@last

   @@drc:
         ; Draw here, AL pixels up with color DL.

        MOVZX   ECX,AL
        MOVZX   EAX,AL
        ADD     EAX,15
        SHR     EAX,4
        AND     CL,15
        PUSH    @@jmptbl[ECX*4]
        MOV     ECX,@@addDITbl[ECX*4]
        RET
   @@last:
       SUB      DH,AL
       MOV      AL,DH
       MOV      DH,[LineLimit]
       SUB      AL,DH
       NEG      AL
       JMP      SHORT @@drc

DumpP MACRO p
@@lde&p:
        MOV     [-80*(15-p)+EDI],DL
        ;MOV     [EDI],DL
        ;SUB     EDI,80
ENDM

DumpPLabel MACRO p
        DD @@lde&p
ENDM

        ALIGN 4
@@jmptbl LABEL DWORD
        DD @@lde0
        I = 15
        REPT 15
           DumpPLabel %I
           I = I - 1
        ENDM

@@addDITbl LABEL DWORD
        DD 16*80
        i = 1
        REPT 15
            DD 80*i
            i = i + 1
        ENDM

    @@dumploop:
         MOV    ECX,80*16
         i = 0
         REPT 16
             DumpP %i
             i = i + 1
         ENDM
         SUB    EDI,ECX
         DEC    EAX
         JNZ    SHORT @@dumploop
        CMP     DH,[LineLimit]
        JZ      @@done

        ADD     EBP,256
        CMP     EBP,[YZLimit]
        JB      LARGE @@drawl1

    @@filll1:
        REPT 8
            CMP    DH,120
            JNC    @@done
            MOV    BYTE PTR [EDI],35
            SUB    EDI,80
            INC    DH
        ENDM
        JMP     LARGE @@filll1

     @@done:
        POP     EDI ESI EBP EBX
        RET

   @@nodraw:
        REPT 16
          ADD     EBP,256
          CMP     EBP,[YZLimit]
          JNB     LARGE @@filll1

          LODSD
          MOVZX   ECX,BYTE PTR [EAX]          ; Height.
          ADD     ECX,[MyHeight]
          CMP     DH,[EBP+ECX]                    ; Project.
          JBE     LARGE @@draw
        ENDM
        JMP     LARGE @@nodraw


ENDS

END


