// -------------------------------- MAIN2.C -----------------------------------
// (C) Copyright 1993 bye Jare and JCAB (Javier & Juan Carlos Arevalo Baeza)
// of Iguana/VangeliSTeam
// Main driver for "Heartquake" part 2.

#include <pmode.h>
#include <modex.h>
#include <sincos.h>
#include <string.h>
#include <vbl.h>
#include <hex.h>
#include <stdio.h>
#include <llkey.h>
#include <file.h>
#include <jclib.h>

#include "main2.h"


void Abort(const char *reason) {
    cli();
    VBL_End();
    LLK_End();
    sti();
    VBL_RestoreSystemTime();
    SetVMode(3);
    puts("HeartQuake kernel panic.... AAAAAAAAAAAARGGGGH!!!!\n\r");
    puts("\n\r");
    puts(reason);
    puts("\n\r");
    _exit();
}

byte  GlobalScrapPal[768];

void main() {

    _initfile();            // Init pmode's file buffers.
    JCLIB_Init("heartq.exe");   // Init JCLIB file routines.
    InitSinCos();           // Init sinus table.

    LLK_Init();             // Init interrupt keyboard handler.
    InitVGA();              // Init video mode tweaked 320x200
    TweakVGA();
    VBL_Initialize(0);      // Init timer retrace interrupt.

    LAND_Do();              // Do it.

    VBL_VSync(0);           // Clear things.
    VBL_VSync(1);
    VBL_End();

    LLK_End();
    VBL_RestoreSystemTime();

    SetVMode(3);
}


