/*
 * FILE: GUSRUN4.C
 */

#include <stdio.h>
#include <stdlib.h>

#ifdef  BORLANDC
#include <alloc.h>
#include <mem.h>
#endif
#ifdef  _MSC_VER
#include <memory.h>
#endif

#include "gf1proto.h"
#include "ultraerr.h"
#include "utility.h"

#define x__DEBUG
#define __SHOW


#define SOUND_MICIN     0x01
#define SOUND_SIGNED    0x02
#define SOUND_16BIT     0x04

static  ULTRA_CFG       gus_config;
static  unsigned        guszero;
static	unsigned		gusoptions;
static  unsigned        gusbufsize, gusrecsize, gusplaysize;
static  unsigned char   huge    *rec_buf, *play_buf;

static	int				current_recording=0;
static  unsigned char   huge    *recording_pos[4];
static  unsigned char   huge    *data_ptr, *data_ptr2;
static  unsigned long           dram_loc, dram_loc2;

static	int				voice_num=0;
static  unsigned char   rec_control=0x80,
						control = 0x80;

static	unsigned		max_buffer_overrun;


void far    *init_process(unsigned bufsize, int prebuf, int option, long frequency);
void far    *next_process(void);
void        end_process(void);



void far *init_process(unsigned bufsize, int prebuf, int option, long frequency)
{
    int         i;

    /*
     * Record parameters
	 */
    if (bufsize>16000u)
        return NULL;
    if (prebuf>3)
        return NULL;

    gusbufsize = bufsize;
    gusrecsize = gusbufsize*4u;
    gusplaysize = gusbufsize*2u;

	gusoptions = option;
	if (gusoptions&SOUND_SIGNED)
		guszero=0;
	else
		guszero=0x80;

	/*
	 * Clear statistics.
	 */
	max_buffer_overrun=0;

	/*
	 * Initial GUS.
	 */
	UltraGetCfg(&gus_config);

	if (UltraProbe(gus_config.base_port) == NO_ULTRA)
		return NULL;

	if (UltraOpen(&gus_config,14) == NO_ULTRA)
		return NULL;

	UltraSetRecordFrequency(frequency);
	UltraSetFrequency(voice_num,frequency);

	if ((rec_buf=malloc(gusrecsize))==NULL
	  ||(play_buf = malloc(gusplaysize))==NULL)
		return NULL;
	recording_pos[0] = rec_buf;
	recording_pos[1] = recording_pos[0]+gusbufsize;
	recording_pos[2] = recording_pos[1]+gusbufsize;
	recording_pos[3] = recording_pos[2]+gusbufsize;
	data_ptr = play_buf;
	data_ptr2 = play_buf+gusbufsize;

	memset(rec_buf, guszero, gusrecsize);
	memset(play_buf, guszero, gusplaysize);

	UltraMemAlloc((unsigned long)gusplaysize,(unsigned long far *)&dram_loc);
	dram_loc2 = dram_loc+gusbufsize;
	UltraDownload(data_ptr,control,dram_loc,gusplaysize,TRUE);

	UltraSetBalance(voice_num,15);
	UltraSetLinearVolume(voice_num,511);

	if (gusoptions&SOUND_MICIN)
        UltraEnableMicIn();
	UltraEnableLineIn();
	UltraEnableOutput();

	current_recording=0;
	for (i=0; i<prebuf; i++)
	{
		UltraRecordData(recording_pos[current_recording],rec_control,gusbufsize,FALSE,FALSE);
		current_recording++;
		if (current_recording>=4)
			current_recording=0;
		while (UltraRecordDmaBusy())
			;
	}

	UltraRecordData(recording_pos[current_recording],rec_control,gusbufsize,FALSE,FALSE);
	current_recording++;
	if (current_recording>=4)
		current_recording=0;
	return (void far *)rec_buf;
}


void far *next_process(void)
{
	void 			*tmp;
	unsigned long 	tmpl;

	// show location
#ifdef __SHOW
	if (UltraRecordDmaBusy())
	{
		unsigned val;
		val = UltraReadRecordPosition();
		max_buffer_overrun=max(max_buffer_overrun, val);
		printf("%04x\r",val);
	} else
	{
		end_process();
		fprintf(stderr, "\n[GUSRUN] Buffer overruned, CPU is too slow!");
		exit(-1);
	}
#endif

	// wait last process
	while (UltraRecordDmaBusy())
		;

	// record new data to new pos
	UltraRecordData(recording_pos[current_recording],rec_control,gusbufsize,FALSE,FALSE);

	// start new data to new pos
	UltraStartVoice(voice_num,dram_loc2,dram_loc2,dram_loc2+gusbufsize-1,0);
	UltraDownload(data_ptr,control,dram_loc,gusbufsize,FALSE);

	current_recording++;
	if (current_recording>=4)
		current_recording=0;

	tmp 		= data_ptr;
	data_ptr 	= data_ptr2;
	data_ptr2 	= tmp;

	tmpl 		= dram_loc;
	dram_loc 	= dram_loc2;
	dram_loc2 	= tmpl;

    return (void far *)data_ptr;
}

void end_process(void)
{
    free(rec_buf);
	free(play_buf);
	UltraMemFree((unsigned long)gusplaysize,dram_loc);
	UltraDisableLineIn();
	if (gusoptions&SOUND_MICIN)
        UltraDisableMicIn();
	UltraClose();
#ifdef __SHOW
	printf("%-05.2lf%\n",(double)max_buffer_overrun/gusbufsize*100.0);
#endif

}



#ifdef __DEBUG

#include <conio.h>
main(int argc, char **argv)
{
	unsigned char 	*p, *q;
	unsigned        rbufsize=4096u, rbufall=rbufsize*4u;
	unsigned 		i, j;
	long	 		frequency;

	if (argc!=2)
	{
		fprintf(stderr, "Usage: %s freq\n", argv[0]);
		exit(-1);
	}
	frequency = max(4000, atol(argv[1]));
	frequency = min(44100, frequency);
	printf("sample freq: %ld\n", frequency);

	if ((p=init_process(rbufsize, 1, frequency))==NULL)
	{
		fprintf(stderr, "Can't init");
		exit(-1);
	}

	j=0;
	do {
		q=next_process();
		for (i=0; i<rbufsize; i++, j++)
		{
			if (j>=rbufall)
				j=0;
			q[i%rbufsize]=p[j];
		}
	} while(!kbhit());

	end_process();

	return 0;
}
#endif

