shared float4x4 World          : WORLD          < string SasBindAddress = "Sas.Skeleton.MeshToJointToWorld[0]"; >;
shared float4x4 View           : VIEW           < string SasBindAddress = "Sas.Camera.WorldToView"; >;
shared float4x4 Projection     : PROJECTION     < string SasBindAddress = "Sas.Camera.Projection"; >;
shared float3   CameraPosition : CAMERAPOSITION < string SasBindAddress = "Sas.Camera.Position"; >;
shared float4   Time           : TIME           < string SasBindAddress = "Sas.Time.Now"; >;
shared float3   LightDir       : DIRECTION      < string SasBindAddress = "Sas.DirectionalLight[0].Direction"; >;

//===========================================================================
float2 MapToTexCoord (float2 coord) {
    return (float2(coord.x, -coord.y) + 1) * 0.5f;
}

texture2D tex0 <
    string Name = "";
    string SasResourceAddress = "..\\..\\examples\\tex_diffuse.tga";
>;
textureCUBE tex1 <
    string Name = "";
    string SasResourceAddress = "..\\..\\examples\\sky_cubemap.dds";
>;
texture2D tex2 <
    string Name = "";
    string SasResourceAddress = "..\\..\\examples\\fresnel.dds";
>;

sampler2D sampler0 = sampler_state {
    Texture   = <tex0>;
    AddressU  = Wrap;
    AddressV  = Wrap;
    MagFilter = Linear;
    MinFilter = Linear;
    MipFilter = Point;
};
samplerCUBE sampler1 = sampler_state {
    Texture   = <tex1>;
    AddressU  = Wrap;
    AddressV  = Wrap;
    MagFilter = Linear;
    MinFilter = Linear;
    MipFilter = Point;
};
sampler2D sampler2 = sampler_state {
    Texture   = <tex2>;
    AddressU  = Clamp;
    AddressV  = Clamp;
    MagFilter = Linear;
    MinFilter = Linear;
    MipFilter = Point;
};

//===========================================================================
void VertexShader0 (
    float3 position : POSITION,
    float3 normal : NORMAL,
    float2 texCoord0 : TEXCOORD0,
    out float2 oT0 : TEXCOORD0,
    out float3 oT1 : TEXCOORD1,
    out float3 oT2 : TEXCOORD2,
    out float3 oT3 : TEXCOORD3,
    out float4 oPos : POSITION
) {
    oPos = mul(mul(mul(float4(position, 1), World), View), Projection);
    float3 eyeDir = normalize(CameraPosition - mul(float4(position, 1), World));
    oT0 = texCoord0;
    oT1 = reflect(-eyeDir, mul(normal, World));
    oT2 = mul(normal, World);
    oT3 = eyeDir;
}

//===========================================================================
float4 PixelShader0 (
    float2 texCoord0_0 : TEXCOORD0,
    float3 eyeDirWorld1 : TEXCOORD1,
    float3 normalWorld0 : TEXCOORD2,
    float3 eyeDirWorld0 : TEXCOORD3
) : COLOR {
    float4 texData13 = tex2D(sampler0, texCoord0_0);
    float4 texData9 = texCUBE(sampler1, eyeDirWorld1);
    float4 op4 = dot(float4(normalWorld0.x, normalWorld0.y, normalWorld0.z, 0), float4(eyeDirWorld0.x, eyeDirWorld0.y, eyeDirWorld0.z, 0));
    float4 texData5 = tex2D(sampler2, float2(op4.x, op4.y));
    float4 op10 = lerp(texData13, texData9, texData5.x);
    return op10;
}

technique T0 < string SortTri = "Off"; > {
    pass P0 <
        int TexGen[] = {0x0, 0x80000130, 0x80000033, 0x80000030};
    > {
        CullMode         = CCW;
        PixelShader      = compile ps_1_4 PixelShader0();
        VertexShader     = compile vs_1_1 VertexShader0();
    }
}
