#ifndef __OCTREE_H__

#define __OCTREE_H__



#include "..\Cargador3d\3ds.h"

#include "..\Frustum\Frustum.h"
#include "..\Miscelanea\Objeto.h"

#include "..\Camara\Camara.h"





extern int				g_MaximoTriangulos;

extern int				g_MaximaSubdivision;

extern int				g_CuentaNodosFinal;

extern int				g_TotalNodosDibujando;

extern int				g_TotalTestColisiones;

extern int				g_TotalColisiones;

extern bool				g_bModoRender;

extern bool				g_bIluminacion;	

extern COGLFrustum		g_Frustum;



#define	MAX_TEXTURAS	30

extern 	UINT			g_mTexturas[MAX_TEXTURAS];


enum eNodosOctree

{

	ARRIBA_IZQUIERDA_ADELANTE,

	ARRIBA_IZQUIERDA_ATRAS,

	ARRIBA_DERECHA_ATRAS,

	ARRIBA_DERECHA_ADELANTE,

	ABAJO_IZQUIERDA_ADELANTE,

	ABAJO_IZQUIERDA_ATRAS,

	ABAJO_DERECHA_ATRAS,

	ABAJO_DERECHA_ADELANTE

};



struct sListaCaras 

{

	vector<bool> pListaCaras;

	int NumeroCaras;

};









class COGLDepuracion

{



public:



	void LineaDepuracion(COGLVector3d vector_punto1, COGLVector3d vector_punto2);

	void CuboDepuracion(COGLVector3d vector_centro, float ancho, float alto, float profundidad);

	void RenderizaLineasDepuracion();		

	void Limpia();					



private:



	vector<COGLVector3d> m_vLineas;		

};



extern COGLDepuracion	g_Depuracion;





class COGLOctree{



public:



	COGLOctree();

	~COGLOctree();



	void ObtenerDimensiones3ds(sModelo3d *Modelo3ds);

	int  ObtenerTriangulos3ds(sModelo3d *Modelo3ds);



	void IndiceObjetoLista(int indice);



	COGLVector3d ObtenerCentroNuevoNodo(COGLVector3d vector_centro,float ancho,int IDNodo);



	void CreaNodo(sModelo3d *Modelo3ds,int numeroTriangulos,COGLVector3d vector_centro,float ancho);



	void CreaNuevoNodo(sModelo3d *Modelo3ds,vector<sListaCaras>,int NumeroTriangulos,

					   COGLVector3d vector_centro,float ancho,int IDNodo);



	void AsignaTriangulosNodo(sModelo3d *Modelo3ds,int numeroTriangulos);



	void DibujaOctree(COGLOctree *pNodo,sModelo3d *pMundoRaiz);



	//void CreaListaDisplay(COGLOctree *pNodo,sModelo3d *pMundoRaiz,int DesplazamientoListaDisplay);

	void CreaListaDisplay(COGLObjeto *pObj,COGLOctree *pNodo,int DesplazamientoListaDisplay);



	bool ColisionObjeto( COGLObjeto *pObjeto,sModelo3d *pNodoRaiz );



	//Funciones inspectoras

	COGLVector3d	ObtenerCentro()							{	return m_vector_centro;		}

	int				ObtenerTriangulos()						{	return m_NumeroTriangulos;	}

	float			ObtenerAncho()							{	return m_Ancho;				}

	bool			EstaSubdividido()						{	return m_bSubdividido;		}

	int				ObtenerIDListaDisplay()					{	return m_IDListaDisplay;	}

	

	//Funciones de asignacin

	void			PonIDListaDisplay(int IDListaDisplay)	{	m_IDListaDisplay=IDListaDisplay;	} 

	//bool			ColisionCamara( COGLCamara *pCamara,sModelo3d *pNodoRaiz );



private:



	//Esta variable nos dice si hemos subdividido el nodo en subnodos

	bool m_bSubdividido;



	//Tamao del cubo del nodo actual

	float m_Ancho;



	//Cantidad de triangulos del nodo actual

	int m_NumeroTriangulos;



	//Punto central del nodo actual

	COGLVector3d m_vector_centro;



	//Informacion de toda la escena(vertices,normales,informacion de las texturas...) del nodo actual

	sModelo3d *m_pModelo3ds;



	//Almacena los indices dentro de la lista de objetos del modelo original

	vector<int>	 m_pListaObjetos;



	vector<bool> m_pListaTestObjetos;



	//ID de la lista display para el nodo actual, el cual incrementa la velocidad de render

	int m_IDListaDisplay;



	//Estos son los ocho nodos hijos del nodo actual

	COGLOctree *m_pNodosOctree[8];	

};



#endif