#include "Objeto.h"

COGLObjeto::COGLObjeto(char *ruta_modelo)
{
	m_Radio=15.0f;
	m_ContadorTexturas=0;
	m_Carga3ds.Importar3DS(&m_MiModelo,ruta_modelo);
	
	m_vector_posicion_ant.m_x=50;
	m_vector_posicion_ant.m_y=50;
	m_vector_posicion_ant.m_z=50;

	m_Rot=0.0;
}

void COGLObjeto::CargarTexturasModelo() 
{
	for(int i = 0; i < m_MiModelo.NumeroMateriales; i++)
	{
		if(strlen(m_MiModelo.pMateriales[i].Archivo) > 0)
		{
			m_MiTextura.CargarArchivo(m_mTexturas, m_MiModelo.pMateriales[i].Archivo, m_ContadorTexturas);	
		}
		m_MiModelo.pMateriales[i].IDTextura = m_ContadorTexturas;
		m_ContadorTexturas++;	
	}
}

void COGLObjeto::AsignaPosicion(float x,float y,float z,float rot)
{
	m_vector_posicion.m_x=x;
	m_vector_posicion.m_y=y;
	m_vector_posicion.m_z=z;
	m_Rot+=rot;
}

void COGLObjeto::DibujaModelo(bool RepetirTextura)
{
	glPushMatrix();
	glRotatef(m_Rot,0.0,1.0,0.0);
	glTranslatef(m_vector_posicion.m_x,m_vector_posicion.m_y,m_vector_posicion.m_z);

	for(int i = 0; i < m_MiModelo.NumeroObjetos; i++)
	{
		if(m_MiModelo.pObjeto.size() <= 0) break;
	
		sObjeto3d *pObjeto = &m_MiModelo.pObjeto[i];
		if(pObjeto->TieneTextura)
		{
			glEnable(GL_TEXTURE_2D);
			glColor3ub(255, 255, 255);
			glBindTexture(GL_TEXTURE_2D, m_mTexturas[pObjeto->IDMaterial]);
		
			if (RepetirTextura)
			{
				glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
				glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
			}
		} 
		else
		{
			glDisable(GL_TEXTURE_2D);
			glColor3ub(255, 255, 255);
		}

		glBegin(GL_TRIANGLES);			

			for(int j = 0; j < pObjeto->NumeroCaras; j++)
			{
				for(int whichVertex = 0; whichVertex < 3; whichVertex++)
				{
					int index = pObjeto->pCaras[j].IndiceVertice[whichVertex];
					glNormal3f(pObjeto->pNormales[ index ].m_x, pObjeto->pNormales[ index ].m_y, pObjeto->pNormales[ index ].m_z);
		
					if(pObjeto->TieneTextura) 
					{
						if(pObjeto->pCoordenadas) 
							glTexCoord2f(pObjeto->pCoordenadas[ index ].m_x, pObjeto->pCoordenadas[ index ].m_y);
					}
					else
					{
						if(m_MiModelo.pMateriales.size() && pObjeto->IDMaterial >= 0) 
						{
							BYTE *pColor = m_MiModelo.pMateriales[pObjeto->IDMaterial].color;
							glColor3ub(pColor[0], pColor[1], pColor[2]);
						}
					}
					glVertex3f(pObjeto->pVertices[ index ].m_x, pObjeto->pVertices[ index ].m_y, pObjeto->pVertices[ index ].m_z);
				}
			}
		glEnd();
	}
	glPopMatrix();
}

bool COGLObjeto::ColisionTriangulo(COGLVector3d *triangulo )
{
	return ColisionEsferaPoligono( triangulo, m_vector_posicion,3,m_Radio);
}

bool COGLObjeto::ColisionCubo(float x, float y, float z, float lado)
{
	float distance =0.0f, d;

	// Eixo X
	d = (x + lado);
	if( m_vector_posicion.m_x > d ){

		d = m_vector_posicion.m_x - d;
		distance += d * d;

	}else{
		d = (x - lado);
		if( m_vector_posicion.m_x < d ){
			d = d - m_vector_posicion.m_x;
			distance += d * d;

		}
	}

	// Eixo Y
	d = (y + lado);
	if( m_vector_posicion.m_y > d ){

		d = m_vector_posicion.m_y - d;
		distance += d * d;

	}else{
		d = (y - lado);
		if( m_vector_posicion.m_y < d ){
			d = d - m_vector_posicion.m_y;
			distance += d * d;

		}
	}

	// Eixo Z
	d = (z + lado);
	if( m_vector_posicion.m_z > d ){

		d = m_vector_posicion.m_z - d;
		distance += d * d;

	}else{
		d = (z - lado);
		if( m_vector_posicion.m_z < d ){
			d = d - m_vector_posicion.m_z;
			distance += d * d;

		}
	}

	return distance <= ( m_Radio * m_Radio );
}

void COGLObjeto::DibujaBoundingSphere()
{
	GLUquadricObj *esfera=gluNewQuadric();
		
	gluQuadricOrientation(esfera,GLU_INSIDE);

	//glTranslatef(m_posicion_x,m_posicion_y,m_posicion_z);

	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE);

	glColor4f(0.5f,0.5f,1.0f,0.4f);
	gluSphere(esfera,m_Radio,12,12);

	glDisable(GL_BLEND);
	
	gluDeleteQuadric(esfera);		
}