#include "vector3d.h"

COGLVector3d ProductoVectorial(COGLVector3d vector1, COGLVector3d vector2)
{
	COGLVector3d vector_normal;	

	//Hacemos el producto vectorial
	vector_normal.m_x = ((vector1.m_y * vector2.m_z) - (vector1.m_z * vector2.m_y));
	vector_normal.m_y = ((vector1.m_z * vector2.m_x) - (vector1.m_x * vector2.m_z));
	vector_normal.m_z = ((vector1.m_x * vector2.m_y) - (vector1.m_y * vector2.m_x));

	return vector_normal;										 
}

float LongitudVector3d(COGLVector3d vector_temp)
{
		return (float)sqrt(vector_temp.m_x*vector_temp.m_x+vector_temp.m_y*vector_temp.m_y+vector_temp.m_z*vector_temp.m_z);
}

COGLVector3d NormalizarVector3d(COGLVector3d vector_normalizado)
{
	float longitud_vector=LongitudVector3d(vector_normalizado);

	if(longitud_vector==0)	
		return vector_normalizado;

	vector_normalizado=vector_normalizado/longitud_vector;

	return vector_normalizado;
}


COGLVector3d Vector2Puntos(COGLVector3d vPoint1, COGLVector3d vPoint2)
{
	COGLVector3d vVector;							
	vVector.m_x = vPoint1.m_x - vPoint2.m_x;			
	vVector.m_y = vPoint1.m_y - vPoint2.m_y;			
	vVector.m_z = vPoint1.m_z - vPoint2.m_z;			

	return vVector;								
}

COGLVector3d DivideVectorPorEscalar(COGLVector3d vector_temp, float escalar)
{
	COGLVector3d vVector;							
	
	vVector.m_x = vector_temp.m_x / escalar;			
	vVector.m_y = vector_temp.m_y / escalar;			
	vVector.m_z = vector_temp.m_z / escalar;			

	return vVector;								
}
