#ifndef __VECTOR2D_H__
#define __VECTOR2D_H__

#include <math.h>


class COGLVector2d{

public:
	//Constructor por defecto
	COGLVector2d() {}

	//Este el constructor que permite inicializar el vector
	COGLVector2d(float x,float y)
	{
		m_x=x;
		m_y=y;
	}

	/////////////////////////////////////////////////////////////////////////
	// Sobrecarga de operadores para poder hacer operaciones entre vectores//
	/////////////////////////////////////////////////////////////////////////
	COGLVector2d operator+(COGLVector2d vector_temp)
	{
		return COGLVector2d(vector_temp.m_x + m_x, vector_temp.m_y + m_y);
	}

	COGLVector2d operator-(COGLVector2d vector_temp)
	{
		return COGLVector2d(m_x - vector_temp.m_x, m_y - vector_temp.m_y);
	}
	
	COGLVector2d operator*(float num)
	{
		return COGLVector2d(m_x * num, m_y * num);
	}

	COGLVector2d operator/(float num)
	{
		return COGLVector2d(m_x / num, m_y / num);
	}


	float m_x;
	float m_y;
};

#endif 