#include "Geometria.h"

/////////////////////////////////////////////////////////////////////////
// Funciones bsicas vectores										   //
/////////////////////////////////////////////////////////////////////////
COGLVector2d CreaVector2d(COGLVector3d punto1, COGLVector3d punto2)
{
	COGLVector2d vVector;							
	
	vVector.m_x = punto1.m_x - punto2.m_x;			
	vVector.m_y = punto1.m_y - punto2.m_y;			

	return vVector;								
}

COGLVector3d CreaVector3d(COGLVector3d punto1, COGLVector3d punto2)
{
	COGLVector3d vVector;							
	vVector.m_x = punto1.m_x - punto2.m_x;			
	vVector.m_y = punto1.m_y - punto2.m_y;			
	vVector.m_z = punto1.m_z - punto2.m_z;			

	return vVector;								
}

float LongitudVector2d(COGLVector2d vector_temp)
{
	return (float)sqrt(vector_temp.m_x*vector_temp.m_x+vector_temp.m_y*vector_temp.m_y);
}

float LongitudVector3d(COGLVector3d vector_temp)
{
		return (float)sqrt(vector_temp.m_x*vector_temp.m_x+vector_temp.m_y*vector_temp.m_y+vector_temp.m_z*vector_temp.m_z);
}

float DistanciaDosVectores(COGLVector3d Punto1, COGLVector3d Punto2)
{
	double distancia = sqrt((Punto2.m_x - Punto1.m_x) * (Punto2.m_x - Punto1.m_x) +
						    (Punto2.m_y - Punto1.m_y) * (Punto2.m_y - Punto1.m_y) +
						    (Punto2.m_z - Punto1.m_z) * (Punto2.m_z - Punto1.m_z) );

	return (float)distancia;
}

COGLVector2d NormalizarVector2d(COGLVector2d vector_normalizado)
{
	float longitud_vector=LongitudVector2d(vector_normalizado);

	if(longitud_vector==0)	
		return vector_normalizado;

	vector_normalizado=vector_normalizado/longitud_vector;

	return vector_normalizado;
}

COGLVector3d NormalizarVector3d(COGLVector3d vector_normalizado)
{
	float longitud_vector=LongitudVector3d(vector_normalizado);

	if(longitud_vector==0)	
		return vector_normalizado;

	vector_normalizado=vector_normalizado/longitud_vector;

	return vector_normalizado;
}

COGLVector3d Normalizar(COGLVector3d vPoligono[])					
{	
	COGLVector3d vVector1 = vPoligono[2] - vPoligono[0];
	COGLVector3d vVector2 = vPoligono[1] - vPoligono[0];

	COGLVector3d vector_normal = ProductoVectorial(vVector1, vVector2);	

	vector_normal = NormalizarVector3d(vector_normal);	

	return vector_normal;								
}

COGLVector3d NormalizarPoligono(COGLVector3d Poligono[])					
{														
	COGLVector3d vVector1 = Poligono[2] - Poligono[0];
	COGLVector3d vVector2 = Poligono[1] - Poligono[0];

	COGLVector3d vector_normal = ProductoVectorial(vVector1, vVector2);		

	vector_normal = NormalizarVector3d(vector_normal);				

	return vector_normal;										
}

float Absoluto(float num)
{
	if(num>0)
		return(0-num);

	return num;
}

float ProductoEscalar(COGLVector3d vector1,COGLVector3d vector2)
{
	return ((vector1.m_x*vector2.m_x)+(vector1.m_y*vector2.m_y)+(vector1.m_z*vector2.m_z));
}

COGLVector3d ProductoVectorial(COGLVector3d vector1, COGLVector3d vector2)
{
	COGLVector3d vector_normal;	

	vector_normal.m_x = ((vector1.m_y * vector2.m_z) - (vector1.m_z * vector2.m_y));
	vector_normal.m_y = ((vector1.m_z * vector2.m_x) - (vector1.m_x * vector2.m_z));
	vector_normal.m_z = ((vector1.m_x * vector2.m_y) - (vector1.m_y * vector2.m_x));

	return vector_normal;										 
}

COGLVector3d DivideVectorPorEscalar(COGLVector3d vector_temp, float escalar)
{
	COGLVector3d vVector;							
	
	vVector.m_x = vector_temp.m_x / escalar;			
	vVector.m_y = vector_temp.m_y / escalar;			
	vVector.m_z = vector_temp.m_z / escalar;			

	return vVector;								
}

double AnguloEntreVectores(COGLVector3d vector1,COGLVector3d vector2)
{
	double producto_escalar=ProductoEscalar(vector1,vector2);

	double longitudes=LongitudVector3d(vector1)*LongitudVector3d(vector2);

	double angulo=acos(producto_escalar/longitudes);

	if(_isnan(angulo))
		return 0;

	return angulo;
}

float DistanciaPlano(COGLVector3d Normal,COGLVector3d Punto)
{
	float distancia=0.0f;

	distancia=-((Normal.m_x*Punto.m_x)+(Normal.m_y*Punto.m_y)+(Normal.m_z*Punto.m_z));

	return distancia;
}

bool InterseccionPlano(COGLVector3d Poligono[],COGLVector3d Linea[],COGLVector3d &vector_normal,float &distancia_origen)
{
	float distancia1=0.0f,distancia2=0.0;

	vector_normal=NormalizarPoligono(Poligono);

	distancia_origen=DistanciaPlano(vector_normal,Poligono[0]);

	distancia1=((vector_normal.m_x*Linea[0].m_x)+						//Ax+
				(vector_normal.m_y*Linea[0].m_y)+						//Bx+
				(vector_normal.m_z*Linea[0].m_z))+distancia_origen;		//Cz+D

	distancia2=((vector_normal.m_x*Linea[1].m_x)+						//Ax
				(vector_normal.m_y*Linea[1].m_y)+						//Bx+
				(vector_normal.m_z*Linea[1].m_z))+distancia_origen;		//Cz+D

	if(distancia1*distancia2>=0)
		return false;

	return true;
}



COGLVector3d PuntoInterseccionLineaPlano(COGLVector3d vector_normal, COGLVector3d Linea[], double distancia)
{
	COGLVector3d punto, direccion_linea;					// Variables to hold the point and the line's direction
	double numerador = 0.0, denominador = 0.0, dist = 0.0;

	//1)Conseguimos el vector de nuestra linea y lo normalizamos
	direccion_linea = Linea[1] - Linea[0];		
	direccion_linea = NormalizarVector3d(direccion_linea);				

	//2)Usamos la ecuacion del plano(distancia=Ax+By+Cz+d) para encontrar la distancia desde uno de nuestros puntos al 
	//plano
	numerador = - (vector_normal.m_x * Linea[0].m_x +	
				   vector_normal.m_y * Linea[0].m_y +
				   vector_normal.m_z * Linea[0].m_z + distancia);

	//3)Hacemos el producto escalar entre la linea y la normal del poligono
	denominador = ProductoEscalar(vector_normal, direccion_linea);		

	//Si es 0, es que la linea est en el plano
	if( denominador == 0.0)					
		return Linea[0];					

	dist = numerador / denominador;	

	punto.m_x = (float)(Linea[0].m_x + (direccion_linea.m_x * dist));
	punto.m_y = (float)(Linea[0].m_y + (direccion_linea.m_y * dist));
	punto.m_z = (float)(Linea[0].m_z + (direccion_linea.m_z * dist));

	return punto;								// Devolvemos el punto de interseccin
}


bool DentroPoligono(COGLVector3d vector_interseccion, COGLVector3d poligono[], long nVertices)
{
	const double FACTOR_CORRECION = 0.99;		// Es usado para corregir el error en coma flotante
	double Angulo = 0.0;						
	COGLVector3d vector1, vector2;						

	for (int i = 0; i < nVertices; i++)		
	{	
		vector1 = poligono[i] - vector_interseccion;			
		vector2 = poligono[(i + 1) % nVertices] - vector_interseccion;
												
		Angulo += AnguloEntreVectores(vector1, vector2);	
	}
											
	if(Angulo >= (FACTOR_CORRECION * (2.0 * PI)) )	//Si el angulo es mayor que 2*PI(360grados)
		return true;							//El punto est dentro del poligono
		
	return false;								//No est dentro del poligono
}

bool InterseccionPoligono(COGLVector3d Poligono[], COGLVector3d Linea[], int nVertices)
{
	COGLVector3d vector_normal;
	float distancia_origen = 0;

	//Primero, nos aseguramos que nuestra linea intersecta con el plano
	if(!InterseccionPlano(Poligono, Linea,   vector_normal,   distancia_origen))
		return false;

	//Ahora que tenemos nuestra normal y la distancia podemos usarlos para calcular el punto de interseccion
	COGLVector3d vector_interseccion = PuntoInterseccionLineaPlano(vector_normal, Linea, distancia_origen);

	//Ahora que tenemos el punto de interseccin, necesitamos testear si est dentro del poligono
	if(DentroPoligono(vector_interseccion, Poligono, nVertices))
		return true;							// Colisin!!! Colisin!!!

	return false;								// No Colisin!!! No Colisin!!!
}

int ClasificacionEsfera(COGLVector3d &vector_centro,COGLVector3d &vector_normal, COGLVector3d &punto, float radio, float &distancia)
{
	float d = (float)DistanciaPlano(vector_normal, punto);

	distancia = (vector_normal.m_x * vector_centro.m_x + vector_normal.m_y * vector_centro.m_y + vector_normal.m_z * vector_centro.m_z + d);

	if(fabs(distancia) < radio)
		return INTERSECCION;
	else if(distancia >= radio)
		return ADELANTE;
	
	return DETRAS;
}

bool ColisionEsferaPoligono(COGLVector3d Poligono[],COGLVector3d &vector_centro, int nVertices, float Radio)
{
	// 1) Encontramos la clasificacin de la esfera
	
	COGLVector3d vector_normal = NormalizarPoligono(Poligono);

	float distancia = 0.0f;

	//En esta variable almacenamos si la esfera est enfrente detras o intersecta con el plano
	//que forma el poligono	
	int clasificacion = ClasificacionEsfera(vector_centro, vector_normal, Poligono[0], Radio, distancia);

	if(clasificacion == INTERSECCION) 
	{
		// 2) Encontramos la pseudo interseccin

		COGLVector3d vector_desplazamiento = vector_normal * distancia;

		COGLVector3d vector_posicion = vector_centro - vector_desplazamiento;

		// 3) Chequeamos si el punto de interseccin est del perimetro del poligono
		if(DentroPoligono(vector_posicion, Poligono, nVertices))
			return true;	//Colisin!!! Colisin!!!
		else
		{
			//4)Chequeamos si la esfera intersecta con los extremos del poligono
			if(EdgeSphereCollision(vector_centro, Poligono, nVertices, Radio))
			{
				return true;	//Colisin!!! Colisin!!!
			}
		}
	}

	//No Colisin!!! No colisin!!!
	return false;
}

COGLVector3d PuntoMasCerradoLinea(COGLVector3d vector1, COGLVector3d vector2, COGLVector3d Punto)
{
	COGLVector3d vVector1 = Punto - vector1;

	COGLVector3d vVector2 = NormalizarVector3d(vector2 - vector1);

	float d = DistanciaDosVectores(vector1, vector2);

	float t = ProductoEscalar(vVector2, vVector1);

	if (t <= 0) 
		return vector1;

	if (t >= d) 
		return vector2;
 
	COGLVector3d vVector3 = vVector2 * t;

	COGLVector3d vClosestPoint = vector1 + vVector3;

	return vClosestPoint;
}

bool EdgeSphereCollision(COGLVector3d &vector_centro,COGLVector3d Poligono[], int nVertices, float Radio)
{
	COGLVector3d punto;

	for(int i = 0; i < nVertices; i++)
	{
		punto = PuntoMasCerradoLinea(Poligono[i], Poligono[(i + 1) % nVertices], vector_centro);
		
		float distancia = DistanciaDosVectores(punto, vector_centro);
	
		if(distancia < Radio)
			return true;
	}

	return false;
}

COGLVector3d ConsigueDesplazamientoColision(COGLVector3d &vector_normal, float radio, float distancia)
{
	COGLVector3d vOffset = COGLVector3d(0, 0, 0);

	
	if(distancia > 0)
	{
		float distanciaOver = radio - distancia;
		vOffset = vector_normal * distanciaOver;
	}
	else 
	{
		float distanciaOver = radio + distancia;
		vOffset = vector_normal * -distanciaOver;
	}

	return vOffset;
}