#ifndef INPUT_H
#define INPUT_H

#define WIN32_LEAN_AND_MEAN
#include <dinput.h>

enum MOUSE_BUTTON
{
	MOUSE_LEFTBUTTON,
	MOUSE_RIGHTBUTTON,
	MOUSE_MIDDLEBUTTON
};

class COGLDInput
{
public:
	COGLDInput();
	~COGLDInput();

	HRESULT Iniciar(HWND hWnd);
	HRESULT Actualizar(void);

	BOOL	TeclaPulsada(int idTecla);

	BOOL	BotonPulsado(int idBoton);

	int		PosicionRelativaX(void);
	int		PosicionRelativaY(void);
	int		PosicionRelativaZ(void);

	int		PosicionAbsolutaX(void);
	int		PosicionAbsolutaY(void);
	int		PosicionAbsolutaZ(void);

private:
	HRESULT					ActualizaTeclado(void);
	HRESULT					ActualizaRaton(void);

	LPDIRECTINPUT8			DInput;
	LPDIRECTINPUTDEVICE8	Teclado;
	LPDIRECTINPUTDEVICE8	Raton;

	BYTE					Teclas[256];
	DIMOUSESTATE2			EstadoRaton;
};

#endif // INPUT_H