#include "Input.h"

//------------------------------------------------------------------------------
//Constructor. Inicia los miembros de la clase
//------------------------------------------------------------------------------
COGLDInput::COGLDInput()
{
	DInput = NULL;
	Teclado = NULL;
	Raton = NULL;
}

//------------------------------------------------------------------------------
//Destructor. Elimina los miembros de la clase necesarios
//------------------------------------------------------------------------------

COGLDInput::~COGLDInput()
{
	if(Teclado)
	{
		Teclado->Unacquire();
		Teclado->Release();
		Teclado = NULL;
	}

	if(Raton)
	{
		Raton->Unacquire();
		Raton->Release();
		Raton = NULL;
	}

	if(DInput)
	{
		DInput->Release();
		DInput = NULL;
	}
}

//------------------------------------------------------------------------------
//Creacin del teclado y del ratn.
//------------------------------------------------------------------------------

HRESULT COGLDInput::Iniciar(HWND hWnd)
{
	/////////////////////////////////////////////////////////////////////////////////////
	// Creamos el objeto DInput
	if(FAILED(DirectInput8Create(GetModuleHandle(NULL), DIRECTINPUT_VERSION, IID_IDirectInput8, (VOID**)&DInput, NULL)))
	{
		MessageBox(hWnd, "No se pudo inicializar DInput!", "Error", MB_OK|MB_ICONEXCLAMATION);
		return E_FAIL;
	}
	/////////////////////////////////////////////////////////////////////////////////////

	
	/////////////////////////////////////////////////////////////////////////////////////
	// Creamos el device Keyboard
	if(FAILED(DInput->CreateDevice(GUID_SysKeyboard, &Teclado, NULL)))
	{
		MessageBox(hWnd, "No se pudo crear el objeto teclado!", "Error", MB_OK|MB_ICONEXCLAMATION);
		return E_FAIL;
	}

	// Especificamos el formato de los datos
	if(FAILED(Teclado->SetDataFormat(&c_dfDIKeyboard)))
	{
		MessageBox(hWnd, "No se pudo especificar el formato de datos del teclado!", "Error", MB_OK|MB_ICONEXCLAMATION);
		return E_FAIL;
	}

	// Especificamos el modo cooperativo
	if(FAILED(Teclado->SetCooperativeLevel(hWnd, DISCL_EXCLUSIVE|DISCL_FOREGROUND)))
	{
		MessageBox(hWnd, "No se pudo especificar el formato de datos del teclado!", "Error", MB_OK|MB_ICONEXCLAMATION);
		return E_FAIL;
	}

	// Adquirimos device keyboard
	Teclado->Acquire();
	/////////////////////////////////////////////////////////////////////////////////////


	/////////////////////////////////////////////////////////////////////////////////////
	// Creamos el device Mouse
	if(FAILED(DInput->CreateDevice(GUID_SysMouse, &Raton, NULL)))
	{
		MessageBox(hWnd, "No se pudo crear el objeto mouse!", "Error", MB_OK|MB_ICONEXCLAMATION);
		return E_FAIL;
	}

	// Especificamos el formato de los datos
	if(FAILED(Raton->SetDataFormat(&c_dfDIMouse2)))
	{
		MessageBox(hWnd, "No se pudo especificar el formato de datos del raton!", "Error", MB_OK|MB_ICONEXCLAMATION);
		return E_FAIL;
	}

	// Especificamos el modo cooperativo
	if(FAILED(Raton->SetCooperativeLevel(hWnd, DISCL_EXCLUSIVE|DISCL_FOREGROUND)))
	{
		MessageBox(hWnd, "No se pudo especificar el formato de datos del mouse!", "Error", MB_OK|MB_ICONEXCLAMATION);
		return E_FAIL;
	}

	// Adquirimos device mouse
	Raton->Acquire();
	/////////////////////////////////////////////////////////////////////////////////////

	return S_OK;

}

//------------------------------------------------------------------------------
// Actualiza el teclado y el ratn.
//------------------------------------------------------------------------------

HRESULT COGLDInput::Actualizar(void)
{
	if(FAILED(ActualizaTeclado()))
	{
		return E_FAIL;
	}

	if(FAILED(ActualizaRaton()))
	{
		return E_FAIL;
	}
	return S_OK;
}

//------------------------------------------------------------------------------
//Nos dice si una tecla ha sido pulsada o no.
//------------------------------------------------------------------------------
BOOL COGLDInput::TeclaPulsada(int idTecla)
{
	// Nos aseguramos de que idTecla sea un entero vlido
	if(idTecla < 0 || idTecla > 255)
		return FALSE;

	// Miramos si la tecla idTecla ha sido pulsada
	if(Teclas[idTecla] & 0x80)
		return TRUE;

	return FALSE;
}

//------------------------------------------------------------------------------
//Nos dice si un botn del ratn ha sido pulsado o no.
//------------------------------------------------------------------------------
BOOL COGLDInput::BotonPulsado(int idBoton)
{
	if(EstadoRaton.rgbButtons[idBoton] & 0x80)
		return TRUE;
	else return FALSE;
}

//------------------------------------------------------------------------------
//Devuelve la coordenada X absoluta (en coordenadas de pantalla) del ratn.
//------------------------------------------------------------------------------
int COGLDInput::PosicionAbsolutaX(void)
{
	static int iBasePos;

	return iBasePos += EstadoRaton.lX;
}

//------------------------------------------------------------------------------
//Devuelve la coordenada Y absoluta (en coordenadas de pantalla) del ratn.
//------------------------------------------------------------------------------
int COGLDInput::PosicionAbsolutaY(void)
{
	static int iBasePos;

	return iBasePos += EstadoRaton.lY;
}

//------------------------------------------------------------------------------
//Devuelve la coordenada Z absoluta (en coordenadas de pantalla) del ratn
//------------------------------------------------------------------------------
int COGLDInput::PosicionAbsolutaZ(void)
{
	static int iBasePos;

	return iBasePos += EstadoRaton.lZ;
}

//------------------------------------------------------------------------------
//Devuelve la coordenada X relativa del ratn.
//------------------------------------------------------------------------------
int COGLDInput::PosicionRelativaX(void)
{
	return EstadoRaton.lX;
}

//------------------------------------------------------------------------------
//Devuelve la coordenada Y relativa del ratn.
//------------------------------------------------------------------------------
int COGLDInput::PosicionRelativaY(void)
{
	return EstadoRaton.lY;
}

//------------------------------------------------------------------------------
//Devuelve la coordenada Z relativa del ratn.
//------------------------------------------------------------------------------
int COGLDInput::PosicionRelativaZ(void)
{
	return EstadoRaton.lZ;
}

//------------------------------------------------------------------------------
//Actualiza el teclado rellenando el array de teclas.
//------------------------------------------------------------------------------
HRESULT COGLDInput::ActualizaTeclado(void)
{
	HRESULT hr;

	if(!Teclado)
		return S_OK;
    
	// Recogemos el estado del teclado y rellenamos el buffer de teclas
	ZeroMemory(&Teclas, sizeof(Teclas));
	if(FAILED(Teclado->GetDeviceState(sizeof(Teclas), &Teclas))) 
	{
		// Si hemos perdido el device entonces intentamos recuperarlo
		hr = Teclado->Acquire();
		while(hr == DIERR_INPUTLOST)
			hr = Teclado->Acquire();

		return S_OK; 
	}

	return S_OK;
}

//------------------------------------------------------------------------------
//Actualiza el ratn rellenando la estructura de estado.
//------------------------------------------------------------------------------
HRESULT COGLDInput::ActualizaRaton(void)
{
	HRESULT hr;

	if(!Raton)
		return S_OK;
    
	// Recogemos el estado del ratn y rellenamos la estructura de estado
	if(FAILED(Raton->GetDeviceState(sizeof(DIMOUSESTATE2), &EstadoRaton))) 
	{
		// Si hemos perdido el device entonces intentamos recuperarlo
		hr = Raton->Acquire();
		while(hr == DIERR_INPUTLOST)
			hr = Raton->Acquire();

		return S_OK; 
	}

	return S_OK;
}