#include "3ds.h"
#include <assert.h>

int gBuffer[50000] = {0};					// Almacena informacion leida  

//Constructor
/// Cargador fantastico!!!!
COGL3DS::COGL3DS()
{
	pFichero = NULL;
}

// Abre el archivo .3ds, lo lee y libera la memoria
bool COGL3DS::Importar3DS(sModelo3d *pModelo, char *NombreArchivo)
{
	char Mensaje[255] = {0};
	sChunk ChunkActual = {0};

	pFichero = fopen(NombreArchivo, "rb");

	//Si encontramos el archivo
	if(!pFichero) 
	{
		sprintf(Mensaje, "Error al cargar el archivo: %s!", NombreArchivo);
		MessageBox(NULL, Mensaje, "Importar3DS", MB_OK);
		return false;
	}

	// Leemos el primer chunk para ver si es un archivo .3ds
	// (Si es un .3ds el ID del primer chunk sera igual a PRIMARIO (un numero hexadecimal))
	LeeChunk(&ChunkActual);

	if (ChunkActual.ID != PRIMARIO)
	{
		sprintf(Mensaje, "Error al cargar el chunk PRIMARIO del archivo %s", NombreArchivo);
		MessageBox(NULL, Mensaje, "Error", MB_OK);
		return false;
	}

	// Comenzamos a cargar los objetos, leyendo los datos recursivamente
	ProcesaSigChunk(pModelo, &ChunkActual);

	// Despues de haber leido todo el archivo .3ds, calculamos las normales
	CalculaNormales(pModelo);

	// Liberamos memoria
	Liberar();

	return true;
}


void COGL3DS::Liberar()
{
	if (pFichero) {
		fclose(pFichero);					// Cerramos el Archivo .3ds					
		pFichero = NULL;
	}
}

void COGL3DS::DestruyeObjetos(sModelo3d pModelo)
{
	for(int i = 0; i < pModelo.NumeroObjetos; i++)
	{
	// Libera caras, normales, vertices y coordenadas de textura
	delete [] pModelo.pObjeto[i].pCaras;
	delete [] pModelo.pObjeto[i].pNormales;
	delete [] pModelo.pObjeto[i].pVertices;
	delete [] pModelo.pObjeto[i].pCoordenadas;
	}
}

// Lee los chunks principales del .3ds y profundiza usando recursividad
void COGL3DS::ProcesaSigChunk(sModelo3d *pModelo, sChunk *pChunkAnterior)
{
	sObjeto3d NuevoObjeto = {0};					// Aade elementos a la lista de objetos
	sInfo_Material NuevaTextura = {0};				// Aade elementos a la lista de materiales

	sChunk ChunkActual = {0};						// El chunk que estamos cargando
	sChunk ChunkTemporal = {0};						// Chunk temporal para almacenar datos

	// Cada vez que leemos un nuevo Chunk leemos su ID, si nos vale se procesa, sino lo pasamos
	// Seguimos leyendo subChunks hasta alcanzar la longitud.
	while (pChunkAnterior->bytesLeidos < pChunkAnterior->longitud)
	{
		// Lee el siguiente chunk
		LeeChunk(&ChunkActual);

		// Comprueba su ID 
		switch (ChunkActual.ID)
		{
		
		// Si el archivo fue creado en 3D Studio Max, este chunk contiene un entero
		// que indica la version. Se introdujeron cambios en el formato .3ds a partir
		// de la version 4.0, con lo que la carga podria ser incorrecta.

		// Hasta ahora no encontre problemas cargando modelos de ninguna version posterior
		// a la 3.0, ademas testearemos nosotros la carga de los modelos asi que saltaremos
		// esta comprobacion

		case VERSION:							// Almacena la version del archivo .3ds
			
			// Leemos la version y aadimos los bytes leidos a bytesLeidos
			ChunkActual.bytesLeidos += fread(gBuffer, 1, ChunkActual.longitud - ChunkActual.bytesLeidos, pFichero);

			// Si la vesion del archivo es mayor que 3 mostramos el aviso
			if ((ChunkActual.longitud - ChunkActual.bytesLeidos == 4) && (gBuffer[0] > 0x03)) {
				MessageBox(NULL, "Este archivo 3ds es posterior a la version 3.0 por lo que podra haber errores en la carga", "Atencion!!!", MB_OK);
			}
			break;

		case INFO_OBJETO:						// Almacena informacion de la malla, y es el padre
			{									// del subChunk MATERIAL y OBJETO
			
			// Lee el siguiente Chunk
			LeeChunk(&ChunkTemporal);

			// Leemos la version y aadimos los bytes leidos a bytesLeidos
			ChunkTemporal.bytesLeidos += fread(gBuffer, 1, ChunkTemporal.longitud - ChunkTemporal.bytesLeidos, pFichero);
			ChunkActual.bytesLeidos += ChunkTemporal.bytesLeidos;

			// Pasamos al siguiente Chunk, que si el objeto tiene asignada una textura sera MATERIAL, sino sera OBJETO
			ProcesaSigChunk(pModelo, &ChunkActual);
			break;
			}
		case MATERIAL:							// Almacena informacion del material

			// Incrementamos el n de materiales
			pModelo->NumeroMateriales++;

			//***************************VER CON CALMA*****************************
			// Add a empty texture structure to our texture list.
			// If you are unfamiliar with STL's "vector" class, all push_back()
			// does is add a new node onto the list.  I used the vector class
			// so I didn't need to write my own link list functions.  
			pModelo->pMateriales.push_back(NuevaTextura);
			//*********************************************************************

			// Cargamos el material
			ProcesaSigChunkMaterial(pModelo, &ChunkActual);
			break;

		case OBJETO:							// Almacena el nombre del objeto que estamos cargando
												// y es el padre de los subChunks de info objeto
	
			// Incrementamos el n de objetos		
			pModelo->NumeroObjetos++;
		
			//***************************VER CON CALMA*****************************
			// Add a new tObject node to our list of objects (like a link list)
			pModelo->pObjeto.push_back(NuevoObjeto);
			//*********************************************************************
			
			// Inicializamos el objeto y sus data members
			memset(&(pModelo->pObjeto[pModelo->NumeroObjetos - 1]), 0, sizeof(sObjeto3d));

			// Lee y almacena el nombre del objeto, despues se aaden los bytes leidos a byteLeido
			ChunkActual.bytesLeidos += GetString(pModelo->pObjeto[pModelo->NumeroObjetos - 1].Nombre);
			
			// Leemos el resto de la informacion del objeto
			ProcesaSigChunkObjeto(pModelo, &(pModelo->pObjeto[pModelo->NumeroObjetos - 1]), &ChunkActual);
			break;

		case EDITKEYFRAME:

			//ProcessNextKeyFrameChunk(pModelo, ChunkActual);

			// Aadimos los bytes leidos a bytesLeidos
			ChunkActual.bytesLeidos += fread(gBuffer, 1, ChunkActual.longitud - ChunkActual.bytesLeidos, pFichero);
			break;

		default: 
			
			// Para chunks innecesarios o desconocidos
			// seguimos teniendo que leer los bytes leidos y aadirlos a bytesLeidos
			ChunkActual.bytesLeidos += fread(gBuffer, 1, ChunkActual.longitud - ChunkActual.bytesLeidos, pFichero);
			break;
		}

		// Aadimos los bytes que acabamos de leer como Leidos anteriormente
		pChunkAnterior->bytesLeidos += ChunkActual.bytesLeidos;
	}
}


/////	Maneja informacion sobre los objetos del archivo
void COGL3DS::ProcesaSigChunkObjeto(sModelo3d *pModelo, sObjeto3d *pObjeto, sChunk *pChunkAnterior)
{
	// Chunk con el que estamos trabajando
	sChunk ChunkActual = {0};

	// Leemos hasta el final de los subChunks
	while (pChunkAnterior->bytesLeidos < pChunkAnterior->longitud)
	{
		// Lee el siguiente Chunk
		LeeChunk(&ChunkActual);

		// Comprobamos su ID
		switch (ChunkActual.ID)
		{
		case MALLA_OBJETO:					/// Nos permite saber si estamos leyendo un objeto nuevo
		
			// Leemos la informacion del nuevo Objeto
			ProcesaSigChunkObjeto(pModelo, pObjeto, &ChunkActual);
			break;

		case VERTICES_OBJETO:				// Vertices del objeto
			LeeVertices(pObjeto, &ChunkActual);
			break;

		case CARAS_OBJETO:					// Caras del objeto
			LeeIndicesVertices(pObjeto, &ChunkActual);
			break;

		case MATERIAL_OBJETO:				// Almacena el nombre del material que tiene el objeto 
			
			//  ***************************************IMPORTANTE*********************************************
			//  Almacena el nombre del material asignado al objeto (ya sea una textura o un color) y las caras
			//	a las ke esta asisgnado (para casos en ke el objeto tiene mas de una textura asignada o no esta 
			//	asignada a todo el objeto)  
			//	SOLO UNA TEXTURA POR OBJETO ......SOLO COGEMOS EL NOMBRE!!!
			//  **********************************************************************************************


			//  Leemos el nombre del material asignado al objeto
			LeeMaterialObjeto(pModelo, pObjeto, &ChunkActual);			
			break;

		case UV_OBJETO:						// Almacena las coordenadas UV de textura para el objeto

			LeeCoordenadasUV(pObjeto, &ChunkActual);
			break;

		default:  

			// Leer chunks innecesarios o desconocidos
			ChunkActual.bytesLeidos += fread(gBuffer, 1, ChunkActual.longitud - ChunkActual.bytesLeidos, pFichero);
			break;
		}

		// Aadimos los bytes leidos del ultimo chunk al contador de ChunkAnterior
		pChunkAnterior->bytesLeidos += ChunkActual.bytesLeidos;
	}
}


/////	Maneja toda la informacion sobre el Material (Textura)
void COGL3DS::ProcesaSigChunkMaterial(sModelo3d *pModelo, sChunk *pChunkAnterior)
{
	// Chunk con el que estamos trabajando
	sChunk ChunkActual = {0};

	// Leemos hasta el final de los subChunks
	while (pChunkAnterior->bytesLeidos < pChunkAnterior->longitud)
	{
		// Lee el siguiente Chunk
		LeeChunk(&ChunkActual);

		// Comprobamos su ID
		switch (ChunkActual.ID)
		{
		case NOMBREMAT:							// Almacena el nombre del material
			
			// Lee y almacena el nombre del material
			ChunkActual.bytesLeidos += fread(pModelo->pMateriales[pModelo->NumeroMateriales - 1].Nombre, 1, ChunkActual.longitud - ChunkActual.bytesLeidos, pFichero);
			break;

		case MATDIFUSO:							// Almacena el color RGB del objeto
			LeeChunkColor(&(pModelo->pMateriales[pModelo->NumeroMateriales - 1]), &ChunkActual);
			break;
		
		case MATTEXT:							// Header de informacion sobre el material
			
			// Leemos la informacion sobre el material
			ProcesaSigChunkMaterial(pModelo, &ChunkActual);
			break;

		case MATTEXT_ARCHIVO:					// Almacena el nombre del archivo de textura

			// Leemos el nombre del archivo de textura
			ChunkActual.bytesLeidos += fread(pModelo->pMateriales[pModelo->NumeroMateriales - 1].Archivo, 1, ChunkActual.longitud - ChunkActual.bytesLeidos, pFichero);
			break;
		
		default:  

			// Leer chunks innecesarios o desconocidos
			ChunkActual.bytesLeidos += fread(gBuffer, 1, ChunkActual.longitud - ChunkActual.bytesLeidos, pFichero);
			break;
		}

		// Aadimos los bytes leidos del ultimo chunk al contador de ChunkAnterior
		pChunkAnterior->bytesLeidos += ChunkActual.bytesLeidos;
	}
}


/////	Lee el id y la longitud en bytes de un Chunk
void COGL3DS::LeeChunk(sChunk *pChunk)
{
	// Lee el Chunk ID (2bytes)
	pChunk->bytesLeidos = fread(&pChunk->ID, 1, 2, pFichero);

	// Lee la longitud del Chunk (4 bytes)
	pChunk->bytesLeidos += fread(&pChunk->longitud, 1, 4, pFichero);
}

/////   Lee el contenido de una cadena de caracteres
int COGL3DS::GetString(char *pBuffer)
{
	int Indice = 0;

	// Lee el primer byte ke es la primera letra de la cadena
	fread(pBuffer, 1, 1, pFichero);

	// Bucle mientras no sea null
	while (*(pBuffer + Indice++) != 0) {

		// Lee un caracter
		fread(pBuffer + Indice, 1, 1, pFichero);
	}

	// Devuelve la longitud de la cadena, que es igual a los bytes leidos(incluyendo el null)
	return strlen(pBuffer) + 1;
}


/////   Lee los datos de color RGB
void COGL3DS::LeeChunkColor(sInfo_Material *pMaterial, sChunk *pChunk)
{
	sChunk ChunkTemporal = {0};

	// Lee la informacion del Chunk de Color
	LeeChunk(&ChunkTemporal);

	// Lee el color RGB (3 bytes - 0 through 255)
	ChunkTemporal.bytesLeidos += fread(pMaterial->color, 1, ChunkTemporal.longitud - ChunkTemporal.bytesLeidos, pFichero);

	// Aadimos los bytes leidos al contador
	pChunk->bytesLeidos += ChunkTemporal.bytesLeidos;
}


/////	Lee los indices para la Matriz de Vertices
void COGL3DS::LeeIndicesVertices(sObjeto3d *pObjeto, sChunk *pChunkAnterior)
{
	unsigned short Indice = 0;					// Indice de la cara actual
	
	// Lee el numero de caras del objeto (int)
	pChunkAnterior->bytesLeidos += fread(&pObjeto->NumeroCaras, 1, 2, pFichero);

	// Reservamos suficiente memoria para las caras e inicializamos la estructura
	pObjeto->pCaras = new sCara [pObjeto->NumeroCaras];
	memset(pObjeto->pCaras, 0, sizeof(sCara) * pObjeto->NumeroCaras);

	// Pasamos por todas las caras del objeto
	for(int i = 0; i < pObjeto->NumeroCaras; i++)
	{
		// Leemos los indices A,B y C. El 4 indice es un valor de visibilidad de 3D Studio
		// que no nos interesa
		for(int j = 0; j < 4; j++)
		{
			// Lee el primer indice de Vertice para la cara actual
			pChunkAnterior->bytesLeidos += fread(&Indice, 1, sizeof(Indice), pFichero);

			if(j < 3)
			{
				// Almacenamos el indice en nuestra estructura de caras
				pObjeto->pCaras[i].IndiceVertice[j] = Indice;
			}
		}
	}
}


/////	Lee las coordenadas UV del Objeto
void COGL3DS::LeeCoordenadasUV(sObjeto3d *pObjeto, sChunk *pChunkAnterior)
{
	// Lee el numero de Coordenadas UV que hay (int)
	pChunkAnterior->bytesLeidos += fread(&pObjeto->NumeroCoordenada, 1, 2, pFichero);

	// Reservamos memoria para almacenar las coordenada UV
	pObjeto->pCoordenadas = new COGLVector2d [pObjeto->NumeroCoordenada];

	// Lee las coordenadas de textura (Matriz 2 floats)
	pChunkAnterior->bytesLeidos += fread(pObjeto->pCoordenadas, 1, pChunkAnterior->longitud - pChunkAnterior->bytesLeidos, pFichero);
}


/////	Lee los vertices del objeto
void COGL3DS::LeeVertices(sObjeto3d *pObjeto, sChunk *pChunkAnterior)
{
	// Lee el numero de vertices (int)
	pChunkAnterior->bytesLeidos += fread(&(pObjeto->NumeroVertices), 1, 2, pFichero);

	// Reserva memoria para los vertices e inicializa la structura
	pObjeto->pVertices = new COGLVector3d [pObjeto->NumeroVertices];
	memset(pObjeto->pVertices, 0, sizeof(COGLVector3d) * pObjeto->NumeroVertices);

	// Lee los vertices (Matriz 3 floats)
	pChunkAnterior->bytesLeidos += fread(pObjeto->pVertices, 1, pChunkAnterior->longitud - pChunkAnterior->bytesLeidos, pFichero);

	
//** SE ACTIVARA PARA NUEVOS MODELOS ***//
	// Now we should have all of the vertices read in.  Because 3D Studio Max
	// Models with the Z-Axis pointing up (strange and ugly I know!), we need
	// to flip the y values with the z values in our vertices.  That way it
	// will be normal, with Y pointing up.  If you prefer to work with Z pointing
	// up, then just delete this next loop.  Also, because we swap the Y and Z
	// we need to negate the Z to make it come out correctly.

	/*
	// Go through all of the vertices that we just read and swap the Y and Z values
	for(int i = 0; i < pObjeto->NumeroVertices; i++)
	{
		// Store off the Y value
		float fTempY = pObjeto->pVertices[i].y;

		// Set the Y value to the Z value
		pObjeto->pVertices[i].y = pObjeto->pVertices[i].z;

		// Set the Z value to the Y value, 
		// but negative Z because 3D Studio max does the opposite.
		pObjeto->pVertices[i].z = -fTempY;
	}
	*/
}

/////	Lee el nombre del material asignado al objeto y le asigna un ID
void COGL3DS::LeeMaterialObjeto(sModelo3d *pModelo, sObjeto3d *pObjeto, sChunk *pChunkAnterior)
{
	char strMaterial[255] = {0};			// Almacena el nombre de los materiales de los objetos

	// Leemos el nombre del material asignado al objeto actual
	// NombreMaterial contendra una cadena con el nombre, por ejemplo "Material #2" etc..
	pChunkAnterior->bytesLeidos += GetString(strMaterial);

	// Teniendo el nombre del material lo comparamos con todos los materiales y lo comparamos
	// con cada material. Cuando encontremos en la lista de materiales uno que coincida le
	// asignamos al ID de material del objeto el indice del material.

	// Hay que pasar el Modelo a la funcion, ya que necesitamos el numero total de texturas
	// (SI NO SE PODRIA PASAR SOLO EL MODELO Y NO MODELO Y OBJETO)

	// Pasar por todos los materiales
	for(int i = 0; i < pModelo->NumeroMateriales; i++)
	{
		// Comparamos cada material con NombreMaterial
		if(strcmp(strMaterial, pModelo->pMateriales[i].Nombre) == 0)
		{
			// Asignar al ID de material el valor de i y parar la comprobacion
			pObjeto->IDMaterial = i;

			// Una vez encontrado el material, comprobamos si es un mapa de textura.
			// Si Archivo contiene una cadena de longitud mayor que 0 lo es.

			if(strlen(pModelo->pMateriales[i].Archivo) > 0) {

				// Activamos la variable que indica que el objeto tiene un mapa de textura que asociar.
				pObjeto->TieneTextura = true;
			}	
			break;
		}
		else
		{
			// Ponemos el ID -1 para asignar que no hay material para este objeto
			pObjeto->IDMaterial = -1;
		}
	}

	// Read past the rest of the chunk since we don't care about shared vertices
	// You will notice we subtract the bytes already read in this chunk from the total longitud.
	pChunkAnterior->bytesLeidos += fread(gBuffer, 1, pChunkAnterior->longitud - pChunkAnterior->bytesLeidos, pFichero);
}			


//////////////////////////////	Math Functions  ////////////////////////////////*

// Calcula la magnitud de una Normal.  (magnitud = sqrt(x^2 + y^2 + z^2)
#define Mag(Normal) (sqrt(Normal.x*Normal.x + Normal.y*Normal.y + Normal.z*Normal.z))


/////	Calcula las normales y las normales de vertice de los objetos
void COGL3DS::CalculaNormales(sModelo3d *pModelo)
{
	COGLVector3d vVector1, vVector2, vNormal, vVertice[3];

	// Comprobamos que haya objetos 
	if(pModelo->NumeroObjetos <= 0)
		return;

	// Calculamos las normales de cada cara (normal de un triangulo), luego cogemos la media de normales por cada vertice

	// Pasamos por todos los objetos
	for(int Indice = 0; Indice < pModelo->NumeroObjetos; Indice++)
	{
		// Cogemos el objeto Actual
		sObjeto3d *pObjeto = &(pModelo->pObjeto[Indice]);

		// Reservamos la memoria necesaria para calcular las normales
		COGLVector3d *pNormales		= new COGLVector3d [pObjeto->NumeroCaras];
		COGLVector3d *pTempNormales	= new COGLVector3d [pObjeto->NumeroCaras];
		pObjeto->pNormales		    = new COGLVector3d [pObjeto->NumeroVertices];

		// Pasamos por todas las caras del objeto
		for(int i=0; i < pObjeto->NumeroCaras; i++)
		{												
			// Cogemos los 3 puntos que forman la cara
			vVertice[0] = pObjeto->pVertices[pObjeto->pCaras[i].IndiceVertice[0]];
			vVertice[1] = pObjeto->pVertices[pObjeto->pCaras[i].IndiceVertice[1]];
			vVertice[2] = pObjeto->pVertices[pObjeto->pCaras[i].IndiceVertice[2]];

			// Calculamos las normales de la cara (Coger 2 vectores y calcular el producto vectorial)

			vVector1 = CreaVector3d(vVertice[0], vVertice[2]);		// Calcula un vector de la cara (Necesitamos 2 para la normal)
			vVector2 = CreaVector3d(vVertice[2], vVertice[1]);		// Get a second vector of the polygon

			vNormal  = ProductoVectorial(vVector1, vVector2);		// Devuelve el producto vectorial de los vectores
			pTempNormales[i] = vNormal;								// Guardamos el producto (lo usaremos para las Normales de vertice)
			vNormal  = NormalizarVector3d(vNormal);					// Normalizamos el producto vectorial 

			pNormales[i] = vNormal;								    // Guardamos las normales en la lista de normales
		}

		//////////////// Calculo de normales de vertice /////////////////

		COGLVector3d vSuma(0.0, 0.0, 0.0);
		COGLVector3d vCero = vSuma;
		int Compartidos=0;

		for (i = 0; i < pObjeto->NumeroVertices; i++)		// Pasamos por todos los vertices
		{
			for (int j = 0; j < pObjeto->NumeroCaras; j++)	// Pasamos por todas las caras
			{	
				// Comprobamos si el vertice esta compartido por otra cara
				if (pObjeto->pCaras[j].IndiceVertice[0] == i || 
					pObjeto->pCaras[j].IndiceVertice[1] == i || 
					pObjeto->pCaras[j].IndiceVertice[2] == i)
				{
					//Suma
					vSuma = vSuma+pTempNormales[j];				// Aadimos las normales guardadas de la cara compartida	
					Compartidos++;								// Incrementamos el contador de caras compartidas
				}
			}      
			
			// Cogemos las normales dividiendo vSuma entre el numero de compartidos.  Negamos los compartidos para que las normales apunten hacia el exterior del objeto.
			pObjeto->pNormales[i] = DivideVectorPorEscalar(vSuma, float(-Compartidos));

			// Convertimos las normales en normales de vertice
			pObjeto->pNormales[i] = NormalizarVector3d(pObjeto->pNormales[i]);	

			// Reseteamos vSuma y Compartidos	
			vSuma = vCero;					
			Compartidos = 0;				
		}
	
		// Liberamos memoria y seguimos con el siguiente objeto
		delete [] pTempNormales;
		delete [] pNormales;
	}
}
