#ifndef __CAMARA_H__
#define __CAMARA_H__

#include <windows.h>
#include <gl\glu.h>
#include "..\Matematicas\Geometria.h"

class COGLCamara{

public:
	//Constructor de la camara
			COGLCamara();

	//Usamos gluLookAt para decirle a opengl hacia dnd mirar
	void	Mira();

	//Sirve para inicializar los vectores de posicion de vista y el up
	void    PosicionCamara(COGLVector3d vector_posicion,
						   COGLVector3d vector_vista,
						   COGLVector3d vector_up);
	
	//Moveremos la cmara hacia adelante o hacia atras dependiendo del signo
	//de incremento a la velocidad que indique el susodicho parmetro
	void	MueveCamara(float incremento);


	void    RotaSobreEje(float angulo, float x, float y, float z);
	void	RotaAlrededor(COGLVector3d vector_centro, float angulo, float x, float y, float z);
	void	StrafeaCamara(float velocidad);
	void    Actualiza();

	bool	ColisionTriangulo(COGLVector3d *triangulo );
	bool	ColisionCubo(float x, float y, float z, float lado);

	void	DibujaBoundingSphere();

	void    ChequeaColisionCamara(COGLVector3d *pVertices, int numOfVerts);

	float	m_Radio;

	COGLVector3d m_vector_posicion;
	COGLVector3d m_vector_vista;
	COGLVector3d m_vector_up;
	COGLVector3d m_vector_strafing;
};

#endif