#include "Camara.h"

//**********************IMPLEMENTACIN CAMARA*************************************
COGLCamara::COGLCamara()
{
	//Creamos unos vectores temporales para asignarselos a las variables 
	//privadas de la clase.
	COGLVector3d vector_posicion_temp(0.0,0.0,0.0);
	COGLVector3d vector_vista_temp(0.0,1.0,0.0);
	COGLVector3d vector_up_temp(0.0,0.0,1.0);

	m_vector_posicion=vector_posicion_temp;
	m_vector_vista=vector_vista_temp;
	m_vector_up=vector_up_temp;

	m_Radio=1.0f;
}

void COGLCamara::Mira()
{
	gluLookAt(m_vector_posicion.m_x,m_vector_posicion.m_y,m_vector_posicion.m_z,		// Posicion donde est la cmara
			  m_vector_vista.m_x,m_vector_vista.m_y,m_vector_vista.m_z,					// Posicion a donde apunta la cmara
			  m_vector_up.m_x,m_vector_up.m_y,m_vector_up.m_z);							// Vector up ;)
}

void COGLCamara::PosicionCamara(COGLVector3d vector_posicion,COGLVector3d vector_vista,COGLVector3d vector_up)
{
	//Este mtodo es casi igual que el constructor solo que en vez de asinarle
	//a las variables privadas de la clase unos valores por defecto se los asignamos
	//pasados mediante los parametros posicion,vista,up
	m_vector_posicion=vector_posicion;
	m_vector_vista=vector_vista;
	m_vector_up=vector_up;
}

void COGLCamara::MueveCamara(float incremento)
{
	//Obtenemos la direccin a la que observamos
	COGLVector3d vector_temp = m_vector_vista - m_vector_posicion;
	
	m_vector_posicion.m_x += vector_temp.m_x * incremento;		
	m_vector_posicion.m_z += vector_temp.m_z * incremento;		
	m_vector_vista.m_x += vector_temp.m_x * incremento;			
	m_vector_vista.m_z += vector_temp.m_z * incremento;			
}

void COGLCamara::RotaSobreEje(float angulo, float x, float y, float z)
{
	COGLVector3d vector_nueva_vista;

	//Conseguimos el vector de vista, la direccion a donde estamos mirando
	COGLVector3d vector_vista = m_vector_vista - m_vector_posicion;		

	//Calculamos el seno y el coseno del angulo una vez
	float cosTheta = (float)cos(angulo);
	float sinTheta = (float)sin(angulo);

	//Encontramos la nueva posicion X para el nuevo punto rotado
	vector_nueva_vista.m_x  = (cosTheta + (1 - cosTheta) * x * x)		* vector_vista.m_x;
	vector_nueva_vista.m_x += ((1 - cosTheta) * x * y - z * sinTheta)	* vector_vista.m_y;
	vector_nueva_vista.m_x += ((1 - cosTheta) * x * z + y * sinTheta)	* vector_vista.m_z;

	//Encontramos la nueva posicion Y para el nuevo punto rotado
	vector_nueva_vista.m_y  = ((1 - cosTheta) * x * y + z * sinTheta)	* vector_vista.m_x;
	vector_nueva_vista.m_y += (cosTheta + (1 - cosTheta) * y * y)		* vector_vista.m_y;
	vector_nueva_vista.m_y += ((1 - cosTheta) * y * z - x * sinTheta)	* vector_vista.m_z;

	//Encontramos la nueva posicion Z para el nuevo punto rotado
	vector_nueva_vista.m_z  = ((1 - cosTheta) * x * z - y * sinTheta)	* vector_vista.m_x;
	vector_nueva_vista.m_z += ((1 - cosTheta) * y * z + x * sinTheta)	* vector_vista.m_y;
	vector_nueva_vista.m_z += (cosTheta + (1 - cosTheta) * z * z)		* vector_vista.m_z;

	//Ahora solo aadimos el nuevo vector rotado a nuestra posicion para poner nuestra
	//nueva vista rotada de la camara
	m_vector_vista = m_vector_posicion + vector_nueva_vista;
}

void COGLCamara::RotaAlrededor(COGLVector3d vector_centro, float angulo, float x, float y, float z)
{
	COGLVector3d vector_nueva_posicion;			

	// Para rotar nuestra posicin alrededor de un punto, primero necesitamos
	// encontrar nuestra posicion alrededor del punto, o sea, encontrar el vector
	// desde nuestra posicion al punto sobre el que rotaremos.
	// Una vez conseguimos este vector, lo rotaremos sobre el eje de coordenadas
	// especificado con unos determinados grados(angulo). Al final, tenemos que sumar
	// el nuevo vector al punto sobre el que estamos rotando para obtener la nueva posicion

	
	// 1Conseguimos el vector desde nuestra posicin hasta el punto sobre el que rotaremos
	COGLVector3d vector_posicion = m_vector_posicion - vector_centro;

	// 2Calculamos el seno y el coseno del angulo
	float cosTheta = (float)cos(angulo);
	float sinTheta = (float)sin(angulo);

	// 3Encontramos la nueva posicion del punto rotado matemticas puras y duras :'(
	
	// Primero con x 
	vector_nueva_posicion.m_x  = (cosTheta + (1 - cosTheta) * x * x)		* vector_posicion.m_x;
	vector_nueva_posicion.m_x += ((1 - cosTheta) * x * y - z * sinTheta)	* vector_posicion.m_y;
	vector_nueva_posicion.m_x += ((1 - cosTheta) * x * z + y * sinTheta)	* vector_posicion.m_z;

	// Luego con y :)
	vector_nueva_posicion.m_y  = ((1 - cosTheta) * x * y + z * sinTheta)	* vector_posicion.m_x;
	vector_nueva_posicion.m_y += (cosTheta + (1 - cosTheta) * y * y)		* vector_posicion.m_y;
	vector_nueva_posicion.m_y += ((1 - cosTheta) * y * z - x * sinTheta)	* vector_posicion.m_z;

	// Por ltimo z, de zorro :p
	vector_nueva_posicion.m_z  = ((1 - cosTheta) * x * z - y * sinTheta)	* vector_posicion.m_x;
	vector_nueva_posicion.m_z += ((1 - cosTheta) * y * z + x * sinTheta)	* vector_posicion.m_y;
	vector_nueva_posicion.m_z += (cosTheta + (1 - cosTheta) * z * z)		* vector_posicion.m_z;

	// 4Ahora aadimos el nuevo vector rotado a nuestra posicion
	// y colocamos nuestro nueva posicion rotada de nuestra cmara
	m_vector_posicion = vector_centro + vector_nueva_posicion;
}

void COGLCamara::StrafeaCamara(float velocidad)
{
	//Aadimos el vector de strafear al vector de posicion
	m_vector_posicion.m_x+=m_vector_strafing.m_x*velocidad;
	m_vector_posicion.m_z+=m_vector_strafing.m_z*velocidad;
	
	m_vector_vista.m_x+=m_vector_strafing.m_x*velocidad;
	m_vector_vista.m_z+=m_vector_strafing.m_z*velocidad;
}

void COGLCamara::Actualiza() 
{
	COGLVector3d vector_perpendicular=ProductoVectorial(m_vector_vista-m_vector_posicion,m_vector_up);
	
	m_vector_strafing=NormalizarVector3d(vector_perpendicular);
}

bool COGLCamara::ColisionTriangulo(COGLVector3d *triangulo )
{
	return ColisionEsferaPoligono( triangulo, m_vector_posicion,3,m_Radio);
}


//Devuelve verdadero si el bounding sphere de la cmara intersecciona con un cubo
//usa el algoritmo de Alvo
bool COGLCamara::ColisionCubo(float x, float y, float z, float lado)
{
	float distance =0.0f, d;

	// X
	d = (x + lado);
	if( m_vector_posicion.m_x > d )
	{
		d = m_vector_posicion.m_x - d;
		distance += d * d;

	}
	else
	{
		d = (x - lado);
		if( m_vector_posicion.m_x < d )
		{
			d = d - m_vector_posicion.m_x;
			distance += d * d;

		}
	}

	// Y
	d = (y + lado);
	if( m_vector_posicion.m_y > d )
	{
		d = m_vector_posicion.m_y - d;
		distance += d * d;

	}
	else
	{
		d = (y - lado);
		if( m_vector_posicion.m_y < d )
		{
			d = d - m_vector_posicion.m_y;
			distance += d * d;

		}
	}

	// Z
	d = (z + lado);
	if( m_vector_posicion.m_z > d )
	{
		d = m_vector_posicion.m_z - d;
		distance += d * d;

	}
	else
	{
		d = (z - lado);
		if( m_vector_posicion.m_z < d )
		{
			d = d - m_vector_posicion.m_z;
			distance += d * d;

		}
	}

	return distance <= ( m_Radio * m_Radio );
}

void COGLCamara::DibujaBoundingSphere()
{
	GLUquadricObj *esfera=gluNewQuadric();
		
	gluQuadricOrientation(esfera,GLU_INSIDE);

	glPushMatrix();
	{
		glTranslatef(m_vector_posicion.m_x,m_vector_posicion.m_y,m_vector_posicion.m_z);

		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA,GL_ONE);

		glColor4f(0.5f,0.5f,1.0f,0.4f);
		gluSphere(esfera,m_Radio,12,12);

		glDisable(GL_BLEND);
	}
	glPopMatrix();
	
	gluDeleteQuadric(esfera);		
}

void COGLCamara::ChequeaColisionCamara(COGLVector3d *pVertices, int numOfVerts)
{	
	// This function is pretty much a direct rip off of SpherePolygonCollision()
	// We needed to tweak it a bit though, to handle the collision detection once 
	// it was found, along with checking every triangle in the list if we collided.  
	// pVertices is the world data. If we have space partitioning, we would pass in 
	// the vertices that were closest to the camera. What happens in this function 
	// is that we go through every triangle in the list and check if the camera's 
	// sphere collided with it.  If it did, we don't stop there.  We can have 
	// multiple collisions so it's important to check them all.  One a collision 
	// is found, we calculate the offset to move the sphere off of the collided plane.

	// Go through all the triangles
	for(int i = 0; i < numOfVerts; i += 3)
	{
		// Store of the current triangle we testing
		COGLVector3d vTriangle[3] = { pVertices[i], pVertices[i+1], pVertices[i+2] };

		// 1) STEP ONE - Finding the sphere's classification
	
		// We want the normal to the current polygon being checked
		COGLVector3d vNormal = Normalizar(vTriangle);

		// This will store the distance our sphere is from the plane
		float distance = 0.0f;

		// This is where we determine if the sphere is in FRONT, BEHIND, or INTERSECTS the plane
		int classification = ClasificacionEsfera(m_vector_posicion, vNormal, vTriangle[0], m_Radio, distance);

		// If the sphere intersects the polygon's plane, then we need to check further
		if(classification == INTERSECCION) 
		{
			// 2) STEP TWO - Finding the psuedo intersection point on the plane

			// Now we want to project the sphere's center onto the triangle's plane
			COGLVector3d vOffset = vNormal * distance;

			// Once we have the offset to the plane, we just subtract it from the center
			// of the sphere.  "vIntersection" is now a point that lies on the plane of the triangle.
			COGLVector3d vIntersection = m_vector_posicion - vOffset;

			// 3) STEP THREE - Check if the intersection point is inside the triangles perimeter

			// We first check if our intersection point is inside the triangle, if not,
			// the algorithm goes to step 4 where we check the sphere again the polygon's edges.

			// We do one thing different in the parameters for EdgeSphereCollision though.
			// Since we have a bulky sphere for our camera, it makes it so that we have to 
			// go an extra distance to pass around a corner. This is because the edges of 
			// the polygons are colliding with our peripheral view (the sides of the sphere).  
			// So it looks likes we should be able to go forward, but we are stuck and considered 
			// to be colliding.  To fix this, we just pass in the radius / 2.  Remember, this
			// is only for the check of the polygon's edges.  It just makes it look a bit more
			// realistic when colliding around corners.  Ideally, if we were using bounding box 
			// collision, cylinder or ellipses, this wouldn't really be a problem.

			if(DentroPoligono(vIntersection, vTriangle, 3) ||
			   EdgeSphereCollision(m_vector_posicion, vTriangle, 3, m_Radio / 2))
			{
				// If we get here, we have collided!  To handle the collision detection
				// all it takes is to find how far we need to push the sphere back.
				// GetCollisionOffset() returns us that offset according to the normal,
				// radius, and current distance the center of the sphere is from the plane.
				vOffset = ConsigueDesplazamientoColision(vNormal, m_Radio, distance);

				// Now that we have the offset, we want to ADD it to the position and
				// view vector in our camera.  This pushes us back off of the plane.  We
				// don't see this happening because we check collision before we render
				// the scene.
				m_vector_posicion = m_vector_posicion + vOffset;
				m_vector_vista = m_vector_vista + vOffset;
			}
		}
	}
}