//
// Cthugha - Audio Seeded Image Processing
//
// Zaph, Digital Aasvogel Group, Torps Productions 1993-1994
//


#include <stdio.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <stdlib.h>
#include <math.h>
#include <conio.h>
#include <bios.h>
#include <memory.h>
#include <assert.h>

#include "cthugha.h"
#include "charset.h"
#include "zorilkey.h"
#include "audio.h"
#include "translat.h"

#define NUMSTRINGS 20

char stringtable[NUMSTRINGS][21]={
//	"---------|---------"
	" Wheres the music? ",
	"       JOLT !      ",
	"      Hey, You!!   ",
	" Turn The Music On ",
	"    Lets Party!!!  ",
	" Pink Floyd Rules  ",
	"Sounds of Silence ?",
	"     The Torps     ",
	"     Play DOOM     ",
	"     Drink COKE    ",
	"     Hello ??      ",
	"Number 5 is ALIVE!!",
	"Spooky....         ",
	"Wheres Cthugha 6.0?",
	"   Subliminal Ads  ",
	"Read a book        ",
	"     Get a life....",
	"      SMILE!       ",
	"    Cthugha 5.0    ",
	" Torps Productions "
};


extern int peaks,peakframes,peaknoise;
extern int massage_audio(void);
extern int allow_fft,use_fft;

void (*flame)(void);

static void flame_upslow(void);
static void flame_upsubtle(void);
static void flame_upfast(void);
static void flame_leftslow(void);
static void flame_leftsubtle(void);
static void flame_leftfast(void);
static void flame_rightslow(void);
static void flame_rightsubtle(void);
static void flame_rightfast(void);
static void flame_water(void);
static void flame_watersubtle(void);
static void flame_skyline(void);
static void flame_weird(void);

int numflames=-1;
void (*flamearray[])(void)={
	flame_leftslow,
	flame_leftsubtle,
	flame_leftfast,
	flame_upslow,
	flame_upsubtle,
	flame_upfast,
	flame_rightslow,
	flame_rightsubtle,
	flame_rightfast,
	flame_water,
	flame_watersubtle,
	flame_skyline,
	flame_weird,
	NULL
};
// Change the flame function pointer...

int change_flame(int flamenum)
{

	if (numflames<0) {
		numflames=0;
		while (flamearray[numflames]!=NULL)
			numflames++;
		assert(numflames);
	}

	flamenum=flamenum%numflames;
	flame=flamearray[flamenum];

	return flamenum;
}

// The flame main loop
// Runs the flame, 
// Gets the stereo, 
// produces the wave
// and then displays it...

extern int was_quiet;
extern void wave(void);

extern int time_to_change;

extern void display_up(void);
extern void display_dn(void);
extern void draw_text(int xpos, int ypos, int size, int colour, char *tbuf);
extern int quiet_change;
void flame_cro(void)
{
	int count,temp;
	static quiet=0,showstring=0;
	static linenum=42;

	count=rand()%rand_time+min_time;

//	memset(buff[BUFF_BOTTOM+1],0,BUFF_WIDTH*2);

	for (temp=0; temp<BUFF_WIDTH; temp++) {
		buff[BUFF_BOTTOM][temp]=0;
		buff[BUFF_BOTTOM+1][temp]=0;
		buff[BUFF_BOTTOM+2][temp]=0;
		buff[BUFF_BOTTOM+3][temp]=0;
	}

	while ((_bios_keybrd(_KEYBRD_READY)==0) && (count>0)) {
		count--;

		flame();

//		draw_text(0,0,1,0,"Cthugha V5.0");
//		draw_text(1,1,1,255,"Cthugha V5.0");

		if (translate)
			translate_screen();

		if (get_stereo()) {
			if (massageStyle)
				massage_audio();
			if (allow_fft && use_fft) {
				FFT(0);
				FFT(1);
			}
			wave();
			if (quiet_change)
				if (quiet>quiet_change) {
					was_quiet=1;
					quiet=0;
				} else {  // We *HAD* silence, but now its noisy again!!
					if (was_quiet) {
						was_quiet=0;
						count=0;
					}
				}
			if (peakframes>0) {
				if (peaknoise) {
					peaks++;
					if (peaks>peakframes) {
						peaks=0;
						time_to_change=1;
						count=0;
					}
				}

			}
		} else {
			quiet++;
			if (quiet>255) {
				draw_text(0,linenum,2,table[curtable][0],stringtable[showstring]);
				draw_text(1,linenum+1,2,table[curtable][quiet-255],stringtable[showstring]);
				if (quiet>512) {
					quiet=0;
					showstring=rand()%NUMSTRINGS;
					linenum=rand()%80;
				}
			}
		}

		switch (curdisplay) {
			case 0:
			default:
				display_up();
				break;
			case 1:
				display_dn();
				break;
		}

	}

}

// Standard flame (upwards)
static void flame_upslow(void)
{
		_asm {
			pusha;

			mov cx,64636;
			mov dx,SEG buff;
			mov es,dx;
			mov dx,OFFSET buff;
			mov di,BUFF_WIDTH;
			}
jp11:    _asm {
			xor ax,ax;
			xor bx,bx;
			mov al,es:[di-1];
			mov bl,es:[di];
			add ax,bx;
			mov bl,es:[di+1];
			add ax,bx;
			mov bl,es:[di+BUFF_WIDTH];
			add ax,bx;
			shr ax,2;
			jz jp12;
			dec ax;
			}
jp12:    _asm {
			mov byte ptr es:[di-BUFF_WIDTH],al;
			inc di;
			loop jp11;

			popa;
		}
}

static void flame_upsubtle(void)
{
		_asm {
			pusha;

			mov cx,64636;
			mov dx,SEG buff;
			mov es,dx;
			mov dx,OFFSET buff;
			mov di,BUFF_WIDTH;
			}
jp11:    _asm {
			xor ax,ax;
			mov al,es:[di-1];
			add al,es:[di];
			add al,es:[di+1];
			add al,es:[di+BUFF_WIDTH];
			shr ax,2;
			jz jp12;
			dec ax;
			}
jp12:    _asm {
			mov byte ptr es:[di-BUFF_WIDTH],al;
			inc di;
			loop jp11;

			popa;
		}
}
// Flame left
static void flame_leftslow(void)
{
		_asm {
			pusha;

			mov cx,64636;
			mov dx,SEG buff;
			mov es,dx;
			mov dx,OFFSET buff;
			mov di,BUFF_WIDTH;
			}
jp21:    _asm {
			xor ax,ax;
			xor bx,bx;
			mov al,es:[di-(BUFF_WIDTH-1)];
			mov bl,es:[di];
			add ax,bx;
			mov bl,es:[di+1];
			add ax,bx;
			mov bl,es:[di+BUFF_WIDTH];
			add ax,bx;
			shr ax,2;
			jz jp22;
			dec ax;
			}
jp22:    _asm {
			mov byte ptr es:[di-BUFF_WIDTH],al;
			inc di;
			loop jp21;

			popa;

	}
}

// Flame right
static void flame_rightslow(void)
{
		_asm {
			pusha;

			mov cx,64636;
			mov dx,SEG buff;
			mov es,dx;
			mov dx,OFFSET buff;
			mov di,BUFF_WIDTH+1;
			}
jp31:    _asm {
			xor ax,ax;
			xor bx,bx;
			mov al,es:[di-(BUFF_WIDTH+1)];
			mov bl,es:[di];
			add ax,bx;
			mov bl,es:[di-1];
			add ax,bx;
			mov bl,es:[di+BUFF_WIDTH];
			add ax,bx;
			shr ax,2;
			jz jp32;
			dec ax;
			}
jp32:		_asm {
			mov byte ptr es:[di-BUFF_WIDTH],al;
			inc di;
			loop jp31;

			popa;

	}
}

// Flame over water effect
static void flame_water(void)
{
		_asm {
			pusha;

			mov cx,32318+BUFF_WIDTH;
			mov dx,SEG buff;
			mov es,dx;
			mov dx,OFFSET buff;
			mov di,BUFF_WIDTH;
			}
jp41:    _asm {
			xor ax,ax;
			xor bx,bx;
			mov al,es:[di-1];
			mov bl,es:[di];
			add ax,bx;
			mov bl,es:[di+1];
			add ax,bx;
			mov bl,es:[di+BUFF_WIDTH];
			add ax,bx;
			}
jp42b: 	_asm {
			shr ax,2;
			jz jp42;
			dec ax;
			}
jp42:    _asm {
			mov byte ptr es:[di-BUFF_WIDTH],al;
			inc di;
			loop jp41;

			popa;
	}
		_asm {
			pusha;

			mov cx,32318;
			mov dx,SEG buff;
			mov es,dx;
			mov dx,OFFSET buff;
//			mov di,64636;
			mov di,64320;
			}

jpz41:   _asm {
			xor ax,ax;
			xor bx,bx;
			mov al,es:[di-(BUFF_WIDTH-1)];
			mov bl,es:[di];
			add ax,bx;
			mov bl,es:[di+1];
			add ax,bx;
			mov bl,es:[di-BUFF_WIDTH];
			add ax,bx;
			shr ax,2;
//			jz jpz42;
//			dec ax;
			}
jpz42:	_asm {
			mov byte ptr es:[di+BUFF_WIDTH],al;
			dec di;
			loop jpz41;

			popa;
	}
}



static void flame_skyline(void)
{
		_asm {
			pusha;

			mov cx,64636;
			mov dx,SEG buff;
			mov es,dx;
			mov dx,OFFSET buff;
			mov di,BUFF_WIDTH;
			}
jp11:    _asm {
			xor ax,ax;
			xor bx,bx;
			mov al,es:[di-1];
			mov bl,es:[di];
			add ax,bx;
			mov bl,es:[di+1];
			add ax,bx;
//			mov bl,es:[di+BUFF_WIDTH];
			mov bl,es:[di];
			add ax,bx;

			jz jp12;
			dec ax;

			shr ax,2;

			}
jp12:    _asm {
			mov byte ptr es:[di-BUFF_WIDTH],al;
			inc di;
			loop jp11;

			popa;

		}
}

static void flame_upfast(void)
{
		_asm {
			pusha;

//			mov cx,16159;
//			mov cx,64636;
			mov cx,64000+BUFF_WIDTH;
			mov dx,SEG buff;
			mov es,dx;
			mov dx,OFFSET buff;
//			mov di,BUFF_WIDTH;
			mov di,64000+BUFF_WIDTH;
			}
jp11:    _asm {
			xor ax,ax;
			xor bx,bx;
			mov al,es:[di];
			mov bl,es:[di+BUFF_WIDTH-1];
			add ax,bx;
			mov bl,es:[di+BUFF_WIDTH+1];
			add ax,bx;
			mov bl,es:[di+BUFF_WIDTH];
			add ax,bx;
			shr ax,2;
			jz jp12;
			dec ax;
			}
jp12:    _asm {
			mov byte ptr es:[di],al;
//			inc di;
			dec di;
			loop jp11;

			popa;
		}
}



// long flame (with triangle artifacts)
static void flame_leftfast(void)
{
		_asm {

			pusha;

//			mov cx,16159;
//			mov cx,64636;
			mov cx,64000+BUFF_WIDTH;
			mov dx,SEG buff;
			mov es,dx;
			mov dx,OFFSET buff;
//			mov di,BUFF_WIDTH;
			mov di,64000+BUFF_WIDTH;
			}
jp11:    _asm {
			xor ax,ax;
			xor bx,bx;
			mov al,es:[di];
			mov bl,es:[di+BUFF_WIDTH+1];
			add ax,bx;
			mov bl,es:[di+BUFF_WIDTH+1];
			add ax,bx;
			mov bl,es:[di+BUFF_WIDTH];
			add ax,bx;
			shr ax,2;
			jz jp12;
			dec ax;
			}
jp12:    _asm {
			mov byte ptr es:[di],al;
//			inc di;
			dec di;
			loop jp11;

			popa;
		}
}

// long flame (with triangle artifacts)
static void flame_rightfast(void)
{
		_asm {

			pusha;

//			mov cx,16159;
//			mov cx,64636;
			mov cx,64000+BUFF_WIDTH;
			mov dx,SEG buff;
			mov es,dx;
			mov dx,OFFSET buff;
//			mov di,BUFF_WIDTH;
			mov di,64000+BUFF_WIDTH;
			}
jp11:    _asm {
			xor ax,ax;
			xor bx,bx;
			mov al,es:[di];
			mov bl,es:[di+BUFF_WIDTH-1];
			add ax,bx;
			mov bl,es:[di+BUFF_WIDTH-1];
			add ax,bx;
			mov bl,es:[di+BUFF_WIDTH];
			add ax,bx;
			shr ax,2;
			jz jp12;
			dec ax;
			}
jp12:    _asm {
			mov byte ptr es:[di],al;
//			inc di;
			dec di;
			loop jp11;

			popa;
		}
}




static void flame_leftsubtle(void)
{
		_asm {
			pusha;

			mov cx,64636;
			mov dx,SEG buff;
			mov es,dx;
			mov dx,OFFSET buff;
			mov di,BUFF_WIDTH;
			}
jp21:    _asm {
			xor ax,ax;
			mov al,es:[di-(BUFF_WIDTH-1)];
			add al,es:[di];
			add al,es:[di+1];
			add al,es:[di+BUFF_WIDTH];
			shr ax,2;
			jz jp22;
			dec ax;
			}
jp22:    _asm {
			mov byte ptr es:[di-BUFF_WIDTH],al;
			inc di;
//			stosb;
			loop jp21;

			popa;

	}
}

// Flame right
static void flame_rightsubtle(void)
{
		_asm {
			pusha;

			mov cx,64636;
			mov dx,SEG buff;
			mov es,dx;
			mov dx,OFFSET buff;
			mov di,BUFF_WIDTH+1;
			}
jp31:    _asm {
			xor ax,ax;
			add al,es:[di-(BUFF_WIDTH+1)];
			add al,es:[di];
			add al,es:[di-1];
			add al,es:[di+BUFF_WIDTH];
			shr ax,2;
			jz jp32;
			dec ax;
			}
jp32:		_asm {
			mov byte ptr es:[di-BUFF_WIDTH],al;
			inc di;
			loop jp31;

			popa;

	}
}

// Flame over water effect
static void flame_watersubtle(void)
{
		_asm {
			pusha;

			mov cx,32318+BUFF_WIDTH;
			mov dx,SEG buff;
			mov es,dx;
			mov dx,OFFSET buff;
			mov di,BUFF_WIDTH;
			}
jp41:    _asm {
			xor ax,ax;
			mov al,es:[di-1];
			add al,es:[di];
			add al,es:[di+1];
			add al,es:[di+BUFF_WIDTH];
			}
jp42b: 	_asm {
			shr ax,2;
			jz jp42;
			dec ax;
			}
jp42:    _asm {
			mov byte ptr es:[di-BUFF_WIDTH],al;
			inc di;
			loop jp41;

			popa;
	}
		_asm {
			pusha;

			mov cx,32318;
			mov dx,SEG buff;
			mov es,dx;
			mov dx,OFFSET buff;
			mov di,64636;
			}

jpz41:   _asm {
			xor ax,ax;
			mov al,es:[di-(BUFF_WIDTH-1)];
			add al,es:[di];
			add al,es:[di+1];
			add al,es:[di-BUFF_WIDTH];
			shr ax,2;
//			jz jpz42;
//			dec ax;
			}
jpz42:	_asm {
			mov byte ptr es:[di+BUFF_WIDTH],al;
			dec di;
			loop jpz41;

			popa;
	}
}


static void flame_weird(void)
{
		_asm {
			pusha;

			mov cx,64636;
			mov dx,SEG buff;
			mov es,dx;
			mov dx,OFFSET buff;
			mov di,BUFF_WIDTH;
			}
jp11:    _asm {
			xor ax,ax;
			mov al,es:[di];
			or al,es:[di-1];
			or al,es:[di+1];
			or al,es:[di+BUFF_WIDTH];

//			shr ax,2;

			jz jp12;
			dec ax;

			}
jp12:    _asm {
			mov byte ptr es:[di-BUFF_WIDTH],al;
			inc di;
			loop jp11;

			popa;

		}
}


