//
// HLOWorld II
//

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <string.h>
#include "bdl.h"
#include "trsload.h"
#include "structs.h"
#include "objhandl.h"
#include "worldmat.h"
#include "draw.h"
#include "clip.h"
#include "order.h"
#include "bmpload.h"
#include "animsyst.h"
#include "midasdll.h"

#define release


struct timerec {
    float fps;
    float anz;
    float highfps;
    float lowfps;
};

extern short rtab[256];
extern short gtab[256];
extern short btab[256];
extern int   waterfl;
extern volatile unsigned framecount;
extern float bugxref;


struct scene worlds[4];
struct scene *world = NULL;
int           worldnr;

ulong             time1=0,time2,timecnt;
float             tfps = 30.0f;
BitMapStruct     *bms;
char             *moduleName = "bugxthem.xm";
float timecounterwait = 0;              // General timecounter
float timecounterani  = 0;              // Timecounter animation
float creditscounter  = 0;
int   modus;
int running=1;
int scenecount = 0;
float SPEEDFACTOR = 2.0f;
int     credits;
short    *credptr[4];
int     crednr = 0;



int                     aktsample=0;
MIDASsample             effects[3] ;
DWORD                   effchannel;
MIDASsamplePlayHandle   effhandle;


extern short rtab[256];
extern short gtab[256];
extern short btab[256];


struct timevalues timev;
struct object *obj;
struct timerec timerecord;

//----------------------------------------------------------------------------

void LoadScene(int nr)
{
    char    name[64];
    char    x[2];

    x[0] = nr + '0';
    x[1] = 0;
    strcpy((char*)name, "szene");
    strcat((char*)name, (char*)x);
    strcat((char*)name, ".trs");

    if (! TrsLoadFile((char*)name,&(worlds[nr])) )
    {
        BugxCleanup();
        printf("ScriptError:\n%s",trserrstr);
        return;
    }

    strcpy((char*)name, "szene");
    strcat((char*)name, (char*)x);
    strcat((char*)name, ".ani");

    if (! LoadAnimFile((char*)name,&(worlds[nr].anim)) )
    {
        BugxCleanup();
        printf("\nLoadAnimFile failed.\n");
        return;
    }

}



void LoadSamples(void)
{
    effects[1] = MIDASloadRawSample("sample1.raw",
                                  MIDAS_SAMPLE_16BIT_MONO,MIDAS_LOOP_NO);
    if (effects[1] == NULL)
        MIDASerror();

    effects[2] = MIDASloadRawSample("sample2.raw",
                                  MIDAS_SAMPLE_16BIT_MONO,MIDAS_LOOP_NO);
    if (effects[2] == NULL)
        MIDASerror();

    effects[3] = MIDASloadRawSample("sample3.raw",
                                  MIDAS_SAMPLE_16BIT_MONO,MIDAS_LOOP_NO);
    if (effects[3] == NULL)
        MIDASerror();
}



void LoadPic(void)
{
    FILE    *raw;
    int     r,g,b;
    int     i;
    char    *src;
    char    *src2;
    char    *src3;
    char    *src4;
    short   *dest;


    credptr[0] = (short*) malloc( 400*300*3);
    dest = credptr[0];

    src = (char*) malloc (400*300*3);
    src2 = src;

    raw = fopen("credits1.raw","rb");
    if (!raw)
    {
        BugxCleanup();
        printf("Failed to load picture Credits1.raw \n");
        return;
    }
    fread(src, 1, 400*300*3, raw);
    fclose(raw);


    for (i=0; i<(400*300) ;i++)
    {
        r = *src++;
        g = *src++;
        b = *src++;
        *dest++ = rtab[r] | gtab[g] | btab[b];
    }

    free(src2);


    credptr[1] = (short*) malloc(400*300*3);
    dest = credptr[1];

    src = (char*) malloc (400*300*3);
    src2 = src;


    raw = fopen("credits2.raw","rb");
    if (!raw)
    {
        BugxCleanup();
        printf("Failed to load picture Credits2.raw\n");
        return;
    }
    fread(src, 1, 400*300*3, raw);
    fclose(raw);


    for (i=0; i<(400*300) ;i++)
    {
        r = *src++;
        g = *src++;
        b = *src++;
        *dest++ = rtab[r] | gtab[g] | btab[b];
    }
    free(src2);


    credptr[2] = (short*) malloc(400*300*3);
    dest = credptr[2];

    src = (char*) malloc (400*300*3);
    src3 = src;


    raw = fopen("credits3.raw","rb");
    if (!raw)
    {
        BugxCleanup();
        printf("Failed to load picture Credits3.raw\n");
        return;
    }
    fread(src, 1, 400*300*3, raw);
    fclose(raw);


    for (i=0; i<(400*300) ;i++)
    {
        r = *src++;
        g = *src++;
        b = *src++;
        *dest++ = rtab[r] | gtab[g] | btab[b];
    }
    free(src3);


    credptr[3] = (short*) malloc(400*300*3);
    dest = credptr[3];

    src = (char*) malloc (400*300*3);
    src4 = src;


    raw = fopen("credits4.raw","rb");
    if (!raw)
    {
        BugxCleanup();
        printf("Failed to load picture Credits4.raw\n");
        return;
    }
    fread(src, 1, 400*300*3, raw);
    fclose(raw);


    for (i=0; i<(400*300) ;i++)
    {
        r = *src++;
        g = *src++;
        b = *src++;
        *dest++ = rtab[r] | gtab[g] | btab[b];
    }
    free(src4);

}


void ActivateScene(int nr)
{
    struct scene *oldworld = world;

    timecounterani  = 0;
    framecount      = 0;
    timecounterwait = 0;
    world   = &worlds[nr];
    worldnr = nr;
    if (oldworld)
    {
        world->camposx = oldworld->camposx;
        world->camposy = oldworld->camposy;
        world->camposz = oldworld->camposz;
        world->camrotx = oldworld->camrotx;
        world->camroty = oldworld->camroty;
        world->camrotz = oldworld->camrotz;
    }

    switch (nr)
    {
        case 0: SetBackground(0, 0, 0);
                waterfl=0;
                break;
        case 1:
        case 2: //SetBackground(47, 121, 197);
                //SetBackground(30, 109, 255);
                SetBackground(68, 134, 255);
                waterfl=1;
                SPEEDFACTOR = 3.4;
                break;
    }

}


//----------------------------------------------------------------------------


void SetBackground(int r, int g, int b)
{
    unsigned int x;
    x = (rtab[r] | gtab[g] | btab[b]);
    FillColor = (x<<16) | (x&0xffff);
}


void WaitVBE(void)
{
    _ASMVWait();
    timecounterwait ++;
    if (timecounterwait >= 0)
    {
        modus = 1;                  // Let's go on!
    }

}


void PlayAnim(int nr)
{
        struct scene *world;
        float         value;
        int           value2;

        world = &(worlds[nr]);
        timev = AnimValues(&(world->anim),timecounterani);

        world->camposx = timev.camposx;
        world->camposy = timev.camposy;
        world->camposz = timev.camposz;
        world->camrotx = timev.camrotx;
        world->camroty = timev.camroty;
        world->camrotz = timev.camrotz;

        value = timev.diverses;
        value2 = (int)value;

        if (value2 != aktsample)
        {
            if (value2 !=0)
            {
                effhandle = MIDASplaySample(effects[1], MIDAS_CHANNEL_AUTO,
                                            200, 22000, 64,
                                            MIDAS_PAN_MIDDLE);
            if (effhandle == NULL)
                MIDASerror();
            }

            aktsample = value2;
        }


        obj = world->first;
        while (obj)
        {
            if  (obj->animated)
            {

                timev = AnimValues(&(obj->movement),timecounterani);

                obj->posx = timev.camposx;
                obj->posy = timev.camposy;
                obj->posz = timev.camposz;
                obj->rotx = timev.camrotx;
                obj->roty = timev.camroty;
                obj->rotz = timev.camrotz;
                if (obj->anzframe > 0)
                    SetObjFrame(obj,timev.diverses);
            }
            obj = obj->next;
        }


        //timecounterani += (30 / tfps) * SPEEDFACTOR;


        timecounterani = (framecount* (30.0/bugxref))* SPEEDFACTOR;


        switch (scenecount)
        {
        case 0:     if (timecounterani >= 1120)  //1150
                    {
                        modus = 2;
                        credits=1;
                        scenecount++;
                    }
                    break;

        case 1:     if (timecounterani >= 2800)
                    {
                        modus = 2;
                        credits = 2;
                        scenecount++;
                    }
                    break;

        case 2:     if (timecounterani >= 4774)
                    {
                        ActivateScene(2);
                        scenecount++;
                    }
                    break;

        case 3:     if (timecounterani >= 1440)
                    {
                        modus = 2;
                        credits = 3;
                        scenecount++;
                    }
                    break;

        case 4:     if (timecounterani >= 2016)
                    {
                        ActivateScene(3);
                        scenecount++;
                    }
                    break;

        case 5:     if (timecounterani >= 6000)
                    {
                        modus = 2;
                        credits = 4;
                        scenecount++;
                    }
                    break;

        }
}




void Credits(void)
{
    char    *src,*dst;
    int     i;
    int     cx,cy;

    if (creditscounter == 0)
    {
        creditscounter = framecount;
    }

    if ((framecount-creditscounter) <= (217 * (30.0/bugxref)))
    {
       cx = (xsize - 400) >> 1;
       cy = (ysize - 300) >> 1;

       memset(cframe, 0, xsize*ysize*2);
       src = (char*) credptr[crednr];
       dst = cframe + (cy*xsize + cx)*2;
       for (i=0; i<300; i++, src+=400*2, dst+=xsize*2)
            memcpy(dst, src, 400*2);

       DoBufferBlit(FALSE);

       if (credits==4) creditscounter = framecount;
    }
    else
    {
        framecount = creditscounter;
        creditscounter = 0;
        modus = 1;

        crednr++;
        if (credits == 1)
        {

            ActivateScene(1);
        }


    }

}



void main(int argc, char *argv[])
{
    int p=1;
    int m=-1;
    timerecord.fps = 0;
    timerecord.anz = 0;
    timerecord.lowfps = 1000;
    timerecord.highfps = 0;

    if (argc>1)
    {
        sscanf(argv[1],"%d",&m);
        if (m>-1) {
        argc--;
        p++;
        }
        if (m<18) m=-1;
    }
    AnalyseParas(argc-1,&argv[p]);
    if (m<0) m=BugxModeCode(400,300,16);            //PRESET: Grafikmodus
    BugxInit(bugxusetup,m);
    centerx = xsize * 0.5;
    centery = ysize * 0.5;
    persp   = PERSPEKTIVE * (xsize / 400.0);

    BugxBottomPrint("");
    if (bugxnosound) BugxBottomPrint("MIDAS disabled");
                else BugxBottomPrint("MIDAS initialized");
    if (bugxmouse)   BugxBottomPrint("Mousedriver found and activated");
                else BugxBottomPrint("Mouse disabled");
    BugxBottomPrint(vesastring);
    BugxBottomPrint("Display resolution: ");
    BugxPrintNumber(xsize,10);
    BugxPrintString(".");
    BugxPrintNumber(ysize,10);
    if (gfxmode<16) BugxPrintString(".8");
               else BugxPrintString(".16");
    BugxBottomPrint("Display refresh: ");
    BugxPrintString(bugxfreq);
    BugxBottomPrint(" ");
    BugxBottomPrint("Loading...");

    PrepareTex(32);     //WARNING: Memory reserved only for 32 textures.
    BugxBottomPrint(" scene 0");
    LoadScene(0);
    BugxBottomPrint(" scene 1");
    LoadScene(1);
    BugxBottomPrint(" scene 2");
    LoadScene(2);
    BugxBottomPrint(" scene 3");
    LoadScene(3);
    BugxBottomPrint(" pics");
    LoadPic();

    BugxSetColors();


    if (!MIDASopenChannels(14))
        MIDASerror();

    if (!(BugxLoadSong(moduleName))) MIDASerror();



    LoadSamples();



    CreateViewPyramid();

    timecnt = 100;                  //Init Timer (auerhalb der mainloop)
    time1=clock();
    time2=time1;


    ActivateScene(0);               //Start with.. h.. the start:-)
    modus = 1;                      // Play Animation


    if (!MIDASallocAutoEffectChannels(2))   // Effectchannel fr
         MIDASerror();                     // Soundeffekte



    BugxPlaySong();


    /*
    BugxGetMouse();
    while (bugxbutton != 1)
        BugxGetMouse();

      */
    //-----------------------------------------------------------------

    while (running)
    {
        BugxGetMouse();
        switch (bugxbutton)
        {
            case 1:
                    break;

            case 2: framecount+=30;
                    break;

            case 3: running=0;
                    break;
        }


        #ifndef release
        timecnt --;
        if (!timecnt)
        {
            timecnt= 50;

            time2=clock();
            if (time1!=0)
            {
                if ((time2-time1)!=0)
                    tfps=(CLOCKS_PER_SEC*timecnt) / (time2-time1);
            }

            time1=time2;
        }
        #endif



        switch (modus)
        {
            case 0: WaitVBE();
                    break;
            case 1: PlayAnim(worldnr);
                    DrawScene(world);
                    break;
            case 2: Credits();
                    break;
        }


        #ifndef release
        BugxSetCur(0,0);
        BugxPrintNumber((int)(framecount),10);
        BugxSetCur(0,15);
        BugxPrintNumber((int)(world->camposx),10);
        BugxSetCur(0,25);
        BugxPrintNumber((int)(world->camposy),10);
        BugxSetCur(0,35);
        BugxPrintNumber((int)(world->camposz),10);
        BugxSetCur(0,50);
        BugxPrintNumber((int)(timecounterani),10);
        #endif

        DoBufferBlit(modus==1);

        #ifndef release
        timerecord.fps += tfps;
        timerecord.anz ++;

        if (tfps < timerecord.lowfps)
            timerecord.lowfps = tfps;

        if (tfps > timerecord.highfps)
            timerecord.highfps = tfps;
        #endif
    }

//------------------------------------------------------------

    BugxStopSong();
    BugxCleanup();

    #ifndef release
    printf("Average FPS : %f \n",(timerecord.fps / timerecord.anz));
    printf("Lowest  FPS : %f \n", timerecord.lowfps);
    printf("Highest FPS : %f \n\n", timerecord.highfps);
    #endif
}
