;=============================================================================
; flag.asm - Runtime Flag Demostration.
;                                                   File created: 10-22-93
; Copyright (C) 1993, Carlos Hasan                 Last modified: 10-22-93
;
; Description:
;   This file implements a runtime flag movement using plasma like
;   sinus overlapping waves in the VGA 320x200x256 graphics mode.
;
; Portability:
;  Requires Turbo Assembler 3.2 or better to be assembler.
;  Dependent on the IBM PC 286 and the VGA graphics card.
;=============================================================================

                .model  small,pascal
                .286

                dosseg                          ; used to link like
                .stack  1024                    ; an standalone program.

                global  FlagDemo:proc

;======================= Demo equates and data ===============================

TIMEOUT         equ     70 * 8                  ; at least 8 secs.
BMPWIDTH        equ     160                     ; bitmap dimens.
BMPHEIGHT       equ     96
MAXWIDTH        equ     320                     ; screen dimens.
MAXHEIGHT       equ     200
XOFS            equ     80                      ; flag upper left
YOFS            equ     30                      ; corner coordinates.

                .data

; flag bitmap, palette and sinus wave tables.
; The bitmap is about 15K, but because it's highly compressed using
; any exepacker, it was included in the data segment avoiding the
; extra segment needed in the demo algorithms.

                include flagbmp.inc 

HWavPos         db      ?                       ; wave horiz and vert
VWavPos         db      ?                       ; positions.

FadePalette     db      768 dup (?)             ; faded palette.
Fade            db      ?                       ; fade level.
Esckey          db      ?                       ; true if key pressed.
Timer           dw      ?                       ; timer counter.

;======================= Demo routines =======================================

                .code

;-----------------------------------------------------------------------------
; WaitVRT - Waits the Vertical Retrace.
;-----------------------------------------------------------------------------

WaitVRT         proc near

                mov     dx,3DAh
WaitVR1:        in      al,dx
                test    al,8
                jne     WaitVR1
WaitVR2:        in      al,dx
                test    al,8
                je      WaitVR2
                ret

WaitVRT         endp

;-----------------------------------------------------------------------------
; SetPalette - set the CX entries of the VGA color palette.
; In:
;   DS:SI - Palette structure address.
;   CX    - Number of colors components.
;-----------------------------------------------------------------------------

SetPalette      proc near

                call    WaitVRT
                mov     dx,3C8h
                xor     al,al
                out     dx,al
                inc     dx
                rep     outsb
                ret

SetPalette      endp

;-----------------------------------------------------------------------------
; PutFlag - Writes the next Flag Frame to the Screen.
;-----------------------------------------------------------------------------

PutFlag         proc near

                mov     ax,0A000h
                mov     es,ax
                add     [HWavPos],4             ; Incr Wave Positions.
                add     [VWavPos],7
                mov     dh,[HWavPos]            ; k = hwavpos.
                mov     di,MAXWIDTH*YOFS+XOFS   ; p = screen offset.
                lea     si,[Piccy]              ; q = piccy offset.
                mov     cx,BMPWIDTH-16          ; for col=0 to W-16 do
                xor     bh,bh
ColLoop:        push    cx
                push    si
                push    di
                mov     bl,dh
                mov     dl,[VWave+bx]           ; x = vwave[k]
                mov     al,[HWave+bx]           ; h = (x+hwave[k])/2
                add     al,dl
                rcr     al,1
                mov     ah,BMPWIDTH             ; q= col+160*h
                mul     ah
                add     si,ax
                mov     ah,[VWavPos]            ; l = vwavpos
                mov     cx,BMPHEIGHT-16         ; for row=0 to H-16 do
RowLoop:        mov     bl,ah
                mov     bl,[VWave+bx]           ; v = (x+vwave[l])/2
                add     bl,dl
                rcr     bl,1
                mov     al,[si+bx]              ; al = pic[si+v]+vwave[k+v]
                add     bl,dh
                mov     bl,[VWave+bx]
                xor     bl,0Fh
                add     al,bl
                mov     es:[di],al              ; put pixel.
                add     di,MAXWIDTH             ; p= p+320
                add     si,BMPWIDTH             ; q= q+160
                inc     ah                      ; l= l+1
                loop    RowLoop
                pop     di
                pop     si
                pop     cx
                inc     dh                      ; k=k+1
                inc     si                      ; q=q+1
                inc     di                      ; p=p+1
                test    di,1                    ; if odd(p) p=p+320
                jne     ColBrk
                add     di,MAXWIDTH
ColBrk:         loop    ColLoop                 ; next col.
                ret

PutFlag         endp

;-----------------------------------------------------------------------------
; FlagDemo - Performs the demonstration.
; In:
;   DS - Data segment.
;-----------------------------------------------------------------------------

FlagDemo        proc

                pusha
                push    ds
                push    es

                mov     ax,0013h                ; set 320x200x256 mode.
                int     10h

                mov     [Fade],0                ; setup variables.
                mov     [EscKey],0
                mov     [Timer],0

                mov     [HWavPos],0
                mov     [VWavPos],0

FlagLoop:       cmp     [EscKey],0              ; change fade level.
                jne     FadeOut
FadeIn:         mov     bl,[Fade]
                cmp     bl,64
                jae     SkipFade
                inc     [Fade]
                jmp     FadeInOut
FadeOut:        mov     bl,[Fade]
                cmp     bl,0
                jbe     FadeInOut
                dec     [Fade]

FadeInOut:      lea     si,[Palette]            ; set faded palette.
                lea     di,[FadePalette]
                mov     cx,3*16*4
                mov     ax,ds
                mov     es,ax
                cld
FadeLoop:       lodsb
                mul     bl
                shr     ax,6
                stosb
                loop    FadeLoop

DoFade:         lea     si,[FadePalette]        ; ensures thats always
                mov     cx,3*16*4               ; waits the VR per frame.
                call    SetPalette
                jmp     DoFlag

SkipFade:       call    WaitVRT

DoFlag:         call    PutFlag                 ; put the flag.

                mov     ah,1                    ; if any key pressed,
                int     16h
                jz      CheckTimer
                mov     ah,0
                int     16h
                jmp     BeginFadeOut

CheckTimer:     inc     [Timer]                 ; or timeout,
                cmp     [Timer],TIMEOUT
                jb      CheckExit

BeginFadeOut:   inc     [EscKey]                ; then fade-out and exit.

CheckExit:      cmp     [Fade],0
                je      FlagExit
                jmp     FlagLoop

FlagExit:       mov     ax,0003h
                int     10h

                pop     es
                pop     ds
                popa
                ret

FlagDemo        endp


;-----------------------------------------------------------------------------
; Start - Startup code called from DOS.
; In:
;   DS - Program Segment Prefix.
;-----------------------------------------------------------------------------

Start           proc

                mov     ax,@Data
                mov     ds,ax
                call    FlagDemo
                mov     ax,4C00h
                int     21h

Start           endp

                end     Start
