#include "stdafx.h"	// Okay, so it doesn't include MFC stuff... sue me. It has all the common
					//	.h files I use.
#include "demo2.h"
#include "resource.h"	// All the information needed to access the bitmaps

BOOL	g_bUserTimer = FALSE;
			// Set to use either WM_TIMER or PeekMessage method of animation
			

void SetUp(HINSTANCE hInstance);
void ShutDown();

void DoAnimation(HWND hWnd);

long FAR PASCAL WndProc (HWND hWnd, WORD iMessage, WORD wParam, LONG lParam);
			// Forward declaration


int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdParam, int nCmdShow)
{
	MSG Message;
	WNDCLASS WndClass;

	if (!hPrevInstance)
	{
		WndClass.cbClsExtra = 0;
		WndClass.cbWndExtra = 0;
		WndClass.hbrBackground = GetStockObject (BLACK_BRUSH);
		WndClass.hCursor = LoadCursor (NULL, IDC_ARROW);
		WndClass.hIcon = LoadIcon (NULL, IDI_APPLICATION);
		WndClass.hInstance = hInstance;
		WndClass.lpfnWndProc = (WNDPROC) WndProc;
		WndClass.lpszClassName = "BITMAP_WINDOW";
		WndClass.lpszMenuName = NULL;
		WndClass.style = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;

		RegisterClass (&WndClass);
	}
	HWND hWnd = CreateWindow ("BITMAP_WINDOW", "Asphyxia 16color Bitmaps", WS_OVERLAPPEDWINDOW|WS_MAXIMIZE,
					50, 100, 320, 200, NULL, NULL, hInstance, NULL);
	
              
	SetUp(hInstance);              

	ShowWindow (hWnd, SW_SHOWMAXIMIZED);
	UpdateWindow (hWnd);
	

	if (g_bUserTimer)
	{
		while (GetMessage (&Message, 0, 0, 0))
		{
			TranslateMessage (&Message);
			DispatchMessage (&Message);
		}
	}
	else
	{
		while (TRUE)
		{
			DoAnimation(hWnd);
			
			if (PeekMessage (&Message, NULL, 0, 0, PM_REMOVE))
			{
				if (Message.message == WM_QUIT)
					return Message.wParam;
				
				TranslateMessage (&Message);
				DispatchMessage (&Message);
			}
		}
	}
	
	ShutDown();
	
	return Message.wParam;
}



long FAR PASCAL WndProc (HWND hWnd, WORD iMessage, WORD wParam, LONG lParam)
{
	switch (iMessage)
	{
		case WM_CREATE :
		{
			if (g_bUserTimer)
				SetTimer (hWnd, 1, 10, NULL);
		}
		break;
		case WM_PAINT :
		{
			PAINTSTRUCT	PtStr;
			HDC pDC = BeginPaint (hWnd, &PtStr);

			for (int i = 0; i < g_nNumPictures; i++)
				g_szcsPicture[g_szcapItem[i].m_nCurFrame].DrawImage (pDC, g_szcapItem[i].GetXPos(), g_szcapItem[i].GetYPos());

			EndPaint (hWnd, &PtStr);
			return (0);
		}
		break;
		case WM_TIMER :
		{
			if ((wParam == 1) && g_bUserTimer)
				DoAnimation(hWnd);
		}
		break;
		case WM_SIZE :
		{
			g_nWinWidth = LOWORD(lParam);
			g_nWinHeight = HIWORD(lParam);
		}
		break;
		case WM_DESTROY :
		{
			if (g_bUserTimer)
				KillTimer (hWnd, 1);
			PostQuitMessage (0);
			return 0;
		}
		break;
	}
	return (DefWindowProc (hWnd, iMessage, wParam, lParam) );
}

void SetUp(HINSTANCE hInstance)
{
	g_szcsPicture[ 0].InitImage (hInstance, IDB_XPIC1, 83, 70);
	g_szcsPicture[ 1].InitImage (hInstance, IDB_XPIC2, 83, 70);
	g_szcsPicture[ 2].InitImage (hInstance, IDB_XPIC3, 83, 70);
	g_szcsPicture[ 3].InitImage (hInstance, IDB_XPIC4, 83, 70);
	g_szcsPicture[ 4].InitImage (hInstance, IDB_XPIC5, 83, 70);
	g_szcsPicture[ 5].InitImage (hInstance, IDB_XPIC6, 83, 70);
	g_szcsPicture[ 6].InitImage (hInstance, IDB_XPIC7, 83, 70);
	g_szcsPicture[ 7].InitImage (hInstance, IDB_XPIC8, 83, 70);
	g_szcsPicture[ 8].InitImage (hInstance, IDB_XPIC9, 83, 70);
	g_szcsPicture[ 9].InitImage (hInstance, IDB_XPIC10, 83, 70);
	g_szcsPicture[10].InitImage (hInstance, IDB_XPIC11, 83, 70);
	g_szcsPicture[11].InitImage (hInstance, IDB_XPIC12, 83, 70);
	g_szcsPicture[12].InitImage (hInstance, IDB_XPIC13, 83, 70);
	g_szcsPicture[13].InitImage (hInstance, IDB_XPIC14, 83, 70);

	for (int i = 0; i < g_nNumPictures; i++)
	{
		g_szcapItem[i].PositionImage (RANDOM (0, g_nWinWidth+90), RANDOM (-70, g_nWinHeight));
			//	Randomly place pictures on the screen
	}
	
}

void ShutDown()
{
		//	The bitmaps are freed in the class deconstructer
		//	If I had "new"'d or "malloc"'d anything, I would free it here
}


void DoAnimation(HWND hWnd)
{
	HDC pDC = GetDC(hWnd);

	for (int i = 0; i < g_nNumPictures; i++)
	{
		int nTempX = g_szcapItem[i].GetXPos ();
		nTempX--;
		int nTempY = g_szcapItem[i].GetYPos ();
		nTempY++;
			//	Move the picture
		
		if (nTempX < - 83)
		{
			nTempX = RANDOM (0, g_nWinWidth+g_nWinHeight);
			nTempY = -70;
		}		//	Reset position when it leaves the screen
		
		g_szcapItem[i].PositionImage (nTempX, nTempY);
		g_szcsPicture[g_szcapItem[i].m_nCurFrame].DrawImage (pDC, g_szcapItem[i].GetXPos(), g_szcapItem[i].GetYPos());
	}
	
	ReleaseDC(hWnd, pDC);
}
