/*/

  QLIB Setup Utility v1.00

  Used to modify MAX/MIN RAM alloc during QLIB startup.

/*/

#include <qlib.h>
#include <stdio.h>
#include <dos.h>
#include <process.h>
#include <string.h>

//#define debug

void usage(void) {
  printf("\nUsage : QSETUP [options] <filename[.exe]>\n\n");
  printf("Options:\n");
  printf("--------\n");
  printf("/X<n>   Maximum extended memory to alloc (in bytes)\n");
  printf("        Default = 4 GBs\n");
  printf("/M<n>   Minimum extended memory to alloc (in bytes)\n");
  printf("        Default = 32 KBs\n");
  exit(0);
}

void error(byte *s) {
  printf("Error : %s\n",s);
  exit(0);
}

int h;
#define bufsiz 64*1024
byte buf[bufsiz];
byte bufc;
dword max;
dword min;
dword omax;
dword omin;
byte domax=0;
byte domin=0;
byte ts[0x80];
byte fn[0x80];
dword bufs;
dword offset;
dword bufp;

struct {
  word sign;
  word siz1;
  word siz2;
  word reits;
  word headsiz;
} EXE;

//total size of EXE part = (headsiz*16)+(siz2-1)*512+siz1

void qmax(byte * s) {
  if (!memicmp(s,"0x",2)) {
    max=str2numx(s);
  } else {
    max=str2num(s);
  }
  domax=1;
}

void qmin(byte * s) {
  if (!memicmp(s,"0x",2)) {
    min=str2numx(s);
  } else {
    min=str2num(s);
  }
  domin=1;
}

union {
  dword d1 ;
  struct {
    byte b1;
    byte b2;
    byte b3;
    byte b4;
  } b;
} conv;

void putmm(dword off,dword m) {
  conv.d1=m;
  buf[off+0]=conv.b.b1;
  buf[off+1]=conv.b.b2;
  buf[off+2]=conv.b.b3;
  buf[off+3]=conv.b.b4;
}  

//not needed anymore
dword getmm(dword off) {
  conv.b.b1=buf[off+0];
  conv.b.b2=buf[off+1];
  conv.b.b3=buf[off+2];
  conv.b.b4=buf[off+3];
  return conv.d1;
}  

void main(byte argc,byte **args) {
  word a;
  printf("\nQLIB Setup Utility   v1.00  (by : Peter Quiring)\n");
  if (argc<2) usage();
  fn[0]=0;
  for (a=1;a<argc;a++) {
    if (! memicmp(args[a],"/x",2)) {qmax(args[a]+2);continue;}
    if (! memicmp(args[a],"/m",2)) {qmin(args[a]+2);continue;}
    if (fn[0]) usage();
    strcpy(fn,args[a]);
  }
  if (!fn[0]) usage();
  if ((! domax) && (! domin)) usage();
  h=open(fn,O_BINARY|O_RDWR);
  if (h==-1) {
    strcat(fn,".EXE");
    h=open(fn,O_BINARY|O_RDWR);
    if (h==-1) error("Unable to find file");
  }
  printf("\nWorking with : %s\n",fn);
  if (read(h,&EXE,sizeof(EXE))!=sizeof(EXE))
    error("Unable to read EXE header");
  offset=(EXE.siz2-1)*512+256;   //(EXE.headsiz*16)+(EXE.siz2-1)*512+EXE.siz1;
  lseek(h,offset,SEEK_SET);
#ifdef debug
  printf("Offset = 0x%x\n",offset);
#endif
  bufs=read(h,buf,bufsiz);
  if ((!bufs) || (memcmp(buf,"LE",2)))
    error("Unable to read LE header (Compressed?)");
  bufp=0;
  while (1) {  //find offset of 'QLIB_MEM'
    if (! memcmp(buf+bufp,"QLIB_MEM",8)) break;
    bufp++;offset++;
    if (bufp>bufs) {
      bufs=read(h,buf,bufsiz);
      if (!bufs) error("This is not a QLIB EXE file!");
      bufp=0;
    }
  }
  //patch the EXE as needed
  lseek(h,offset,SEEK_SET);
  read(h,buf,16);
  if (memcmp(buf,"QLIB_MEM",8)) error("This is not a QLIB EXE file!");
  if (!domax) max=0xffffffff;  //like there will ever be EXACTLY 4 gigs free
  if (!domin) {
    if (max<32*1024) min=max; else min=32*1024;
  }

  if (max<min) error("Max < Min ?");

  putmm(8,max);
  printf("Maximum extended memory set to : %i\n",max);
  putmm(12,min);
  printf("Minimum extended memory set to : %i\n",min);

#ifdef debug
  printf("Offset(QLIB) = 0x%x\n",offset);
#endif
  lseek(h,offset,SEEK_SET);
  write(h,buf,16);
  close(h);
  printf("\nComplete!\n");
}

