/* Fast Square Root using derivatives      
   Coded By Noble Roman / DiGiTaLuS                   
   Email for questions thomas@unix.cde.com 
   Coded in DJGCC on March 9                   */

/* This function returns the Square Root of
   the number given in 16.16 fixed point
   math.  The number supplied must also be
   in 16.16 fixed point math.  You must call
   the table(); before using it.  The numbers
   returned are not precise at all but will
   work very well.  Numbers can range from 0
   to 300.  You can increase this if you feel
   the need. It is not optimized, since I
   didn't feel like it.                        */

#include <pc.h>
#include <stdio.h>
#include <stdlib.h>

unsigned long SQRTAB[17];

unsigned long SQRT(unsigned long NUM);

unsigned long SQRT(unsigned long NUM)
{
     unsigned int t,d;
     unsigned long ANS,dx,e;
     long c;
     e=0xfff;     /* Big number so don't pick zero as then answer */
     dx=0;        /* If zero really is the answer :) */
     for(t=0;t<17;t++)
     {
          c=SQRTAB[t]-NUM; /* Make c the diff between t^2 and num */
          if(c & 65536)   /* Get the abs */
               c=c^65536;
          if(c<e) /* If c is less than e then make d=t */
               d=t;
          e=c;    /* Make e=c so we can find the closest match */
     }
     dx=NUM-SQRTAB[d];
     d=d<<16; /* Make d fixed point */
     ANS=d;
     ANS+=dx/(2*d);
     return(ANS);
}

void table()
{
     int t;
     for(t=0;t<17;t++)
     {
          SQRTAB[t]=t*t;
          SQRTAB[t]=SQRTAB[t]<<16; /* Make it 16.16 */
     }
}

unsigned int ABS(int a)
{
     if(a & 65536)
          a=a|65536;
     return(a);
}





