;
; ESCAPE NOTE EDITOR v2.0
;
; done late march 1996 by Capella/Escape
;
;
;
ideal
p386n

assume ss:_stacking

segment  _stacking  stack

        db 1024 dup (?)

ends  _stacking

assume cs:coding

masm
include bwsb.inc
include gdmtype.inc
ideal

macro   set_charset

        push es
        mov ax,ds
        mov es,ax
        mov ax,1110h
        mov bh,16
        xor bl,bl
        mov cx,256
        xor dx,dx
        mov bp,offset charset
        int 10h
        pop es

endm    set_charset

macro   cursor_off

        mov dx,03d4h
        mov al,0ah
        out dx,al
        inc dx
        in al,dx
        mov [cs:oldcursor],al
        mov al,32
        out dx,al

endm    cursor_off

macro   cursor_on

        mov dx,03d4h
        mov al,0ah
        mov ah,[cs:oldcursor]
        out dx,ax

endm    cursor_on

noter_length    = 4936
replay_length   = 34837
char_length     = 4096



segment         coding

oldcursor       db 0

start:
                push es

                pushad
                mov ax,4a00h
                mov bx,141000/16+1
                int 21h
                popad

                pop es

                mov ax,[es:2ch]
                mov [cs:env_block],ax

                mov ax,miscdata
                mov ds,ax

                mov ax,0b800h
                mov es,ax

                mov ax,textdata
                mov gs,ax

                nop
                nop
                nop
                nop

                mov ax,[cs:env_block]
                mov fs,ax

                xor di,di
                mov eax,00010000h
env_loop:       cmp [dword fs:di],eax
                je _name_found
                inc di
                jmp env_loop

_name_found:
                add di,4
                xor si,si
env_loop2:      mov al,[fs:di]
                or al,al
                jz end_env
                mov [ds:env_name+si],al
                inc si
                inc di
                jmp env_loop2

end_env:
                
main_menu:      mov ax,0003h
                int 10h

                cursor_off

                mov si,offset menu1
                xor di,di
                call print_string

get_key1:
                xor ax,ax
                int 16h

                cmp al,"r"
                je read_note
                cmp al,"R"
                je read_note

                cmp al,"w"
                je write_note
                cmp al,"W"
                je write_note

                cmp al,"s"
                je set_sound
                cmp al,"S"
                je set_sound

                cmp al,"x"
                je _exit
                cmp al,"X"
                je _exit

                jmp get_key1

;====================================
; EXIT TO DOS
;====================================
_exit:
                cmp [cs:sound_on],1
                jne normal_exit

                call stopmusic
                call stopoutput
                call unloadmodule
                call freemse

normal_exit:    mov ax,0003h
                int 10h

                cursor_on

                xor di,di
                mov si,offset end_text
                call print_string

                mov ax,4c00h
                int 21h

;====================================
; WRITE NEW NOTE
;====================================
write_note:
                cmp [byte cs:sound_on],1
                je write_menu
                jmp main_menu
write_menu:
                clc                             ; load charset
                mov ax,3d00h
                mov dx,offset env_name
                int 21h
                mov bx,ax

                mov ax,4200h                    ; set filepointer to charset
                xor cx,cx
                mov dx,noter_length+replay_length
                int 21h

                mov ax,3f00h                    ; load charset
                mov dx,offset charset
                mov cx,4096
                int 21h

                mov ax,3f00h                    ; load length-pointer
                mov dx,offset music_length
                mov cx,8
                int 21h
                
                mov ax,3e00h
                int 21h

                clc
                mov ax,3d00h
                mov dx,offset env_name
                int 21h
                mov [cs:handle],ax

                call emsexist                   ; check for ems to load in
                and al,1
                mov bl,al

                mov ax,[cs:handle]              ; load da damned file
                mov ecx,8

                add ecx,noter_length+replay_length+char_length

                mov dx,ds
                mov di,offset modhead
                call LoadGDM
                or bx,bx
                jnz music_error

                mov ax,3e00h                    ; close da shit...
                mov bx,[cs:handle]
                int 21h

                mov ax,8
                call startoutput
                call startmusic
                                
after_char:
                mov ax,0003h
                int 10h

                cursor_off

                set_charset

                mov si,offset menu2
                xor di,di
                call print_string
                
get_key2:       xor ax,ax
                int 16h

                cmp al,"e"
                je edit_note
                cmp al,"E"
                je edit_note

                cmp al,"m"
                je load_music
                cmp al,"M"
                je load_music

                cmp al,"c"
                je load_charset
                cmp al,"C"
                je load_charset

                cmp al,"s"
                je save_note
                cmp al,"S"
                je save_note

                cmp al,"x"
                je _exit
                cmp al,"X"
                je _exit

                jmp get_key2
;====================================
; READ ACTUAL NOTE
;====================================
read_note:
                cmp [byte cs:sound_on],1
                je read_me
                jmp main_menu

read_me:
                mov ax,0003h
                int 10h
                      
              mov ax,1201h      ;disable DAC-setting
              mov bx,31h
              int 10h

              mov dx,03dah      ;reset Flip-Flop
              in al,dx

              mov cx,16         ;merge DAC with 16mode-colorlines
              mov dx,03c0h
              xor al,al
set_p:        out dx,al
              out dx,al
              inc al
              dec cx
              jnz set_p

              mov dx,03dah     ;reset Flip-Flop
              in al,dx

              mov dx,03c0h     ;reset sequence-controller
              mov al,32
              out dx,al

              mov dx,03c8h
              mov al,07h
              out dx,al
              xor al,al
              inc dx  
              out dx,al
              out dx,al
              out dx,al

              mov [word ds:pagepos],0

                ;------------------------------------------------------
                clc                             ; load charset        
                mov ax,3d00h
                mov dx,offset env_name
                int 21h
                mov bx,ax

                mov ax,4200h                    ; set filepointer to charset
                xor cx,cx
                mov dx,noter_length+replay_length
                int 21h

                mov ax,3f00h                    ; load charset
                mov dx,offset charset
                mov cx,4096
                int 21h

                mov ax,3f00h                    ; load length-pointer
                mov dx,offset music_length
                mov cx,8
                int 21h

                mov ax,3e00h                    ; close da shit.....
                int 21h

                
                ;------------------------------------------------------
                clc
                mov ax,3d00h
                mov dx,offset env_name
                int 21h
                mov [cs:handle],ax

                call emsexist                   ; check for ems to load in
                and al,1
                mov bl,al

                mov ax,[cs:handle]              ; load da damned file
                mov ecx,8

                add ecx,noter_length+replay_length+char_length

                mov dx,ds
                mov di,offset modhead
                call LoadGDM
                or bx,bx
                jnz music_error

                mov ax,3e00h                    ; close da shit...
                mov bx,[cs:handle]
                int 21h

                ;------------------------------------------------------

                clc                             ; load da textfile
                mov ax,3d00h
                mov dx,offset env_name
                int 21h
                mov bx,ax

                add [dword ds:music_length],8+noter_length+replay_length+char_length

                mov ax,4200h
                mov dx,[word ds:music_length]
                mov cx,[word ds:music_length+2]
                int 21h

                mov cx,0ffffh

                push ds
                mov ax,loaddata
                mov ds,ax

                mov ax,3f00h
                xor dx,dx
                int 21h

                pop ds

                mov ax,3e00h
                int 21h
                
                ;------------------------------------------------------
                push es
                push fs

                xor si,si
                xor di,di

                mov ax,loaddata
                mov es,ax
                mov ax,textdata
                mov fs,ax

                call unpack_it

                pop fs
                pop es

                set_charset

                cursor_off
                                
                mov ax,8
                call startoutput                ; start the music-output
                call startmusic

                ;------------------------------------------------------

                mov si,[ds:pagepos]
                call ram2screen
                call fade_in

get_key3:
                xor ax,ax
                int 16h

                cmp al," "
                je next_page

                cmp al,"x"
                je jump_exit
                cmp al,"X"
                je jump_exit

                jmp get_key3

next_page:      mov si,[ds:pagepos]
                add si,2000
                cmp si,[ds:pages]
                jne go_page
                xor si,si
go_page:        mov [ds:pagepos],si

                call fade_out
                call ram2screen
                call fade_in

                jmp get_key3

jump_exit:
                jmp _exit

                
fade_in:
                mov ah,0
fade_in2:       mov dx,03c8h
                mov al,07h
                out dx,al
                inc dx
                mov al,ah  
                out dx,al
                out dx,al
                out dx,al
                push ax

                mov dx,03dah
wb1:            in al,dx
                test al,8
                jne wb1
wb2:            in al,dx
                test al,8
                je wb2

                pop ax
                add ah,2
                cmp ah,50
                jne fade_in2
                ret

fade_out:
                mov ah,50
fade_out2:      mov dx,03c8h
                mov al,07h
                out dx,al
                inc dx
                mov al,ah
                out dx,al
                out dx,al
                out dx,al
                push ax

                mov dx,03dah
wb3:            in al,dx
                test al,8
                jne wb3
wb4:            in al,dx
                test al,8
                je wb4

                pop ax
                sub ah,2
                or ah,ah
                jne fade_out2
                ret



;====================================
; SET SOUNDDEVICE
;====================================
sound_on        db 0

set_sound:
                mov ax,0003h
                int 10h

                cursor_off

                mov si,offset menu3
                xor di,di
                call print_string

get_key4:
                xor ax,ax
                int 16h

                cmp al,"g"
                je gus_set
                cmp al,"G"
                je gus_set

                cmp al,"s"
                je sb_set
                cmp al,"S"
                je sb_set

                cmp al,"p"
                je pas_set
                cmp al,"P"
                je pas_set

                jmp get_key4

gus_set:        mov edi,noter_length
                mov ah,48
                jmp load_device

sb_set:         mov edi,12126
                add edi,noter_length 
                mov ah,22
                jmp load_device

pas_set:        mov edi,12126+11567
                add edi,noter_length
                mov ah,22

load_device:    mov bx,offset env_name
                mov al,10
                mov dx,0ffffh
                mov cx,0ffffh
                call LoadMSE
                or ax,ax
                jz all_ok

                jmp _exit

all_ok:         mov [byte cs:sound_on],1

                jmp main_menu
;====================================
; LOAD CHARSET
;====================================
load_charset:
                cursor_on

                call ask_file
                
                mov cx,8
                mov si,10*2+19*160
                mov di,offset charname
next_char2:     mov al,[es:si]
                mov [ds:di],al
                add si,2
                inc di
                dec cx
                jnz next_char2

                mov ax,3d02h
                mov dx,offset charname
                int 21h
                jc char_error
                mov bx,ax

                mov ah,3fh
                mov cx,4096
                mov dx,offset charset
                int 21h

                mov ah,3eh
                int 21h

                jmp after_char

char_error:
                mov cx,15
                mov di,10*2+19*160
                mov si,offset not_found
                mov ah,04
char_e:         mov al,[ds:si]
                mov [es:di],ax
                inc si
                add di,2
                dec cx
                jnz char_e

                cursor_off
                               
                jmp get_key2

;====================================
; LOAD MUSIC
;====================================

handle          dw 0
new_music       db 0

load_music:

                cursor_on

                call ask_file
                
                mov cx,8
                mov si,10*2+19*160
                mov di,offset modname
next_char3:     mov al,[es:si]
                mov [ds:di],al
                add si,2
                inc di
                dec cx
                jnz next_char3

                clc                             ; open music-file to read
                mov ax,3d00h
                mov dx,offset modname
                int 21h
                jc music_error
                mov [cs:handle],ax

                mov ax,4202h                    ; get file_length
                xor cx,cx
                xor dx,dx
                mov bx,[cs:handle]
                int 21h

                mov [word ds:music_length],ax        ; store length of file
                mov [word ds:music_length+2],dx
                
                mov ax,4200h
                xor cx,cx
                xor dx,dx
                mov bx,[cs:handle]
                int 21h
                
                                                ; stop music-output
                call stopmusic
                call stopoutput
                call unloadmodule               ; remove old module 
                
                call emsexist                   ; check for ems to load in
                and al,1
                mov bl,al

                mov ax,[cs:handle]              ; load da damned file
                xor ecx,ecx
                mov dx,ds
                mov di,offset modhead
                call LoadGDM
                or bx,bx
                jnz music_error

                mov ax,3e00h                    ; close da shit...
                mov bx,[cs:handle]
                int 21h

                mov [cs:new_music],1

                mov ax,8
                call startoutput                ; start the music-output
                call startmusic

                jmp after_char

music_error:                                    ; if error appears... 
                mov cx,15
                mov di,10*2+19*160
                mov si,offset not_found
                mov ah,04
music_e:        mov al,[ds:si]
                mov [es:di],ax
                inc si
                add di,2
                dec cx
                jnz music_e

                cursor_off

                jmp get_key2

;====================================
; EDIT TEXTPAGES
;====================================
edit_note:
                mov ax,0003h
                int 10h

                set_charset

                xor ax,ax
                mov [ds:ypos],ax
                mov [ds:xpos],ax
                mov [ds:yoff],ax
                mov [ds:xoff],ax
                call set_curpos2

;
; THE EDIT-ROUTINE 
;

edit_me:        mov ah,02h
                xor bh,bh
                mov dh,[byte ds:ypos]
                add dh,[byte ds:yoff]
                mov dl,[byte ds:xpos]
                add dl,[byte ds:xoff]
                int 10h

                mov si,[ds:pagepos]
                call ram2screen

getkey:         xor ax,ax
                int 16h 
                or al,al
                jz exp_code

                cmp al,1bh
                je exit_vote
                cmp al,0dh
                je return
                cmp al,08h
                je delete
                cmp al,09h
                je tab_move
                jmp print_char

exp_code:       cmp ah,4fh
                je end_pos
                cmp ah,47h
                je first_pos
                cmp ah,48h
                je y_dec
                cmp ah,50h
                je y_inc
                cmp ah,4bh
                je x_dec
                cmp ah,4dh
                je x_inc
                cmp ah,51h
                je page_up
                cmp ah,49h
                je page_down

print_char:     mov di,[ds:yoff]
                add di,[ds:ypos]
                imul di,160

                mov bx,[ds:xoff]
                add bx,[ds:xpos]
                shl bx,1
                add di,bx
                
                mov [es:di],al
                jmp x_inc

exit_vote:      mov si,[ds:pagepos]
                add si,2000
                mov [ds:pages],si
                sub si,2000
                call screen2ram
                cursor_off
                jmp after_char


return:         mov di,[ds:ypos]
                inc di
                cmp di,10
                jne ret1
                jmp getkey
ret1:           mov [ds:ypos],di
                mov [ds:xpos],0
                jmp set_curpos

delete:
                 
                mov ax,[ds:xpos]
                dec ax
                cmp ax,0ffffh
                jne del1
                jmp getkey
del1:           mov [ds:xpos],ax

                mov di,[ds:ypos]
                add di,[ds:yoff]
                imul di,160
                
                mov bx,[ds:xoff]
                add bx,[ds:xpos]
                shl bx,1
                add di,bx

                mov al,20h
                mov [es:di],al

                jmp set_curpos


tab_move:       mov ax,[ds:xpos]
                add ax,8
                cmp ax,80
                jb xx2
                mov ax,79
xx2:            mov [ds:xpos],ax
                jmp set_curpos


end_pos:        
                mov [word ds:xpos],79
                call set_curpos2

ep1:            mov di,[ds:ypos]
                add di,[ds:yoff]
                imul di,160
                
                mov bx,[ds:xoff]
                add bx,[ds:xpos]
                shl bx,1
                add di,bx

                cmp [byte es:di],32
                jne set_it

                mov ax,[ds:xpos]
                or ax,ax
                jz set_it2
                dec ax
                mov [ds:xpos],ax
                jmp ep1

set_it2:        mov [ds:xpos],ax
                jmp set_curpos


set_it:                         
                jmp set_curpos


first_pos:      mov [word ds:xpos],0
                
                jmp set_curpos



y_dec:          mov ax,[ds:ypos]
                dec ax
                cmp ax,0ffffh
                jne y1
                jmp getkey
y1:             mov [ds:ypos],ax
                jmp set_curpos

y_inc:          mov ax,[ds:ypos]
                inc ax
                cmp ax,25
                jne y2
                jmp getkey
y2:             mov [ds:ypos],ax
                jmp set_curpos

x_dec:          mov ax,[ds:xpos]
                dec ax
                cmp ax,0ffffh
                jne x1
                jmp getkey
x1:             mov [ds:xpos],ax
                jmp set_curpos

x_inc:          mov ax,[ds:xpos]
                inc ax
                cmp ax,80
                jne x2
                jmp getkey
x2:             mov [ds:xpos],ax
                jmp set_curpos

page_up:        mov si,[ds:pagepos]
                cmp si,31*2000
                je pge1
                call screen2ram
                add si,2000
                mov [ds:pagepos],si
                call ram2screen
pge1:           jmp getkey
                

page_down:      mov si,[ds:pagepos]
                or si,si
                jz pge2
                call screen2ram
                sub si,2000
                mov [ds:pagepos],si
                call ram2screen
pge2:           jmp getkey

set_curpos:     mov ah,02h
                xor bh,bh
                mov dh,[byte ds:ypos]
                add dh,[byte ds:yoff]
                mov dl,[byte ds:xpos]
                add dl,[byte ds:xoff]
                int 10h
                jmp getkey

screen2ram:     push si
                mov cx,2000
                xor di,di
scr1:           mov al,[es:di]
                mov [gs:si],al
                add di,2
                inc si
                dec cx
                jnz scr1
                pop si
                ret

ram2screen:     push si
                mov cx,2000
                xor di,di
scr2:           mov al,[gs:si]
                mov [es:di],al
                add di,2
                inc si
                dec cx
                jnz scr2
                pop si
                ret

;====================================
; SAVE NEW NOTE
;====================================

env_block       dw 0
handle2         dw 0

save_note:
                cursor_on

                call ask_file
                
                mov cx,8
                mov si,10*2+19*160
                mov di,offset notename
next_char4:     mov al,[es:si]
                mov [ds:di],al
                add si,2
                inc di
                dec cx
                jnz next_char4

                cursor_off

                clc                             ; create new file
                mov ax,3c00h
                xor cx,cx
                mov dx,offset notename
                int 21h
                mov [cs:handle],ax

                clc
                mov ax,3d00h                    ; open old note-file
                mov dx,offset env_name
                int 21h
                jnc _ok
                jmp _exit
_ok:
                mov [cs:handle2],ax

                push ds

                mov ax,loaddata
                mov ds,ax
               
                mov ax,3f00h                      ; read noter-programm and
                mov cx,noter_length+replay_length ; replay-routines
                xor dx,dx
                mov bx,[cs:handle2]
                int 21h

                mov ax,4000h
                mov cx,noter_length+replay_length
                xor dx,dx
                mov bx,[cs:handle]
                int 21h

                pop ds

                mov ax,3e00h
                mov bx,[cs:handle2]
                int 21h
                
                mov ax,4000h                    ; save charset
                mov dx,offset charset
                mov cx,4096
                mov bx,[cs:handle]
                int 21h

                ;---------------------------------------------------

                mov ax,4000h                    ; save length-pointer
                mov dx,offset music_length
                mov cx,8
                mov bx,[cs:handle]
                int 21h
                
                cmp [cs:new_music],1
                je its_new2
                jmp old_music

its_new2:       clc                             ; open music_file
                mov ax,3d00h
                mov dx,offset modname
                int 21h
                mov [cs:handle2],ax

                mov cx,0ffffh

its_old2:       push ds                         ; load_music_file

                mov ax,loaddata
                mov ds,ax
                
                mov ax,3f00h
                xor dx,dx
                mov bx,[cs:handle2]
                int 21h
                mov cx,ax

                mov ax,4000h                   ; save music_file
                xor dx,dx
                mov bx,[cs:handle]
                int 21h

                pop ds

                mov ax,3e00h                    ; close music_file
                mov bx,[cs:handle2]
                int 21h

                ;-------------------------------------------------------

                push es                 ; pack textfile
                push fs

                mov ax,textdata
                mov es,ax
                mov ax,loaddata
                mov fs,ax

                call pack_it

                pop fs
                pop es

                ;-------------------------------------------------------

                mov cx,[ds:text_length]

                push ds

                mov ax,loaddata
                mov ds,ax

                mov ax,4000h
                xor dx,dx
                mov bx,[cs:handle]
                int 21h

                pop ds

                mov ax,3e00h
                mov bx,[cs:handle]
                int 21h
                
                jmp get_key2

;===========================
; OLD_MUSIC TO SAVE
;===========================
old_musiclength dw 0

old_music:      clc
                mov ax,3d00h
                mov dx,offset env_name
                int 21h
                mov [cs:handle2],ax

                mov ax,4200h
                mov dx,8+noter_length+replay_length+char_length
                xor cx,cx
                mov bx,[cs:handle2]
                int 21h
                
                mov cx,[word ds:music_length]

                jmp its_old2
                
;===========================
; PRINT-STRING   / DS:SI = offset to textstring with '0' as eof
;                  ES:DI = offset of screenposition to print it
;                  code 0ffh + 'number' = color for writing
;                  code 0feh = next_line
;                  code 0fdh + 'number' = set number of spaces
;===========================
_di     dw 0

print_string:
                mov [cs:_di],di
                mov ah,01h
loop_string:
                mov al,[ds:si]
                or al,al
                jz end_string
                cmp al,0ffh
                je change_col
                cmp al,0feh
                je next_line
                cmp al,0fdh
                je next_row
                mov [es:di],ax
                inc si
                add di,2
                jmp loop_string
change_col:
                mov ah,[ds:si+1]
                add si,2
                jmp loop_string
next_line:
                mov di,[cs:_di]
                add di,160
                mov [cs:_di],di
                inc si
                jmp loop_string
next_row:
                push bx
                xor bx,bx
                mov bl,[ds:si+1]
                add si,2
                shl bx,1
                add di,bx
                pop bx
                jmp loop_string
                
end_string:     ret

;
; THE FILENAME-INPUT-ROUTINE 
;

ask_file:

                mov di,10*2+19*160
                mov eax,00200020h
                mov cx,16/2
clear_f:        mov [es:di],eax
                add di,4
                dec cx
                jnz clear_f
                
                mov ax,10
                mov [ds:xoff],ax
                xor ax,ax
                mov [ds:ypos],ax
                mov [ds:xpos],ax
                mov ax,19
                mov [ds:yoff],ax

                mov si,offset text1
                mov cx,10
                mov di,19*160
                mov ah,07h
cop_v1:         mov al,[ds:si]
                mov [es:di],ax
                add di,2
                inc si
                dec cx
                jnz cop_v1

                call set_curpos2
                jmp askkey
                           

set_curpos2:    mov ah,02h
                xor bh,bh
                mov dh,[byte ds:yoff]
                add dh,[byte ds:ypos]
                mov dl,[byte ds:xoff]
                add dl,[byte ds:xpos]
                int 10h
                ret

askkey:         xor ax,ax
                int 16h
                or al,al
                jz exp_code2

                cmp al,1bh
                je return2
                cmp al,0dh
                je return2
                cmp al,08h
                je delete2
                jmp print_char2

exp_code2:      cmp ah,4bh
                je x_dec2
                cmp ah,4dh
                je x_inc2
               
print_char2:    mov si,[ds:xoff]
                add si,[ds:xpos]
                shl si,1
                mov bx,[ds:yoff]
                add bx,[ds:ypos]
                imul bx,160
                add si,bx
                mov ah,02h
                mov [es:si],ax
                jmp x_inc2

return2:        ret

delete2:        mov si,[ds:yoff]
                add si,[ds:ypos]
                imul si,160
                mov bx,[ds:xoff]
                add bx,[ds:xpos]
                shl bx,1
                add si,bx
                xor al,al
                mov [es:si],al
                jmp x_dec2

x_dec2:         mov ax,[ds:xpos]
                dec ax
                cmp ax,0ffffh
                jne x3
                jmp askkey
x3:             mov [ds:xpos],ax
                call set_curpos2
                jmp askkey

x_inc2:         mov ax,[ds:xpos]
                inc ax
                cmp ax,8
                jne x4
                jmp askkey
x4:             mov [ds:xpos],ax
                call set_curpos2
                jmp askkey

;
; PACK / UNPACK - ROUTINES 
;

include "pack.inc"
include "depack.inc"

ends  coding

segment         miscdata

masm
modhead        GDMHeader <?>
ideal

menu1           db 254,254,254,254,254,254,254
                db 253,22,253, 7,255, 9,"",255,11,"ESCAPE NOTER v2.0",255,9,"",254
                db 253,22,255, 1,"",254,254
                db 253,22,253, 7,255, 5," R ",255,8,"Read actual note",254
                db 253,22,253, 7,255, 5," W ",255,8,"Write new note",254
                db 253,22,253, 7,255, 5," S ",255,8,"Set sounddevice",254
                db 253,22,253, 7,255, 5," X ",255,8,"Exit to DOS",254,254
                db 253,22,255, 1,"",254
                db 253,22,255,14,253,3,"please make your choice.....",0
                              
menu2           db 254,254,254,254,254,254,254
                db 253,22,253,10,255,11,"WRITE NEW NOTE",254
                db 253,22,255, 1,"",254,254
                db 253,22,253, 7,255, 5," E ",255,8,"Edit textpages",254
                db 253,22,253, 7,255, 5," M ",255,8,"Load new music",254
                db 253,22,253, 7,255, 5," C ",255,8,"Load new charset",254
                db 253,22,253, 7,255, 5," S ",255,8,"Save the note",254
                db 253,22,253, 7,255, 5," X ",255,8,"Exit to DOS",254,254
                db 253,22,255, 1,"",254
                db 253,22,255,14,253,3,"please make your choice.....",0

menu3           db 254,254,254,254,254,254,254
                db 253,22,253,10,255,11,"SET SOUNDDEVICE",254
                db 253,22,255, 1,"",254,254
                db 253,22,253, 7,255, 5," G ",255,8,"Gravis Ultrasound",254
                db 253,22,253, 7,255, 5," S ",255,8,"SoundBlaster Pro",254
                db 253,22,253, 7,255, 5," P ",255,8,"PAS",254
                db 253,22,255, 1,"",254
                db 253,22,255,14,253,3,"please make your choice.....",0
                

end_text        db 254,254,254,254,254
                db 255,15,"ESCAPE NOTER v2.0 ",255,7,"done march 1996 "
                db        "by Escape Factories",254
                db 255,3,"e-mail: ascelon@aol.com / The Seven Gates +49-5254-958024",254
                db 253,26,"Tales of Infinity +31-50-5734105",0

text1           db "Filename: "
not_found       db "FILE NOT FOUND!"

xpos            dw 0
ypos            dw 0
xoff            dw 0
yoff            dw 0
pagepos         dw 0

        db "ESCAPE"

music_length    dd 0
text_length     dw 0
pages           dw 0

modname         db 8 dup (0)
                db ".gdm",0

charname        db 8 dup (0)
                db ".fnt",0

notename        db 8 dup (0)
                db ".exe",0

env_name        db "test    .exe",0
                db 128 dup (0)


include "charset.inc"

ends  miscdata

segment         loaddata

                db 65535 dup (?)

ends            loaddata

segment         textdata

_text           db 32*2000 dup (0)

ends            textdata

end     start

