#define DEFHIGHT 16

#define O_JustifyLeft 0
#define O_JustifyRight 1
#define O_JustifyCenter 2

//#include "vos.h"
#include "filler.c"
typedef struct h_word { /* word data type */
			struct char4 charz[260];
			int len;
			word hight;
			word width;
		} h_word;

int docnum; /* document number currently playing in da cinema :) */

int o_algin=ON; /* is word algining on/off */
int o_algincol; /* if algin is off, max o_algincol */
int o_justify=O_JustifyLeft;
int curcol;
int curx; 
int curleft,curright,curlenght;
int cury;
int curi;

struct h_word wnext;
struct h_word cline;

void h_wordcat(h_word *dst,h_word src) { /* cats two words together */
	int i;
	for (i=0;i<src.len;i++) {
		(*dst).charz[(*dst).len++]=src.charz[i];
  	};
  	(*dst).width+=src.width;
	(*dst).hight=max((*dst).hight,src.hight);
}

void getnextword() {  /* gets next word according to current output status */
/* if no word available returns ONLY ONE char4 */
	int i=curi;
	wnext.len=0;
	wnext.hight=0;
	wnext.width=0;
	if (docs[docnum].data[i].type==C4T_CHAR) /* do we have a text here */
	{     
		while ((i<docs[docnum].datasize)) 
		{
			char4 c=docs[docnum].data[i];
			if (c.type!=C4T_CHAR) return; /* stop if not text */  
			wnext.charz[wnext.len]=c;
			if (!mtext)	{
				wnext.width+=getwidthchar(c.chr,c.nfo1);
				wnext.hight=max(wnext.hight,gethightchar(c.chr,c.nfo1)); /* this is da way hight is determined */
			
			} else 
			{
				wnext.width+=TOSgetwidthchar();
				wnext.hight=max(wnext.hight,TOSgethightchar()); /* this is da way hight is determined */
			}
			wnext.len++;
			if (c.chr==32) return; /* space is an only word separator */ 
			if (o_algin==OFF) return; /* if no algining every char is a word */
			i++;
		}
		return;
	}

	wnext.len=1;
	wnext.charz[0]=docs[docnum].data[i];

	if (wnext.charz[0].type==C4T_PIC) { /* we have picutre here */
		wnext.width=getpicwidth(wnext.charz[0].nfo1);
	}
	return;
}

void putword (h_word w) {     /* put a word on the screen */
  /* kinda trivial */
	int i;
	
	/* test for Justifying ... left is default */
	if (o_justify==O_JustifyCenter) {
		curx=curleft+curlenght/2-w.width/2;
	} else  
	if (o_justify==O_JustifyRight) {
		curx=curleft+curlenght-w.width;
	}
	for (i=0;i<w.len;i++) {
		if (w.charz[i].type==C4T_CHAR) { /* only if we are dealing with a character */
			struct char4 c=w.charz[i];
			byte type=c.type;
			byte chr=c.chr;
			byte fnt=c.nfo1;
			byte color=c.nfo2;
  
			if (!mtext) {
				putfntchar(curx,cury,chr,fnt,color); 
				curx+=getwidthchar(chr,fnt);
			} else {
				TOSputchar(curx,cury,chr,color); 
				curx+=TOSgetwidthchar();
			
			}
		}
		else if (w.charz[i].type==C4T_PIC)  /* we are dealing with the picture */
		{
			int pnum=w.charz[i].nfo1; /* get picture number */
			int palign=w.charz[i].nfo2; /* algin - not supported yet */

			if (palign==IMG_ARIGHT) {
				addbreakrect(curright-getpicwidth(pnum),cury,curright,cury+getpichight(pnum)); /* reserve space*/ 
				if ((curright-getpicwidth(pnum)<XRES)) 
				{
					if (!mtext) putpic(curright-getpicwidth(pnum),cury,pnum); /*yea.. don't draw if not on screen */
				}
				curright-=getpicwidth(pnum);		
			} else
			{
				addbreakrect(curx,cury,curx+getpicwidth(pnum),cury+getpichight(pnum)); /* reserve space*/ 
				if ((curx<XRES)) 
				{
					if (!mtext) putpic(curx,cury,pnum); /*yea.. don't draw if not on screen */
				}
				curx+=getpicwidth(pnum);
			}
		}  

	} 
	return;
}
void wantnewline(int newl) { /* shows where is the place for new/next line */
/* if newl means we HAVE TO go into NEXT line */
	curx=getleft(curx,cury); /* find first sutable block */
	while ((curx==XRES)||(newl==1)) { /*  no more free space in this line or new line requied */
		if (cline.hight==0) cline.hight=DEFHIGHT; /* just in case something with undefined hight was the problem */
		cury+=cline.hight;  /* next line */ 
		curx=0; /* first pixel */
		curx=getleft(curx,cury); /*get first block */
		newl=0; /*ok we went once in new line */
	} /* new line symbol */ 
   
	curleft=curx; /* where our current block starts */
	curright=getright(curx,cury); /* where our current block ends*/ 
	curlenght=curright-curleft; /*width of current block */
	//printf("next block: %i-%i line: %i\n",curleft,curright,cury);
 
}
void flushline(int newl){      /* draws current line buffer  */
	putword(cline);   /* put the word to da screen */
	wantnewline(newl);  /* find next block */
	cline.len=0;       /* empty current line, that we drawed with putword */
	cline.width=0;
	cline.hight=0;
	curcol=0;
}    
void putsimpl(int l_docnum) /* puts docnum to da screen fast and cleanly */
{  


	//struct h_word w; 
	//char   tmp[100]="";
//	XWdebug("simpl put5");
	docnum=l_docnum; /* internal docnum */
	o_algin=ON; /* default word algining = ON */
	o_justify=O_JustifyLeft; /* default justifying = left */
	curi=0; /* incremental coutner */
	cury=0; /* current coords */
	curx=0;
	curcol=0; /* current column */
	
	if (!mtext) curlenght=XRES; else curlenght=ctext.xvirtualres;/* current line length */
	curleft=0;  /* leftmost free pixel */
	curright=curlenght; /* rightmost free pixel */
	cline.len=0; /* current line clear */
	cline.width=0;
	cline.hight=0;
	initfill(10); /* init fill table */
	
	while ((curi<docs[docnum].datasize) && (docs[docnum].data[curi].type!=C4T_EOF)) 
	{
		getnextword();
		/* check for state chagnes first */
		if (wnext.charz[0].type==C4T_DALGIN) {     /* disable auto algining */  
			o_algin=OFF; 
			o_algincol=wnext.charz[0].nfo1;         
		} else
		if (wnext.charz[0].type==C4T_EALGIN) {      /* enable auto algining */
			o_algin=ON; 
		} else
		if (wnext.charz[0].type==C4T_ECENTER) {     /* enable centred text*/  
			o_justify=O_JustifyCenter; 
		} else
		if (wnext.charz[0].type==C4T_ELEFT) {      /* disable centred text */
			o_justify=O_JustifyLeft; 
		} else
		if (wnext.charz[0].type==C4T_ERIGHT) {      /* disable centred text */
		o_justify=O_JustifyRight; 
		} else
		if (wnext.charz[0].type==C4T_EOL) {      /* new paragraph */
			flushline(1); /*have to go into NEW line */
		} else
		if ((wnext.charz[0].type==C4T_CHAR) || (wnext.charz[0].type==C4T_PIC)) /* we have a real word, what shall we do? */
		/* or picture */
		/* check if it doesn't go into next line */
		/* draw a line if it goes or just add it to a line if it doesn't */
		{ 
			if ((cline.width+wnext.width>curlenght) || (wnext.len==0) || ((o_algin==OFF)&&(cline.len+wnext.len-1>o_algincol))) {
			/* checks for right border owerflow */
			/* checks for o_algin settings */
				flushline(0); /* no need to go into new line */
			};
			while ((wnext.width>curlenght)) { /* we have to make sure the word that comes next will have enough space */
				curx++; /* this automaticly means next block */ 
				wantnewline(0); /* just next block */
			};
			h_wordcat(&cline,wnext); /* make current word a current line */
		} 
		curi+=wnext.len; 
   
	}
	flushline(0); /* ... just go and write what is still not done */
	freefill();
	if (!mtext) {
		if (cscreen.yres<YRES) VOSresize(XRES,YRES);
	} else {
		
	}
	
	//VOSresize(XRES,cscreen.yres+YRES);
	
}