/* Generic fonts unit 
   23.1.1998:
   first version of this mighty library
       
   currently max 30 fonts supported
   writen by MinMax
   */
#include "..\defs.h"
#include "..\params.h"
#include "fonts.h"
#include "..\graph\vos.h"
#include <fcntl.h>
typedef struct genfont {
							char name[30];
							byte *data;
							word width,hight;
						} genfont;

int numfonts=0;
struct genfont fonts[MAXFONTS];
int loadfnt(const char *filename) {
/* loads generic 16x16 font from filename */
/* returns font internal number */
/* currently supports only generic 16x16 fonts */

	int fh,i;
	char name[30]="";
	int tmp=getfntnum(filename);
	//printf("loading fonts\n");
//	if (tmp!=-1) {printf("Font: %s already loaded\n",filename); return(tmp);}
	if (numfonts+1==MAXFONTS) {printf("Too many fonts loaded\n"); return(-1); }
	if ((fh=open(filename,O_BINARY|O_RDONLY))==-1) {printf("Font file doesn't exist\n"); return (-1);};
	for (i=0;(i<strlen(filename))&&(filename[i]!='.');i++) { /* we want only filename without path & extension */
		char str[2]="a";
		if (filename[i]=='\\') {name[0]=0;} else {
			str[0]=filename[i];
			strcat(name,str);
		} 
	}
	strcpy(fonts[numfonts].name,name);
	fonts[numfonts].data=malloc(filelength(fh));
	read(fh,fonts[numfonts].data,filelength(fh));
	fonts[numfonts].width=8;
	fonts[numfonts].hight=16; 
	close(fh);
	if (dinfo) printf("Font name: %s, number: %i was loaded successefuly\n",fonts[numfonts].name,numfonts); 
	return(numfonts++);
}
putfntchar(word x, word y, char c, int fin, byte color) {
/* puts char c to x,y font fin */
	word ofs=(word)c*16;
	shortint bx,by;
	for (by=0;by<fonts[fin].hight;by++) {
		for (bx=fonts[fin].width;bx>0;bx--) {
			if (((fonts[fin].data[ofs+by]&(1<<(fonts[fin].width-bx)))!=0)) 
			{
				VOSputpixel(x+bx,y+by,color);
			}
		} 
	}
     
}

putfntchardbg(word x, word y, char c, int fin, word color) {
/* puts char c to x,y font fin */
	word ofs=(word)c*16;
	shortint bx,by;
	for (by=0;by<fonts[fin].hight;by++) {
		for (bx=fonts[fin].width;bx>0;bx--) {
			if (((fonts[fin].data[ofs+by]&(1<<(fonts[fin].width-bx)))!=0)) 
			{
				putpixeldbg(x+bx,y+by,color);
			}
		} 
	}
     
}

word getwidthchar(char c, int fin) {
/* gets width of the char of font fin */
	return(fonts[fin].width);
}

word getwidthstr(char const *c, int fin) { 
/* ... get string width */
	int i,j=0;
	for (i=0;i<strlen(c);i++) 
	{
		j+=getwidthchar(c[i],fin);
	}
	return(j);
}
   
word gethightchar(char c, int fin) {
/* gets highth of the char of font fin */

	return(fonts[fin].hight);
}
   
void freefnt() {
/* frees ALL fonts that are loaded */
	int i;
	for (i=0;i<numfonts;i++) {
		free(fonts[i].data);
	}
	printf("All fonts successefuly freed\n");
}

putfntstr(word x, word y, const char *str, int fin, byte color) { 
/* puts string to x,y  */
	int i;
	int curx=x;
	for (i=0;i<strlen(str);i++) {
		char c=str[i];
		putfntchar(curx,y,c,fin,color);
		curx+=getwidthchar(c,fin);
	}
}

putfntstrdbg(word x, word y, const char *str, int fin, word color) {
/* puts string to x,y  */

	int i;
	int curx=x;
	for (i=0;i<strlen(str);i++) {
		char c=str[i];
		putfntchardbg(curx,y,c,fin,color);
		curx+=getwidthchar(c,fin);
	}
}

int getfntnum(const char *fontname){
	int i=0;
	char name[80]="";
	for (i=0;(i<strlen(fontname))&&(fontname[i]!='.');i++) { /* we want only filename without path & extension */
		char str[2]="a";
		if (fontname[i]=='\\') {name[0]=0;} else {
			str[0]=fontname[i];
			strcat(name,str);
		} 
	}
	i=0;
	while ((i<numfonts)&&(strcmpi(fonts[i].name,name)!=0)) i++;
	if (i==numfonts) return(-1); else return (i);
}   