
;۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰
; constants, hardware specific
Freq_22KHzS        EQU  256-23

;۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰
; hardware specific variables

;۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰
; hardware specific functions and macros

SBP_Playback       PROC  NEAR
                   SHL   DMALen,1
                   DEC   DMALen
                   MOV   AL,B CFG_PrimaryDMA
                   MOV   EBX,DMABuffer
                   MOVZX ECX,DMALen
                   CALL  COMM_DMARead
                   WriteDSP Cmd_PlaybackFreq
                   WriteDSP Freq_22KHzS
                   WriteDSP DMA_8bit
                   ;DEC   DMALen
                   WriteDSP <BYTE PTR DMALen>
                   WriteDSP <BYTE PTR DMALen+1>
                   RET
SBP_Playback       ENDP

SBP_Playback2      PROC NEAR
                   SHL   DMALen,1
                   DEC   DMALen
                   MOV   AL,B CFG_PrimaryDMA
                   MOV   EBX,DMABuffer
                   MOVZX ECX,DMALen
                   CALL  COMM_DMARead
                   ;WriteDSP Cmd_PlaybackFreq
                   ;WriteDSP Freq_22KHz
                   WriteDSP DMA_8bit
                   ;DEC   DMALen
                   WriteDSP <BYTE PTR DMALen>
                   WriteDSP <BYTE PTR DMALen+1>
                   RET
SBP_Playback2      ENDP

SBP_MixerWrite     PROC  NEAR
; AL index AH value
                   PUSH  EAX
                   PUSH  EDX
                   MOV   DX,SBP_Mixer
                   OUT   DX,AL
                   MOV   ECX,130
@@Wait:            IN    AL,80H
                   LOOP  @@Wait
                   INC   DX
                   MOV   AL,AH
                   OUT   DX,AL
                   POP   EDX
                   POP   EAX
                   RET
SBP_MixerWrite     ENDP

SBP_IRQ            PROC
                   ;CLI
                   PushSegs
                   ReLoadSegs
                   PUSHAD
                   MOV   DX,SBP_DataAvail
                   IN    AL,DX          ; ack irq to blaster

                   CMP   Buffer0Played,FALSE
                   JNZ   @@Here

                   MOV   EAX,Buffer0Abs
                   MOV   DMABuffer,EAX
                   MOV   EAX,Buffer0Len
                   MOV   DMALen,AX
                   MOV   EAX,Buffer1Offset
                   MOV   BufferToMix,EAX
                   MOV   EAX,TickLen
                   MOV   Buffer1Len,EAX
                   JMP   @@Done

@@Here:            MOV   EAX,Buffer1Abs
                   MOV   DMABuffer,EAX
                   MOV   EAX,Buffer1Len
                   MOV   DMALen,AX
                   MOV   EAX,Buffer0Offset
                   MOV   BufferToMix,EAX
                   MOV   EAX,TickLen
                   MOV   Buffer0Len,EAX

@@Done:            CMP   SB_ShutDown,TRUE
                   JZ    @@ShutDown
                   CALL  SBP_Playback2
                   CALL  SBP_TickHandler
                   NOT   Buffer0Played
@@ShutDown:        MOV   SB_ShutDown,FALSE

                   POPAD
                   PUSH  AX
                   MOV   AL,20H
                   CMP   SB_PIC1,TRUE
                   JNZ   @@pic0
                   OUT   0A0H,AL
@@pic0:            OUT   20H,AL
                   POP   AX
                   PopSegs
                   ;STI
                   IRETD
SBP_IRQ            ENDP

SBP_IRQInit        PROC  NEAR
                   CLI
                   MOVZX ESI,W CFG_PrimaryIRQ
                   MOVZX EAX,CFG_IRQNumTable[ESI*2]
                   MOV   EBX,O SBP_IRQ
                   MOV   CX,CS
                   CALL  COMM_HookIRQ
                   MOV   D OldIRQ,EBX
                   MOV   W OldIRQ+4,CX

                   MOV   SB_PIC1,FALSE
                   MOVZX ESI,W CFG_PrimaryIRQ
                   MOV   BX,CFG_IRQNumTable[ESI*2]
                   CMP   BL,8
                   JB    @@PIC0
                   MOV   SB_PIC1,TRUE
@@PIC0:            MOVZX EBX,BL

                   CALL  GetIRQMasks
                   MOVZX ESI,W CFG_PrimaryIRQ
                   MOV   BX,CFG_IRQMaskTable[ESI*2]
                   NOT   BX
                   AND   AX,BX
                   CALL  SetIRQMasks

                   MOVZX ESI,W CFG_PrimaryIRQ
                   MOV   BX,W CFG_IRQNumTable[ESI*2]
                   CALL  EnableCallBack
                   STI

                   MOV   Buffer0Played,TRUE

                   MOV   EAX,Buffer0Offset
                   MOV   BufferToMix,EAX
                   MOV   EAX,TickLen
                   MOV   Buffer0Len,EAX
                   CALL  SBP_TickHandler
                   MOV   EAX,Buffer1Offset
                   MOV   BufferToMix,EAX
                   MOV   EAX,TickLen
                   MOV   Buffer1Len,EAX
                   CALL  SBP_TickHandler

                   MOV   EAX,Buffer0Abs
                   MOV   DMABuffer,EAX
                   MOV   EAX,Buffer0Len
                   MOV   DMALen,AX

                   CALL  SBP_Playback

                   RET
SBP_IRQInit        ENDP

SBP_IRQDone        PROC  NEAR
                   JMP   SB_IRQDone
SBP_IRQDone        ENDP


SBP_Init           PROC  NEAR
                   PUSHAD
                   CALL  SB_Init
                   IFDEF SND_DOAMP
                   MOV   EAX,AmpTable
                   MOV   AmpTable0L,EAX
                   MOV   AmpTable0R,EAX
                   ENDIF
                   CALL  ModifyMulTable
                   ;CLR   EAX
                   ;CALL  SBP_MixerWrite ; reset mixer
                   MOV   EAX,0AA22H ; master volume
                   CALL  SBP_MixerWrite
                   MOV   EAX,0AA24H ; dsp output
                   CALL  SBP_MixerWrite
                   MOV   EAX,0130EH ; set stereo output
                   CALL  SBP_MixerWrite

                   MOV   ESI,O ChannelsInfo
                   MOV   ECX,MixingChannels
@@PanLp:           MOV   EAX,MixingChannels
                   SUB   EAX,ECX
                   MOV   AL,DefaultPanning[EAX]
                   MOV   [ESI.CI_Panning],AL
                   ADD   ESI,Size ChannelInfo
                   LOOP  @@PanLp
                   POPAD
                   RET
SBP_Init           ENDP

SBP_Done           PROC  NEAR
                   PUSHAD
                   CALL  SB_Done
                   POPAD
                   RET
SBP_Done           ENDP

