.386P
LOCALS @@
JUMPS

Include Krnl386.Def
Include Krnl386.Inc
Include Gfx386.Inc
Include ProcArg.Inc

Code32             SEGMENT PARA PUBLIC USE32
                   ASSUME CS:Code32,DS:Code32,ES:Code32,SS:Code32


Include FullPal.Inc
Include Small.Inc

ShadeXLAT          LABEL BYTE
                   DB   256D DUP(00H)
                   DB   'GFX386 256 Color VGA tweaked mode Graphic Routines version 1.3 '
                   DB   'Copyright by Dominik Behr 1993,1994 '

VirtualScreenWidth DD   0H
ScreenHeigth       DD   0H


; data for various tweaked modes
; ripped from xlib 6.0 by Themie Gouthas

Tweak256x200       DB   0E3H    ; dot clock
                   DB   8       ; Number of CRTC Registers to update
                   DW   05F00H  ; horz total
                   DW   03F01H  ; horz displayed
                   DW   04202H  ; start horz blanking
                   DW   09F03H  ; end horz blanking
                   DW   04C04H  ; start h sync
                   DW   00005H  ; end h sync
                   DW   00014H  ; turn off DWord mode
                   DW   0E317H  ; turn on byte mode
                   DW   256
                   DW   200

Tweak256x240       DB   0E3H    ; dot clock
                   DB   16      ; Number of CRTC Registers to update
                   DW   05F00H  ; horz total
                   DW   03F01H  ; horz displayed
                   DW   04202H  ; start horz blanking
                   DW   09F03H  ; end horz blanking
                   DW   04C04H  ; start h sync
                   DW   00005H  ; end h sync
                   DW   00D06H  ; vertical total
                   DW   03E07H  ; overflow (bit 8 of vertical counts)
                   DW   04109H  ; cell height (2 to double-scan)
                   DW   0EA10H  ; v sync start
                   DW   0AC11H  ; v sync end and protect cr0-cr7
                   DW   0DF12H  ; vertical displayed
                   DW   00014H  ; turn off DWord mode
                   DW   0E715H  ; v blank start
                   DW   00616H  ; v blank end
                   DW   0E317H  ; turn on byte mode
                   DW   256
                   DW   240

Tweak320x200       DB   00      ; 0e3h    ; dot clock
                   DB   02      ; Number of CRTC Registers to update
                   DW   00014H  ; turn off DWord mode
                   DW   0E317H  ; turn on byte mode
                   DW   320     ; width
                   DW   200     ; height

Tweak320x240       DB   0E3H    ; dot clock
                   DB   10      ; Number of CRTC Registers to update
                   DW   00D06H  ; vertical total
                   DW   03E07H  ; overflow (bit 8 of vertical counts)
                   DW   04109H  ; cell height (2 to double-scan)
                   DW   0EA10H  ; v sync start
                   DW   0AC11H  ; v sync end and protect cr0-cr7
                   DW   0DF12H  ; vertical displayed
                   DW   00014H  ; turn off DWord mode
                   DW   0E715H  ; v blank start
                   DW   00616H  ; v blank end
                   DW   0E317H  ; turn on byte mode
                   DW   320     ; width
                   DW   240     ; height

Tweak360x200       DB   0E7H    ; dot clock
                   DB   08      ; Number of CRTC Registers to update
                   DW   06B00H  ; horz total
                   DW   05901H  ; horz displayed
                   DW   05A02H  ; start horz blanking
                   DW   08E03H  ; end horz blanking
                   DW   05E04H  ; start h sync
                   DW   08A05H  ; end h sync
                   DW   00014H  ; turn off DWord mode
                   DW   0E317H  ; turn on byte mode
                   DW   360     ; width
                   DW   200     ; height

Tweak360x240       DB   0E7H    ; dot clock
                   DB   17      ; Number of CRTC Registers to update
                   DW   06B00H  ; horz total
                   DW   05901H  ; horz displayed
                   DW   05A02H  ; start horz blanking
                   DW   08E03H  ; end horz blanking
                   DW   05E04H  ; start h sync
                   DW   08A05H  ; end h sync
                   DW   00D06H  ; vertical total
                   DW   03E07H  ; overflow (bit 8 of vertical counts)
                   DW   04109H  ; cell height (2 to double-scan)
                   DW   0EA10H  ; v sync start
                   DW   0AC11H  ; v sync end and protect cr0-cr7
                   DW   0dF12H  ; vertical displayed
                   DW   02D13H  ; OFFSET;
                   DW   00014H  ; turn off DWord mode
                   DW   0E715H  ; v blank start
                   DW   00616H  ; v blank end
                   DW   0E317H  ; turn on byte mode
                   DW   360
                   DW   240

Tweak376x282       DB   0E7H
                   DB   18
                   DW   06E00H  ; horz total
                   DW   05D01H  ; horz displayed
                   DW   05E02H  ; start horz blanking
                   DW   09103H  ; end horz blanking
                   DW   06204H  ; start h sync
                   DW   08F05H  ; end h sync
                   DW   06206H  ; vertical total
                   DW   0F007H  ; overflow
                   DW   06109H  ; cell height
                   DW   0310FH  ;
                   DW   03710H  ; v sync start
                   DW   08911H  ; v sync end and protect cr0-cr7
                   DW   03312H  ; vertical displayed
                   DW   02F13H  ; OFFSET
                   DW   00014H  ; turn off DWord mode
                   DW   03C15H  ; v blank start
                   DW   05C16H  ; v blank end
                   DW   0E317H  ; turn on byte mode
                   DW   376
                   DW   282

Tweak360x360       DB   0E7H
                   DB   15
                   DW   06B00H  ; horz total
                   DW   05901H  ; horz displayed
                   DW   05A02H  ; start horz blanking
                   DW   08E03H  ; end horz blanking
                   DW   05E04H  ; start h sync
                   DW   08A05H  ; end h sync
                   DW   04009H  ; cell height
                   DW   08810H  ; v sync start
                   DW   08511H  ; v sync end and protect cr0-cr7
                   DW   06712H  ; vertical displayed
                   DW   02D13H  ; OFFSET
                   DW   00014H  ; turn off DWord mode
                   DW   06D15H  ; v blank start
                   DW   0BA16H  ; v blank end
                   DW   0E317H  ; turn on byte mode
                   DW   360
                   DW   360


Tweak376x308       DB   0E7H
                   DB   18
                   DW   06E00H  ; horz total
                   DW   05D01H  ; horz displayed
                   DW   05E02H  ; start horz blanking
                   DW   09103H  ; end horz blanking
                   DW   06204H  ; start h sync
                   DW   08F05H  ; end h sync
                   DW   06206H  ; vertical total
                   DW   00F07H  ; overflow
                   DW   04009H  ;
                   DW   0310FH  ;
                   DW   03710H  ; v sync start
                   DW   08911H  ; v sync end and protect cr0-cr7
                   DW   03312H  ; vertical displayed
                   DW   02F13H  ; OFFSET
                   DW   00014H  ; turn off DWord mode
                   DW   03C15H  ; v blank start
                   DW   05C16H  ; v blank end
                   DW   0E317H  ; turn on byte mode
                   DW   376
                   DW   308

ModeTable label dword    ; Mode X tweak table
                   DD   OFFSET Tweak320x200
                   DD   OFFSET Tweak320x240
                   DD   OFFSET Tweak360x200
                   DD   OFFSET Tweak360x240
                   DD   OFFSET Tweak376x282
                   DD   OFFSET Tweak360x360
                   DD   OFFSET Tweak376x308
                   DD   OFFSET Tweak256x200
                   DD   OFFSET Tweak256x240

;
;SetGraphic!
;  EXPLANATION  : sets desired graphic according to mode number
;  INPUT        : mode : mode number
;  OUTPUT       : none
;  SCREWED REGS : none
;

SetGraphic         PROC NEAR
                   ArgInit
                   Argument Mode

                   ProcEnter
                   PUSHAD
                   MOV   ESI,[EBP+Mode]
                   MOV   ESI,DWORD PTR ModeTable[ESI*4]
                   CLD
                   MOV   AX,0012H
                   CALL  SetGrMode
                   MOV   AX,0013H
                   CALL  SetGrMode

                   MOV   DX,3D4H      ;CRTC
                   MOV   AL,11H       ;Register 11H, Light pen low
                   OUT   DX,AL
                   INC   DX
                   IN    AL,DX
                   AND   AL,01111111B ;Delete b7, write protect off
                   OUT   DX,AL

                   MOV   DX,03C4H     ; Sequencer
                   MOV   AX,0604H
                   OUT   DX,AX        ; disable chain4 mode

                   MOV   AX,0100H
                   OUT   DX,AX       ;  synchronous reset while setting Misc

                   LODSB
                   OR    AL,AL
                   JZ    @@Skip1
                   MOV   DX,03C2H    ; miscellaneous output
                   OUT   DX,AL       ; set dot clock
@@Skip1:
                   MOV   DX,03C4H
                   MOV   AX,0300H
                   OUT   DX,AX       ; sequencer normal operation

                   MOV   DX,03D4H    ; CRTC
                   LODSB
                   MOVZX ECX,AL

@@SetCRTCReg:      LODSW
                   OUT   DX,AX
                   LOOP  @@SetCRTCReg

                   MOV   DX,3D4H      ;CRTC
                   MOV   AL,11H       ;Register 11H, Light pen low
                   OUT   DX,AL
                   INC   DX
                   IN    AL,DX
                   AND   AL,01111111B ;Delete b7, write protect off
                   OUT   DX,AL

                   LODSW
                   MOVZX EAX,AX
                   SHR   EAX,2
                   MOV   VirtualScreenWidth,EAX
                   SHR   EAX,1
                   MOV   AH,AL
                   MOV   DX,3D4H
                   MOV   AL,13H
                   OUT   DX,AX
                   POPAD
                   ProcLeave
SetGraphic         ENDP

;
;SetTextMode!
;  EXPLANATION  : Turns on text color mode 03H
;  INPUT        : NONE
;  OUTPUT       : NONE
;  SCREWED REGS : AX surely
;

SetTextMode        PROC NEAR
                   MOV  AX,0003H
                   CALL SetGrMode
                   RET
SetTextMode        ENDP

;
;SetPixel!
;  EXPLANATION  : Sets specified pixel with given color
;  INPUT        : X,Y - pixel position, Color - pixel color (low byte)
;  OUTPUT       : NONE
;  SCREWED REGS : DS preserved
;

SetPixel           PROC NEAR
                   ArgInit
                   Argument X
                   Argument Y
                   Argument Color

                   ProcEnter
                   MOV  DX,3C4H
                   MOV  ECX,[EBP+X]
                   AND  ECX,00000011B
                   MOV  AX,0102H
                   SHL  AH,CL
                   OUT  DX,AX
                   MOV  EAX,[EBP+Y]
                   MUL  VirtualScreenWidth
                   MOV  EBX,[EBP+X]
                   SAR  EBX,2
                   ADD  EBX,EAX
                   MOV  AL,BYTE PTR [EBP+Color]
                   ADD  EBX,SegA000
                   MOV  BYTE PTR [EBX],AL
                   ProcLeave
SetPixel           ENDP

;
;GetPixel!
;  EXPLANATION  : Returns color of specified pixel
;  INPUT        : X,Y - pixel position
;  OUTPUT       : AL - pixel color
;  SCREWED REGS :
;

GetPixel           PROC NEAR
                   ArgInit
                   Argument X
                   Argument Y

                   ProcEnter
                   MOV   DX,3CEH
                   MOV   AX,[EBP+X]
                   AND   AL,00000011B
                   MOV   AH,AL
                   MOV   AL,04H
                   OUT   DX,AX
                   MOV   EAX,[EBP+Y]
                   MUL   VirtualScreenWidth
                   MOV   EBX,[EBP+X]
                   SAR   EBX,2
                   ADD   EBX,EAX
                   ADD   EBX,SegA000
                   MOVZX EAX,BYTE PTR [EBX]
                   ProcLeave
GetPixel           ENDP

;
;Line!
;  EXPLANATION  : Draw a line
;  INPUT        : X1,Y1 - line begin
;                  X2,Y2 - line end
;                  Color - line color (low byte)
;  OUTPUT       : NONE
;  SCREWED REGS : ALL except DS
;

Line               PROC NEAR
                   ArgInit
                   Argument X1
                   Argument Y1
                   Argument X2
                   Argument Y2
                   Argument Color
                   LocVar DeltaX
                   LocVar DeltaY

 ; REGISTER USAGE    SI   DD
 ;                   DI   DP      LUB ODWROTNIE
 ;                   AX   DELI
 ;                   CX   X
 ;                   DX   Y       LUB ODWROTNIE
 ; BRESENHAM'S ALGORITHM

                   ProcEnter
                   PUSH ESI
                   PUSH EDI
                   MOV  EAX,[EBP+X1]
                   CMP  EAX,[EBP+X2]
                   JLE  @@NPEX
                   XCHG EAX,[EBP+X2]
                   MOV  [EBP+X1],EAX
                   MOV  EAX,[EBP+Y1]
                   XCHG EAX,[EBP+Y2]
                   MOV  [EBP+Y1],EAX
@@NPEX:            MOV  EAX,[EBP+X2]
                   SUB  EAX,[EBP+X1]
                   MOV  [EBP+DeltaX],EAX
                   JNZ  @@NOONEP
                   MOV  EAX,[EBP+Y2]
                   CMP  EAX,[EBP+Y1]
                   JNZ  @@NOONEP
                   MOV  ECX,[EBP+X1]
                   MOV  EDX,[EBP+Y1]
                   CALL @@KICK_IT
                   JMP  @@ExitProc
@@NOONEP:          MOV  EAX,[EBP+Y2]
                   SUB  EAX,[EBP+Y1]
                   JGE  @@DODATNI
                   JMP  @@UJEMNY

@@DODATNI:         MOV  [EBP+DeltaY],EAX ;--------
                   CMP  EAX,[EBP+DeltaX]
                   JG   @@DODWROT
                   JMP  @@DNORM
@@DODWROT:         JMP  @@DODWR

@@UJEMNY:          MOV  EAX,[EBP+Y1]
                   SUB  EAX,[EBP+Y2]
                   MOV  [EBP+DeltaY],EAX ;---------
                   CMP  EAX,[EBP+DeltaX]
                   JG   @@UODWROT
                   JMP  @@UNORM
@@UODWROT:         JMP  @@UODWR

 ; DODATNI <45 STOPNI
@@DNORM:           MOV  ECX,[EBP+X1]
                   MOV  EDX,[EBP+Y1]
                   MOV  ESI,[EBP+DeltaY]
                   SUB  ESI,[EBP+DeltaX]
                   SHL  ESI,1
                   MOV  EDI,[EBP+DeltaY]
                   SHL  EDI,1
                   MOV  EAX,EDI
                   SUB  EAX,[EBP+DeltaX]
                   CALL @@KICK_IT     ; INITIAL POINT
@@LLOP1:           INC  ECX
                   CMP  EAX,0
                   JL   @@LSKIP1
                   ADD  EAX,ESI
                   INC  EDX
                   JMP  @@LSKIP2
@@LSKIP1:          ADD  EAX,EDI
@@LSKIP2:          CALL @@KICK_IT
                   CMP  ECX,[EBP+X2]
                   JNZ  @@LLOP1
                   JMP  @@ExitProc

@@UNORM:           MOV  ECX,[EBP+X1]
                   MOV  EDX,[EBP+Y1]
                   MOV  ESI,[EBP+DeltaY]
                   SUB  ESI,[EBP+DeltaX]
                   SHL  ESI,1
                   MOV  EDI,[EBP+DeltaY]
                   SHL  EDI,1
                   MOV  EAX,EDI
                   SUB  EAX,[EBP+DeltaX]
                   CALL @@KICK_IT     ; INITIAL POINT
@@LLOP2:           INC  ECX
                   CMP  EAX,0
                   JL   @@LSKIP3
                   ADD  EAX,ESI
                   DEC  EDX
                   JMP  @@LSKIP4
@@LSKIP3:          ADD  EAX,EDI
@@LSKIP4:          CALL @@KICK_IT
                   CMP  ECX,[EBP+X2]
                   JNZ  @@LLOP2
                   JMP  @@ExitProc
 ; DODATNI >45 STOPNI
@@DODWR:           MOV  ECX,[EBP+Y1]
                   MOV  EDX,[EBP+X1]
                   MOV  ESI,[EBP+DeltaX]
                   SUB  ESI,[EBP+DeltaY]
                   SHL  ESI,1
                   MOV  EDI,[EBP+DeltaX]
                   SHL  EDI,1
                   MOV  EAX,EDI
                   SUB  EAX,[EBP+DeltaY]
                   XCHG ECX,EDX
                   CALL @@KICK_IT     ; INITIAL POINT
                   XCHG ECX,EDX
@@LLOP3:           INC  ECX
                   CMP  EAX,0
                   JL   @@LSKIP5
                   ADD  EAX,ESI
                   INC  EDX
                   JMP  @@LSKIP6
@@LSKIP5:          ADD  EAX,EDI
@@LSKIP6:          XCHG ECX,EDX
                   CALL @@KICK_IT
                   XCHG ECX,EDX
                   CMP  ECX,[EBP+Y2]
                   JNZ  @@LLOP3
                   JMP  @@ExitProc

@@UODWR:           MOV  ECX,[EBP+Y2]
                   MOV  EDX,[EBP+X2]
                   MOV  ESI,[EBP+DeltaX]
                   SUB  ESI,[EBP+DeltaY]
                   SHL  ESI,1
                   MOV  EDI,[EBP+DeltaX]
                   SHL  EDI,1
                   MOV  EAX,EDI
                   SUB  EAX,[EBP+DeltaY]
                   XCHG ECX,EDX
                   CALL @@KICK_IT     ; INITIAL POINT
                   XCHG ECX,EDX
@@LLOP4:           INC  ECX
                   CMP  EAX,0
                   JL   @@LSKIP7
                   ADD  EAX,ESI
                   DEC  EDX
                   JMP  @@LSKIP8
@@LSKIP7:          ADD  EAX,EDI
@@LSKIP8:          XCHG ECX,EDX
                   CALL @@KICK_IT
                   XCHG ECX,EDX
                   CMP  ECX,[EBP+Y1]
                   JNZ  @@LLOP4
                   JMP  @@ExitProc

                   ; IN ECX=X COORDINATION
                   ;    EDX=Y COORDINATION
@@KICK_IT:         PUSH EAX
                   PUSH ECX
                   PUSH EDX

                   PUSH ECX
                   PUSH EDX

                   MOV  DX,3C4H
                   AND  ECX,00000011B
                   MOV  AX,0102H
                   SHL  AH,CL
                   OUT  DX,AX
                   POP  EDX
                   POP  ECX

                   MOV  EAX,EDX
                   MUL  VirtualScreenWidth
                   SAR  ECX,2
                   ADD  ECX,EAX
                   ADD  ECX,SegA000
                   MOV  AL,BYTE PTR [EBP+Color]
                   MOV  [ECX],AL
@@EXITKK:
                   POP  EDX
                   POP  ECX
                   POP  EAX
                   RET

@@ExitProc:        POP  EDI
                   POP  ESI
                   ProcLeave
Line               ENDP

;
;FF_PutImage!
;  EXPLANATION  : Puts image at given position
;  INPUT        : X,Y - position of upper left corner of picture
;                  Sprite  - image
;  OUTPUT       : NONE
;  SCREWED REGS : ALL except DS
;

FF_PutImage        PROC NEAR
                   ArgInit
                   Argument X
                   Argument Y
                   Argument Sprite
                   LocVar  SpriteWidth
                   LocVar  SpriteHeight
                   LocVar  Base

                   ProcEnter
                   CLD
                   MOV   ESI,[EBP+Sprite]
                   MOVZX EAX,WORD PTR [ESI]
                   MOV   [EBP+SpriteWidth],EAX
                   MOVZX EAX,WORD PTR [ESI+2]
                   MOV   [EBP+SpriteHeight],EAX
                   ADD   ESI,4

                   MOV   DX,3CEH
                   MOV   AL,05H
                   OUT   DX,AL ; GDC MODE REGISTER
                   INC   DX
                   IN    AL,DX
                   AND   AL,11111100B
                   OUT   DX,AL ; WRITE MODE 0, DIRECT WRITE
                   DEC   DX
                   MOV   AL,03H
                   OUT   DX,AL
                   INC   DX
                   IN    AL,DX
                   AND   AL,11100000B ; NO ROTATE, NO FUNCTION
                   OUT   DX,AL

                   MOV   DX,3C4H
                   MOV   AL,02H
                   OUT   DX,AL

                   MOV   EAX,[EBP+Y]
                   MUL   VirtualScreenWidth
                   MOV   EBX,[EBP+X]
                   SAR   EBX,2
                   ADD   EAX,EBX
                   ADD   EAX,SegA000
                   MOV   [EBP+Base],EAX   ; BASE ADDRESS

                   MOV   EAX,[EBP+X]
                   AND   EAX,3
                   MOV   CL,AL
                   MOV   AH,11H
                   ROL   AH,CL   ; plane to start

                   MOV   EBX,[EBP+SpriteHeight]
                   MOV   DX,3C5H

@@NextLine:        MOV   EDI,[EBP+Base]
                   MOV   ECX,[EBP+SpriteWidth]
                   MOV   AL,AH
@@NextPixel:       OUT   DX,AL
                   MOVSB
                   ROL   AL,1
                   CMC
                   SBB   EDI,0
                   LOOP  @@NextPixel
                   MOV   EDI,VirtualScreenWidth
                   ADD   [EBP+Base],EDI
                   DEC   EBX
                   JNZ   @@NextLine
@@ProcExit:
                   ProcLeave
FF_PutImage        ENDP

;
;FF_PutImageTr!
;  EXPLANATION  : Same as FF_PutImage but color 0 is assumed transparent
;                  ideal with use with FF_GetMaskedImage
;  INPUT        : X,Y - position of upper left corner
;                  Sprite  - image
;  OUTPUT       : NONE
;  SCREWED REGS :
;

FF_PutImageTr      PROC NEAR
                   ArgInit
                   Argument X
                   Argument Y
                   Argument Sprite
                   LocVar  SpriteWidth
                   LocVar  SpriteHeight
                   LocVar  Base

                   ProcEnter
                   CLD
                   MOV   ESI,[EBP+Sprite]
                   MOVZX EAX,WORD PTR [ESI]
                   MOV   [EBP+SpriteWidth],EAX
                   MOVZX EAX,WORD PTR [ESI+2]
                   MOV   [EBP+SpriteHeight],EAX
                   ADD   ESI,4

                   MOV   DX,3CEH
                   MOV   AL,05H
                   OUT   DX,AL ; GDC MODE REGISTER
                   INC   DX
                   IN    AL,DX
                   AND   AL,11111100B
                   OUT   DX,AL ; WRITE MODE 0, DIRECT WRITE
                   DEC   DX
                   MOV   AL,03H
                   OUT   DX,AL
                   INC   DX
                   IN    AL,DX
                   AND   AL,11100000B ; NO ROTATE, NO FUNCTION
                   OUT   DX,AL

                   MOV   DX,3C4H
                   MOV   AL,02H
                   OUT   DX,AL

                   MOV   EAX,[EBP+Y]
                   MUL   VirtualScreenWidth
                   MOV   EBX,[EBP+X]
                   SAR   EBX,2
                   ADD   EAX,EBX
                   ADD   EAX,SegA000
                   MOV   [EBP+Base],EAX   ; BASE ADDRESS

                   MOV   EAX,[EBP+X]
                   AND   EAX,3
                   MOV   CL,AL
                   MOV   AH,11H
                   ROL   AH,CL   ; PLANE TO START

                   MOV   EBX,[EBP+SpriteHeight]
                   MOV   DX,3C5H

@@NextLine:        MOV   EDI,[EBP+Base]
                   MOV   ECX,[EBP+SpriteWidth]
                   MOV   AL,AH
@@NextPixel:       CMP   BYTE PTR [ESI],0
                   JNZ   @@DoIt
                   INC   ESI
                   ROL   AL,1
                   ADC   EDI,0
                   LOOP  @@NextPixel
                   JMP   @@PixelLoopEnd

@@DoIt:            OUT   DX,AL
                   MOVSB
                   ROL   AL,1
                   CMC
                   SBB   EDI,0
                   LOOP  @@NextPixel
@@PixelLoopEnd:    MOV   EDI,VirtualScreenWidth
                   ADD   [EBP+Base],EDI
                   DEC   EBX
                   JNZ   @@NextLine
@@ProcExit:
                   ProcLeave
FF_PutImageTr      ENDP

;
;FF_GetImage!
;  EXPLANATION  : Takes from screen rectangular part of picture
;                  and puts it to given pointer
;  INPUT        : X1,Y1 - upper left corner
;                  X2,Y2 - lower right corner of picture
;  OUTPUT       : Where^ - picture
;  SCREWED REGS : ALL except DS
;

FF_GetImage        PROC NEAR
                   ArgInit
                   Argument X1
                   Argument Y1
                   Argument X2
                   Argument Y2
                   Argument Where

                   ProcEnter
                   CLD
                   MOV  EDI,[EBP+Where]
                   MOV  EAX,[EBP+X2]
                   SUB  EAX,[EBP+X1]
                   INC  EAX
                   MOV  @@_Width,EAX
                   STOSW                       ; IMAGE _Width
                   MOV  EAX,[EBP+Y2]
                   SUB  EAX,[EBP+Y1]
                   INC  EAX
                   MOV  @@Height,EAX
                   STOSW                        ; IMAGE Height
                   MOV  EAX,[EBP+X1]
                   AND  EAX,3
                   MOV  @@FirstPlane,AL   ; PLANE TO START
                   MOV  EAX,[EBP+Y1]
                   MUL  VirtualScreenWidth
                   MOV  EBX,[EBP+X1]
                   SAR  EBX,2
                   ADD  EAX,EBX
                   ADD  EAX,SegA000
                   MOV  @@Base,EAX   ; BASE ADDRESS

                   MOV  DX,3CEH
                   MOV  AL,05H
                   OUT  DX,AL ; GDC MODE REGISTER
                   INC  DX
                   IN   AL,DX
                   AND  AL,11110111B
                   OUT  DX,AL ; READ MODE 0, DIRECT READ
                   DEC  DX
                   MOV  AL,04H
                   OUT  DX,AL
                   INC  DX

                   DB   0BBH     ; mov ebx,
@@Height           DD   1

@@NEXTLINE:        DB   0BEH     ; mov esi,
@@Base             DD   123456H
                   DB   0B9H  ; mov  ecx,
@@_Width           DD   1
                   DB   0B0H  ; mov  al,
@@FirstPlane       DB   0
@@NEXTPIXEL:       OUT  DX,AL
                   MOVSB
                   INC  AL
                   AND  AL,3
                   JZ   @@SKIPDEC
                   DEC  ESI
@@SKIPDEC:         LOOP @@NEXTPIXEL
                   MOV  ESI,VirtualScreenWidth
                   ADD  @@Base,ESI
                   DEC  EBX
                   JNZ  @@NEXTLINE
@@PROCEXIT:
                   ProcLeave
FF_GetImage        ENDP

;
;PaletteBlack!
;  EXPLANATION  : none
;  INPUT        : none
;  OUTPUT       : none
;  SCREWED REGS : eax,ecx,edx
;

PaletteBlack       PROC  NEAR
                   MOV   EDX,03C8H
                   XOR   AL,AL
                   OUT   DX,AL
                   INC   DX
                   MOV   ECX,768
@@Here:            OUT   DX,AL
                   LOOP  @@Here
                   RET
PaletteBlack       ENDP

;
;PalFadeOut!
;  EXPLANATION  : fades out palette
;  INPUT        : esi - pointe to palette
;  OUTPUT       : none
;  SCREWED REGS : ax,bx,cx,dx
;

PalFadeOut         PROC  NEAR
                   MOV   BL,64
                   CLD
@@Here:
                   WaitVBLANK
                   MOV   ECX,768
                   MOV   DX,3C8H
                   XOR   AL,AL
                   OUT   DX,AL
                   INC   DX

@@ColorLoop:       LODSB
                   MUL   BL
                   SHR   AX,6
                   OUT   DX,AL
                   LOOP  @@ColorLoop
                   SUB   ESI,768

                   DEC   BL
                   JNZ   @@Here

                   RET
PalFadeOut         ENDP

;
;PalFadeOut!
;  EXPLANATION  : fades in palette
;  INPUT        : esi - pointe to palette
;  OUTPUT       : none
;  SCREWED REGS : ax,bx,cx,dx
;

PalFadeIn          PROC  NEAR
                   MOV   BL,1
                   CLD
@@Here:
                   WaitVBLANK
                   MOV   ECX,768
                   MOV   DX,3C8H
                   XOR   AL,AL
                   OUT   DX,AL
                   INC   DX

@@ColorLoop:       LODSB
                   MUL   BL
                   SHR   AX,6
                   OUT   DX,AL
                   LOOP  @@ColorLoop
                   SUB   ESI,768

                   INC   BL
                   CMP   BL,65
                   JNZ   @@Here

                   RET
PalFadeIn          ENDP

;
;SetDefaultPalette!
;  EXPLANATION  : Sets default palette (FullPalette)
;  INPUT        : NONE
;  OUTPUT       : NONE
;  SCREWED REGS : AX,CX,DX,SI
;

SetDefaultPalette  PROC NEAR
                   PUSH OFFSET FullPalette
                   CALL SetPalette
                   RET
SetDefaultPalette  ENDP

;
;Box!
;  EXPLANATION  : Draws a box of given color
;  INPUT        : X1,Y1 - upper left corner
;                  X2,Y2 - lower right corner
;                  Color - color to fill the box
;  OUTPUT       : NONE
;  SCREWED REGS : ALL except DS
;

Box                PROC NEAR
                   ArgInit
                   Argument X1
                   Argument Y1
                   Argument X2
                   Argument Y2
                   Argument Color
                   LocVar BoxWidth
                   LocVar BoxHeight
                   LocVar Base

                   ProcEnter
                   MOV   EAX,[EBP+X2]
                   SUB   EAX,[EBP+X1]
                   INC   EAX
                   MOV   [EBP+BoxWidth],EAX
                   MOV   EAX,[EBP+Y2]
                   SUB   EAX,[EBP+Y1]
                   INC   EAX
                   MOV   [EBP+BoxHeight],EAX

                   MOV   DX,3CEH
                   MOV   AL,05H
                   OUT   DX,AL ; GDC MODE REGISTER
                   INC   DX
                   IN    AL,DX
                   AND   AL,11111100B
                   OUT   DX,AL ; WRITE MODE 0, DIRECT WRITE
                   DEC   DX
                   MOV   AL,03H
                   OUT   DX,AL
                   INC   DX
                   IN    AL,DX
                   AND   AL,11100000B ; NO ROTATE, NO FUNCTION
                   OUT   DX,AL

                   MOV   DX,3C4H
                   MOV   AL,02H
                   OUT   DX,AL

                   MOV   EAX,[EBP+Y1]
                   MUL   VirtualScreenWidth
                   MOV   EBX,[EBP+X1]
                   SAR   EBX,2
                   ADD   EAX,EBX
                   ADD   EAX,SegA000
                   MOV   [EBP+Base],EAX   ; BASE ADDRESS

                   MOV   EAX,[EBP+X1]
                   AND   EAX,3
                   MOV   CL,AL
                   MOV   AH,11H
                   ROL   AH,CL  ; plane to start

                   MOV   ESI,[EBP+BoxHeight]
                   MOV   BL,BYTE PTR [EBP+Color]
                   MOV   DX,3C5H

@@NextLine:        MOV   EDI,[EBP+Base]
                   MOV   ECX,[EBP+BoxWidth]
                   MOV   AL,AH
@@NextPixel:       OUT   DX,AL
                   MOV   BYTE PTR [EDI],BL
                   ROL   AL,1
                   ADC   EDI,0
                   LOOP  @@NextPixel
                   MOV   EDI,VirtualScreenWidth
                   ADD   [EBP+Base],EDI
                   DEC   ESI
                   JNZ   @@NextLine
@@ProcExit:
                   ProcLeave
Box                ENDP

;
;SFontXYC!
;  EXPLANATION  : Writes given text in Small font on screen
;  INPUT        : X,Y - text start position
;                  Color - text color
;                  St  - pointer to 0 terminated string
;  OUTPUT       : NONE
;  SCREWED REGS : ALL exceptr DS
;

SFontXYC           PROC NEAR
                   ArgInit
                   Argument X
                   Argument Y
                   Argument Color
                   Argument OutStr
                   LocVar SevenVSW

                   ProcEnter
                   MOV   EAX,VirtualScreenWidth
                   SHL   EAX,3
                   SUB   EAX,VirtualScreenWidth
                   MOV   [EBP+SevenVSW],EAX
                   MOV   EAX,[EBP+Y]
                   MUL   VirtualScreenWidth
                   MOV   EDI,EAX
                   MOV   EAX,[EBP+X]
                   SHR   EAX,2
                   ADD   EDI,EAX
                   ADD   EDI,SegA000
                   MOV   ECX,[EBP+X]
                   AND   CL,00000011B
                   MOV   DX,1102H
                   ROL   DH,CL

@@NextChar:        MOV   ESI,[EBP+OutStr]
                   MOVZX EAX,BYTE PTR [ESI]
                   OR    AL,AL
                   JNZ   @@GoForIt
                   JMP   @@ProcExit
@@GoForIt:         INC   DWORD PTR [EBP+OutStr]

                   LEA   ESI,SmallFontDat[EAX*8-20H*8]
                   
                   LODSB
                   MOVZX ECX,AL

                   MOV   BH,80H

@@NextPixel:       MOV   AX,DX
                   MOV   DX,3C4H
                   OUT   DX,AX
                   MOV   DX,AX
                   MOV   AL,BYTE PTR [EBP+Color]

SmallPixel         MACRO a
                   LOCAL Here
                   TEST  BYTE PTR [ESI+a],BH
                   JZ    Here
                   MOV   [EDI],AL
Here:              ADD   EDI,VirtualScreenWidth
                   ENDM

                   SmallPixel 0
                   SmallPixel 1
                   SmallPixel 2
                   SmallPixel 3
                   SmallPixel 4
                   SmallPixel 5
                   SmallPixel 6

                   SUB  EDI,[EBP+SevenVSW]
                   ROR  BH,1
                   ROL  DH,1
                   ADC  EDI,0
                   LOOP @@NextPixel
                   JMP  @@NextChar
@@ProcExit:
                   ProcLeave
SFontXYC           ENDP

;
;SFontLen!
;  EXPLANATION  : Gives length in pixel of string in small font
;  INPUT        : StringPtr - pointer to 0 terminated string
;  OUTPUT       : AX - length of string in pixels
;  SCREWED REGS : AX,BX,DX,ES,SI
;

SFontLen           PROC  NEAR
                   ArgInit
                   Argument StringPtr

                   ProcEnter
                   MOV   ESI,[EBP+StringPtr]
                   XOR   EAX,EAX

@@NextChar:        MOVZX EBX,BYTE PTR [ESI]
                   OR    BL,BL
                   JZ    @@ProcExit
                   INC   ESI
                   MOV   DL,BYTE PTR SmallFontDat[EBX*8-20H*8]
                   MOVZX EDX,DL
                   ADD   EAX,EDX
                   JMP   @@NextChar
@@ProcExit:
                   ProcLeave
SFontLen           ENDP

;
;CharWidth!
;  EXPLANATION  : gives width of char
;  INPUT        : Character - char
;  OUTPUT       : EAX - char width
;  SCREWED REGS :
;

CharWidth          PROC NEAR
                   ArgInit
                   Argument Character

                   ProcEnter
                   MOVZX EBX,BYTE PTR [EBP+Character]
                   MOV   AL,BYTE PTR SmallFontDat[EBX*8-20H*8]
                   MOVZX EAX,AL
                   ProcLeave
CharWidth          ENDP

;
;GetPalette!
;  EXPLANATION  : Gets palette to PalPtr
;  INPUT        : PalPtr - pointer to 768 free bytes
;  OUTPUT       : NONE
;  SCREWED REGS : AX,CX,DX,DI
;

GetPalette         PROC NEAR
                   ArgInit
                   Argument PalPtr

                   ProcEnter
                   MOV  EDI,[EBP+PalPtr]
		   CLD
		   MOV  DX,3C7H
		   XOR  AL,AL
                   OUT  DX,AL
                   ADD  DX,2
                   MOV  ECX,768D
@@Here:            INSB
                   JmpWait
                   JmpWait
                   LOOP @@Here
                   ProcLeave
GetPalette         ENDP

;
;SetPalette!
;  EXPLANATION  : Sets palette
;  INPUT        : PalPtr - pointer to 768 bytess with palette
;  OUTPUT       : NONE
;  SCREWED REGS : AX,CX,DX,SI
;

SetPalette         PROC NEAR
                   ArgInit
                   Argument PalPtr

                   ProcEnter
                   MOV  ESI,[EBP+PalPtr]
		   CLD
		   MOV  DX,3C8H
		   XOR  AL,AL
		   OUT  DX,AL
		   INC  DX
                   MOV  ECX,768D
@@Here:            OUTSB
                   JmpWait
                   JmpWait
                   LOOP @@Here
                   ProcLeave
SetPalette         ENDP

;
;SetScaledPalette!
;  EXPLANATION  : Set palette using scaling, enables fading
;  INPUT        : PalPtr - pointer to palette
;                  Factor - scaling factor 0 to 64
;  OUTPUT       : NONE
;  SCREWED REGS : EAX,ECX,EDX,ESI
;

SetScaledPalette   PROC NEAR
                   ArgInit
                   Argument PalPtr
                   Argument Factor

                   ProcEnter
                   MOV  ESI,[EBP+PalPtr]
                   MOV  BL,BYTE PTR [EBP+Factor]
		   CLD
		   XOR  AL,AL
		   MOV  DX,3C8H
		   OUT  DX,AL
		   INC  DX
                   MOV  ECX,768D
@@Here:            LODSB
                   MUL  BL
                   SHR  AX,6
                   AND  AL,3FH
                   OUT  DX,AL
                   LOOP @@Here
                   ProcLeave
SetScaledPalette   ENDP

;
;SetVisibleWindow!
;  EXPLANATION  : MOVES
;  INPUT        : X,Y : Position of window
;  OUTPUT       : NONE
;  SCREWED REGS : AX,BX,DX
;

SetVisibleWindow   PROC NEAR
                   ArgInit
                   Argument X
                   Argument Y

                   ProcEnter
                   MOV  EAX,[EBP+Y]
                   MUL  VirtualScreenWidth
                   MOV  EBX,[EBP+X]
                   SHR  EBX,2
                   ADD  EBX,EAX
		   MOV  DX,3D4H
		   MOV  AL,0CH
		   MOV  AH,BH
		   OUT  DX,AX
		   INC  AL
		   MOV  AH,BL
		   OUT  DX,AX
                   ProcLeave
SetVisibleWindow   ENDP

;
;SetScreenWidth!
;  EXPLANATION  : set width of virtual screen in 8 byte chunks
;  INPUT        : AH - width
;  OUTPUT       : none
;  SCREWED REGS : none
;

SetScreenWidth     PROC  NEAR
                   PUSH  EAX
                   PUSH  DX

                   MOV   DX,3D4H
                   MOV   AL,13H
                   OUT   DX,AX
                   MOVZX EAX,AH
                   SHL   EAX,1
                   MOV   VirtualScreenWidth,EAX
                   POP   DX
                   POP   EAX
                   RET
SetScreenWidth     ENDP

;
;SetScreenStart!
;  EXPLANATION  : sets start of display memory
;  INPUT        : BX - start address
;  OUTPUT       : none
;  SCREWED REGS : none
;

SetScreenStart     PROC NEAR
                   PUSH AX
                   PUSH DX
                   MOV  DX,3D4H
		   MOV  AL,0CH
		   MOV  AH,BH
		   OUT  DX,AX
		   INC  AL
		   MOV  AH,BL
		   OUT  DX,AX
                   POP  DX
                   POP  AX
                   RET
SetScreenStart     ENDP

;
;SetLineCompare!
;  EXPLANATION  : Sets line compare register to specified value
;  INPUT        : LineComp - new line compare
;  OUTPUT       : NONE
;  SCREWED REGS : AX,BX,DX
;

SetLineCompare     PROC NEAR
                   ArgInit
                   Argument LineComp

                   ProcEnter
                   MOV  BX,[EBP+LineComp]
		   MOV  DX,3D4H
		   MOV  AL,18H
		   MOV  AH,BL
		   OUT  DX,AX

                   MOV  AL,07H
                   OUT  DX,AL
                   INC  DX
                   IN   AL,DX
                   AND  AL,11101111B
                   MOV  AH,BH
                   SHL  AH,4
                   AND  AH,00010000B
                   OR   AL,AH
                   OUT  DX,AL
                   DEC  DX

                   MOV  AL,9H
                   OUT  DX,AL
                   INC  DX
                   IN   AL,DX
                   AND  AL,10111111B
                   SHL  BH,5
                   AND  BH,01000000B
                   OR   AL,BH
		   OUT  DX,AL

                   ProcLeave
SetLineCompare     ENDP

BiggerTo           MACRO Dest,Value1,Value2
                   LOCAL Skip
                   MOV  EAX,Value1
                   CMP  EAX,Value2
                   JA   Skip
                   MOV  EAX,Value2
Skip:              MOV  Dest,EAX
                   ENDM

SmallerTo          MACRO Dest,Value1,Value2
                   LOCAL Skip
                   MOV  EAX,Value1
                   CMP  EAX,Value2
                   JB   Skip
                   MOV  EAX,Value2
Skip:              MOV  Dest,EAX
                   ENDM

;
;DetectCollision!
;  EXPLANATION  : Dectects collision beetween sprites
;  INPUT        : Sprites positions and shapes
;  OUTPUT       : EAX = 0000H - no collision
;                  AX = -1 - collision detected
;  SCREWED REGS : all
;

DetectCollision    PROC NEAR
                   ArgInit
                   Argument S1X1
                   Argument S1Y1
                   Argument Sprite1
                   Argument S2X1
                   Argument S2Y1
                   Argument Sprite2
                   LocVar S1X2
                   LocVar S1Y2
                   LocVar S2X2
                   LocVar S2Y2
                   LocVar Width1
                   LocVar Width2
                   LocVar NX1
                   LocVar NX2
                   LocVar NY1
                   LocVar NY2
                   LocVar RealWidth

                   ProcEnter
                   CLD
                   MOV   ESI,[EBP+Sprite2]
                   LODSW
                   MOV   [EBP+Width2],EAX
                   DEC   EAX
                   ADD   EAX,[EBP+S2X1]
                   MOV   [EBP+S2X2],EAX
                   LODSW
                   DEC   EAX
                   ADD   EAX,[EBP+S2Y1]
                   MOV   [EBP+S2Y2],EAX

                   MOV   ESI,[EBP+Sprite1]
                   LODSW
                   MOV   [EBP+Width1],EAX
                   DEC   EAX
                   ADD   EAX,[EBP+S1X1]
                   MOV   [EBP+S1X2],EAX
                   LODSW
                   DEC   EAX
                   ADD   EAX,[EBP+S1Y1]
                   MOV   [EBP+S1Y2],EAX

                   MOV   EDI,[EBP+Sprite2]
                   ADD   DI,4

                   BiggerTo  <[EBP+NX1]>,<[EBP+S1X1]>,<[EBP+S2X1]>
                   SmallerTo <[EBP+NX2]>,<[EBP+S1X2]>,<[EBP+S2X2]>
                   BiggerTo  <[EBP+NY1]>,<[EBP+S1Y1]>,<[EBP+S2Y1]>
                   SmallerTo <[EBP+NY2]>,<[EBP+S1Y2]>,<[EBP+S2Y2]>

                   MOV   EAX,[EBP+NX1]
                   CMP   [EBP+NX2],EAX
                   JB    @@ProcExit
                   MOV   EAX,[EBP+NY1]
                   CMP   [EBP+NY2],EAX
                   JB    @@ProcExit

                   MOV   EAX,[EBP+NY1]
                   SUB   EAX,[EBP+S1Y1]
                   MUL   DWORD PTR [EBP+Width1]
                   ADD   EAX,[EBP+NX1]
                   SUB   EAX,[EBP+S1X1]
                   ADD   ESI,EAX

                   MOV   EAX,[EBP+NY1]
                   SUB   EAX,[EBP+S2Y1]
                   MUL   DWORD PTR [EBP+Width1]
                   ADD   EAX,[EBP+NX1]
                   SUB   EAX,[EBP+S2X1]
                   ADD   EDI,EAX

                   MOV   EAX,[EBP+NX2]
                   SUB   EAX,[EBP+NX1]
                   INC   EAX
                   MOV   [EBP+RealWidth],EAX
                   SUB   [EBP+Width1],EAX
                   SUB   [EBP+Width2],EAX
                   MOV   EDX,[EBP+NY2]
                   SUB   EDX,[EBP+NY1]
                   INC   EDX
                   XOR   AH,AH

@@NextLine:        MOV   ECX,RealWidth
@@NextPixel:       LODSB
                   OR    AL,AL
                   JZ    @@SkipIt
                   CMP   [EDI],AH
                   JNZ   @@Collision
@@SkipIt:          INC   EDI
                   LOOP  @@NextPixel
                   ADD   ESI,[EBP+Width1]
                   ADD   EDI,[EBP+Width2]
                   DEC   EDX
                   JNZ   @@NextLine

@@ProcExit:        MOV   EAX,0
                   ProcLeave
@@Collision:       MOV   EAX,-1
                   ProcLeave
DetectCollision    ENDP

;
;CreateShadeTable!
;  EXPLANATION  : creates xlat table for shading colors
;  INPUT        : Factor - BYTE every color compunds will be
;                  multiplied by Factor/256
;  OUTPUT       : new shade table ShadeXLAT
;  SCREWED REGS : all except DS,ES,BP
;

CreateShadeTable   PROC  NEAR
                   ArgInit
                   Argument Factor

                   ProcEnter
                   MOV   ECX,100H
@@NextColor:       PUSH  ECX
                   MOV   ESI,OFFSET FullPalette
                   LEA   EAX,[ECX+ECX*2-3]
                   ADD   ESI,EAX

                   MOV   CH,BYTE PTR [EBP+Factor]
                   ;multiply red by factor
                   MOV   AL,[ESI]
                   MUL   CH
                   MOV   BL,AH
                   ;multiply green by factor
                   MOV   AL,[ESI+1]
                   MUL   CH
                   MOV   BH,AH
                   ;multiply blue by factor
                   MOV   AL,[ESI+2]
                   MUL   CH
                   MOV   CL,AH

                   XOR   CH,CH     ; best color found
                   MOV   DI,0FFFFH ; best distance
                   MOV   ESI,OFFSET FullPalette+768
@@NextColor2:      SUB   ESI,3
                   CMP   ESI,OFFSET FullPalette
                   JB    @@ScanDone
                   MOV   AL,BL
                   SUB   AL,BYTE PTR [ESI]
                   IMUL  AL
                   MOV   DX,AX
                   MOV   AL,BH
                   SUB   AL,BYTE PTR [ESI+1]
                   IMUL  AL
                   ADD   DX,AX
                   MOV   AL,CL
                   SUB   AL,BYTE PTR [ESI+2]
                   IMUL  AL
                   ADD   DX,AX
                   CMP   DI,DX
                   JB    @@Skip1
                   MOV   DI,DX
                   MOV   EAX,ESI
                   SUB   EAX,OFFSET FullPalette
                   MOV   DL,3
                   DIV   DL
                   MOV   CH,AL
@@Skip1:
                   JMP   @@NextColor2
@@ScanDone:        MOV   AL,CH
                   POP   ECX
                   MOV   BYTE PTR ShadeXLAT[ECX-1],AL
                   LOOP  @@NextColor
                   ProcLeave
CreateShadeTable   ENDP

;
;ShadeColor!
;  EXPLANATION  : shades given color
;  INPUT        : AL - color
;  OUTPUT       : AL - shaded color
;  SCREWED REGS : EAX
;

ShadeColor         PROC  NEAR
                   MOVZX EAX,AL
                   MOV   AL,ShadeXLAT[EAX]
                   RET
ShadeColor         ENDP

;
;ShadePicture!
;  EXPLANATION  : copies given picture to outptr and shades it
;  INPUT        : PicPtr - pointer to picture
;                  OutPtr - pointer to output picture
;  OUTPUT       : picture at outptr
;  SCREWED REGS : all except ds
;

ShadePicture       PROC NEAR
                   ArgInit
                   Argument PicPtr
                   Argument OutPtr

                   ProcEnter
                   CLD
                   MOV  ESI,[EBP+PicPtr]
                   MOV  EDI,[EBP+OutPtr]
                   LODSW
                   STOSW
                   MOVZX ECX,AX
                   LODSW
                   STOSW
                   MOVZX EAX,AX
                   MUL   ECX
                   MOV   ECX,EAX
@@NextByte:        MOVZX EAX,BYTE PTR [ESI]
                   INC   ESI
                   MOV   AL,ShadeXLAT[EAX]
                   STOSB
                   LOOP  @@NextByte
                   ProcLeave
ShadePicture       ENDP

;
;FixedChar!
;  EXPLANATION  : paints given character in given color. my standard of
;                  bitmap fonts
;  INPUT        : Char - character, X,Y,Color, And font pointer
;  OUTPUT       : none
;  SCREWED REGS : all
;

FixedChar          PROC NEAR
                   ArgInit
                   Argument Char
                   Argument X
                   Argument Y
                   Argument Color
                   Argument FontPtr

                   ProcEnter
                   CLD
                   MOV   EAX,[EBP+Y]
                   MUL   VirtualScreenWidth
                   MOV   DWORD PTR @@Base,EAX
                   MOV   EAX,[EBP+X]
                   SAR   EAX,2
                   ADD   EAX,SegA000
                   ADD   DWORD PTR @@Base,EAX
                   MOV   CL,[EBP+X]
                   AND   CL,00000011B
                   MOV   AL,11H
                   ROL   AL,CL
                   MOV   BYTE PTR @@StartPlane,AL
                   MOV   ESI,[EBP+FontPtr]
                   MOVZX EAX,BYTE PTR [EBP+Char]
                   LEA   ESI,[ESI+EAX*4+60D]
                   MOV   BX,[ESI+2]
                   MOV   BYTE PTR @@XSize,BL
                   MOVZX ECX,BH
                   MOVZX ESI,WORD PTR [ESI]
                   ADD   ESI,[EBP+FontPtr]
                   MOV   AL,BYTE PTR [EBP+Color]
                   MOV   BYTE PTR @@ColorByte,AL

                   MOV   DX,3C4H
                   MOV   AL,02H
                   OUT   DX,AL
                   INC   DX

@@NextLine:        DB    0B3H  ; MOV BL,xx
@@XSize:           DB    00H
                   DB    0BFH  ; MOV EDI,xxxx
@@Base:            DD    0000H
                   DB    0B0H  ; MOV AL,xx
@@StartPlane:      DB    00H

@@GetByte:         MOV   AH,[ESI]
                   INC   ESI
                   MOV   BH,8

@@NextPixel:       SHL   AH,1
                   JNC   @@SkipPoint
                   OUT   DX,AL
                   DB    0C6H,007H  ;MOV [EDI],xx  should be 05 !
@@ColorByte:       DB    00H
@@SkipPoint:       ROL   AL,1
                   ADC   EDI,0
                   DEC   BL
                   JZ    @@LineEnd
                   DEC   BH
                   JNZ   @@NextPixel
                   JMP   @@GetByte

@@LineEnd:         MOV   EAX,VirtualScreenWidth
                   ADD   DWORD PTR @@Base,EAX
                   LOOP  @@NextLine
@@ProcExit:
                   ProcLeave
FixedChar          ENDP

;
;FixedLen!
;  EXPLANATION  : gives length of character
;  INPUT        : Char - character, and font pointer
;  OUTPUT       : AL - character length
;  SCREWED REGS : AX,ES,DI
;


FixedLen           PROC NEAR
                   ArgInit
                   Argument Char
                   Argument FontPtr

                   ProcEnter
                   MOV   EDI,[EBP+FontPtr]
                   MOVZX EAX,BYTE PTR [EBP+Char]
                   LEA   EDI,[EDI+EAX*4+62D]
                   MOVZX EAX,BYTE PTR [EDI]

                   ProcLeave
FixedLen           ENDP

;
;NewPalette!
;  EXPLANATION  : replaces default palette with new, given palette
;  INPUT        : NewPal - ptr to palette
;  OUTPUT       : none
;  SCREWED REGS : AX,CX,SI,DI,ES,Flags
;

NewPalette         PROC NEAR
                   ArgInit
                   Argument NewPal

                   ProcEnter
                   MOV  ESI,[EBP+NewPal]
                   MOV  EDI,OFFSET FullPalette
                   MOV  ECX,768D
                   CLD
                   REP  MOVSB
                   ProcLeave
NewPalette         ENDP

;
;GrayScaleSumming!
;  EXPLANATION  :
;  INPUT        :
;  OUTPUT       :
;  SCREWED REGS :
;

GrayScaleSumming   PROC NEAR
                   MOV  ESI,OFFSET FullPalette
                   MOV  ECX,256
@@Here:            MOV  AL,[ESI]  ; red
                   MOV  AH,76
                   MUL  AH
                   MOV  DX,AX
                   MOV  AL,[ESI+1]
                   MOV  AH,151
                   MUL  AH
                   ADD  DX,AX
                   MOV  AL,[ESI+2]
                   MOV  AH,28
                   MUL  AH
                   ADD  AX,DX
                   MOV  BYTE PTR [ESI],0
                   MOV  [ESI+1],AH
                   MOV  BYTE PTR [ESI+2],0
                   ADD  ESI,3
                   LOOP @@Here
                   RET
GrayScaleSumming   ENDP

ClearVideoMem      PROC  NEAR
                   PUSHAD
                   MOV   DX,3C4H
                   MOV   AX,0F02H
                   OUT   DX,AX
                   MOV   EDI,SegA000
                   MOV   ECX,16384
                   XOR   EAX,EAX
                   CLD
                   REP   STOSD
                   POPAD
                   RET
ClearVideoMem      ENDP

Code32             ENDS
END
