;*****************************************************************************
; Filename: STRICMP.ASM
;   Author: Peter Andersson
;  Version: 0.0
;  Created: 1995.03.12
;  Updated: 
;*****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;*****************************************************************************
; Function: LONG @stricmp(PSZ srcptr,PSZ destptr)
;  Comment: Compares two strings without case sensitivity
;    Input: Eax - srcptr
;           Edx - destptr
;  Returns: zero if equal, less than zero srcptr < destptr and above zero
;           if srcptr > destptr.
;*****************************************************************************

        Include STDDEF.INC

        Codeseg

Extrn UpperCaseTable:Byte:256

Proc    stricmp ,2
                Push    Ebx
                Clear   Ebx
                Clear   Ecx
        Align   4
@@Loop01:       Mov     Cl,[Eax]
                Mov     Bl,[Edx]
                Jecxz   @@Exit01
                Mov     Bl,[UpperCaseTable+Ebx]
                Mov     Cl,[UpperCaseTable+Ebx]
                Sub     Ecx,Ebx
                Inc     Eax
                Inc     Edx
                Jecxz   @@Loop01
                Mov     Eax,Ecx
                Pop     Ebx
                Ret
        Align   4
@@Exit01:       Movsx   Eax,[UpperCaseTable+Ebx]
                Neg     Eax
                Pop     Ebx
                Ret
Endp

        End
