#include "bfd.h"
#include "sysdep.h"
#include "libbfd.h"
#include "bfdlink.h"
#include "genlink.h"
#include "dos32.h"
#define  USABLE_SECTION (SEC_ALLOC | SEC_HAS_CONTENTS)
#define  HDRSIZE dos32_header_size
#define  SECTIONEND(s) s->vma+s->_raw_size
/*
# define  DEBUGIT
# define  ULTRADEBUG
*/

typedef struct fd {
dos32_header *d32_file_header;
unsigned long stacksize;
unsigned long alloc_for_d32;
unsigned long data_written;
long seek_cache;
} i386dos32_dll_file_data;

static void noswap()
BFD_FAIL()

#define i386dos32_dll_close_and_cleanup _bfd_generic_close_and_cleanup
#define i386dos32_dll_bfd_free_cached_info _bfd_generic_bfd_free_cached_info
#define i386dos32_dll_new_section_hook _bfd_generic_new_section_hook

#define i386dos32_dll_get_section_contents \
_bfd_generic_get_section_contents

boolean i386dos32_dll_set_section_contents(bfd *abfd,sec_ptr the_section,
        void *buf,file_ptr where,bfd_size_type size)
{
    i386dos32_dll_file_data *info=(i386dos32_dll_file_data *)abfd->tdata.any;
    int dummy=0;
    #ifdef DEBUGIT
    printf("[i386-dos32-dll] section %s no. %d of %s at %x, size: %x\n",
         the_section->name,the_section->index,the_section->owner->filename,
         where,size);
    #endif
    if ((the_section->flags & USABLE_SECTION)==USABLE_SECTION)
    {
        long section_position=the_section->vma+where+HDRSIZE;
        if (info->seek_cache!=section_position)
              dummy = bfd_seek(abfd,section_position,SEEK_SET);
        if (bfd_write((char *)buf,1,size,abfd)!=size)
        {
          ++dummy;
          info->seek_cache=-1;
        }
        else info->seek_cache=section_position+size;
        if (info->data_written<SECTIONEND(the_section))
                             info->data_written=SECTIONEND(the_section);
    }
    #ifdef DEBUGIT
      printf("[i386-dos32-dll] write result: %d\n",dummy);
    #endif
    return dummy==0; /* debugging, stack, bss stuff is just skipped */
    /* WARNING: THIS WILL CAUSE TROUBLE IF BSS & STACK ARE NOT AT THE
       END OF THE PROGRAM ! */
}

/* stolen from srec.c */
boolean
i386dos32_dll_set_arch_mach (abfd, arch, machine)
     bfd *abfd;
     enum bfd_architecture arch;
     unsigned long machine;
{
  return bfd_default_set_arch_mach (abfd, arch, machine);
}

int i386dos32_dll_sizeof_headers(bfd *abfd,boolean exec)
{
    return 0;
}
#define i386dos32_dll_bfd_get_relocated_section_contents \
  bfd_generic_get_relocated_section_contents
#define i386dos32_dll_bfd_relax_section bfd_generic_relax_section
#define i386dos32_dll_bfd_link_hash_table_create _bfd_generic_link_hash_table_create
#define i386dos32_dll_bfd_link_add_symbols _bfd_generic_link_add_symbols

/*
   final link routine, parts taken from linker.c
   This seems to be a weird hack, but there is IMHO no other way to do it:
   On the one hand we need relocations for the fixup table of the DLL,
   on the other hand a DLL is NOT a real relocatable output - it doesn't
   contain any symbols and you can't link it together with any other DLL
   or other object file.
   So I've set this target to be not relocatable and hacked bfd_final_link.
   -r.
*/

boolean
i386dos32_dll_bfd_final_link (abfd, info)
     bfd *abfd;
     struct bfd_link_info *info;
{
  asection *o;
  struct bfd_link_order *p;
  struct reloc_cache_entry **myreloc;
  i386dos32_dll_file_data *bfdinfo=(i386dos32_dll_file_data *)abfd->tdata.any;
  unsigned long l;


#ifdef DEBUGIT
   printf("[i386-dos32-dll] performing final link\n");
#endif
   if (_bfd_generic_final_link(abfd,info)==false) return false;

   /*
      - gather all absolute relocs and write them at the end of the dll
      - get the highest mem alloced
   */

   /* seek to end of file */
   if (bfdinfo->seek_cache!=bfdinfo->data_written+HDRSIZE)
      if (bfd_seek(abfd,bfdinfo->data_written+HDRSIZE,SEEK_SET)) return false;
   bfdinfo->seek_cache=-1;

   /* align end */
   bfdinfo->alloc_for_d32=(bfdinfo->data_written+15) & 0xFFFFFFF0;

   for (o = abfd->sections; o != (asection *) NULL; o = o->next)
   {
#ifdef DEBUGIT
    printf("[i386-dos32-dll] scanning section %s\n",o->name);
#endif
    if (o->flags & SEC_ALLOC)
    {
      if (bfdinfo->alloc_for_d32<SECTIONEND(o))
                                    bfdinfo->alloc_for_d32=SECTIONEND(o);
    }
    for (p = o->link_order_head; p != (struct bfd_link_order *) NULL;p = p->next)
    {
     if (p->type == bfd_section_reloc_link_order
         || p->type == bfd_symbol_reloc_link_order)
         return false; /* abort if there are any output relocations */
     else if (p->type == bfd_indirect_link_order)
     {
       asection *input_section;
       bfd *input_bfd;
       long relsize;
       arelent **relocs;
       asymbol **symbols;
       long reloc_count;

       input_section = p->u.indirect.section;
       input_bfd = input_section->owner;

#ifdef DEBUGIT
   printf("[i386-dos32-dll] gathering relocations of %s in %s\n",
          input_section->name,input_bfd->filename);
#endif

       relsize = bfd_get_reloc_upper_bound (input_bfd,input_section);
       if (relsize < 0) return false;
       relocs = (arelent **) malloc ((size_t) relsize);
       if (!relocs && relsize != 0)
       {
         bfd_set_error (bfd_error_no_memory);
         return false;
       }
#ifdef DEBUGIT
#ifdef ULTRADEBUG
         printf("[i386-dos32-dll] start count:"); fflush(stdout);
#endif
#endif
       symbols = _bfd_generic_link_get_symbols (input_bfd);
       reloc_count = bfd_canonicalize_reloc (input_bfd,input_section,relocs,
                                             symbols);
       if (reloc_count < 0) return false;
       BFD_ASSERT (reloc_count == input_section->reloc_count);
       for (myreloc=relocs;reloc_count;reloc_count--,myreloc++)
       {
         if (myreloc[0]->howto->pc_relative==false)
         {
#ifdef DEBUGIT
#ifdef ULTRADEBUG
         printf("A");
#endif
#endif
           bfdinfo->d32_file_header->fixup_entries++;
           l=(myreloc[0]->address+input_section->output_offset+o->vma)
              | 0xC0000000U;
           if (bfd_write(&l,1,4,abfd)!=4) return false;
         }
#ifdef DEBUGIT
#ifdef ULTRADEBUG
         else printf("r");
#endif
#endif
       }
#ifdef DEBUGIT
#ifdef ULTRADEBUG
         printf("ok\n"); fflush(stdout);
#endif
#endif
       free (relocs);
     }
   } /* link order loop */
  }  /* output section loop */

  #ifdef DEBUGIT
  printf("[i386-dos32-dll] writing header in %s\n",abfd->filename);
  #endif

  /* update header */
  bfdinfo->d32_file_header->exe_length=bfdinfo->data_written+HDRSIZE+
                                     bfdinfo->d32_file_header->fixup_entries*4;
  bfdinfo->d32_file_header->image_length=bfdinfo->data_written;
  bfdinfo->d32_file_header->initial_memory=bfdinfo->alloc_for_d32;
  bfdinfo->d32_file_header->start_eip=abfd->start_address;
  #ifdef DEBUGIT
     printf("[i386-dos32-dll] Header info:  image length: %08x\n",
                                bfdinfo->d32_file_header->image_length);
     printf("[i386-dos32-dll]  entry point: %08x  allocmem: %08x\n",
           bfdinfo->d32_file_header->start_eip,
           bfdinfo->d32_file_header->initial_memory);
  #endif
  if (bfd_seek(abfd,0,SEEK_SET)) return false;
  if (bfd_write((char *)bfdinfo->d32_file_header,1,HDRSIZE,abfd)!=HDRSIZE)
        return false;
  free(bfdinfo->d32_file_header);
  free(bfdinfo);
  return true;
}



/*  set up the dos32 header */
boolean i386dos32_dll_bfd_set_format(bfd *abfd)
{
   dos32_header *dummy=(dos32_header *)malloc(HDRSIZE);
   i386dos32_dll_file_data *dummy2=
                   (i386dos32_dll_file_data *)malloc(sizeof(i386dos32_dll_file_data));
   #ifdef DEBUGIT
   printf("[i386-dos32-dll] open %s\n",abfd->filename);
   #endif
   if (dummy == NULL || dummy2 == NULL) return false;
   dummy->dos32_id=dos32_dll_id;         /*     "DLL ", little endian */
   dummy->fixup_entries=0;
   dummy->dlink_version=0x9999;          /* this is ultra - dlink     */
   dummy->exe_flags=0;                   /* no flags                  */
   dummy->minimum_dos32_version=0x0330;  /* running on 3.3 & better   */
   dummy->exe_start=HDRSIZE;       /* image starts right after header */
   dummy->start_esp=0;                   /* stack ignored in DLLs     */
   dummy2->d32_file_header=dummy;
   dummy2->alloc_for_d32=0;
   dummy2->data_written=0;
   dummy2->seek_cache=-1;
/* if (bfd_write((char *)dummy,1,HDRSIZE,abfd)!=HDRSIZE) return false; */
   abfd->tdata.any=(void *)dummy2;
   return true;
}

boolean i386dos32_dll_bfd_write_contents(bfd *abfd)
{
    i386dos32_dll_file_data *dummy = (i386dos32_dll_file_data *)abfd->tdata.any;
    #ifdef DEBUGIT
    printf("[i386-dos32-dll] flushing %s\n",abfd->filename);
    #endif
    dummy->seek_cache= -1;
    return !bfd_flush(abfd);  /* flush */
}


#define i386dos32_dll_get_symtab_upper_bound _bfd_nosymbols_get_symtab_upper_bound
#define i386dos32_dll_get_symtab             _bfd_nosymbols_get_symtab

/* this is needed for creating the output sections */
asymbol * i386dos32_dll_make_empty_symbol (bfd *abfd)
{
  asymbol *new = (asymbol *) bfd_zalloc (abfd, sizeof (asymbol));
  if (new) new->the_bfd = abfd;
  return new;
}

#define i386dos32_dll_print_symbol          _bfd_nosymbols_print_symbol
#define i386dos32_dll_get_symbol_info       _bfd_nosymbols_get_symbol_info
#define i386dos32_dll_bfd_is_local_label    _bfd_nosymbols_bfd_is_local_label
#define i386dos32_dll_get_lineno            _bfd_nosymbols_get_lineno
#define i386dos32_dll_find_nearest_line     _bfd_nosymbols_find_nearest_line
#define i386dos32_dll_bfd_make_debug_symbol _bfd_nosymbols_bfd_make_debug_symbol


bfd_target i386dos32_dll_vec =
{
   "i386-dos32-dll",
   bfd_target_unknown_flavour,
   false,
   false,
   EXEC_P , /* that's all, no relocation entries !*/
   SEC_ALLOC | SEC_LOAD | SEC_CODE | SEC_DATA | SEC_HAS_CONTENTS
   | SEC_DATA | SEC_CODE | SEC_READONLY, /* needed ? */
   0,
   0,
   255,
   0, /* don't care ? */
#define swapfail1 ((bfd_vma (*) PARAMS ((const bfd_byte *))) noswap)
#define swapfail2 ((bfd_signed_vma (*) PARAMS ((const bfd_byte *))) noswap)
#define swapfail3 ((void (*) PARAMS ((bfd_vma, bfd_byte *))) noswap)
   swapfail1,swapfail2,swapfail3,
   swapfail1,swapfail2,swapfail3,
   swapfail1,swapfail2,swapfail3,
   swapfail1,swapfail2,swapfail3,
   swapfail1,swapfail2,swapfail3,
   swapfail1,swapfail2,swapfail3,
   {
      _bfd_dummy_target, /* we don't want to read the exe        */
      _bfd_dummy_target, /* perhaps sometimes I'll...            */
      _bfd_dummy_target, /* might be useful for a debugger       */
      _bfd_dummy_target,
   },
   {
      bfd_false,
      i386dos32_dll_bfd_set_format, /* only creating a file is o.k. */
      bfd_false,
      bfd_false,
   },
   {
      bfd_false,
      i386dos32_dll_bfd_write_contents, /* just a flush of iostream */
      bfd_false,
      bfd_false,
   },
     BFD_JUMP_TABLE_GENERIC(i386dos32_dll),
     BFD_JUMP_TABLE_COPY(_bfd_generic),
     BFD_JUMP_TABLE_CORE(_bfd_nocore),
     BFD_JUMP_TABLE_ARCHIVE(_bfd_noarchive),
     BFD_JUMP_TABLE_SYMBOLS(i386dos32_dll),
     BFD_JUMP_TABLE_RELOCS(_bfd_norelocs),
     BFD_JUMP_TABLE_WRITE(i386dos32_dll),
     BFD_JUMP_TABLE_LINK(i386dos32_dll),
     BFD_JUMP_TABLE_DYNAMIC(_bfd_nodynamic),
     NULL
};

