/*
 this file was changed or created for the DOS32 library for DJGPP on 21.9.1996
 new created files are copyright 1996 by C.Lageman, see docs.doc for details
*/
/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
/* This is file FILELEN.C */
/*
 * Copyright (c) 1994 Eli Zaretskii <eliz@is.elta.co.il>
 *
 * This software may be used freely so long as this copyright notice is
 * left intact.  There is no warranty on this software.
 *
 */

#include <errno.h>
#include <libc/dosio.h>

long __filelength(int);

long
__filelength(int fhandle)
{
  int a,f;
  unsigned short fpos_high, fpos_low;
  long           retval;

  /* Remember the current file position, so we can return there
     later.  */
  asm("movw $0x4201,%%ax\n\
       xorl %%ecx,%%ecx\n\
       xorl %%edx,%%edx\n\
       int  $0x21\n\
       movl %%eax,%k0\n\
       sbbl %%ebx,%%ebx"
      : "=g" (a), "=b" (f), "=d" (fpos_high), "=a" (fpos_low)
      : "b" (fhandle)
      : "eax","ebx","ecx","edx","cc");
  if (f)
    {
      errno = __doserr_to_errno(a);
      return -1L;
    }

  asm("movw $0x4202,%%ax\n\
       xorl %%ecx,%%ecx\n\
       xorl %%edx,%%edx\n\
       int  $0x21\n\
       shll $16,%%edx\n\
       sbbl %%ebx,%%ebx\n\
       movw %%ax,%%dx"
      : "=a" (a), "=b" (f), "=d" (retval)
      : "b" (fhandle)
      : "eax","ebx","ecx","edx","cc");
  if (f)
    {
      errno = __doserr_to_errno(a);
      return -1L;
    }

  /* The absolute byte offset returned in DX:AX is the file size. */

  /* Leave things as we have found them. */
  asm("movw $0x4200,%%ax\n\
       int  $0x21\n\
       sbbl %%ebx,%%ebx"
      : "=a" (a), "=b" (f)
      : "b" (fhandle), "c" (fpos_high), "d" (fpos_low)
      : "eax","ebx","ecx","edx","cc");
  if (f)
    {
      errno = __doserr_to_errno(a);
      return -1L;
    }
  return retval;
}
