        

; This module uses the space between
; _LoMemBase and lomemtop for buffering file transferts
; and the space between
; _HiMemBase and  _HiMemTop to store loaded files

extrn _FOpen: near
;Opens a file and returns its handle into V86bx
; In:
;   ESI -> ASCIIZ filename (IN LOW MEMORY)
;   AL  == file mode: 00 = Read Only
;                     01 = Write Only (create it if it doesn't exist)
; Out:
;   if
;       CF=1 : Error opening file
;   else
;       CF=0 : File opened succesfully
;              V86bx = file handle
        
extrn _FClose: near
; Closes file with handle V86bx
; In:
;   V86bx = file handle

extrn _FSeek: near
; Seeks position in file
; In:
;   V86bx = file handle
;   EAX   = signed offset to move to
;   DL    = from: 0-beginning of file, 1-current location, 2-end of file
; Out:
;   CF=1  : Error seeking in file
;               EAX = ?
;   CF=0  : Seek done
;               EAX = new offset from beginning of file

extrn _FSize: near
; Get size of file
; In:
;   V86bx = file handle
; Out:
;   CF=1  : Error checking file
;               EAX = ?
;   CF=0  : File exist
;               EAX = size of file

extrn _FRead: near
; Reads a block from a file with handle V86bx
; In:   V86bx = file handle
;       EDI   = base address of block ( relative offset)
;       EAX   = size of block 
; Out:  If carry clear
;       The space between _LoMemBase and _LoMemTop is used as a 
;       "transition buffer"
        
extrn _FLoad: near
; Loads a file with ASCIIZ name pointed by DS:ESI (located in low mem)
; Out:  If carry clear
;       EAX = file size
;       The file gets loaded starting from _HiMemBase
;       The space between _LoMemBase and _LoMemTop is used as a 
;       "transition buffer"
;       N.B. _LoMemBase and _HiMemBase are left as they were
;            BEFORE calling _FLoad, what will you do with the heaps
;            is up to you.

extrn _LoFLoad: near
; Loads a file with ASCIIZ name pointed by DS:ESI (located in low mem)
; Out:  If carry clear
;       EAX = file size
;       The file gets loaded starting from _LoMemBase
;       N.B _LoMemBase and _HiMemBase are left as they were
;           BEFORE calling _LoFLoad, it's up to you to decide to update 'em
;           or "discard" the load.


        
extrn _FWrite: near
; Writes a block of memory to file with handle V86bx
; In:   V86bx = file handle
;       esi   = buffer base (relative address)
;       eax   = file size
; Out:  If carry clear
;       file write done

extrn _FSave: near
; Saves a block of memory 
; into the file with ASCIIZ name 
; In:
;       esi = ptr to asciiz file name in low memory
;       edi = buffer base
;       eax = file size
; Out:  If carry clear
;       file write done

