#define PAL1
#define PAGE1

#include <conio.h>
#include "myh\float.h"
#include "myh\mode13c.h"
#include "myh\palette.h"
#include "myh\pcx.h"
#include "myh\fps.h"
#include "myh\mouse.h"

/////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////

void scale(byte * src,  int srcwid, int srchgt,
           byte * dest, int dstwid, int dsthgt,
           int pagewid, int pagehgt, int left, int top);

void animate(char *file);

/////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////

void main(int argc, char **argv)
{
  if(argv[1])
  {
    if(SetUpVirtual()==0)
    {
      randomize();
      create_sines();

      VGA320x200();
 
      animate(argv[1]);

      Mode3h();
    }
    else{
      printf("You need more memory to run this program.\n");
    }

    ShutDownVirtual();

    ShowFps();
  }
  else
    printf("Tell me what PCX file to scale, dumbass.");
}

/////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////

// Woo-hoo!  This just makes the scaling look kind of interesting...
void animate(char *file)
{
  char *image;

  PCXheader head;

  MOUSE mouse;

  int left=0, top=0, right, bottom;

  int width, height;

  char ch=0;


  LoadPCXinfo(file, &head, Pal1);

  width  = head.xmax - head.xmin + 1;
  height = head.ymax - head.ymin + 1;

  image = malloc(width * height);

  LoadPCX(file, image, &head, Pal1, 1);

  clearscreen(Vaddr1, 0);

  M_reset(&mouse);


  FpsStart();
  {
    int x1, y1, x2, y2;
    int x1dir=0, y1dir=0,  x2dir=0, y2dir=0;

    x1 = rand()%320; y1 = rand()%200;
    x2 = rand()%320; y2 = rand()%200;

    while(x1dir == 0) x1dir = rand()%7 - 3;
    while(y1dir == 0) y1dir = rand()%7 - 3;
    while(x2dir == 0) x2dir = rand()%7 - 3;
    while(y2dir == 0) y2dir = rand()%7 - 3;

    while(!kbhit())
    {
      x1 += x1dir;
      y1 += y1dir;
      x2 += x2dir;
      y2 += y2dir;

      if(x1 < 0) x1=0, x1dir *=-1;
      if(y1 < 0) y1=0, y1dir *=-1;
      if(x2 < 0) x2=0, x2dir *=-1;
      if(y2 < 0) y2=0, y2dir *=-1;

      if(x1 >= 320) x1=319, x1dir *=-1;
      if(y1 >= 200) y1=199, y1dir *=-1;
      if(x2 >= 320) x2=319, x2dir *=-1;
      if(y2 >= 200) y2=199, y2dir *=-1;

      scale(image, width, height,
            Vaddr1, x2-x1, y2-y1,
            320, 200, x1, y1);
      toVGA(Vaddr1);
      frames++;
    }
  }

/*
  // old code, pretty uninteresting...
  for(right = 16, bottom = 16; right < 200; right ++, bottom ++)
  {
    scale(image, width, height,
          Vaddr1, right-left, bottom-top,
          320, 200, left, top);
    toVGA(Vaddr1);
    frames++;
  }

  for(left = 0, top = 0; left < 192; left ++, top ++)
  {
    scale(image, width, height,
          Vaddr1, right-left, bottom-top,
          320, 200, left, top);
    toVGA(Vaddr1);
    frames++;
  }
*/
  FpsEnd();

  getch();

/*
  // I had fun scaling with the mouse.  It works well...
  left = 160; top = 100;
  while(ch != 27)
  {
    M_read_butt_pos(&mouse);

    if(kbhit())
    {
      ch = getch();
      switch(ch)
      {
        case ' ':
          left = mouse.x>>1;
          top = mouse.y;
          break;
        case 'c':
          clearscreen(Vaddr1,0);
          break;
      }
    }
    else{
      right = mouse.x>>1;
      bottom = mouse.y;
    }

    scale(image, width, height,
          Vaddr1, right-left, bottom-top,
          320, 200, left, top);
    toVGA(Vaddr1);
  }
*/
/*
  // And, of course, the random scaling...
  while(!kbhit())
  {
    left = rand()%320;
    right = rand()%320;
    top = rand()%200;
    bottom = rand()%200;

    scale(image, width, height,
          Vaddr1, right-left, bottom-top,
          320, 200, left, top);

    left = rand()%320;
    right = rand()%320;
    top = rand()%200;
    bottom = rand()%200;

    scale(image, width, height,
          Vaddr1, right-left, bottom-top,
          320, 200, left, top);

    toVGA(Vaddr1);
  }
*/
  free(image);
}



// La la la...  Here's the stuff you're probably interested in...

void scale(byte * src,  int srcwid, int srchgt,
           byte * dest, int dstwid, int dsthgt,
           int pagewid, int pagehgt, int left, int top)
{

  int x, y;             // horz & vert counters
  int xmax, ymax;       // width and height to scale to
  int xdir, ydir;       // do we flip the image?

  byte c;               // dummy byte, holds single pixel values

  int srcx, srcy=0;     // x / y coordinates in source image

  int xstep, ystep;     // distance (in source) between pixels (in dest)
                        //  : in 16.16 fixed point

  int dstystep;         // number of pixels between the end of one row and
                        //  the begininning of the next

  if(dstwid == 0) return;       // don't draw no-width pictures
  if(dsthgt == 0) return;

  dstwid += sign(dstwid);       // add one to the width and height
  dsthgt += sign(dsthgt);       //  (one-off error)

  xmax = abs(dstwid);           // width and height to scale to
  ymax = abs(dsthgt);

  xstep = (srcwid<<16) / xmax;  // calculate distance (in source) between
  ystep = (srchgt<<16) / ymax;  //  pixels  (in dest)

  xdir = sign(dstwid);          // is the image flipped?
  ydir = sign(dsthgt);

  if(dstwid > 0 && dsthgt > 0)          // calculate the distance (in bytes)
    dstystep = pagewid - xmax;          //  between the end of one row, and
  else if(dstwid > 0 && dsthgt < 0)     //  the beginning of the next row
    dstystep = - pagewid - xmax;        //  (in the destination)
  else if(dstwid < 0 && dsthgt > 0)
    dstystep = pagewid + xmax;
  else if(dstwid < 0 && dsthgt < 0)
    dstystep = - pagewid + xmax;

  dest += left + (top*pagewid);         // set our pointer to the first pixel


  for(y = 0; y < ymax; y++)
  {
    srcx = 0;           // reset our x counter before each row...

    for(x = 0; x < xmax; x++)
    {
//      c = src[srcx>>16];      // get the next pixel...
//      if(c) *dest = c;        //  and store it, if it's not transparent
      *dest = src[(srcx>>16)];        // copy next pixel

      dest += xdir;     // move through destination image
      srcx += xstep;    // move through source image
    }

    dest += dstystep;   // go to the next row in destination

    srcy += ystep;      // move through the source image...
    src += (srcy>>16)*srcwid;   // and possibly to the next row.
    srcy &= 0xffff;     // set up the y-coordinate between 0 and 1
  }

}



// Everything below here is just old code, previous versions of the above
// scaling code...
/*
void scale(byte * src,  int srcwid, int srchgt,
           byte * dest, int dstwid, int dsthgt,
           int pagewid, int pagehgt, int left, int top)
{

  int x, y;
  int xmax, ymax;
  int xdir, ydir;

  int srcx, srcy=0;

  int ystep;
  int xstep;

  int dstystep;

  if(dstwid == 0) return;
  if(dsthgt == 0) return;

  dstwid += sign(dstwid);
  dsthgt += sign(dsthgt);

  xmax = abs(dstwid);
  ymax = abs(dsthgt);

  xstep = (srcwid<<16) / xmax;
  ystep = (srchgt<<16) / ymax;

  xdir = sign(dstwid);
  ydir = sign(dsthgt);

  if(dstwid > 0 && dsthgt > 0)
    dstystep = pagewid - xmax;
  else if(dstwid > 0 && dsthgt < 0)
    dstystep = - pagewid - xmax;
  else if(dstwid < 0 && dsthgt > 0)
    dstystep = pagewid + xmax;
  else if(dstwid < 0 && dsthgt < 0)
    dstystep = - pagewid + xmax;

  dest += left + (top*pagewid);


  for(y = 0; y < ymax; y++)
  {
    srcx = 0;

    for(x = 0; x < xmax; x++)
    {
      *dest = src[(srcx>>16)];

      dest += xdir;
      srcx += xstep;
    }

    dest += dstystep;

    srcy += ystep;
    src += (srcy>>16)*srcwid;
    srcy &= 0xffff;
  }

}
*/
/*
void scale(byte * src,  int srcwid, int srchgt,
           byte * dest, int dstwid, int dsthgt,
           int pagewid, int pagehgt, int left, int top)
{

  int x, y;

  int srcx, srcy=0;

  int ystep;
  int xstep;

  if(dstwid == 0) return;
  if(dsthgt == 0) return;

  ystep = (srchgt<<16) / dsthgt;
  xstep = (srcwid<<16) / dstwid;

  dest += left + (top*pagewid);


  for(y = 0; y < dsthgt; y++)
  {
    srcx = 0;

    for(x = 0; x < dstwid; x++)
    {
      *dest = src[(srcx>>16)];

      dest ++;
      srcx += xstep;
    }

    dest += pagewid - dstwid;

    srcy += ystep;
    src += (srcy>>16)*srcwid;
    srcy &= 0xffff;
  }

}
*/
/*
void scale(byte * src,  int srcwid, int srchgt,
           byte * dest, int dstwid, int dsthgt,
           int pagewid, int pagehgt, int left, int top)
{

  int sx=left, sy=top;

  int srcx, srcy=0;

  int ystep;
  int xstep;

  if(dstwid == 0) return;
  if(dsthgt == 0) return;

  ystep = (srchgt<<16) / dsthgt;
  xstep = (srcwid<<16) / dstwid;

  dest += left + (top*pagewid);


  for(sy = top; sy < top+dsthgt; sy++)
  {
    srcx = 0;

    for(sx = left; sx < left+dstwid; sx++)
    {
      *dest = src[(srcx>>16)];

      dest ++;
      srcx += xstep;
    }

    dest += pagewid - dstwid;

    srcy += ystep;
    src += (srcy>>16)*srcwid;
    srcy &= 0xffff;
  }

}
*/
