;     Ŀ
;        Sound Deluxe System 5, a Maple Leaf production               
;        1996-1997                                                    
;           
;        EFX routines for fast commands (init) and the normal ones    
;     

;****************************************************************************
; Effects initialization. SI=event offset, AL=para, BX=channel #
;****************************************************************************

i_A     proc     near  ; A=1=Set speed
        test     al,al
        sjz      sdso1
        mov      BPara[bx],al
        push     dx
        movzx    cx,al
        mov      Speed,cx
        mov      ax,TickSpeed
        xor      dx,dx
        mul      cx
        dec      ax
        xor      dx,dx
        mov      cx,3
        div      cx
        mov      ArpSpeed,ax
        pop      dx
sdso1:  retn
i_A     endp

;---------------------------------------------------------------------------
i_B     proc     near    ;B=2=Jump
        mov      BPara[bx],al
        mov      cx,CLinesPerPatt
        dec      cx
        mov      CRow,cx
        movzx    cx,al
        dec      cx
        mov      CEntry,cx
        sjge     sdso4
        mov      cx,Entries
        dec      cx
        mov      CEntry,cx
sdso4:  retn
i_B     endp

;---------------------------------------------------------------------------
i_C     proc     near    ; C=3=Cancel(Break)
;       mov      cx,CLinesPerPatt
;       dec      cx
;       mov      CRow,cx
        mov      BPara[bx],al
        mov      RestartRow,al
        mov      mustBreak,1
        retn
i_C     endp

;---------------------------------------------------------------------------
i_D     proc     near  ; D=4=Slide volume up/down
        test     al,al
        sjz      sdso5
        mov      BPara[bx],al
        mov      BPara2[bx],al
sdso5:  retn
i_D     endp

;---------------------------------------------------------------------------
i_E     proc     near  ; E=5=Slide down, fine and extrafine slide down
        test     al,al
        sjz      sdso6
        mov      BPara[bx],al
        push     bx
        shl      bx,2
        and      eax,0FFh
        mov      WPara[bx],eax
        mov      WPara2[bx],eax
        pop      bx
sdso6:  retn
i_E     endp

;---------------------------------------------------------------------------
i_F     proc     near ; F=6=Slide up, fine and extrafine slide up
        test     al,al
        sjz      sdso7
        mov      BPara[bx],al
        shl      bx,2
        and      eax,0FFh
        mov      WPara[bx],eax
        mov      WPara2[bx],eax
        shr      bx,2
sdso7:  retn
i_F     endp

;---------------------------------------------------------------------------
i_H     proc     near  ; H=8=Vibrato

        test     al,al     ; parameter equals zero ?
        jz       sdso40    ; if yes, get the fuck out

        mov      BPara[bx],al
        mov      BPara2[bx],al

        push     di dx

        push     ax        ; save orig para

        shr      al,4      ; high nibble

        mov      VibratoStep[bx],al   ; Save vibrato step (speed)
        mov      VibratoIndex[bx],0   ; index in vibrato table = 0 (start pos)

        shl      bx,2

        mov      ax,word ptr VoicePeriod[bx] ; save original period

        cmp      ax,word ptr VibratoOrig[bx]
        sje      iH_1
        mov      cx,word ptr VibratoOrig[bx]
        mov      ah,bl
        shr      ah,2
        CallFunc 9   ; fn #9 = "set voice period"
        mov      ax,cx
iH_1:   mov      word ptr VibratoOrig[bx],ax

        mov      cx,ax   ; keep it into CX (orig period)

        pop      ax      ; restore orig para

        and      ax,0Fh  ; Al=amplitude (low nibble)
        shr      bx,2
        movzx    di,CNote[bx]
        add      di,ax
        dec      di     ; di:=(CNote[channel]-1)+amplitude

        add      di,di
        mov      ax,Pitch[di] ; ax:=Pitch

        ;
        ; this fuckin value MUST be scaled with C2Speed, too !...
        ;

        mov      di,8363
        mul      di
        movzx    di,CSam[bx]
        add      di,di
        mov      di,SC2Spd[di]
        inc      di
        div      di  ; reference pitch in AX

     ; computing amplitude ...
        sub      cx,ax
        sjge     iH_2
        neg      cx
iH_2:

        cmp      cx,1
        jbe      iH_3

        mov      dx,cx
        shr      cx,2          ; *ATENUATION*
        mov dx,0 ;shr      dx,5
        add      cx,dx

iH_3:

        shl      bx,2
        mov      word ptr VibratoAmpl[bx],cx
        shr      bx,2

        pop      dx di

sdso40: retn
i_H     endp

;---------------------------------------------------------------------------
i_I     proc     near  ; I=9=Tremor
        test     al,al
        sjz      sdso9
        mov      RTTicks[bx],0
        mov      BPara[bx],al
        shl      bx,2
        movzx    eax,byte ptr VoiceVol[bx]
        mov      WPara[bx],eax
        shr      bx,2
sdso9:  retn
i_I     endp

;--- Slow arpeggio ---------------------------------------------------------
i_J     proc     near  ; J=10=Arpeggio
        mov      BPara[bx],al
        mov      ax,Speed
        push     cx
        mov      cl,3
        div      cl
        and      al,0Fh
        mov      cl,al
        shl      al,4
        or       al,cl
        mov      RTTicks[bx],al   ; RTTicks is also used by Retrig and Tremor
        pop      cx
        retn
i_J     endp

;--- Fast arpeggio ---------------------------------------------------------
i_J2    proc     near  ; J=10=Arpeggio
        mov      BPara[bx],al
        mov      RTTicks[bx],0    ; RTTicks is also used by Retrig and Tremor
        retn
i_J2    endp

;---------------------------------------------------------------------------
i_K     proc     near  ; K=11=Vibrato+VolSlide
        test     al,al
        sjz      iK_1
        mov      BPara[bx],al
iK_1:   retn
i_K     endp

;---------------------------------------------------------------------------
i_M     proc     near  ;M=13=fine vol slide up/down
        test     al,al
        sjz      sdso50
        mov      BPara[bx],al
sdso50: mov      BPara2[bx],1  ; a fuckin flag
        retn
i_M     endp

;---------------------------------------------------------------------------
i_Q     proc     near ; Q=17=Retrig note + vol slide
        test     al,al
        sjz      sdso8
        mov      RTTicks[bx],0
        mov      ah,al
        and      al,0Fh
        mov      BPara[bx],al   ; Used for retrig
        mov      al,ah
        shr      al,4
        mov      BPara2[bx],al  ; Used for vol slide
sdso8:  retn
i_Q     endp

;---------------------------------------------------------------------------
LastTrem db      MaxChannels dup (0)

i_R     proc     near    ; R=18=Tremolo
        test     al,al           ; is para = 0 ?
        jz       short iR_out    ; yeah, get the fuck out
        mov      BPara[bx],al
        cmp      al,LastTrem[bx] ;
        je       short iR_out    ; A test against ST3's MOD bugs !
        mov      LastTrem[bx],al ;
        push     di dx
        mov      dl,al           ; save parameter into DL
        shr      al,4
        mov      VibratoStep[bx],al   ; Save tremolo step
        mov      VibratoIndex[bx],0   ; index in vibrato table = 0 (start pos)
        shl      bx,2
        mov      al,byte ptr VoiceVol[bx] ; save original volume
        cmp      al,byte ptr TremoloOrig[bx]
        je       short iR_1
        mov      al,byte ptr TremoloOrig[bx]
        mov      ah,bl
        shr      ah,2
        CallFunc 5   ; fn #5 = "set voice volume"
iR_1:   mov      byte ptr TremoloOrig[bx],al
        mov      al,dl
        and      ax,0Fh  ; Al=amplitude
        shl      ax,1    ; Kurt Kennett's DOC says AX:=amplitude*(speed-1), but it doesn't seem to work right w/ it ... I used AX:=ampl*2, and the result is quite nice !
        mov      word ptr VibratoAmpl[bx],ax  ; store ampl.
        shr      bx,2
        pop      dx di
iR_out: retn
i_R     endp

;---------------------------------------------------------------------------
i_S     proc     near  ; S=19=special effects
        push     di
        mov      BPara2[bx],al  ; In BPara2[bx] will be the orig. parameter (xy)
        mov      BPara[bx],al
        movzx    di,al
        shr      di,4         ; DI = extended effect #
        and      al,0Fh       ; AL = extended para
        add      di,di
        mov      di,iSTable[di]
        test     di,di        ; implemented ?
        sjz      iS_out       ; no, get out
        call     di           ; yeah, call the routine
iS_out: pop      di
        retn
i_S     endp

;---------------------------------------------------------------------------
i_T     proc     near   ; T=20=Set BPM tempo
        test     al,al
        sjz      sdso3
        mov      BPara[bx],al
        cmp      AllowBPM,1
        jne      short sdso3

        cmp      al,45      ; Minimum BPM supported is 45... sorry guys, set a lower speed if you want one line per hour ... :)
        jb       sdso3

        push     eax ecx edx

        sub      ah,ah
        mov      BPM,ax
        add      ax,ax
        mov      cl,5
        div      cl
        movzx    ecx,al

        SetTimerFreq cx             ; new rate or BPM*2/5 Hz (ticks per second)

        mov      eax,mxMixSpd
        xor      edx,edx
        div      ecx
        mov      mxMaxMix,ax     ; compute new mix-ahead amount

        mov      ax,34DCh
        mov      dx,12h
        mov      cx,cs:TicksPerSec
        div      cx
        mov      cs:TimerSpeed,ax

        pop      edx ecx eax

sdso3:  retn
i_T     endp

;----------------------------------------------------------------------------
i_U     proc     near ; U=21=Fine vibrato (4 times finer than normal vibrato)
        call     i_H   ; do a normal vibrato init ...
        retn
i_U     endp

;---------------------------------------------------------------------------
i_V     proc     near  ; V=22=Set global volume
        cmp      al,40h
        sja      sdso2
        mov      BPara[bx],al
        CallFunc 13  ; fn #13 = "global volume"
sdso2:  retn
i_V     endp

;---------------------------------------------------------------------------
i_X     proc     near  ; X=24=Amiga command #8 (unused)
        mov      BPara[bx],al
        retn
i_X     endp

;--------------------------------------------------------------------------
i_Y     proc     near  ; Y=25=SDS effect: set amplification
        mov      BPara[bx],al
        and      ax,0FFh ; keep only bits 0-7
        add      ax,ax   ; AmplifPercent = param * 2
        mov      AmplPercent,ax
        CallFunc 14      ; fn #14 = "set amplification"
        retn
i_Y     endp

;---------------------------------------------------------------------------
i_Z     proc     near   ; Z=26=SDS commands
        push     di
        movzx    di,al
        mov      BPara2[bx],al
        mov      BPara[bx],al
        shr      di,4         ; DI = SDS extended effect #
        and      al,0Fh       ; AL = SDS extended para
        add      di,di
        mov      di,iZTable[di]
        test     di,di        ; implemented ?
        sjz      iZ_out       ; no, get out
        call     di           ; yeah, call the routine
iZ_out: pop      di
        retn
i_Z     endp

;----------------------------------------------------------------------------
;-----<<< Effects routines >>>-----------------------------------------------
;  In:   BX=channel #, SI=event's eff offset, and the others (pre-stored)
;  Note: MUST keep all the registers untouched, except AX which can be modified
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------

c_D     proc     near          ; D=4=sld vol up/dn
        mov      al,BPara[bx]  ; load parameter
        mov      ah,al
        test     al,0Fh        ; slide vol down ?
        sjnz     sdsc3
sdsc4: ; **** slide vol up ****
        shl      bx,2
        mov      ah,byte ptr VoiceVol[bx]
        shr      al,4
        add      ah,al         ; increase volume
        cmp      ah,40h
        sjbe     sdsok1
        mov      ah,40h
sdsok1: shr      bx,2
        mov      al,ah
        mov      ah,bl  ; voice #
        CallFunc 5      ; fn #5 = "set voice volume"
        retn
sdsc3: ; **** slide vol down ****
        and      al,0Fh
        shl      bx,2
        mov      ah,byte ptr VoiceVol[bx]
        sub      ah,al  ; decrease volume
        sjge     sdsok2
        sub      ah,ah
sdsok2: shr      bx,2
        mov      al,ah
        mov      ah,bl  ; voice #
        CallFunc 5      ; fn #5 = "set voice volume"
        retn
c_D     endp

;----------------------------------------------------------------------------
c_E     proc     near ; E=5=((extra)fine) slide down
        shl      bx,2
        mov      al,byte ptr WPara[bx]  ; parameter
        mov      ah,al
        and      al,0F0h
        cmp      al,0F0h      ; fine slide down ?
        je       short sdsc5
        cmp      al,0E0h      ; extrafine slide down ?
        je       short sdsc6
        mov      al,ah
sdsc7: ;**** sld down ****
        inc      PortamentoXor   ;
        test     PortamentoXor,3 ; A trick to convert Amiga slides to PC slides
        jz       short sdso32    ;
        xor      ah,ah
        push     cx
        mov      cx,word ptr VoicePeriod[bx]
        add      cx,ax
        cmp      cx,1800
        jle      short sdset1
        mov      cx,1800
sdset1: mov      ah,bl
        shr      ah,2
        CallFunc 9    ; fn #9 = "set voice period"
        pop      cx
sdso32: shr      bx,2
        retn
sdsc5: ;**** fine sld down ****
        mov      ax,word ptr WPara2[bx]
        or       ax,ax
        jz       short sdso34
        mov      word ptr WPara2[bx],0
        mov      ax,word ptr WPara[bx]
        and      ax,0Fh
        push     cx
        mov      cx,word ptr VoicePeriod[bx]
        add      cx,ax
        cmp      cx,1800
        jle      short sdset2
        mov      cx,1800
sdset2: mov      ah,bl
        shr      ah,2
        CallFunc 9  ; fn #9 = set voice period
        pop      cx
sdso34: shr      bx,2
        retn
sdsc6: ;**** extrafine sld down ****
        shr      bx,2
        retn
c_E     endp

;---------------------------------------------------------------------------
c_F     proc     near  ; F=6=((extra)fine) slide up
        shl      bx,2
        mov      al,byte ptr WPara[bx]  ; parameter
        mov      ah,al
        and      al,0F0h
        cmp      al,0F0h      ; fine slide up ?
        je       short sdsc8
        cmp      al,0E0h      ; extrafine slide up ?
        je       short sdsc9
        mov      al,ah
sdsc10: ;**** sld up ****
        inc      PortamentoXor   ;
        test     PortamentoXor,3 ; A trick to convert Amiga slides to PC slides
        jz       short sdso38    ;
        xor      ah,ah
        push     cx
        mov      cx,word ptr VoicePeriod[bx]
        sub      cx,ax
        jge      short sdset3
        mov      cx,0
sdset3: mov      ah,bl
        shr      ah,2
        CallFunc 9    ; fn #9 = "set voice period"
        pop      cx
sdso38: shr      bx,2
        retn
sdsc8: ;**** fine sld up ****
        mov      ax,word ptr WPara2[bx]
        test     ax,ax
        jz       short sdso39
        mov      word ptr WPara2[bx],0
        mov      ax,word ptr WPara[bx]
        and      ax,0Fh
        push     cx
        mov      cx,word ptr VoicePeriod[bx]
        sub      cx,ax
        jge      short sdset6
        mov      cx,0
sdset6: mov      ah,bl
        shr      ah,2
        CallFunc 9  ; fn #9 = set voice period
        pop      cx
sdso39: shr      bx,2
        retn
sdsc9: ;**** extrafine sld up ****
        shr      bx,2
        retn
c_F     endp

;----------------------------------------------------------------------------
c_G     proc     near  ; G=7=Tone portamento
        push     cx
        mov      cx,bx
        shl      bx,2
        mov      ax,word ptr VoicePeriod[bx]     ; extract period
        cmp      ax,word ptr ToNoteAttended[bx]  ; period reached ?
        sjg      c_G_inc
        sjl      c_G_dec
        mov      bx,cx
        pop      cx
        retn
c_G_inc: ; increment frequency (decrement period)
        mov      bx,cx
        movzx    cx,ToNoteSpeed[bx]
        sub      ax,cx
        shl      bx,2
        cmp      ax,word ptr ToNoteAttended[bx]
        jge      short c_G_ok1
        mov      ax,word ptr ToNoteAttended[bx]
c_G_ok1:mov      cx,ax
        shr      bx,2
        mov      ah,bl
        CallFunc 9   ; fn #9 = "set voice period"
        pop      cx
        retn
c_G_dec: ; decrement frequency (increment period)
        mov      bx,cx
        movzx    cx,ToNoteSpeed[bx]
        add      ax,cx
        shl      bx,2
        cmp      ax,word ptr ToNoteAttended[bx]
        jle      short c_G_ok2
        mov      ax,word ptr ToNoteAttended[bx]
c_G_ok2:mov      cx,ax
        shr      bx,2
        mov      ah,bl
        CallFunc 9   ; fn #9 = "set voice period"
        pop      cx
        retn
c_G     endp

;----------------------------------------------------------------------------
c_H     proc     near  ; H=8=Vibrato
        push     di cx dx
        mov      al,VibratoStep[bx]            ; load vibrato step
        add      VibratoIndex[bx],al           ; increment table index
        and      VibratoIndex[bx],3Fh          ; fit in 0-63
        movzx    di,VibratoIndex[bx]           ; load index in DI
        movsx    cx,VibratoTable[di]           ; load scale w/ idx DI from the vibrato table. Signed.
        shl      bx,2
        mov      ax,word ptr VibratoAmpl[bx]   ; load amplitude into AX
        cwd
        imul     cx                            ;
        shrd     ax,dx,7   ; mov cx,127 & idiv cx
        add      ax,word ptr VibratoOrig[bx]   ; NewPitch=OrigPitch+deviation

        sjge     cH_2
        mov      ax,0                          ; if overflow, set it to zero
cH_2:   cmp      ax,1800
        sjle     cH_3
        mov      ax,1800                       ; if too big, reduce it

cH_3:   shr      bx,2

        mov      cx,ax                         ;
        mov      ah,bl                         ;
        CallFunc 9  ; fn #9 = set voice period ; set new pitch and frequence

        pop      dx cx di
        retn
c_H     endp

;----------------------------------------------------------------------------
c_I     proc     near   ; I=9=Tremor
        push     cx
        mov      cx,bx
        inc      RTTicks[bx]
        mov      al,BPara[bx]
        mov      ah,RTTicks[bx]
        shl      bx,2
        cmp      VoiceVol[bx],0
        sje      c_I_2
c_I_1: ; turn volume off
        shr      al,4
        cmp      ah,al
        jbe      short c_I_3
        mov      bx,cx
        mov      RTTicks[bx],0
        mov      ah,bl
        mov      al,0
        CallFunc 5   ; fn #5 = "set voice volume"
c_I_3:  pop      cx
        retn
c_I_2: ; turn vol on
        and      al,0Fh
        cmp      ah,al
        sjbe     c_I_3
        mov      bx,cx
        mov      RTTicks[bx],0
        mov      ah,bl
        shl      bx,2
        mov      al,byte ptr WPara[bx]
        CallFunc 5   ; fn #5 = "set voice volume"
        mov      bx,cx
        pop      cx
        retn
c_I     endp

;--- Slow arpeggio ----------------------------------------------------------
c_J     proc     near  ; J=10=Arpeggio ; IN: BX=chn#

        mov      al,RTTicks[bx] ; RTTicks is also used by Retrig/Tremor (they all share the same control data)
        mov      ah,al     ; save it (bits 4-7 = original val)
        and      al,0Fh    ; bits 0-3 = control counter
        dec      al
        jg       cJ_notYet

        mov      al,ah
        shr      al,4   ; original value (restart control counter)

        push     ax si dx cx                   ; all the registers must remain untouched.

        movzx    dx,CNote[bx]                  ; get orig. frequence
        movzx    si,BPara[bx]
        shr      si,4

        dec      si         ; theoretically it is NOT correct.

        sjge     cJ_1
        inc      si
cJ_1:   add      si,dx
        add      si,si
        mov      si,Pitch[si]                  ; get next period to be played

        mov      ax,si                ;
        mov      cx,8363              ;
        mul      cx                   ;  scale the pitch with C2Speed
        movzx    si,CSam[bx]          ;
        add      si,si                ;
        mov      cx,SC2Spd[si]        ;
        test     cx,cx                ;
        sjnz     cJ_2                 ;
        inc      cx                   ;
cJ_2:   div      cx                   ;
        mov      cx,ax                ;

        mov      ah,bl
        CallFunc 9  ; fn #9=set voice period   ; enable this period
        shl      BPara[bx],4                   ; prepare another arpeggio step

        pop      cx dx si ax

cJ_notYet:
        and      RTTicks[bx],0F0h
        or       RTTicks[bx],al   ; write the new control counter (bits 0-3)

        retn
c_J     endp

;--- Fast arpeggio ----------------------------------------------------------
c_J2    proc     near  ; J=10=Arpeggio ; IN: BX=chn#

        push     ax si dx cx

        inc      RTTicks[bx]
        and      RTTicks[bx],3
        mov      al,RTTicks[bx]

        test     al,al
        sjz      cJ2_s
        cmp      al,1                 ; first phase ?
        sjne     cJ2_e1
        mov      al,BPara[bx]
        shr      al,4
        jmp      short cJ2_s
cJ2_e1: mov      al,BPara[bx]
        and      al,0Fh

cJ2_s:  movzx    dx,CNote[bx]         ; get orig. frequence
        movzx    si,al

        dec      si                   ; theoretically it is NOT correct.

        sjge     cJ2_1
        inc      si
cJ2_1:  add      si,dx
        add      si,si
        mov      si,Pitch[si]         ; get next period to be played

        mov      ax,si                ;
        mov      cx,8363              ;
        mul      cx                   ;  scale the pitch with C2Speed
        movzx    si,CSam[bx]          ;
        add      si,si                ;
        mov      cx,SC2Spd[si]        ;
        test     cx,cx                ;
        jz       cJ2_2                ;
        div      cx                   ;
cJ2_2:  mov      cx,ax                ;

        mov      ah,bl
        CallFunc 9  ; fn #9=set voice period   ; enable this period

        pop      cx dx si ax

        retn
c_J2    endp

;----------------------------------------------------------------------------
c_K     proc     near ; K=11=Vibrato+VolSlide
        call     c_H    ; do a vibrato
        call     c_D    ; do a vol slide
        retn
c_K     endp

;----------------------------------------------------------------------------
c_L     proc     near ; L=12=TonePorta+VolSlide
        call     c_G    ; do a tone portamento
        call     c_D    ; do a vol slide
        retn
c_L     endp

;----------------------------------------------------------------------------
c_M     proc     near  ; M=13=Fine volume slide up/down
        mov      al,BPara[bx]
        test     al,0Fh
        sjnz     sdsc2 ; down
sdsc1: ; **** fine slide vol up ****
        mov      ah,BPara2[bx]
        test     ah,ah
        sjz      sdso31
        mov      BPara2[bx],0
        shl      bx,2
        mov      ah,byte ptr VoiceVol[bx]
        shr      al,4
        add      ah,al  ; increase volume
        cmp      ah,40h
        sjbe     sdsok4
        mov      ah,40h
sdsok4: shr      bx,2
        mov      al,ah
        mov      ah,bl  ; voice #
        CallFunc 5      ; fn #5 = "set voice volume"
sdso31: retn
sdsc2: ; **** fine slide vol down ****
        mov      ah,BPara2[bx]
        test     ah,ah
        sjz      sdso30
        mov      BPara2[bx],0
        shl      bx,2
        mov      ah,byte ptr VoiceVol[bx]
        and      al,0Fh
        sub      ah,al  ; decrease volume
        sjge     sdsok3
        sub      ah,ah
sdsok3: shr      bx,2
        mov      al,ah
        mov      ah,bl  ; voice #
        CallFunc 5      ; fn #5 = "set voice volume"
sdso30: retn
c_M     endp

;----------------------------------------------------------------------------
c_Q     proc     near  ; Q=17=retrig note + vol slide
        inc      RTTicks[bx]
        mov      al,BPara[bx]
        cmp      al,RTTicks[bx]
        jae      c_Q_1
        mov      RTTicks[bx],0 ; reset counter
        ; now retrig the sample ...
        mov      ah,bl                 ;** voice #
        mov      al,0                  ;** relative offset 0
        push     cx dx si edi
        shl      bx,2
        mov      cx,word ptr VoiceSize[bx]      ;** size
        mov      dx,word ptr VoiceLoopStart[bx] ;** loop start
        mov      si,word ptr VoiceLoopEnd[bx]   ;** loop end
        mov      edi,VoiceSeg[bx]               ;** address
        shr      bx,2
        CallFunc 11     ; fn #11 = "play voice"
        pop      edi si dx cx
   ; --- now treat the volume slide ---
        mov      al,BPara2[bx] ; extract slide flag
        test     al,al         ; is it zero ?
        jz       c_Q_1         ; if yes, get out
        push     cx
        cmp      al,5          ; is between 1-5 ?
        sja      cQ_2
        mov      cl,al
        dec      cl
        mov      ah,1
        shl      ah,cl
        mov      al,byte ptr VoiceVol[bx]
        sub      al,ah         ; volume:=volume-(1 shl (flag-1))
        sjge     cQset
        sub      al,al
        jmp      short cQset   ; go set it
cQ_2:   cmp      al,6          ; is flag = 6 ?
        sja      cQ_3
        movzx    ax,byte ptr VoiceVol[bx]
        add      ax,ax
        mov      cl,3
        div      cl            ; volume:=volume * 2/3
        jmp      short cQset   ; go set it
cQ_3:   cmp      al,8          ; is flag 7 or 8 ?
        sja      cQ_4
        mov      al,byte ptr VoiceVol[bx]
        shr      al,1          ; volume:=volume * 1/2
        jmp      short cQset   ; go set it
cQ_4:   cmp      al,0Dh        ; is flag between 9-0Dh ?
        sja      cQ_5
        mov      cl,al
        sub      cl,9
        mov      ah,1
        shl      ah,cl
        mov      al,byte ptr VoiceVol[bx]
        add      al,ah         ; volume:=volume+(1 shl (flag-9))
        cmp      al,40h        ; overflow ?
        sjbe     cQset         ; go set it
        mov      al,40h        ; max is 40h ...
        jmp      short cQset   ; go set it
cQ_5:   cmp      al,0Eh        ; is flag = 0Eh ?
        sja      cQ_6
        mov      al,byte ptr VoiceVol[bx]
        mov      cl,3
        mul      cl
        shr      ax,1          ; volume:=volume * 3/2
        jmp      short cQset   ; go set it
cQ_6:   mov      al,byte ptr VoiceVol[bx]
        add      al,al         ; ... else flag=0Fh => volume:=volume*2
        cmp      al,40h
        sjbe     cQset         ; go set it
        mov      al,40h        ; max=40h ...
cQset:  mov      ah,bl
        CallFunc 5  ; fn #5 = set voice volume
        pop      cx
c_Q_1:  retn
c_Q     endp

;-----------------------------------------------------------------------------
c_R     proc     near   ; R=18=Tremolo
        push     di cx dx
        mov      al,VibratoStep[bx]            ; load tremolo step
        add      VibratoIndex[bx],al           ; increment table index
        cmp      VibratoIndex[bx],64           ; end of table ?
        jb       short cR_1
        sub      VibratoIndex[bx],64           ; if yes, start again
cR_1:   movzx    di,VibratoIndex[bx]           ; load index in DI
        movsx    cx,VibratoTable[di]           ; load scale w/ idx DI from the vibrato table. Signed.
        shl      bx,2
        mov      ax,word ptr VibratoAmpl[bx]   ; load amplitude into AX
        sub      dx,dx
        imul     cx                            ;
        shrd     ax,dx,7  ; mov cx,127 & idiv cx
        mov      dx,ax                         ; store deviation into dx
        movzx    ax,byte ptr TremoloOrig[bx]
        sub      ax,dx                         ; NewVol=OrigVol-deviation
        jge      short cR_2
        sub      ax,ax                         ; if overflow, set it to zero
cR_2:   cmp      ax,64
        jle      short cR_3
        mov      ax,64                         ; if too big, reduce it
cR_3:   shr      bx,2
        mov      ah,bl                         ;
        CallFunc 5  ; fn #5 = set voice volume ; set new volume
        pop      dx cx di
        retn
c_R     endp

;-----------------------------------------------------------------------------
c_S     proc     near  ; S=19=special effects
        push     di
        movzx    di,BPara2[bx]
        shr      di,4        ; DI = extended effect #
        and      al,0Fh      ; AL = extended para
        add      di,di
        mov      di,STable[di]
        test     di,di       ; implemented ?
        sjz      S_out       ; no, get out
        call     di          ; yeah, call the routine
S_out:  pop      di
        retn
c_S     endp

;-----------------------------------------------------------------------------
c_U     proc     near  ; U=21=Fine vibrato (4 times finer than normal vibrato)
        push     di cx dx
        mov      al,VibratoStep[bx]            ; load vibrato step
        add      VibratoIndex[bx],al           ; increment table index
        and      VibratoIndex[bx],3Fh          ; fit in 0-63
cU_1:   movzx    di,VibratoIndex[bx]           ; load index in DI
        movsx    cx,VibratoTable[di]           ; load scale w/ idx DI from the vibrato table. Signed.
        shl      bx,2
        mov      ax,word ptr VibratoAmpl[bx]   ; load amplitude into AX
        shr      ax,1   ;(???)                 ; fine vibrato, so reduce the amplitude
        sub      dx,dx
        imul     cx                            ;
        shrd     ax,dx,7
        mov      dx,ax                         ; store deviation into dx
        mov      ax,word ptr VibratoOrig[bx]
        add      ax,dx                         ; NewPitch=OrigPitch+deviation
        jge      short cU_2
        sub      ax,ax                         ; if overflow, set it to zero
cU_2:   cmp      ax,1800
        jle      short cU_3
        mov      ax,1800                       ; if too big, reduce it
cU_3:   shr      bx,2
        mov      cx,ax                         ;
        mov      ah,bl                         ;
        CallFunc 9  ; fn #9 = set voice period ; set new pitch and frequence
        pop      dx cx di
        retn
c_U     endp

;---------------------------------------------------------------------------
c_Z     proc     near   ; SDS special effects
        push     di
        movzx    di,BPara2[bx]
        shr      di,4        ; DI = SDS extended effect #
        and      al,0Fh      ; AL = SDS extended para
        add      di,di
        mov      di,ZTable[di]
        test     di,di       ; implemented ?
        sjz      Z_out       ; no, get out
        call     di          ; yeah, call the routine
Z_out:  pop      di
        retn
c_Z     endp

;****************************************************************************
;  Special effects (Sxy)  - Initialization Routines
;  IN:  BX=channel #, AL=extended para (0x), BPara2[bx]=para (xy)
;  all registers must remain untouched, except AX and DI which can be changed
;****************************************************************************

FTune   dw       8363,8413,8463,8529,8581,8651,8723,8757,7895,7941,7985,8046,8107,8169,8232,8280

i_S2    proc     near  ; set finetune
        movzx    di,al
        add      di,di
        mov      ax,FTune[di]
        movzx    di,CSam[bx]       ; di:=# of instrument on the channel BX
        add      di,di
        mov      SC2Spd[di],ax     ; store new C2 speed
        retn
i_S2    endp

;---------------------------------------------------------------------------

i_S3    proc     near  ; set vibrato waveform
        push     eax cx si
        and      ax,3
        shl      ax,6  ; mul 64
        mov      si,ax
        add      si,offset WaveForms
        mov      di,offset VibratoTable
        mov      cx,16
iS3_l:  mov      eax,cs:[si]       ;
        mov      cs:[di],eax       ; Copy the specified table into
        add      si,4              ; the default Vibrato Table
        add      di,4              ;
        dec      cx                ;
        sjg      iS3_l             ;
        pop      si cx eax
        retn
i_S3    endp

;---------------------------------------------------------------------------

i_S4    proc     near  ; set tremolo waveform
        push     eax cx si
        and      ax,3
        shl      ax,6  ; mul 64
        mov      si,ax
        add      si,offset WaveForms
        mov      di,offset VibratoTable
        mov      cx,16
iS4_l:  mov      eax,cs:[si]       ;
        mov      cs:[di],eax       ; Copy the specified table into
        add      si,4              ; the default Tremolo Table. Sorry,
        add      si,4              ; it's the same table as for vibrato...
        dec      cx                ;
        sjg      iS4_l             ;
        pop      si cx eax
        retn
i_S4    endp

;---------------------------------------------------------------------------

i_S8    proc     near  ; set panning
        cmp      AllowPanning,1    ; panning is allowed ?
        sjne     iS8_1             ; no, get the fuck out
        mov      ah,bl             ; yeh, do it !
        CallFunc 7   ; fn #7 = "set voice balance"
iS8_1:  retn
i_S8    endp

;---------------------------------------------------------------------------

efx_RowOffs dw   0                          ; used by SBx effect
efx_FirstSB db   0                          ; used by SBx effect
LoopC   db       MaxChannels dup (0)        ; used by SBx effect
LoopRow db       MaxChannels dup (0)        ; used by SBx effect
LoopOfs dw       MaxChannels dup (0)        ; used by SBx effect


i_SB    proc     near  ; Set/Start loop

        test     al,al                ; is para = 0 ?
        jz       short iSB_saveStatus ; yeah, go store the looping point

        cmp      efx_FirstSB,1        ; here for the first time in the pattern ?
        sjne     iSB_5                ; no, skip

        mov      LoopC[bx],0          ;
        mov      LoopRow[bx],0        ; yeah, set these to the default
        add      bx,bx                ; values
        mov      LoopOfs[bx],0        ;
        shr      bx,1                 ;
        mov      efx_FirstSB,0        ;

iSB_5:  and      ax,0Fh
        inc      LoopC[bx]
        cmp      LoopC[bx],al         ; must loop ?
        jg       short iSBnoMore

iSBagain:
        movzx    ax,LoopRow[bx]
        dec      ax
        mov      CRow,ax              ; row = LoopStart row
        add      bx,bx
        mov      ax,LoopOfs[bx]
        shr      bx,1
        mov      word ptr RowPtr,ax   ; pattern offset = LoopStart offset (DANGEROUS OPERATION!)
        retn

iSBnoMore:
        mov      LoopC[bx],0          ; no loop, reset counter

   ; the next "SetLoop" effect will start from the next row by default,
   ; so the following code initializes LoopRow and LoopOfs accordingly.

        mov      ax,word ptr RowPtr
        add      bx,bx
        mov      LoopOfs[bx],ax       ; init LoopStart offset
        shr      bx,1
        mov      ax,CRow
        inc      ax
        cmp      ax,CLinesPerPatt
        sjb      iSB_3
        xor      al,al
iSB_3:  mov      LoopRow[bx],al

        retn

iSB_saveStatus:
        mov      ax,CRow
        mov      LoopRow[bx],al    ; store loopstart row
        add      bx,bx
        mov      ax,efx_RowOffs
        mov      LoopOfs[bx],ax    ; store loopstart offset in pattern
        shr      bx,1
        retn
i_SB    endp

;---------------------------------------------------------------------------

i_SC    proc     near  ; SCx = note cut in x frames
        test     al,al         ; para = 0 ?
        sje      iSC_1         ; yes, get the fuck out
        mov      BPara[bx],al  ; init counter
iSC_1:  retn
i_SC    endp

;---------------------------------------------------------------------------

i_SD    proc     near  ; SDx = note delay
        test     al,al
        jz       iSD_1
        mov      BPara[bx],al   ; # of ticks to delay
        mov      al,CVol[bx]    ; is always ok ?
        shl      bx,2
        mov      byte ptr WPara[bx],al
        shr      bx,2
        mov      ah,bl
        CallFunc 12  ; fn #12 = "stop voice"
iSD_1:  retn
i_SD    endp

;---------------------------------------------------------------------------

i_SE    proc     near  ; SEx = pattern delay for x notes
        test     al,al
        sjz      iSE_1
        and      ax,0Fh
        push     dx
        mul      Speed
        pop      dx
        shl      bx,2
        mov      word ptr WPara[bx],ax
        shr      bx,2
iSE_1:  retn
i_SE    endp

;****************************************************************************
;  Special effects (Sxy)  - Routines
;  IN: BX=channel #, AL=extended para (0x), BPara2[bx]=para (xy)
;  all registers must remain untouched, except AX and DI
;****************************************************************************

c_SC    proc     near   ; SCx = note cut in x frames
        cmp      BPara[bx],0
        sja      cSC_no
        mov      ah,bl
        CallFunc 12  ; fn #12 = "stop voice"
        jmp      short cSC_out
cSC_no: dec      BPara[bx]
cSC_out:retn
c_SC    endp

;---------------------------------------------------------------------------

c_SD    proc     near   ; SDx = note delay  ; doesn't work OK always !
        cmp      BPara[bx],0
        sjg      cSD_no
        sjl      cSD_out
        shl      bx,2
        mov      al,byte ptr WPara[bx]      ; read old volume
        shr      bx,2
        mov      ah,bl                      ; ah=voice #
        CallFunc 5                          ; fn #5 = "set voice volume"
        push     cx dx si edi
        shl      bx,2
        mov      cx,word ptr VoiceSize[bx]
        mov      dx,word ptr VoiceLoopStart[bx]
        mov      si,word ptr VoiceLoopEnd[bx]
        mov      edi,VoiceSeg[bx]
        shr      bx,2
        mov      ah,bl
        xor      al,al
        CallFunc 11                         ; fn #11 = "start voice"
        pop      edi si dx cx
cSD_no: dec      byte ptr BPara[bx]
cSD_out:retn
c_SD    endp

;---------------------------------------------------------------------------

c_SE    proc     near   ; SEx = pattern delay for x notes
        shl      bx,2
        cmp      word ptr WPara[bx],0
        sje      cSE_1
        dec      word ptr WPara[bx]
        mov      ax,Speed            ; Reset spd counter (do row again)
        mov      SpeedCounter,ax     ;
cSE_1:  shr      bx,2
        retn
c_SE    endp

;****************************************************************************
;  SDS Special effects (Zxy)  - Init Routines
;  IN: BX=channel #, AL=extended para (0x)
;  all registers must remain untouched, except AX and DI
;****************************************************************************

i_Z0    proc     near   ; Z0x = surround mode
        mov      SurroundMode,al
        retn
i_Z0    endp

;---------------------------------------------------------------------------

i_Z1    proc     near   ; Z1x = increment semaphore
        movzx    di,al
        inc      Semaphores[di]
        retn
i_Z1    endp

;---------------------------------------------------------------------------

i_Z2    proc     near   ; Z2x = fast tremor, x=whatever
        shl      bx,2
        mov      ax,word ptr VoiceVol[bx]
        shr      bx,2
        mov      RTTicks[bx],al
        retn
i_Z2    endp

;---------------------------------------------------------------------------

i_Z4    proc     near   ; Z4x = skip the next x ticks
        test     al,al
        sjz      iZ4_1
        mov      BPara[bx],al
iZ4_1:  retn
i_Z4    endp

;---------------------------------------------------------------------------

i_ZB    proc     near   ; ZBx = BPM changes on/off
        mov      AllowBPM,al
        retn
i_ZB    endp

;---------------------------------------------------------------------------

i_ZC    proc     near   ; ZCx = panning changes on/off
        mov      AllowPanning,al
        retn
i_ZC    endp

;****************************************************************************
;  SDS Special effects (Zxy)  - Routines
;  IN: BX=channel #, AL=extended para (0x)
;  all registers must remain untouched, except AX and DI
;****************************************************************************

c_Z2    proc     near  ; Z2x = fast tremor, x=whatever
        shl      bx,2
        cmp      byte ptr VoiceVol[bx],0   ; vol is turned off ?
        sje      cZ2_on                    ; yeh, turn it on
cZ2_off:mov      ah,bl                     ; no, turn it off
        shr      ah,2
        mov      al,0
        CallFunc 5  ; fn #5 = set voice volume
        jmp      short cZ2_out
cZ2_on: shr      bx,2
        mov      al,RTTicks[bx]        ; used as vol-keeper
        mov      ah,bl
        CallFunc 5  ; fn #5 = set voice volume
        jmp      short cZ2_ret
cZ2_out:shr      bx,2
cZ2_ret:retn
c_Z2    endp

;---------------------------------------------------------------------------

c_Z4    proc     near   ; Z4x = skip the next x ticks
        cmp      BPara[bx],0
        sje      cZ4_1
        movzx    ax,BPara[bx]
        mov      BPara[bx],0
        sub      SpeedCounter,ax
        sjge     cZ4_1
        mov      SpeedCounter,0
cZ4_1:  retn
c_Z4    endp
